<?php
// Account Report
if (($title=='admin' || $title=='account') && isset($_GET['opt']) && $_GET['opt'] == 'account') {
    include "header.php";

    $quoteFilter = isset($_GET['quote_no']) ? $_GET['quote_no'] : '';
    $stageFilter = isset($_GET['stage']) ? $_GET['stage'] : '';
    $accountFilter = isset($_GET['accountname']) ? $_GET['accountname'] : '';
    $profitFilter = isset($_GET['profit']) ? $_GET['profit'] : '';
    $countryFilter = isset($_GET['country']) ? $_GET['country'] : '';

    // Updated SQL query with country filter
    $sql = "SELECT
            q.quoteid,
                q.quote_no,
                q.quotestage,
                q.no_pax,
                q.country,
                vqcf.cf_1162,
                va.accountname,
                COALESCE((
                    SELECT SUM(ph.total_amount)
                    FROM vtiger_payment_history ph
                    WHERE ph.quoteid = q.quoteid
                ), 0) AS invoice_total,
                COALESCE((
                    SELECT SUM(sp.total_amount)
                    FROM vtiger_supplier_payment sp
                    WHERE sp.quoteid = q.quoteid
                ), 0) AS supplier_total
            FROM vtiger_quotes q
            LEFT JOIN vtiger_quotescf vqcf ON q.quoteid = vqcf.quoteid
            LEFT JOIN (SELECT * FROM vtiger_account UNION SELECT * FROM vtiger_account_custom) va ON q.accountid = va.accountid
            WHERE q.quoteid = (
                SELECT MIN(sub.quoteid)
                FROM vtiger_quotes sub
                WHERE sub.quote_no = q.quote_no
            )";

    // Apply filters
    if ($quoteFilter) {
        $sql .= " AND q.quote_no LIKE '%" . $conn->real_escape_string($quoteFilter) . "%'";
    }
    if ($stageFilter) {
        $sql .= " AND q.quotestage LIKE '%" . $conn->real_escape_string($stageFilter) . "%'";
    }
    if ($accountFilter) {
        $sql .= " AND va.accountname LIKE '%" . $conn->real_escape_string($accountFilter) . "%'";
    }
    if ($countryFilter) {
        $sql .= " AND q.country LIKE '%" . $conn->real_escape_string($countryFilter) . "%'";
    }
    if (isset($_GET['date_range']) && !empty($_GET['date_range'])) {
        $date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['date_range']));
        $start_date = $date_range[0];
        $end_date = isset($date_range[1]) ? $date_range[1] : $date_range[0];
        $sql .= " AND DATE(vqcf.cf_1162) BETWEEN '$start_date' AND '$end_date'";
    }

    if ($profitFilter == 'profit') {
        $sql .= " HAVING invoice_total - supplier_total > 0";
    } else if ($profitFilter == 'loss') {
        $sql .= " HAVING invoice_total - supplier_total < 0";
    } else if ($profitFilter == 'zero') {
        $sql .= " HAVING invoice_total - supplier_total = 0";
    } else {
        $sql .= " HAVING 1=1";
    }

    $sql .= " AND (invoice_total > 0 OR supplier_total > 0) ORDER BY quote_no";
    //var_dump($sql);
    $result = $conn->query($sql);
    ?>

    <h1 style="text-align: center; margin-top: 20px;">Account Summary</h1>

    <table class="styled-table" style="width: 90%; margin: 20px auto;">
        <tr>
            <th></th>
            <th style="text-align: left;">Travel Date</th>
            <th style="text-align: left;">Quote No</th>
            <th style="text-align: left;">Stage</th>
            <th style="text-align: left;">Organisation</th>
            <th>Country</th>
            <th>Pax</th>
            <th>Invoice Total</th>
            <th>Supplier Total</th>
            <th>Percentage</th>
            <th>Profit/Loss</th>
        </tr>
        <tr>
            <form method="GET">
                <input type="hidden" name="opt" value="account">
                <td><button type="submit">Search</button></td>
                <td style="text-align: left;">
                    <input type="text" id="date_range" name="date_range" value="<?php echo isset($_GET['date_range']) ? htmlspecialchars($_GET['date_range']) : ''; ?>">
                </td>
                <td style="text-align: left;"><input type="text" name="quote_no" value="<?= htmlspecialchars($quoteFilter); ?>"></td>
                <td style="text-align: left;"><input type="text" name="stage" value="<?= htmlspecialchars($stageFilter); ?>"></td>
                <td style="text-align: left;"><input type="text" name="accountname" value="<?= htmlspecialchars($accountFilter); ?>"></td>
                <td>
                    <select name="country">
                        <option value="">All</option>
                        <option value="Australia" <?= $countryFilter == 'Australia' ? 'selected' : ''; ?>>AU</option>
                        <option value="New Zealand" <?= $countryFilter == 'New Zealand' ? 'selected' : ''; ?>>NZ</option>
                    </select>
                </td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td style="text-align: center;">
                    <select name="profit">
                        <option value="">All</option>
                        <option value="profit" <?= $profitFilter == 'profit' ? 'selected' : ''; ?>>Profit</option>
                        <option value="loss" <?= $profitFilter == 'loss' ? 'selected' : ''; ?>>Loss</option>
                        <option value="zero" <?= $profitFilter == 'zero' ? 'selected' : ''; ?>>Zero</option>
                    </select>
                </td>
            </form>
        </tr>
        
        <?php 
        $totalInvoice = 0;
        $totalSupplier = 0;
        $totalProfitLoss = 0;
        ?>

        <?php if ($result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): ?>
                <?php 
                $invoiceTotal = $row['invoice_total'];
                $supplierTotal = $row['supplier_total'];
                $profitLoss = $invoiceTotal - $supplierTotal;

                // Sum up totals
                $totalInvoice += $invoiceTotal;
                $totalSupplier += $supplierTotal;
                $totalProfitLoss += $profitLoss;

                // Format country
                $country = ($row['country'] == 'Australia') ? 'AU' : (($row['country'] == 'New Zealand') ? 'NZ' : $row['country']);
                ?>

                <tr>
                    <td></td>
                    <td style="text-align: left;">
                        <?php
                        if (isset($row['cf_1162']) && $row['cf_1162'] != '0000-00-00') {
                            $date = new DateTime($row['cf_1162']);
                            echo $date->format('d-M-Y');
                        }
                        ?>
                    </td>
                    <td style="text-align: left;">
                        <a href="?opt=summary&quoteNumber=<?php echo urlencode($row['quote_no']); ?>">
                            <?php echo htmlspecialchars($row['quote_no']); ?>
                        </a>
                    </td>
                    <td style="text-align: left;"><?= htmlspecialchars($row['quotestage']); ?></td>
                    <td style="text-align: left;"><?= htmlspecialchars($row['accountname']); ?></td>
                    <td><?= htmlspecialchars($country); ?></td>
                    <td><?= $row['no_pax']; ?></td>
                    <td>$ <?= number_format($invoiceTotal, 2); ?></td>
                    <td style="text-align: right;">
                        <!--SUPPLIER BREAKDOWN MODAL CLICKABLE CELL START-->
                        <?php if ($supplierTotal > 0): ?>
                            <a href="#" onclick="openSupplierBreakdownModal_ACCREP_202405_FN('<?= htmlspecialchars($row['quoteid']) ?>', '<?= htmlspecialchars($row['quote_no']) ?>', <?= $supplierTotal ?>); return false;" style="text-decoration: underline; color: blue; cursor: pointer;">
                                $<?= number_format($supplierTotal, 2); ?>
                            </a>
                        <?php else: ?>
                            $<?= number_format($supplierTotal, 2); ?>
                        <?php endif; ?>
                        <!--SUPPLIER BREAKDOWN MODAL CLICKABLE CELL END-->
                    </td>
                    <td>
                        <?= $invoiceTotal != 0 ? number_format(($profitLoss / $invoiceTotal) * 100, 2) : "N/A"; ?> %
                    </td>
                    <td style="background-color: 
                        <?= $profitLoss > 0 ? 'lightgreen' : ($profitLoss < 0 ? 'lightcoral' : ''); ?>;">
                        <?= $profitLoss < 0 ? '($ ' . number_format(abs($profitLoss), 2) . ')' : '$ ' . number_format($profitLoss, 2); ?>
                    </td>
                </tr>
            <?php endwhile; ?>

            <!-- Totals Row -->
            <tr style="font-weight: bold;">
                <td colspan="5" style="text-align: right;"></td>
                <td style="text-align: center;">Total:</td>
                <td style="text-align: center;"></td>
                <td>$ <?= number_format($totalInvoice, 2); ?></td>
                <td>$ <?= number_format($totalSupplier, 2); ?></td>
                <td>
                    <?= $totalInvoice != 0 ? number_format(($totalProfitLoss / $totalInvoice) * 100, 2) : "N/A"; ?> %
                </td>
                <td style="background-color: 
                    <?= $totalProfitLoss > 0 ? 'lightgreen' : ($totalProfitLoss < 0 ? 'lightcoral' : ''); ?>;">
                    <?= $totalProfitLoss < 0 ? '($ ' . number_format(abs($totalProfitLoss), 2) . ')' : '$ ' . number_format($totalProfitLoss, 2); ?>
                </td>
            </tr>
            
        <?php else: ?>
            <tr>
                <td colspan="9">No results found</td>
            </tr>
        <?php endif; ?>
    </table>

    <style>
        .styled-table td input[type="text"],
        .styled-table td select {
            width: 80%;
            height: 30px;
            margin: 0;
        }
        /* <!--SUPPLIER BREAKDOWN MODAL STYLE START--> */
        #sbm_acc_rep_modal_elem_202405_Overlay {
            display: none; /* Hidden by default */
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.6);
            z-index: 10000; /* Very high z-index */
            justify-content: center;
            align-items: center;
        }
        #sbm_acc_rep_modal_elem_202405_ModalContent {
            background-color: #ffffff;
            padding: 25px;
            border-radius: 8px;
            width: 90%;
            max-width: 650px; /* Slightly wider */
            max-height: 85vh;
            overflow-y: auto;
            box-shadow: 0 5px 20px rgba(0,0,0,0.25);
            position: relative;
        }
        #sbm_acc_rep_modal_elem_202405_ModalCloseBtn {
            position: absolute;
            top: 10px;
            right: 15px;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
            border: none;
            background: none;
            color: #555;
        }
        #sbm_acc_rep_modal_elem_202405_ModalCloseBtn:hover {
            color: #000;
        }
        #sbm_acc_rep_modal_elem_202405_BreakdownTable {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        #sbm_acc_rep_modal_elem_202405_BreakdownTable th,
        #sbm_acc_rep_modal_elem_202405_BreakdownTable td {
            border: 1px solid #e0e0e0;
            padding: 10px;
            text-align: left;
        }
        #sbm_acc_rep_modal_elem_202405_BreakdownTable th {
            background-color: #f7f7f7;
            font-weight: bold;
        }
        #sbm_acc_rep_modal_elem_202405_BreakdownTable td:last-child,
        #sbm_acc_rep_modal_elem_202405_BreakdownTable th:last-child {
            text-align: right;
        }
        #sbm_acc_rep_modal_elem_202405_ModalTitle {
            margin-top: 0;
            margin-bottom: 20px;
            font-size: 1.6em;
            color: #333;
            border-bottom: 1px solid #eee;
            padding-bottom: 10px;
        }
        #sbm_acc_rep_modal_elem_202405_Loading {
            text-align: center;
            padding: 30px;
            font-size: 1.2em;
        }
        #sbm_acc_rep_modal_elem_202405_BreakdownTable tfoot td {
            font-weight: bold;
            background-color: #f9f9f9;
        }
        /* <!--SUPPLIER BREAKDOWN MODAL STYLE END--> */

    </style>

    <!--SUPPLIER BREAKDOWN MODAL HTML START-->
    <div id="sbm_acc_rep_modal_elem_202405_Overlay"> <!-- style="display: flex;" will be set by JS -->
        <div id="sbm_acc_rep_modal_elem_202405_ModalContent">
            <button id="sbm_acc_rep_modal_elem_202405_ModalCloseBtn" onclick="closeSupplierBreakdownModal_ACCREP_202405_FN()">×</button>
            <h3 id="sbm_acc_rep_modal_elem_202405_ModalTitle">Supplier Breakdown for Quote #<span id="sbm_acc_rep_modal_elem_202405_QuoteNo"></span></h3>
            <div id="sbm_acc_rep_modal_elem_202405_ModalBody">
                <div id="sbm_acc_rep_modal_elem_202405_Loading" style="display: none;">Loading...</div>
                <table id="sbm_acc_rep_modal_elem_202405_BreakdownTable" style="display: none;"> <!-- Hidden until data loads -->
                    <thead>
                        <tr>
                            <th>Vendor Name</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody id="sbm_acc_rep_modal_elem_202405_BreakdownTableBody">
                        <!-- Data will be populated here by JavaScript -->
                    </tbody>
                    <tfoot>
                        <tr>
                            <td>Total</td>
                            <td id="sbm_acc_rep_modal_elem_202405_ModalTotalAmount"></td>
                        </tr>
                    </tfoot>
                </table>
                <div id="sbm_acc_rep_modal_elem_202405_ErrorMessage" style="display: none; color: red; margin-top: 15px;"></div>
            </div>
        </div>
    </div>
    <!--SUPPLIER BREAKDOWN MODAL HTML END-->


    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        flatpickr("#date_range", {
            mode: "range",
            dateFormat: "Y-m-d",
            defaultDate: "<?php echo isset($_GET['date_range']) ? htmlspecialchars($_GET['date_range']) : ''; ?>"
        });
        
        // <!--SUPPLIER BREAKDOWN MODAL JAVASCRIPT START-->
        const sbmModalOverlay_UNIQUE_ACCREP = document.getElementById('sbm_acc_rep_modal_elem_202405_Overlay');
        const sbmModalTable_UNIQUE_ACCREP = document.getElementById('sbm_acc_rep_modal_elem_202405_BreakdownTable');
        const sbmModalTableBody_UNIQUE_ACCREP = document.getElementById('sbm_acc_rep_modal_elem_202405_BreakdownTableBody');
        const sbmModalLoading_UNIQUE_ACCREP = document.getElementById('sbm_acc_rep_modal_elem_202405_Loading');
        const sbmModalQuoteNoSpan_UNIQUE_ACCREP = document.getElementById('sbm_acc_rep_modal_elem_202405_QuoteNo');
        const sbmModalTotalAmountSpan_UNIQUE_ACCREP = document.getElementById('sbm_acc_rep_modal_elem_202405_ModalTotalAmount');
        const sbmModalErrorMessage_UNIQUE_ACCREP = document.getElementById('sbm_acc_rep_modal_elem_202405_ErrorMessage');

        function openSupplierBreakdownModal_ACCREP_202405_FN(quoteId, quoteNo, expectedTotal) {
            if (!sbmModalOverlay_UNIQUE_ACCREP) {
                console.error("Modal overlay element not found.");
                alert("Error: Cannot display supplier breakdown.");
                return;
            }

            sbmModalQuoteNoSpan_UNIQUE_ACCREP.textContent = quoteNo;
            sbmModalTableBody_UNIQUE_ACCREP.innerHTML = ''; // Clear previous data
            sbmModalTotalAmountSpan_UNIQUE_ACCREP.textContent = '$ ' + parseFloat(expectedTotal).toFixed(2);
            sbmModalLoading_UNIQUE_ACCREP.style.display = 'block';
            sbmModalTable_UNIQUE_ACCREP.style.display = 'none'; // Hide table while loading
            sbmModalErrorMessage_UNIQUE_ACCREP.style.display = 'none'; // Hide error message
            sbmModalOverlay_UNIQUE_ACCREP.style.display = 'flex';


            // Construct AJAX URL. Using the current script for the AJAX endpoint.
            // Adding a cache-busting parameter 'rand' is good practice.
            const ajaxUrl = `ajax_supplier_breakdown.php?quoteid_for_breakdown_ACCREP_202405_PARAM=${encodeURIComponent(quoteId)}&rand=${Date.now()}`;

            fetch(ajaxUrl)
            .then(response => {
                if (!response.ok) {
                    // If HTTP error (e.g., 500, 404), try to get text for more info
                    return response.text().then(text => {
                        throw new Error(`Network response was not ok: ${response.status} ${response.statusText}. Server said: ${text}`);
                    });
                }
                return response.json(); // If response is OK, expect JSON
            })
            .then(data => {
                sbmModalLoading_UNIQUE_ACCREP.style.display = 'none';
                if (data.success && data.items) {
                    if (data.items.length === 0) {
                        sbmModalTableBody_UNIQUE_ACCREP.innerHTML = '<tr><td colspan="2" style="text-align:center;">No supplier payment breakdown found.</td></tr>';
                    } else {
                        let calculatedTotalFromBreakdown = 0;
                        data.items.forEach(item => {
                            const row = sbmModalTableBody_UNIQUE_ACCREP.insertRow();
                            row.insertCell().textContent = item.vendorname || 'N/A';
                            const amount = parseFloat(item.supplier_invoice_amount) || 0;
                            const cellAmount = row.insertCell();
                            cellAmount.textContent = '$ ' + amount.toFixed(2);
                            cellAmount.style.textAlign = "right";
                            calculatedTotalFromBreakdown += amount;
                        });
                        // Optionally update the displayed total with the sum from breakdown items for verification
                        sbmModalTotalAmountSpan_UNIQUE_ACCREP.textContent = '$ ' + calculatedTotalFromBreakdown.toFixed(2);
                    }
                    sbmModalTable_UNIQUE_ACCREP.style.display = 'table'; // Show table
                } else {
                    const errorMsg = `Error loading data: ${data.error || 'Unknown error.'} ${data.debug_query ? '(Query: ' + data.debug_query + ')' : ''}`;
                    sbmModalErrorMessage_UNIQUE_ACCREP.textContent = errorMsg;
                    sbmModalErrorMessage_UNIQUE_ACCREP.style.display = 'block';
                    console.error("AJAX Error:", errorMsg, data);
                }
            })
            .catch(error => {
                sbmModalLoading_UNIQUE_ACCREP.style.display = 'none';
                const errorMsg = `Failed to load breakdown: ${error.message}. Check the browser console (Network tab) for the server's response.`;
                sbmModalErrorMessage_UNIQUE_ACCREP.textContent = errorMsg;
                sbmModalErrorMessage_UNIQUE_ACCREP.style.display = 'block';
                console.error('Error fetching supplier breakdown:', error);
            });
        }

        function closeSupplierBreakdownModal_ACCREP_202405_FN() {
            if (sbmModalOverlay_UNIQUE_ACCREP) {
                sbmModalOverlay_UNIQUE_ACCREP.style.display = 'none';
            }
        }

        // Close modal if user clicks outside the modal content (on the overlay)
        if (sbmModalOverlay_UNIQUE_ACCREP) {
            sbmModalOverlay_UNIQUE_ACCREP.addEventListener('click', function(event) {
                if (event.target === sbmModalOverlay_UNIQUE_ACCREP) { // Check if the click is on the overlay itself
                    closeSupplierBreakdownModal_ACCREP_202405_FN();
                }
            });
        }
        // Close modal on 'Escape' key press
        document.addEventListener('keydown', function(event) {
            if (event.key === "Escape" && sbmModalOverlay_UNIQUE_ACCREP.style.display === 'flex') {
                closeSupplierBreakdownModal_ACCREP_202405_FN();
            }
        });
        // <!--SUPPLIER BREAKDOWN MODAL JAVASCRIPT END-->

    </script>
    <?php
}
else if (($title == 'admin' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'report-hotel-deadline') {
    include "header.php";

    $sql = "SELECT DISTINCT vq.quote_no, va.accountname, vp.productname,
                it_checkin.meta_value AS check_in, it_checkout.meta_value AS check_out,
                it_payment.meta_value AS payment_deadline, it_cancellation.meta_value AS cancellation_deadline
            FROM (SELECT *
                FROM vtiger_quotes
                WHERE quoteid = (
                    SELECT MIN(quoteid) AS quoteid
                    FROM vtiger_quotes AS sub
                    WHERE sub.quote_no = vtiger_quotes.quote_no)
                ORDER BY quote_no DESC) vq
            LEFT JOIN (SELECT * FROM vtiger_account UNION SELECT * FROM vtiger_account_custom) va ON vq.accountid = va.accountid
            LEFT JOIN vtiger_inventoryproductrel vi ON vq.quoteid = vi.id
            LEFT JOIN (SELECT *, '' AS customised FROM vtiger_products UNION ALL SELECT *, 'true' AS customised FROM vtiger_products_custom) vp ON vi.productid = vp.productid
            LEFT JOIN vtiger_itinerary it_checkin ON vq.quoteid = it_checkin.quoteid AND vi.sequence_no = it_checkin.sequence_no AND it_checkin.meta_key = 'check_in'
            LEFT JOIN vtiger_itinerary it_checkout ON vq.quoteid = it_checkout.quoteid AND vi.sequence_no = it_checkout.sequence_no AND it_checkout.meta_key = 'check_out'
            LEFT JOIN vtiger_itinerary it_payment ON vq.quoteid = it_payment.quoteid AND vi.sequence_no = it_payment.sequence_no AND it_payment.meta_key = 'payment_deadline'
            LEFT JOIN vtiger_itinerary it_cancellation ON vq.quoteid = it_cancellation.quoteid AND vi.sequence_no = it_cancellation.sequence_no AND it_cancellation.meta_key = 'cancellation_deadline'
            WHERE vi.cf_928 = 'Hotel'AND ((YEAR(it_cancellation.meta_value) = YEAR(CURDATE()) AND MONTH(it_cancellation.meta_value) >= MONTH(CURDATE())) OR YEAR(it_cancellation.meta_value) > YEAR(CURDATE()))
                AND (it_checkin.meta_value IS NOT NULL
                OR it_checkout.meta_value IS NOT NULL
                OR it_payment.meta_value IS NOT NULL
                OR it_cancellation.meta_value IS NOT NULL);";

    // Initialize array to hold counts for each month
    $currentMonth = (int)date('m');
    $currentYear = (int)date('Y');

    $monthsCount = [];
    for ($i = 0; $i < 12; $i++) {
        $monthKey = date('F Y', mktime(0, 0, 0, $currentMonth + $i, 1, $currentYear));
        $monthsCount[$monthKey] = 0;
    }

    // Run the query
    $result = mysqli_query($conn, $sql) or die(mysqli_error($conn));

    // Process results
    $totalCount = 0;
    while ($row = mysqli_fetch_assoc($result)) {
        $cancellation_deadline = $row['cancellation_deadline'];

        // Create a DateTime object from the date string
        $date = new DateTime($cancellation_deadline);

        // Get the month and year
        $cancel_month = $date->format('m'); // Month in 'mm' format
        $cancel_year = $date->format('Y');  // Year in 'yyyy' format

        // Calculate the key (month name and year) for the cancellation deadline
        $monthKey = date('F Y', mktime(0, 0, 0, $cancel_month, 1, $cancel_year));

        // Increment the count for that month
        if (isset($monthsCount[$monthKey])) {
            $monthsCount[$monthKey]++;
            $totalCount++;
        }
    }

    ?>
    <h1 style="text-align:center; margin-top: 20px;">Hotel Cancelation Deadline</h1>
    <div class="table-container" style="width: 80%; margin: auto;">
        <div class="table-wrapper">
            <table>
                <tr>
                    <?php
                    // Output month headers (starting from the current month)
                    for ($i = 0; $i < 12; $i++) {
                        echo "<th>" . date('M-y', mktime(0, 0, 0, $currentMonth + $i, 1, $currentYear)) . "</th>";
                    }
                    ?>
                    <th>Total</th> <!-- Total column header -->
                </tr>
                <tr>
                    <?php
                    // Output counts for each month
                    $i = 0;
                    foreach ($monthsCount as $month => $count) {
                        $date_range_start = date('Y-m', mktime(0, 0, 0, $currentMonth + $i, 1, $currentYear)) . "-01";
                        $date_range_end = date('Y-m-t', mktime(0, 0, 0, $currentMonth + $i, 1, $currentYear));
                        echo "<td><a href='?opt=detail-hotel-deadline&date_range=$date_range_start to $date_range_end'>$count</a></td>";
                        $i += 1;
                    }
                    ?>
                    <td><?php echo $totalCount; ?></td> <!-- Output total count -->
                </tr>
            </table>
        </div>
    </div>
    <?php
}
else if (($title == 'admin' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'detail-hotel-deadline') {
    include "header.php";

    $sql = "SELECT DISTINCT vq.quote_no, va.accountname, vp.productname,
                it_checkin.meta_value AS check_in, it_checkout.meta_value AS check_out,
                it_payment.meta_value AS payment_deadline, it_cancellation.meta_value AS cancellation_deadline,
                it_booking_status.meta_value AS booking_status
            FROM (SELECT *
                FROM vtiger_quotes
                WHERE quoteid = (
                    SELECT MIN(quoteid) AS quoteid
                    FROM vtiger_quotes AS sub
                    WHERE sub.quote_no = vtiger_quotes.quote_no)
                ORDER BY quote_no DESC) vq
            LEFT JOIN (SELECT * FROM vtiger_account UNION SELECT * FROM vtiger_account_custom) va ON vq.accountid = va.accountid
            LEFT JOIN vtiger_inventoryproductrel vi ON vq.quoteid = vi.id
            LEFT JOIN (SELECT *, '' AS customised FROM vtiger_products UNION ALL SELECT *, 'true' AS customised FROM vtiger_products_custom) vp ON vi.productid = vp.productid
            LEFT JOIN vtiger_itinerary it_checkin ON vq.quoteid = it_checkin.quoteid AND vi.sequence_no = it_checkin.sequence_no AND it_checkin.meta_key = 'check_in'
            LEFT JOIN vtiger_itinerary it_checkout ON vq.quoteid = it_checkout.quoteid AND vi.sequence_no = it_checkout.sequence_no AND it_checkout.meta_key = 'check_out'
            LEFT JOIN vtiger_itinerary it_payment ON vq.quoteid = it_payment.quoteid AND vi.sequence_no = it_payment.sequence_no AND it_payment.meta_key = 'payment_deadline'
            LEFT JOIN vtiger_itinerary it_cancellation ON vq.quoteid = it_cancellation.quoteid AND vi.sequence_no = it_cancellation.sequence_no AND it_cancellation.meta_key = 'cancellation_deadline'
            LEFT JOIN vtiger_itinerary it_booking_status ON vq.quoteid = it_booking_status.quoteid AND vi.sequence_no = it_booking_status.sequence_no AND it_booking_status.meta_key = 'booking_status' -- Join for booking_status
            WHERE vi.cf_928 = 'Hotel'
                AND (it_checkin.meta_value IS NOT NULL
                OR it_checkout.meta_value IS NOT NULL
                OR it_payment.meta_value IS NOT NULL
                OR it_cancellation.meta_value IS NOT NULL)";

    if (isset($_GET['date_range']) && !empty($_GET['date_range'])) {
        $date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['date_range']));
        $start_date = $date_range[0];
        $end_date = isset($date_range[1]) ? $date_range[1] : $date_range[0];
        $sql .= " AND DATE(it_cancellation.meta_value) BETWEEN '$start_date' AND '$end_date'";
    }
    $sql.= " ORDER BY it_cancellation.meta_value ASC;";
    $result = mysqli_query($conn, $sql) or die(mysqli_error($conn));
    ?>

    <h1 style="text-align:center; margin-top: 20px;">Hotel Cancellation Deadline</h1>
    <p style="text-align:center;"><?php echo $_GET['date_range']; ?></p>
    <div class="table-container" style="width: 80%; margin: auto;">
        <div class="table-wrapper">
            <table border="1" style="width: 100%; border-collapse: collapse;">
                <tr>
                    <th>Quote No</th>
                    <th>Account Name</th>
                    <th>Product Name</th>
                    <th>Check In</th>
                    <th>Check Out</th>
                    <th>Payment Deadline</th>
                    <th>Cancellation Deadline</th>
                    <th>Booking Status</th>
                    <th>Notes</th>
                </tr>
                <?php while ($row = mysqli_fetch_assoc($result)): ?>
                    <tr>
                        <td><?php echo $row['quote_no']; ?></td>
                        <td><?php echo $row['accountname']; ?></td>
                        <td><?php echo $row['productname']; ?></td>
                        <td><?php echo !empty($row['check_in']) ? (new DateTime($row['check_in']))->format('d-M-y') : ''; ?></td>
                        <td><?php echo !empty($row['check_out']) ? (new DateTime($row['check_out']))->format('d-M-y') : ''; ?></td>
                        <td><?php echo !empty($row['payment_deadline']) ? (new DateTime($row['payment_deadline']))->format('d-M-y') : ''; ?></td>
                        <td><?php echo !empty($row['cancellation_deadline']) ? (new DateTime($row['cancellation_deadline']))->format('d-M-y') : ''; ?></td>
                        <td><?php echo $row['booking_status']; ?></td>
                        <td>
                            <a href="?opt=summary&quoteNumber=<?php echo urlencode($row['quote_no']); ?>&edit=div-notes">
                                <i class="fa-solid fa-clipboard"></i>
                            </a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </table>
        </div>
    </div>
    <?php
}
else if (($title == 'admin' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'product-deadline') {
    // Handle POST request to update multiple is_paid statuses
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_is_paid'])) {
        foreach ($_POST['is_paid'] as $auto_id) {
            $update_sql = "UPDATE vtiger_product_payment SET is_paid = 1 WHERE auto_id = $auto_id;";
            mysqli_query($conn, $update_sql);
        }
    }

    include "header.php";

    // Retrieve filter values from GET parameters
    $travel_date_range = $_GET['travel_date_range'] ?? '';
    $payment_date_range = $_GET['payment_date_range'] ?? '';
    $productname_filter = $_GET['productname'] ?? '';
    $quote_no_filter = $_GET['quote_no'] ?? '';
    $is_paid_filter = $_GET['is_paid'] ?? '';

    if (isset($_GET['travel_date_range']) && !empty($_GET['travel_date_range'])) {
        $travel_dates = explode(" to ", $_GET['travel_date_range']);
        $travel_start_date = $travel_dates[0];
        $travel_end_date = $travel_dates[1] ?? $travel_dates[0];
    }
    if (isset($_GET['payment_date_range']) && !empty($_GET['payment_date_range'])) {
        $payment_dates = explode(" to ", $_GET['payment_date_range']);
        $payment_start_date = $payment_dates[0];
        $payment_end_date = $payment_dates[1] ?? $payment_dates[0];
    }
    
    ?>
    <h1 style="text-align:center; margin-top: 20px;">Product Payment Deadline</h1>
    <table class="styled-table" style="width: 80%; margin: 20px auto;">
        <tr>
            <th></th>
            <th>
                <input type="checkbox" id="select_all"> Paid
            </th>
            <th style="text-align: left;">Travel Date</th>
            <th style="text-align: left;">Payment Deadline</th>
            <th style="text-align: left;">Product Name</th>
            <th style="text-align: left;">Quote Number</th>
        </tr>
        <tr>
            <!-- Filter Form in Table Row -->
            <form method="GET" action="">
                <input type="hidden" name="opt" value="product-deadline">
                <td style="width: 2%;">
                    <button type="submit">Search</button>
                </td>
                <td style="width: 5%;">
                    <select name="is_paid" style="width: 80%; height: 30px; margin: 0;">
                        <option value="">All</option>
                        <option value="0" <?php echo ($is_paid_filter == '0') ? 'selected' : ''; ?>>Unpaid</option>
                        <option value="1" <?php echo ($is_paid_filter == '1') ? 'selected' : ''; ?>>Paid</option>
                    </select>
                </td>
                <td style="text-align: left;">
                    <input type="text" id="travel_date_range" name="travel_date_range" class="flatpickr-input" value="<?php echo htmlspecialchars($travel_date_range); ?>" style="width: 80%; height: 30px;">
                </td>
                <td style="text-align: left;">
                    <input type="text" id="payment_date_range" name="payment_date_range" class="flatpickr-input" value="<?php echo htmlspecialchars($payment_date_range); ?>" style="width: 80%; height: 30px;">
                </td>
                <td style="text-align: left;">
                    <input type="text" name="productname" value="<?php echo htmlspecialchars($productname_filter); ?>" style="width: 80%; height: 30px;">
                </td>
                <td style="text-align: left;">
                    <input type="text" name="quote_no" value="<?php echo htmlspecialchars($quote_no_filter); ?>" style="height: 30px;">
                </td>
            </form>
        </tr>
        <?php
        // Construct the query with filters
        $sql = "SELECT vpp.auto_id, vpp.travel_date, vpp.payment_deadline, vpp.is_paid, vp.productname, vq.quote_no
                FROM vtiger_product_payment vpp
                LEFT JOIN (SELECT productid, productName AS productname FROM tdu_products UNION ALL SELECT productid, productname FROM vtiger_products_custom) vp 
                    ON vpp.productid = vp.productid
                LEFT JOIN vtiger_quotes vq 
                    ON vpp.quoteid = vq.quoteid
                WHERE vq.quotestage IN (
                    'Accepted', 'PRE QA - pending', 'PRE QA - completed', 'Payment Received - Release Vouchers',
                    'Final QA', 'Delivered', 'On Ground', 'Accounts - Reconciliation', 'Completed (Accounts)'
                )";

        // Apply filters if set
        if (!empty($travel_start_date) && !empty($travel_end_date)) {
            $sql .= " AND vpp.travel_date BETWEEN '" . mysqli_real_escape_string($conn, $travel_start_date) . "' AND '" . mysqli_real_escape_string($conn, $travel_end_date) . "'";
        }
        if (!empty($payment_start_date) && !empty($payment_end_date)) {
            $sql .= " AND vpp.payment_deadline BETWEEN '" . mysqli_real_escape_string($conn, $payment_start_date) . "' AND '" . mysqli_real_escape_string($conn, $payment_end_date) . "'";
        }
        if (!empty($productname_filter)) {
            $sql .= " AND vp.productname LIKE '%" . mysqli_real_escape_string($conn, $productname_filter) . "%'";
        }
        if (!empty($quote_no_filter)) {
            $sql .= " AND vq.quote_no LIKE '%" . mysqli_real_escape_string($conn, $quote_no_filter) . "%'";
        }
        if ($is_paid_filter === '0') {
            $sql .= " AND vpp.is_paid = 0";
        } elseif ($is_paid_filter === '1') {
            $sql .= " AND vpp.is_paid = 1";
        }
        if (empty($travel_start_date) && empty($payment_start_date)) {
            $sql .= " AND vpp.payment_deadline >= DATE(NOW())";
        }

        $limit = 20;
        $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
        $page = max($page, 1);
        $offset = ($page - 1) * $limit;

        $sql_total = $sql;
        $total_result = mysqli_query($conn, $sql_total);
        $totalRecords = mysqli_num_rows($total_result);
        $totalPages = ceil($totalRecords / $limit);

        $sql .= " ORDER BY vq.quote_no DESC, vpp.payment_deadline ASC, vpp.travel_date ASC LIMIT $limit OFFSET $offset";

        // $sql .= " ORDER BY vpp.payment_deadline ASC";
        // if (empty($travel_start_date) && empty($payment_start_date)) {
        //     $sql .= " LIMIT 20";
        // }
        $result = mysqli_query($conn, $sql);

        ?>
        <form method="POST" action="">
            <?php
            while ($row = mysqli_fetch_assoc($result)) {
                $auto_id = $row['auto_id'];
                $is_paid = $row['is_paid'] ?? 0;
                ?>
                <tr>
                    <td></td>
                    <td>
                        <input type="checkbox" class="is_paid_checkbox" name="is_paid[]" value="<?php echo $auto_id; ?>" <?php echo $is_paid == 1 ? 'checked' : ''; ?>>
                        <?php echo $is_paid == 1 ? 'Paid' : ''; ?>
                    </td>
                    <td style="text-align: left;"><?php echo htmlspecialchars($row['travel_date']); ?></td>
                    <td style="text-align: left;"><?php echo htmlspecialchars($row['payment_deadline']); ?></td>
                    <td style="text-align: left;"><?php echo htmlspecialchars($row['productname']); ?></td>
                    <td style="text-align: left;"><a href="?opt=summary&quoteNumber=<?php echo urlencode($row['quote_no']); ?>"><?php echo htmlspecialchars($row['quote_no']); ?></a></td>
                </tr>
                <?php
            }
            ?>
            <tr>
                <td colspan="6">
                    <button type="submit" name="update_is_paid" style="padding: 10px 20px;">Mark All Selected as Paid</button>
                </td>
            </tr>
            <tr>
                <td colspan="6">Number of results: <?= $totalRecords ?></td>
            </tr>
        </form>
    </table>

    <div class="pagination" style="margin-top: 0;">
        <div>
            <?php if ($page > 1): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
            <?php endif; ?>

            <?php
            $max_pages = min($totalPages, $page + 2);
            for ($i = $page; $i <= $max_pages; $i++): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" <?php if ($i == $page) echo 'style="background-color: #334155; color: white;"'; ?>>
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($page < $totalPages): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
            <?php endif; ?>
        </div>
        
        <form method="GET" action="" style="display:inline;">
            <?php
            foreach ($_GET as $key => $value) {
                if ($key != 'page') {
                    echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                }
            }
            ?>
            <input type="number" name="page" min="1" max="<?php echo $totalPages; ?>" value="<?php echo $page; ?>" style="width:75px;"> / <?php echo $totalPages; ?>
            <button type="submit">Jump</button>
        </form>
    </div>
    <style>
        .pagination {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 20px 0;
        }
        
        .pagination div {
            display: flex;
            align-items: center;
        }
        
        .pagination a {
            text-decoration: none;
            padding: 8px 12px;
            margin: 0 5px;
            border: 1px solid #334155;
            color: #334155;
            border-radius: 4px;
            transition: background-color 0.3s, color 0.3s;
        }
        
        .pagination a:hover {
            background-color: #334155;
            color: white;
        }
        
        .pagination input[type="number"] {
            width: 50px;
            padding: 10px;
            margin-left: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        
        .pagination button {
            padding: 10px 10px;
            margin-left: 5px;
            border: none;
            border-radius: 4px;
            background-color: #334155;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .pagination button:hover {
            background-color: #334155;
        }
        
        tr:nth-child(odd) {
            background-color: #f9f9f9;
        }

        .styled-table td input[type="text"], .styled-table td select, .styled-table td input[type="date"] {
            width: 100%;
            height: 30px;
            margin: 0;
        }
    </style>

    <!-- Include Flatpickr JS and enable range mode -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        flatpickr("#travel_date_range", {
            mode: "range",
            dateFormat: "Y-m-d"
        });
        flatpickr("#payment_date_range", {
            mode: "range",
            dateFormat: "Y-m-d"
        });

        // JavaScript for "Select All" functionality
        document.getElementById("select_all").addEventListener("change", function() {
            var checkboxes = document.querySelectorAll(".is_paid_checkbox");
            checkboxes.forEach(function(checkbox) {
                checkbox.checked = document.getElementById("select_all").checked;
            });
        });
    </script>
    <?php
}

// Operation Report
else if (($title == 'admin' || $title == 'group') && isset($_GET['opt']) && $_GET['opt'] == 'report-ops') {
    include "header.php";
    $sql = "
        SELECT 
            IF(vqr.ops_by_person IS NULL OR vqr.ops_by_person = '', 'Unassigned', vqr.ops_by_person) AS name,
            COUNT(vq.quoteid) AS count
        FROM (SELECT *
            FROM vtiger_quotes
            WHERE quoteid = (
                SELECT MIN(quoteid) AS quoteid
                FROM vtiger_quotes AS sub
                WHERE sub.quote_no = vtiger_quotes.quote_no)
            ORDER BY quote_no DESC) vq
        LEFT JOIN vtiger_quotes_related vqr ON vq.quoteid = vqr.quoteid
        WHERE vq.quotestage NOT LIKE '%create%' AND vq.quotestage NOT LIKE '%reject%'
        GROUP BY name

        UNION ALL

        SELECT 
            'Total Rejected Quotes' AS name, 
            COUNT(*) AS count
        FROM  (SELECT *
            FROM vtiger_quotes
            WHERE quoteid = (
                SELECT MIN(quoteid) AS quoteid
                FROM vtiger_quotes AS sub
                WHERE sub.quote_no = vtiger_quotes.quote_no)
            ORDER BY quote_no DESC) vq 
        WHERE vq.quotestage = 'Auto Rejected' or vq.quotestage = 'Rejected' or vq.quotestage = 'Rejected After Confirmation' 

        UNION ALL

        SELECT 
            'Total Created Quotes' AS name, 
            COUNT(*) AS count
        FROM  (SELECT *
            FROM vtiger_quotes
            WHERE quoteid = (
                SELECT MIN(quoteid) AS quoteid
                FROM vtiger_quotes AS sub
                WHERE sub.quote_no = vtiger_quotes.quote_no)
            ORDER BY quote_no DESC) vq 
        WHERE vq.quotestage = 'Create Project' or vq.quotestage = 'Created'
    ";

    $result = $conn->query($sql);

    ?>
    <h1 style="text-align:center; margin-top: 20px;">Group Quotes Overview</h1>
    <div class="table-container" style="width: 30%; margin: auto;">
        <div class="table-wrapper">
            <table>
                <tr>
                    <th>Operation Person</th>
                    <th>Confirm group assigned</th>
                </tr>
                <?php
                if ($result->num_rows > 0) {
                    while($row = $result->fetch_assoc()) {
                        if ($row['name'] == 'Total Created Quotes' || $row['name'] == 'Total Rejected Quotes') {
                            continue;
                        }
                        ?>
                        <tr>
                        <td>
                            <?php 
                            if ($row['name'] == 'Total Created Quotes' || $row['name'] == 'Total Rejected Quotes') {
                                $quote_stage = ($row['name'] == 'Total Created Quotes') ? 'Create' : 'Reject';
                                echo "<a href='?opt=search&quote_stage=" . $quote_stage . "'>" . $row['name'] . "</a>";
                            } else {
                                echo "<a href='?opt=search&ops_by_person=" . urlencode($row['name']) . "'>" . $row['name'] . "</a>";
                            }
                            ?>
                        </td>
                            <td><?php echo $row['count']; ?></td>
                        </tr>
                        <?php
                    }
                } else {
                    ?>
                    <tr>
                        <td colspan="2">No results found</td>
                    </tr>
                    <?php
                }
                ?>
            </table>
        </div>
    </div>
    <?php

    $activeStages = fetchActiveQuoteStages($conn);
    $groupStages = fetchGroupQuoteStages($conn);
    $commonStages = array_intersect($activeStages, $groupStages);
    $active_quote_stages = implode(',', $commonStages);
    ?>
    <div id="loader">
        <p>Loading...</p><br>
    </div>
    <style>
        #loader {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 50vh;
            font-size: 2em;
        }
    </style>
    <div id="content-all" style="display: none;" style="width: 100%;">
        <?php
        $sql = "SELECT 
                    IF(vqr.ops_by_person IS NULL OR vqr.ops_by_person = '', 'Unassigned', vqr.ops_by_person) AS name,
                    COUNT(
                        CASE 
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) THEN vq.quoteid
                        END
                    ) AS count_per_month,
                    MONTH(vqcf.cf_1162) AS month_num
                FROM (SELECT *
                    FROM vtiger_quotes
                    WHERE quoteid = (
                        SELECT MIN(quoteid) AS quoteid
                        FROM vtiger_quotes AS sub
                        WHERE sub.quote_no = vtiger_quotes.quote_no)
                    ORDER BY quote_no DESC) vq
                LEFT JOIN vtiger_quotes_related vqr ON vq.quoteid = vqr.quoteid
                LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                WHERE vq.quotestage NOT LIKE '%reject%'
                GROUP BY name, month_num
                ORDER BY month_num ASC;";
        $result = $conn->query($sql);

        // Organizing data by person and month
        $personData = [];
        $totalPerMonth = array_fill(1, 12, 0); // Total for each month
        while ($row = $result->fetch_assoc()) {
            $personName = $row['name'];
            $monthNum = $row['month_num'];
            $count = $row['count_per_month'];

            if (!isset($personData[$personName])) {
                $personData[$personName] = array_fill(1, 12, 0); // Initialize for 12 months with 0
            }

            $personData[$personName][$monthNum] = $count;
            $totalPerMonth[$monthNum] += $count; // Sum counts per month
        }
        ?>
        <div class="table-container" style="width: 80%; margin: auto;">
            <div class="table-wrapper">
                <h2 style="margin-bottom: 10px;">Working Quotes by Ops (Past 6 Months)</h2>
                <table>
                    <tr>
                        <th style="width: 15%;">Ops By Person</th>
                        <?php
                        // Output month headers (starting from the current month)
                        for ($i = 1; $i <= 6; $i++) {
                            $monthName = date("M-y", strtotime("first day of -$i month"));
                            echo "<th>$monthName</th>";
                        }
                        ?>
                        <th>Total</th> <!-- Total column header -->
                    </tr>
                    <?php
                    // Output data for each person
                    foreach ($personData as $personName => $monthsData) {
                        echo "<tr>";
                        echo "<td>$personName</td>";

                        $totalPerPerson = 0; // Sum counts for this person
                        // Output counts for each month
                        for ($i = 1; $i <= 6; $i++) {
                            $monthNum = date("n", strtotime("first day of -$i month")); // Get numeric month
                            $startDate = date("Y-m-01", strtotime("first day of -$i month")); // Start of the month
                            $endDate = date("Y-m-t", strtotime("first day of -$i month")); // End of the month
                            $dateRange = "$startDate to $endDate";
                            $count = $monthsData[$monthNum];

                            // Generate the link for each month
                            if($count != 0) {
                                $link = "<a href='?opt=search&quote_stage=$active_quote_stages&ops_by_person=" . urlencode($personName) . "&date_range=$dateRange'>$count</a>";
                                // $link = "<a href='?opt=agent-quote-stage&ops_by_person=" . urlencode($personName) . "&date_range=$dateRange'>$count</a>";
                            } else {
                                $link = '';
                            }

                            echo "<td>$link</td>";
                            $totalPerPerson += $count; // Add to person total
                        }

                        // Output total count for this person
                        echo "<td>$totalPerPerson</td>";

                        echo "</tr>";
                    }

                    $sql_delivered = "SELECT 
                                COUNT(
                                    CASE 
                                        WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) THEN vq.quoteid
                                        WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) THEN vq.quoteid
                                        WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) THEN vq.quoteid
                                        WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) THEN vq.quoteid
                                        WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) THEN vq.quoteid
                                        WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) THEN vq.quoteid
                                    END
                                ) AS count_per_month,
                                MONTH(vqcf.cf_1162) AS month_num
                            FROM (SELECT *
                                FROM vtiger_quotes
                                WHERE quoteid = (
                                    SELECT MIN(quoteid) AS quoteid
                                    FROM vtiger_quotes AS sub
                                    WHERE sub.quote_no = vtiger_quotes.quote_no)
                                ORDER BY quote_no DESC) vq
                            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                            WHERE vq.quotestage='On Ground - Changes (Ops)' 
                            GROUP BY month_num
                            ORDER BY month_num ASC;";
                    $result_delivered = $conn->query($sql_delivered);
                    // Fetch and prepare delivered data
                    $deliveredData = [];
                    if ($result_delivered->num_rows > 0) {
                        while ($row = $result_delivered->fetch_assoc()) {
                            $monthNum = $row['month_num'];
                            $deliveredData[$monthNum] = $row['count_per_month'];
                            $totalPerMonth[$monthNum] += $row['count_per_month'];
                        }
                    }

                    echo "<tr>";
                    echo "<td>Arun Karotiya (On Ground)</td>";
                    $totalDelivered = 0;

                    // Loop through 12 months
                    for ($i = 1; $i <= 6; $i++) {
                        $monthNum = date("n", strtotime("first day of -$i month")); // Get numeric month
                        $startDate = date("Y-m-01", strtotime("first day of -$i month")); // Start of the month
                        $endDate = date("Y-m-t", strtotime("first day of -$i month")); // End of the month
                        $dateRange = "$startDate to $endDate";

                        $countDelivered = isset($deliveredData[$monthNum]) ? $deliveredData[$monthNum] : 0;

                        if ($countDelivered != 0) {
                            echo "<td><a href='?opt=search&quote_stage=" . urlencode('On Ground - Changes (Ops)') . "&date_range=$dateRange'>$countDelivered</a></td>";
                        } else {
                            echo "<td></td>";
                        }

                        $totalDelivered += $countDelivered;
                    }

                    // Output total for delivered
                    echo "<td>$totalDelivered</td>";
                    echo "</tr>";
                    ?>

                    <tr>
                        <th>Total</th>
                        <?php
                        $grandTotal = 0; // Total for all persons and months
                        // Output total per month
                        for ($i = 1; $i <= 6; $i++) {
                            $monthNum = date("n", strtotime("first day of -$i month")); // Get numeric month
                            $startDate = date("Y-m-01", strtotime("first day of -$i month")); // Start of the month
                            $endDate = date("Y-m-t", strtotime("first day of -$i month")); // End of the month

                            $sql_country = "SELECT vq.country, COUNT(*) AS country_count
                                            FROM (
                                                SELECT *
                                                FROM vtiger_quotes
                                                WHERE quoteid = (
                                                    SELECT MIN(quoteid) AS quoteid
                                                    FROM vtiger_quotes AS sub
                                                    WHERE sub.quote_no = vtiger_quotes.quote_no
                                                )
                                                ORDER BY quote_no DESC
                                            ) vq
                                            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                                            WHERE ((vq.quotestage NOT LIKE '%deliver%'
                                                AND vq.quotestage NOT LIKE '%reject%'
                                                AND vq.quotestage NOT LIKE '%create%'
                                                AND vq.quotestage NOT LIKE '%requote%'
                                                AND vq.quotestage NOT LIKE '%complete%'
                                                AND vq.quotestage NOT LIKE '%Reconciliation%'
                                                AND vq.quotestage NOT LIKE '%Final QA%'
                                                AND vq.quotestage != 'Accepted' 
                                                AND vq.quotestage != 'Handover to Ops'
                                                AND vq.quotestage != 'Create Project'
                                                AND vq.quotestage NOT LIKE '%Partial Payment Due%'
                                                AND vq.quotestage NOT LIKE '%TA Verification%')
                                                OR vq.quotestage = 'On Ground - Changes (Ops)')
                                                AND vqcf.cf_1162 >= '$startDate' AND vqcf.cf_1162 <= '$endDate'
                                            GROUP BY vq.country;";

                            $result_country = $conn->query($sql_country);

                            // Fetch the results and display the count for each country
                            $au = 0;
                            $nz = 0;
                            if ($result_country->num_rows > 0) {
                                while ($row = $result_country->fetch_assoc()) {
                                    if($row['country'] == 'Australia') {
                                        $au += $row['country_count'];
                                    }
                                    else {
                                        $nz += $row['country_count'];
                                    }
                                }
                            }

                            $dateRange = "$startDate to $endDate";
                            $totalForMonth = $totalPerMonth[$monthNum];
                            if($totalForMonth != 0) {
                                echo "<td style='white-space: nowrap;'><a href='?opt=search&quote_stage=$active_quote_stages&date_range=$dateRange'>$totalForMonth</a> [AU: $au, NZ: $nz]</td>";
                            }
                            else {
                                echo "<td></td>";
                            }
                            
                            $grandTotal += $totalForMonth;
                        }
                        // Output grand total
                        echo "<th>$grandTotal</th>";
                        ?>
                    </tr>
                </table>
            </div>
        </div>

        <?php
        $sql = "SELECT 
                    quotestage,
                    COUNT(
                        CASE 
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) THEN vq.quoteid
                            WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) THEN vq.quoteid
                        END
                    ) AS count_per_month,
                    MONTH(vqcf.cf_1162) AS month_num
                FROM (SELECT *
                    FROM vtiger_quotes
                    WHERE quoteid = (
                        SELECT MIN(quoteid) AS quoteid
                        FROM vtiger_quotes AS sub
                        WHERE sub.quote_no = vtiger_quotes.quote_no)
                    ORDER BY quote_no DESC) vq
                LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                GROUP BY quotestage, month_num
                ORDER BY month_num ASC;";

        $result = $conn->query($sql);

        // Organizing data by quote stage and month
        $quoteStageData = [];
        $totalPerMonth = array_fill(1, 12, 0); // Total for each month
        while ($row = $result->fetch_assoc()) {
            $quoteStage = $row['quotestage'];
            $monthNum = $row['month_num'];
            $count = $row['count_per_month'];

            if (!isset($quoteStageData[$quoteStage])) {
                $quoteStageData[$quoteStage] = array_fill(1, 12, 0); // Initialize for 12 months with 0
            }

            $quoteStageData[$quoteStage][$monthNum] = $count;
            $totalPerMonth[$monthNum] += $count; // Sum counts per month
        }
        ?>
        <div class="table-container" style="width: 80%; margin: auto;">
            <div class="table-wrapper">
                <h2 style="margin-bottom: 10px;">Quotes based on Stage (Past 6 Months)</h2>
                <table>
                    <tr>
                        <th style="width: 15%;">Quote Stage</th>
                        <?php
                        // Output month headers (starting from the current month)
                        for ($i = 1; $i <= 6; $i++) {
                            $monthName = date("M-y", strtotime("first day of -$i month"));
                            echo "<th>$monthName</th>";
                        }
                        ?>
                        <th>Total</th> <!-- Total column header -->
                    </tr>
                    <?php
                    // Output data for each quote stage
                    foreach ($quoteStageData as $quoteStage => $monthsData) {
                        echo "<tr>";
                        echo "<td>$quoteStage</td>";

                        $totalPerQuoteStage = 0; // Sum counts for this quote stage
                        // Output counts for each month
                        for ($i = 1; $i <= 6; $i++) {
                            $monthNum = date("n", strtotime("first day of -$i month")); // Get numeric month
                            $startDate = date("Y-m-01", strtotime("first day of -$i month")); // Start of the month
                            $endDate = date("Y-m-t", strtotime("first day of -$i month")); // End of the month
                            $dateRange = "$startDate to $endDate";
                            $count = $monthsData[$monthNum];

                            // Generate the link for each month
                            if($count != 0) {
                                $link = "<a href='?opt=search&quote_stage=" . urlencode($quoteStage) . "&date_range=$dateRange'>$count</a>";
                            } else {
                                $link = '';
                            }

                            echo "<td>$link</td>";
                            $totalPerQuoteStage += $count; // Add to quote stage total
                        }

                        // Output total count for this quote stage
                        echo "<td>$totalPerQuoteStage</td>";

                        echo "</tr>";
                    }
                    ?>
                    <tr>
                        <th>Total</th>
                        <?php
                        $grandTotal = 0; // Total for all quote stages and months
                        // Output total per month
                        for ($i = 1; $i <= 6; $i++) {
                            $monthNum = date("n", strtotime("first day of -$i month")); // Get numeric month
                            $totalForMonth = $totalPerMonth[$monthNum];
                            if($totalForMonth != 0) {
                                echo "<th>$totalForMonth</th>";
                            }
                            else {
                                echo "<th></th>";
                            }
                            $grandTotal += $totalForMonth;
                        }
                        // Output grand total
                        echo "<th>$grandTotal</th>";
                        ?>
                    </tr>
                </table>
            </div>
        </div>
        <style>
            .table-wrapper table tr th {
                width: 7%;
            }
            .table-wrapper table tr:nth-child(odd) {
                background-color: #f2f2f2;
            }
        </style>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('loader').style.display = 'none'; // Hide loader
            document.getElementById('content-all').style.display = 'block'; // Show content
        });
    </script>
    <?php
}
else if (($title == 'admin' || $title == 'group' || $title == 'account' || $title == 'qa') && isset($_GET['opt']) && $_GET['opt'] == 'report-payment-deadline') {
    include "header.php";

    $sql = "SELECT 
                IF(vqr.ops_by_person IS NULL OR vqr.ops_by_person = '', 'Unassigned', vqr.ops_by_person) AS name,
                COUNT(CASE 
                    WHEN MONTH(vqcf.cf_1182) = MONTH(CURDATE()) THEN vq.quoteid
                    WHEN MONTH(vqcf.cf_1182) = MONTH(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) THEN vq.quoteid
                    WHEN MONTH(vqcf.cf_1182) = MONTH(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) THEN vq.quoteid
                    WHEN MONTH(vqcf.cf_1182) = MONTH(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) THEN vq.quoteid
                    WHEN MONTH(vqcf.cf_1182) = MONTH(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) THEN vq.quoteid
                    WHEN MONTH(vqcf.cf_1182) = MONTH(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) THEN vq.quoteid
                    WHEN MONTH(vqcf.cf_1182) = MONTH(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) THEN vq.quoteid
                    WHEN MONTH(vqcf.cf_1182) = MONTH(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) THEN vq.quoteid
                    WHEN MONTH(vqcf.cf_1182) = MONTH(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) THEN vq.quoteid
                    WHEN MONTH(vqcf.cf_1182) = MONTH(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) THEN vq.quoteid
                    WHEN MONTH(vqcf.cf_1182) = MONTH(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) THEN vq.quoteid
                    WHEN MONTH(vqcf.cf_1182) = MONTH(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) THEN vq.quoteid
                END) AS count_per_month,
                MONTH(vqcf.cf_1182) AS month_num
            FROM (SELECT *
                FROM vtiger_quotes
                WHERE quoteid = (
                    SELECT MIN(quoteid) AS quoteid
                    FROM vtiger_quotes AS sub
                    WHERE sub.quote_no = vtiger_quotes.quote_no)
                ORDER BY quote_no DESC) vq
            LEFT JOIN vtiger_quotes_related vqr ON vq.quoteid = vqr.quoteid
            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
            WHERE vq.quotestage LIKE '%Accepted%' 
            AND ((YEAR(vqcf.cf_1182) = YEAR(CURDATE()) AND MONTH(vqcf.cf_1182) >= MONTH(CURDATE())) OR YEAR(vqcf.cf_1182) > YEAR(CURDATE()))
            GROUP BY name, month_num
            ORDER BY month_num ASC;";
    $result = $conn->query($sql);

    // Organizing data by person and month
    $personData = [];
    $totalPerMonth = array_fill(1, 12, 0); // Total for each month
    while ($row = $result->fetch_assoc()) {
        $personName = $row['name'];
        $monthNum = $row['month_num'];
        $count = $row['count_per_month'];

        if (!isset($personData[$personName])) {
            $personData[$personName] = array_fill(1, 12, 0); // Initialize for 12 months with 0
        }

        $personData[$personName][$monthNum] = $count;
        $totalPerMonth[$monthNum] += $count; // Sum counts per month
    }

    $active_quote_stages = implode(',', fetchAcceptedQuoteStages($conn));
    ?>

    <h1 style="text-align:center; margin-top: 20px;">Group Deadline</h1>
    <div class="table-container" style="width: 80%; margin: auto;">
        <div class="table-wrapper">
            <h2 style="margin-bottom: 10px;">Payment Deadline Summary</h2>
            <table>
                <tr>
                    <th style="width: 15%;">Ops By Person</th>
                    <?php
                    // Output month headers (starting from the current month)
                    for ($i = 0; $i < 12; $i++) {
                        $monthName = date("M-y", strtotime("first day of +$i month"));
                        echo "<th>$monthName</th>";
                    }
                    ?>
                    <th>Total</th> <!-- Total column header -->
                </tr>
                <?php
                // Output data for each person
                foreach ($personData as $personName => $monthsData) {
                    echo "<tr>";
                    echo "<td>$personName</td>";

                    $totalPerPerson = 0; // Sum counts for this person
                    // Output counts for each month
                    for ($i = 0; $i < 12; $i++) {
                        $monthNum = date("n", strtotime("first day of +$i month")); // Get numeric month
                        $startDate = date("Y-m-01", strtotime("first day of +$i month")); // Start of the month
                        $endDate = date("Y-m-t", strtotime("first day of +$i month")); // End of the month
                        $dateRange = "$startDate to $endDate";
                        $count = $monthsData[$monthNum];

                        // Generate the link for each month
                        if($count != 0) {
                            $link = "<a href='?opt=search&quote_stage=$active_quote_stages&ops_by_person=" . urlencode($personName) . "&payment_deadline=$dateRange'>$count</a>";
                        } else {
                            $link = '';
                        }

                        echo "<td>$link</td>";
                        $totalPerPerson += $count; // Add to person total
                    }

                    // Output total count for this person
                    echo "<td>$totalPerPerson</td>";

                    echo "</tr>";
                }
                ?>
                <tr>
                    <th>Total</th>
                    <?php
                    $grandTotal = 0; // Total for all persons and months
                    // Output total per month
                    for ($i = 0; $i < 12; $i++) {
                        $monthNum = date("n", strtotime("first day of +$i month")); // Get numeric month
                        $startDate = date("Y-m-01", strtotime("first day of +$i month")); // Start of the month
                        $endDate = date("Y-m-t", strtotime("first day of +$i month")); // End of the month
                        $dateRange = "$startDate to $endDate";
                        $totalForMonth = $totalPerMonth[$monthNum];
                        if($totalForMonth != 0) {
                            echo "<td><a href='?opt=search&quote_stage=$active_quote_stages&payment_deadline=$dateRange'>$totalForMonth</a></td>";
                        }
                        else {
                            echo "<td></td>";
                        }
                        
                        $grandTotal += $totalForMonth;
                    }
                    // Output grand total
                    echo "<th>$grandTotal</th>";
                    ?>
                </tr>
            </table>
        </div>
    </div>
    <?php

    $sql = "SELECT 
            IF(vqr.ops_by_person IS NULL OR vqr.ops_by_person = '', 'Unassigned', vqr.ops_by_person) AS name,
            COUNT(
                CASE 
                    WHEN YEAR(vqcf.cf_1162) = YEAR(CURDATE()) AND MONTH(vqcf.cf_1162) = MONTH(CURDATE()) THEN vq.quoteid
                    WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) THEN vq.quoteid
                    WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) THEN vq.quoteid
                    WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) THEN vq.quoteid
                    WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) THEN vq.quoteid
                    WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) THEN vq.quoteid
                    WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) THEN vq.quoteid
                    WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) THEN vq.quoteid
                    WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) THEN vq.quoteid
                    WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) THEN vq.quoteid
                    WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) THEN vq.quoteid
                    WHEN YEAR(vqcf.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) AND MONTH(vqcf.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) THEN vq.quoteid
                END
            ) AS count_per_month,
            MONTH(vqcf.cf_1162) AS month_num
            FROM (SELECT *
            FROM vtiger_quotes
            WHERE quoteid = (
                SELECT MIN(quoteid) AS quoteid
                FROM vtiger_quotes AS sub
                WHERE sub.quote_no = vtiger_quotes.quote_no)
            ORDER BY quote_no DESC) vq
            LEFT JOIN vtiger_quotes_related vqr ON vq.quoteid = vqr.quoteid
            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
            WHERE vq.quotestage LIKE '%Accepted%' AND (vqcf.cf_1182 IS NULL OR vqcf.cf_1182 = '0000-00-00') 
            AND ((YEAR(vqcf.cf_1162) = YEAR(CURDATE()) AND MONTH(vqcf.cf_1162) >= MONTH(CURDATE())) OR YEAR(vqcf.cf_1162) > YEAR(CURDATE()))
            GROUP BY name, month_num
            ORDER BY month_num ASC;";
    $result = $conn->query($sql);

    // Organizing data by person and month
    $personData = [];
    $totalPerMonth = array_fill(1, 12, 0); // Total for each month
    while ($row = $result->fetch_assoc()) {
        $personName = $row['name'];
        $monthNum = $row['month_num'];
        $count = $row['count_per_month'];

        if (!isset($personData[$personName])) {
            $personData[$personName] = array_fill(1, 12, 0); // Initialize for 12 months with 0
        }

        $personData[$personName][$monthNum] = $count;
        $totalPerMonth[$monthNum] += $count; // Sum counts per month
    }

    $active_quote_stages = implode(',', fetchAcceptedQuoteStages($conn));
    ?>

    <div class="table-container" style="width: 80%; margin: auto;">
        <div class="table-wrapper">
            <h2 style="margin-bottom: 10px;">Quotes without Payment Deadline</h2>
            <table>
                <tr>
                    <th style="width: 15%;">Ops By Person</th>
                    <?php
                    // Output month headers (starting from the current month)
                    for ($i = 0; $i < 12; $i++) {
                        $monthName = date("M-y", strtotime("first day of +$i month"));
                        echo "<th>$monthName</th>";
                    }
                    ?>
                    <th>Total</th> <!-- Total column header -->
                </tr>
                <?php
                // Output data for each person
                foreach ($personData as $personName => $monthsData) {
                    echo "<tr>";
                    echo "<td>$personName</td>";

                    $totalPerPerson = 0; // Sum counts for this person
                    // Output counts for each month
                    for ($i = 0; $i < 12; $i++) {
                        $monthNum = date("n", strtotime("first day of +$i month")); // Get numeric month
                        $startDate = date("Y-m-01", strtotime("first day of +$i month")); // Start of the month
                        $endDate = date("Y-m-t", strtotime("first day of +$i month")); // End of the month
                        $dateRange = "$startDate to $endDate";
                        $count = $monthsData[$monthNum];

                        // Generate the link for each month
                        if($count != 0) {
                            $link = "<a href='?opt=search&quote_stage=$active_quote_stages&ops_by_person=" . urlencode($personName) . "&payment_deadline=null&date_range=$dateRange'>$count</a>";
                        } else {
                            $link = '';
                        }

                        echo "<td>$link</td>";
                        $totalPerPerson += $count; // Add to person total
                    }

                    // Output total count for this person
                    echo "<td>$totalPerPerson</td>";

                    echo "</tr>";
                }
                ?>
                <tr>
                    <th>Total</th>
                    <?php
                    $grandTotal = 0; // Total for all persons and months
                    // Output total per month
                    for ($i = 0; $i < 12; $i++) {
                        $monthNum = date("n", strtotime("first day of +$i month")); // Get numeric month
                        $startDate = date("Y-m-01", strtotime("first day of +$i month")); // Start of the month
                        $endDate = date("Y-m-t", strtotime("first day of +$i month")); // End of the month
                        $dateRange = "$startDate to $endDate";
                        $totalForMonth = $totalPerMonth[$monthNum];
                        if($totalForMonth != 0) {
                            echo "<td><a href='?opt=search&quote_stage=$active_quote_stages&payment_deadline=null&date_range=$dateRange'>$totalForMonth</a></td>";
                        }
                        else {
                            echo "<td></td>";
                        }
                        
                        $grandTotal += $totalForMonth;
                    }
                    // Output grand total
                    echo "<th>$grandTotal</th>";
                    ?>
                </tr>
            </table>
        </div>
    </div>
    <?php
}
else if (($title=='admin' || $title == 'group' || $title == 'fit') && isset($_GET['opt']) && $_GET['opt'] == 'booking-products-list') {
    include "header.php";

    // Filters
    $quoteNoFilter = isset($_GET['quote_no']) ? $_GET['quote_no'] : '';
    $quoteStageFilter = isset($_GET['quotestage']) ? $_GET['quotestage'] : '';
    $quoteTypeFilter = isset($_GET['quote_type']) ? $_GET['quote_type'] : '';
    $productNameFilter = isset($_GET['productname']) ? $_GET['productname'] : '';
    $vendorNameFilter = isset($_GET['vendor_name']) ? $_GET['vendor_name'] : '';
    $organisationFilter = isset($_GET['organisation']) ? $_GET['organisation'] : '';
    $categoryFilter = isset($_GET['category']) ? $_GET['category'] : '';
    $bookingStatusFilter = isset($_GET['booking_status']) ? $_GET['booking_status'] : '';
    if(!isset($_GET['booking_status'])) {
        $bookingStatusFilter = 'Pending,Awaiting confirmation';
    }
    $bookingMethodFilter = isset($_GET['booking_method']) ? $_GET['booking_method'] : '';
    $cityFilter = isset($_GET['city']) ? $_GET['city'] : '';
    $countryFilter = isset($_GET['country']) ? $_GET['country'] : '';

    // Base query
    $sql = "SELECT 
                vq.quoteid, vq.quotestage, vq.quote_no, vq.country, 
                vqcf.cf_1162, 
                GROUP_CONCAT(
                    DATE_ADD(vqcf.cf_1162, INTERVAL vi.day - 1 DAY) 
                    ORDER BY DATE_ADD(vqcf.cf_1162, INTERVAL vi.day - 1 DAY) 
                    SEPARATOR '\n\n'
                ) AS travel_date,
                GROUP_CONCAT(vp.productname ORDER BY vp.productname SEPARATOR '\n\n') AS productnames, 
                vp.productname, vp.customised, vp.city, 
                vv.vendorid, vv.vendorName, vv.email, vv.bookingMethod, 
                vi.sequence_no, vi.booking_status, vi.cf_928, 
                torg.organization_name
            FROM (SELECT * FROM vtiger_quotes WHERE quoteid = (
                      SELECT MIN(quoteid) AS quoteid FROM vtiger_quotes AS sub WHERE sub.quote_no = vtiger_quotes.quote_no)
                  ORDER BY quote_no DESC) vq
            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid=vqcf.quoteid
            LEFT JOIN vtiger_inventoryproductrel vi ON vq.quoteid=vi.id
            LEFT JOIN (
                SELECT productid, productname, unit_price, 'true' AS customised, vendor_id, '' AS description, '' AS city FROM vtiger_products_custom
                UNION ALL
                SELECT productid, productName AS productname, unitPrice AS unit_price, '' AS customised, vendorid AS vendor_id, description, city FROM tdu_products
            ) vp ON vi.productid=vp.productid
            LEFT JOIN tdu_vendors vv ON vi.vendorid=vv.vendorid
            LEFT JOIN tdu_organisation torg ON vq.accountid = torg.organizationid 
            WHERE (vv.show_within_35_days IS NULL OR vv.show_within_35_days = 'No' OR vqcf.cf_1162 <= DATE_ADD(CURDATE(), INTERVAL 35 DAY)) AND vq.quotestage IN (
                'Accepted', 'PRE QA - pending', 'PRE QA - completed', 'Payment Received - Release Vouchers',
                'Final QA', 'Delivered', 'On Ground', 'Accounts - Reconciliation', 'Completed (Accounts)'
            )";

    // Apply filters
    if (isset($_GET['date_range']) && !empty($_GET['date_range'])) {
        $date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['date_range']));
        $start_date = $date_range[0];
        $end_date = isset($date_range[1]) ? $date_range[1] : $date_range[0]; // in case only one date is selected
        $sql .= " AND DATE_ADD(vqcf.cf_1162, INTERVAL vi.day - 1 DAY) BETWEEN '$start_date' AND '$end_date'";
    } else {
        $sql .= " AND DATE_ADD(vqcf.cf_1162, INTERVAL vi.day - 1 DAY) >= CURDATE()";
    }
    if ($quoteNoFilter) {
        $sql .= " AND vq.quote_no LIKE '%" . $conn->real_escape_string(trim($quoteNoFilter)) . "%'";
    }
    if ($quoteStageFilter) {
        $sql .= " AND vq.quotestage = '" . $conn->real_escape_string($quoteStageFilter) . "'";
    }
    if ($quoteTypeFilter) {
        if ($quoteTypeFilter == 'G') {
            $sql .= " AND vq.quote_no LIKE '%G'";
        } else {
            $sql .= " AND vq.quote_no NOT LIKE '%G'";
        }
    }
    if ($productNameFilter) {
        $sql .= " AND vp.productname LIKE '%" . $conn->real_escape_string($productNameFilter) . "%'";
    }
    if ($vendorNameFilter) {
        $sql .= " AND vv.vendorName LIKE '%" . $conn->real_escape_string($vendorNameFilter) . "%'";
    }
    if ($organisationFilter) {
        $sql .= " AND torg.organization_name LIKE '%" . $conn->real_escape_string($organisationFilter) . "%'";
    }
    if ($categoryFilter) {
        $sql .= " AND vi.cf_928 = '" . $conn->real_escape_string($categoryFilter) . "'";
    }
    if (!empty($bookingStatusFilter)) {
        $statusArray = explode(',', $bookingStatusFilter); // Convert the string into an array
        $escapedStatuses = array_map([$conn, 'real_escape_string'], $statusArray); // Escape each value
        $statusList = "'" . implode("','", $escapedStatuses) . "'"; // Format for SQL IN clause
    
        $sql .= " AND vi.booking_status IN ($statusList)";
    }
    if ($bookingMethodFilter) {
        $sql .= " AND vv.bookingMethod = '" . $conn->real_escape_string($bookingMethodFilter) . "'";
    }
    if ($cityFilter) {
        $sql .= " AND vp.city LIKE '%" . $conn->real_escape_string($cityFilter) . "%'";
    }
    if ($countryFilter) {
        $sql .= " AND vq.country LIKE '%" . $conn->real_escape_string($countryFilter) . "%'";
    }

    $sql .= " GROUP BY vq.quote_no, vv.vendorid, vi.cf_928";

    // Pagination
    $limit = 20;
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $page = max($page, 1);
    $offset = ($page - 1) * $limit;

    $sql_total = $sql;
    $total_result = mysqli_query($conn, $sql_total);
    $totalRecords = mysqli_num_rows($total_result);
    $totalPages = ceil($totalRecords / $limit);

    $sql .= " ORDER BY DATE_ADD(vqcf.cf_1162, INTERVAL vi.day - 1 DAY) ASC LIMIT $limit OFFSET $offset";

    $result = $conn->query($sql);
    ?>

    <h1 style="text-align: center; margin-top: 20px;">Products Booking Status</h1>
    <table class="styled-table" style="width: 95%; margin: 20px auto;">
        <tr>
            <th></th>
            <th>Travel Date</th>
            <th style="text-align: left; width: 10%;">Organisation</th>
            <th colspan="2">Quote Number</th>
            <th>Quote Stage</th>
            <th style="text-align: left; width: 25%;">Product Name</th>
            <th style="text-align: left; width: 10%;">Vendor</th>
            <th>Category</th>
            <th>Booking Status</th>
            <th></th>
            <th>Booking Method</th>
            <th>City</th>
            <th>Country</th>
        </tr>
        <tr>
            <form method="GET">
                <input type="hidden" name="opt" value="booking-products-list">
                <td><button type="submit">Search</button></td>
                <td><input type="text" id="date_range" name="date_range" value="<?php echo isset($_GET['date_range']) ? htmlspecialchars($_GET['date_range']) : ''; ?>"></td>
                <td><input type="text" name="organisation" value="<?php echo htmlspecialchars($organisationFilter); ?>"></td>
                <td colspan="2">
                    <input type="text" name="quote_no" value="<?= htmlspecialchars($quoteNoFilter); ?>" style="width: 65%;">
                    <select name="quote_type" style="width: 30%;">
                        <option value="">All</option>
                        <option value="G" <?= ($quoteTypeFilter === 'G') ? 'selected' : ''; ?>>G</option>
                        <option value="FIT" <?= ($quoteTypeFilter === 'FIT') ? 'selected' : ''; ?>>FIT</option>
                    </select>
                </td>
                <td>
                    <select name="quotestage">
                        <option value="">All</option>
                        <?php
                        $stageoptions = [
                            'Accepted', 'PRE QA - pending', 'PRE QA - completed', 
                            'Payment Received - Release Vouchers', 'Final QA', 
                            'Delivered', 'On Ground', 'Accounts - Reconciliation', 
                            'Completed (Accounts)'
                        ];
                        
                        foreach ($stageoptions as $option) {
                            $selected = ($quoteStageFilter === $option) ? 'selected' : '';
                            echo "<option value=\"" . htmlspecialchars($option) . "\" $selected>" . htmlspecialchars($option) . "</option>";
                        }
                        ?>
                    </select>
                </td>
                <td><input type="text" name="productname" value="<?= htmlspecialchars($productNameFilter); ?>"></td>
                <td><input type="text" name="vendor_name" value="<?php echo htmlspecialchars($vendorNameFilter); ?>"></td>
                <td>
                    <select name="category">
                        <option value="" <?php echo $categoryFilter == '' ? 'selected' : ''; ?>>All</option>
                        <option value="Attraction" <?php echo $categoryFilter == 'Attraction' ? 'selected' : ''; ?>>Attraction</option>
                        <option value="Hotel" <?php echo $categoryFilter == 'Hotel' ? 'selected' : ''; ?>>Hotel</option>
                        <option value="Restaurant" <?php echo $categoryFilter == 'Restaurant' ? 'selected' : ''; ?>>Restaurant</option>
                        <option value="Tour" <?php echo $categoryFilter == 'Tour' ? 'selected' : ''; ?>>Tour</option>
                        <option value="Transfers" <?php echo $categoryFilter == 'Transfers' ? 'selected' : ''; ?>>Transfers</option>
                        <option value="Guide" <?php echo $categoryFilter == 'Guide' ? 'selected' : ''; ?>>Guide</option>
                        <option value="SIC" <?php echo $categoryFilter == 'SIC' ? 'selected' : ''; ?>>SIC</option>
                    </select>
                </td>
                <td colspan="2">
                    <div style="width: 100%;">
                        <input type="text" id="booking_status_input" name="booking_status" value="<?php echo isset($bookingStatusFilter) ? htmlspecialchars($bookingStatusFilter) : ''; ?>" readonly style="width: 100%;">
                        <div id="booking_status_checkboxes" style="display: none; text-align: left; border: 1px solid #ccc; padding: 10px; position: absolute; background: white; z-index: 1000;">
                            <?php 
                                $bookingStatuses = ["Pending", "Awaiting confirmation", "Confirmation received", "Cancelled after Confirmation"];
                                foreach ($bookingStatuses as $status): 
                            ?>
                                <label>
                                    <input type="checkbox" value="<?php echo htmlspecialchars($status); ?>" 
                                        <?php 
                                        if(isset($bookingStatusFilter) && $bookingStatusFilter != '') {
                                            $checked_statuses = explode(',', $bookingStatusFilter);
                                            echo in_array($status, $checked_statuses) ? 'checked' : '';
                                        }
                                        ?>
                                    >
                                    <?php echo htmlspecialchars($status); ?>
                                </label><br>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </td>
                <script>
                    const bookingInput = document.getElementById('booking_status_input');
                    const bookingCheckboxes = document.getElementById('booking_status_checkboxes');

                    // Toggle the display of the checkboxes on input click
                    bookingInput.addEventListener('click', function() {
                        bookingCheckboxes.style.display = bookingCheckboxes.style.display === 'block' ? 'none' : 'block';
                    });

                    // Update the input field with selected checkbox values
                    document.querySelectorAll('#booking_status_checkboxes input[type="checkbox"]').forEach(checkbox => {
                        checkbox.addEventListener('change', function() {
                            const selectedValues = Array.from(document.querySelectorAll('#booking_status_checkboxes input[type="checkbox"]:checked')).map(cb => cb.value);
                            bookingInput.value = selectedValues.join(','); // Join selected values with a comma
                        });
                    });

                    // Close the checkbox dropdown when clicking outside
                    document.addEventListener('click', function(event) {
                        if (!bookingInput.contains(event.target) && !bookingCheckboxes.contains(event.target)) {
                            bookingCheckboxes.style.display = 'none';
                        }
                    });
                </script>
                <td>
                    <select name="booking_method">
                        <option value="" <?php echo $bookingMethodFilter == '' ? 'selected' : ''; ?>>All</option>
                        <option value="Email" <?php echo $bookingMethodFilter == 'Email' ? 'selected' : ''; ?>>Email</option>
                        <option value="Online" <?php echo $bookingMethodFilter == 'Online' ? 'selected' : ''; ?>>Online</option>
                        <option value="Rezdy" <?php echo $bookingMethodFilter == 'Rezdy' ? 'selected' : ''; ?>>Rezdy</option>
                    </select>
                </td>
                <td><input type="text" name="city" value="<?php echo htmlspecialchars($cityFilter); ?>"></td>
                <td>
                    <select name="country">
                        <option value="" <?php echo $countryFilter == '' ? 'selected' : ''; ?>>All</option>
                        <option value="Australia" <?php echo $countryFilter == 'Australia' ? 'selected' : ''; ?>>Australia</option>
                        <option value="New Zealand" <?php echo $countryFilter == 'New Zealand' ? 'selected' : ''; ?>>New Zealand</option>
                    </select>
                </td>
            </form>
        </tr>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
        <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
        <script>
            flatpickr("#date_range", {
                mode: "range",
                dateFormat: "Y-m-d",
                defaultDate: "<?php echo isset($_GET['date_range']) ? htmlspecialchars($_GET['date_range']) : ''; ?>"
            });
        </script>

        <?php if ($result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td>
                        <?php if ($row['booking_status'] == 'Pending' && $row['customised'] != 'true') : ?>
                            <button 
                                type="button" 
                                onclick="openComposeForm(this)" 
                                data-email="<?= htmlspecialchars($row['email']) ?>" 
                                data-quote-no="<?= htmlspecialchars($row['quote_no']) ?>" 
                                data-vendorName="<?= htmlspecialchars($row['vendorName']) ?>" 
                                data-quoteid="<?= htmlspecialchars($row['quoteid']) ?>" 
                                data-cf928="<?= htmlspecialchars($row['cf_928']) ?>" 
                                data-vendorid="<?= htmlspecialchars($row['vendorid']) ?>"
                                data-ccEmailids="">
                                <i class="fa-solid fa-envelope"></i>
                            </button>
                        <?php endif; ?>
                    </td>
                    <td style="white-space: nowrap;">
                        <?php 
                        if (!empty($row['travel_date'])) {
                            $dates = explode("\n\n", $row['travel_date']);
                            $dateObjects = [];
                        
                            foreach ($dates as $dateStr) {
                                $date = DateTime::createFromFormat('Y-m-d', trim($dateStr));
                                if ($date) {
                                    $dateObjects[] = $date;
                                }
                            }
                        
                            if (!empty($dateObjects)) {
                                usort($dateObjects, function($a, $b) {
                                    return $a <=> $b;
                                });
                        
                                $minDate = $dateObjects[0]->format('d-M-Y');
                                $maxDate = end($dateObjects)->format('d-M-Y');
                                
                                if($minDate == $maxDate) {
                                    echo $minDate;
                                } else {
                                    echo $minDate . '<br> ~ <br>' . $maxDate;
                                }
                            }
                        }
                        ?>
                    </td>
                    <td style="text-align: left;"><?= htmlspecialchars($row['organization_name']); ?></td>
                    <td>
                        <?php if(in_array($row['quotestage'], ['Accepted', 'Requote After Confirmation', 'PRE QA - pending', 'PRE QA - completed', 'Payment Received - Release Vouchers', 'Final QA', 'Delivered', 'On Ground', 'Accounts - Reconciliation', 'Completed (Accounts)'])) { 
                            $quoteid = $row['quoteid'];
                            ?>
                            <div class="payment-icon-wrapper" style="position: relative;">
                                <i class="fa-solid fa-circle-dollar-to-slot grey payment-icon" id="payment_icon_<?php echo $quoteid; ?>"></i>
                                <div class="payment-popup" id="payment_popup_<?php echo $quoteid; ?>" style="display:none; position:absolute; top:24px; left:50%; transform:translateX(-50%); background:white; border:1px solid #ccc; padding:10px; z-index:999; width:220px; box-shadow:0 2px 6px rgba(0,0,0,0.2); font-size:13px;">
                                    <p>Loading...</p>
                                </div>
                            </div>
                            <style>
                                .payment-icon {
                                    cursor: pointer;
                                }
                                .payment-icon.grey {
                                    color: lightgrey;
                                }
                                .payment-icon.green {
                                    color: green;
                                }
                                .payment-icon.orange {
                                    color: orange;
                                }
                                .payment-icon.red {
                                    color: red;
                                }
                            </style>
                            <script>
                                document.addEventListener("DOMContentLoaded", function () {
                                    fetchPaymentStatus(<?php echo $quoteid; ?>);

                                    const icon = document.getElementById("payment_icon_<?php echo $quoteid; ?>");
                                    const popup = document.getElementById("payment_popup_<?php echo $quoteid; ?>");

                                    icon.addEventListener("click", function (e) {
                                        e.stopPropagation();
                                        if (popup.style.display === "none") {
                                            fetch('quote_payment_status_ajax.php?quoteid=<?php echo $quoteid; ?>&action=popup')
                                                .then(response => response.text())
                                                .then(data => {
                                                    popup.innerHTML = data;
                                                    popup.style.display = "block";
                                                });
                                        } else {
                                            popup.style.display = "none";
                                        }
                                    });

                                    document.addEventListener("click", function () {
                                        popup.style.display = "none";
                                    });
                                });

                                function fetchPaymentStatus(quoteId) {
                                    fetch('quote_payment_status_ajax.php?quoteid=' + quoteId + '&action=status')
                                        .then(response => response.json())
                                        .then(data => {
                                            const icon = document.getElementById('payment_icon_' + quoteId);
                                            if (data && data.colorClass) {
                                                icon.classList.remove('grey', 'green', 'orange', 'red');
                                                icon.classList.add(data.colorClass);

                                                if (data.colorClass === 'green') {
                                                    const tr = icon.closest('tr');
                                                    const bgColor = window.getComputedStyle(tr).backgroundColor;

                                                    // Compare to RGB equivalent of #f8d7da
                                                    if (bgColor === 'rgb(248, 215, 218)') {
                                                        tr.style.backgroundColor = '';
                                                    }
                                                }
                                            }
                                        });
                                }
                            </script>
                        <?php } ?>
                    </td>
                    <td>
                        <a href="quote.php?opt=summary&quoteNumber=<?= urlencode($row['quote_no']); ?>">
                            <?= htmlspecialchars($row['quote_no']); ?>
                        </a>
                    </td>
                    <td><?= $row['quotestage'] ?></td>
                    <?php
                    $productLines = explode("\n\n", $row['productnames']);
                    $firstLine = array_shift($productLines);
                    $remainingLines = implode("<br><br>", $productLines);
                    $uniqueId = uniqid('prod_');
                    ?>

                    <td style="text-align: left;">
                        <?= nl2br($firstLine); ?>
                        <?php if (!empty($productLines)): ?>
                            <div id="<?= $uniqueId ?>" style="display: none;">
                                <br>
                                <?= $remainingLines ?>
                                <br><br>
                            </div>
                            <button type="button" onclick="toggleProductList('<?= $uniqueId ?>', this)">Show more</button>
                        <?php endif; ?>
                    </td>
                    <td style="text-align: left;">
                        <?= $row['customised'] == 'true' ? '<i class="fa-solid fa-palette"></i> Custom' : '' ?>
                        <a href="quote.php?opt=vendor-details&id=<?= htmlspecialchars($row['vendorid']); ?>&product_active=Yes">
                            <?= htmlspecialchars($row['vendorName']); ?>
                        </a>
                    </td>
                    <td><?= htmlspecialchars($row['cf_928']); ?></td>
                    <td><?= htmlspecialchars($row['booking_status']); ?></td>
                    <td style="text-align: left;">
                        <?php if ($row['booking_status'] == 'Awaiting confirmation') { ?>
                            <i class="fa-solid fa-spell-check toggle-confirmation" data-quoteid="<?php echo $row['quoteid']; ?>" data-sequence_no="<?php echo $row['sequence_no']; ?>"></i>
                        <?php } ?>

                        <!-- Confirmation input fields, initially hidden -->
                        <div class="confirmation-info" style="display: none;">
                            <label>Tour Time</label><br>
                            <input type="text" id="tour_time_<?= $row['quoteid']; ?>_<?= $row['sequence_no']; ?>" class="tour_time_input" style="width: 100%; height: 30px;">

                            <label>Confirmation Number</label><br>
                            <input type="text" id="confirmation_info_<?= $row['quoteid']; ?>_<?= $row['sequence_no']; ?>" class="confirmation_info_input" style="width: 100%;"><br>

                            <label>Payment Deadline</label><br>
                            <input type="date" id="payment_deadline_<?= $row['quoteid']; ?>_<?= $row['sequence_no']; ?>" class="payment_deadline_input" style="width: 100%; height: 30px;"><br>

                            <label>Cancellation Deadline</label><br>
                            <input type="date" id="cancellation_deadline_<?= $row['quoteid']; ?>_<?= $row['sequence_no']; ?>" class="cancellation_deadline_input" style="width: 100%; height: 30px;"><br>

                            <button type="button" class="confirm-button" style="width: 100%; height: 30px; margin-top: 5px;"
                                    data-quoteid="<?= $row['quoteid']; ?>"
                                    data-sequence_no="<?= $row['sequence_no']; ?>" 
                                    data-cf_928="<?= $row['cf_928']; ?>">
                                <i class="fa-solid fa-check"></i>
                            </button>
                        </div>
                    </td>
                    <td><?= htmlspecialchars($row['bookingMethod']); ?></td>
                    <td><?= htmlspecialchars($row['city']); ?></td>
                    <td><?= htmlspecialchars($row['country']); ?></td>
                </tr>
            <?php endwhile; ?>
        <?php endif; ?>
        <tr><td></td><td colspan="13" style="text-align: left;">Number of results: <?= $totalRecords ?></td></tr>
    </table>

    <!-- show/hide products in Products Booking Status rows -->
    <script>
        function toggleProductList(id, btn) {
            const el = document.getElementById(id);
            if (el.style.display === 'none') {
                el.style.display = 'block';
                btn.textContent = 'Show less';
            } else {
                el.style.display = 'none';
                btn.textContent = 'Show more';
            }
        }
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function() {
            flatpickr(".tour_time_input", {
                enableTime: true,
                noCalendar: true,
                time_24hr: true,
            });

            $(".toggle-confirmation").click(function() {
                var quoteid = $(this).data('quoteid');
                var sequence_no = $(this).data('sequence_no');
                $(".confirmation-info").each(function() {
                    if ($(this).siblings(".toggle-confirmation").data('quoteid') === quoteid && $(this).siblings(".toggle-confirmation").data('sequence_no') === sequence_no) {
                        $(this).toggle();
                    } else {
                        $(this).hide();
                    }
                });
            });

            $(".confirm-button").click(function() {
                var quoteid = $(this).data('quoteid');
                var sequence_no = $(this).data('sequence_no');
                var cf_928 = $(this).data('cf_928');
                var confirmation_info = $("#confirmation_info_" + quoteid + "_" + sequence_no).val();
                var payment_deadline = $("#payment_deadline_" + quoteid + "_" + sequence_no).val();
                var cancellation_deadline = $("#cancellation_deadline_" + quoteid + "_" + sequence_no).val();
                var tour_time = $("#tour_time_" + quoteid + "_" + sequence_no).val();
                var username = "<?php echo $username_ajax; ?>";

                // Validate if all fields are filled
                if (confirmation_info === "" || payment_deadline === "" || cancellation_deadline === "" || tour_time === "") {
                    alert("Please fill in all the fields before submitting.");
                    return;  // Stop the form submission if any field is empty
                }

                // Proceed with the AJAX request if validation is successful
                $.ajax({
                    url: 'ajax_confirmation_no_handler_booking_status_report.php',
                    type: 'POST',
                    data: {
                        quoteid: quoteid,
                        sequence_no: sequence_no,
                        cf_928: cf_928,
                        confirmation_info: confirmation_info,
                        payment_deadline: payment_deadline,
                        cancellation_deadline: cancellation_deadline,
                        tour_time: tour_time,
                        username: username
                    },
                    success: function(response) {
                        location.reload();
                    },
                    error: function() {
                        alert("An error occurred while processing the request.");
                    }
                });
            });
        });
    </script>

    <!-- Compose Mail Start -->
    <div id="composeFormContainer" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 75%; background-color: white; padding: 20px; border: 1px solid #ccc; z-index: 1000; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);">
        <h2 style="text-align: center;">Compose Email</h2>
        <form action="email_sender.php" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="need-process-booking-status" value="yes">
            <input type="hidden" name="email-quoteid" id="hidden-quoteid">
            <input type="hidden" name="email-vendorid" id="hidden-vendorid">

            <input type="hidden" name="quoteid_compose" id="hidden-quoteid_compose">
            <input type="hidden" name="quote_type_compose" value="vendor">
            <input type="hidden" name="email_sender_compose" value="<?= $username_ajax ?>">
            
            <div>
                <label for="from">From:</label>
                <input type="text" name="from" id="from" value="groups@turtledownunder.com.au" required readonly>
            </div>
            <div>
                <label for="to">To:</label>
                <div style="display: flex; gap: 5px;">
                    <input type="text" name="to" id="to" required style="flex: 1;">
                    <button type="button" onclick="openAddEmailModal('to')">+</button>
                </div>
            </div>
            <div>
                <label for="cc">CC:</label>
                <div style="display: flex; gap: 5px;">
                    <input type="text" name="cc" id="cc" style="flex: 1;">
                    <button type="button" onclick="openAddEmailModal('cc')">+</button>
                </div>
            </div>
            <div>
                <label for="subject">Subject:</label>
                <input type="text" name="subject" id="subject" required style="width: 100%;">
            </div>
            <div>
                <label for="content">Content:</label>
                <textarea name="content" id="content" rows="10" style="display: none;"></textarea>
            </div>
            <div id="attachments-container" style="margin-bottom: 10px;">
                <label>Attachments:</label>
                <div class="attachment-row" style="margin-bottom: 10px;">
                    <input type="file" name="attachments[]" onchange="handleAttachmentChange('attachments-container', this)">
                </div>
            </div>
            <div>
                <button type="submit" value="compose">Send</button>
                <button type="button" onclick="closeComposeForm(1)">Cancel</button>
            </div>
        </form>
    </div>
    <style>
        .ck-editor__editable {
            height: 300px;
            overflow-y: auto;
        }
    </style>
    <script src="https://cdn.ckeditor.com/ckeditor5/23.0.0/classic/ckeditor.js"></script>
    <script>
        let emailEditor = null; // Global reference to CKEditor instance

        function loadOrSetEditor(content) {
            if (emailEditor) {
                emailEditor.setData(content);
            } else {
                ClassicEditor
                    .create(document.querySelector('#content'), {
                        toolbar: {
                            items: ['heading', 'bold', 'italic', 'link', 'insertTable', 'undo', 'redo']
                        }
                    })
                    .then(editor => {
                        emailEditor = editor;
                        editor.setData(content);
                    })
                    .catch(error => console.error(error));
            }
        }

        // Initialize CKEditor on page load (optional)
        document.addEventListener('DOMContentLoaded', function () {
            loadOrSetEditor(''); // Empty editor on load
        });
    </script>
    <script>
        function handleAttachmentChange(containerId, input) {
            const container = document.getElementById(containerId);

            // If the input has a file, display the file name
            if (input.files.length > 0) {
                // Hide the input field
                input.style.display = "none";

                // Create a span to display the file name
                const fileName = document.createElement("span");
                fileName.textContent = input.files[0].name;
                fileName.style.marginLeft = "10px";
                fileName.style.fontSize = "0.9em";

                // Add a remove icon
                const removeButton = document.createElement("button");
                removeButton.type = "button";
                removeButton.style.marginLeft = "10px";
                removeButton.style.border = "none";
                removeButton.style.background = "none";
                removeButton.style.color = "red";
                removeButton.style.cursor = "pointer";
                removeButton.style.fontSize = "1.2em";
                removeButton.innerHTML = `<i class="fa-regular fa-circle-xmark"></i>`;
                removeButton.onclick = function () {
                    // Remove the parent row
                    input.parentElement.remove();
                };

                // Append the file name and remove button to the current row
                input.parentElement.appendChild(fileName);
                input.parentElement.appendChild(removeButton);

                // Add a new file input for future attachments
                const newField = document.createElement("div");
                newField.className = "attachment-row";
                newField.style.marginBottom = "10px";
                newField.innerHTML = `
                    <input type="file" name="attachments[]" onchange="handleAttachmentChange('${containerId}', this)">
                `;

                container.appendChild(newField);
            }
        }
    </script>
    <script>
        // Show the compose form
        function openComposeForm(button) {
            const email = button.getAttribute('data-email');
            const quoteNo = button.getAttribute('data-quote-no');
            const vendorName = button.getAttribute('data-vendorName');
            const quoteid = button.getAttribute('data-quoteid');
            const vendorid = button.getAttribute('data-vendorid');
            const cf928 = button.getAttribute('data-cf928');
            const ccEmailids = button.getAttribute('data-ccEmailids');

            document.getElementById('to').value = email;
            document.getElementById('cc').value = ccEmailids;
            document.getElementById('subject').value = vendorName + " Booking Request - " + quoteNo;

            document.getElementById('hidden-quoteid').value = quoteid;
            document.getElementById('hidden-quoteid_compose').value = quoteid;
            document.getElementById('hidden-vendorid').value = vendorid;

            // Show the loading spinner
            document.getElementById('loadingSpinner').style.display = 'block';

            fetch('ajax_get_mailbox_to_send.php?quoteid=' + encodeURIComponent(quoteid))
                .then(response => response.text())
                .then(fromEmail => {
                    document.getElementById('from').value = fromEmail;
                })
                .catch(err => {
                    console.error('Failed to load mailbox email:', err);
                    document.getElementById('from').value = 'groups@turtledownunder.com.au';
                });

            fetch('ajax_vendor_email_content.php?quoteid=' + encodeURIComponent(quoteid) + '&vendorid=' + encodeURIComponent(vendorid))
                .then(response => response.text())
                .then(content => {
                    if (content.trim() === 'Operation Details are INCOMPLETE') {
                        if (emailEditor) {
                            emailEditor.setData('');
                        }
                        document.getElementById('composeFormContainer').innerHTML = `
                            <div style="text-align: left; padding: 20px;">
                                <h1 style="color: red;">${content.trim()}</h1><br><br>
                                <h2>Please review the quote details before sending this email:</h2><br>
                                <h2>Hotel: Checkin, Checkout, Pax List</h2><br>
                                <h2>Transfers: Tour Time, Pickup location, Dropoff location</h2><br>
                                <h2>Other Categories: Tour Time</h2><br>
                                <a href="quote.php?opt=summary&quoteNumber=${encodeURIComponent(quoteNo)}"
                                style="font-size: 24px; color: blue; text-decoration: underline;">
                                    Edit Quote ${encodeURIComponent(quoteNo)}
                                </a><br><br>
                                <button onclick="closeComposeForm(1)">Close</button>
                            </div>
                        `;
                        document.getElementById('loadingSpinner').style.display = 'none';
                        document.getElementById('composeFormContainer').style.display = 'block';
                        document.getElementById('composeFormContainer').style.width = 'auto';
                    } else if (content.trim() === 'Please assign to ops before operating') {
                        if (emailEditor) {
                            emailEditor.setData('');
                        }
                        document.getElementById('composeFormContainer').innerHTML = `
                            <div style="text-align: left; padding: 20px;">
                                <h1 style="color: red;">${content.trim()}</h1><br>
                                <a href="quote.php?opt=summary&quoteNumber=${encodeURIComponent(quoteNo)}"
                                style="font-size: 24px; color: blue; text-decoration: underline;">
                                    Edit Quote ${encodeURIComponent(quoteNo)}
                                </a><br><br>
                                <button onclick="closeComposeForm(1)">Close</button>
                            </div>
                        `;
                        document.getElementById('loadingSpinner').style.display = 'none';
                        document.getElementById('composeFormContainer').style.display = 'block';
                        document.getElementById('composeFormContainer').style.width = 'auto';
                    } else {
                        loadOrSetEditor(content);
                        if(cf928 == 'Transfers') {
                            // Fetch itinerary file and auto-add to attachments
                            fetch('ajax_fetch_itinerary_file.php?quoteid=' + encodeURIComponent(quoteid) + '&vendorid=' + encodeURIComponent(vendorid))
                                .then(response => response.json())
                                .then(data => {
                                    if (data.status === 'success') {
                                        autoAddAttachment(data.fileName, data.fileUrl);
                                    } else {
                                        console.error('Failed to fetch itinerary:', data.message);
                                    }
                                    document.getElementById('loadingSpinner').style.display = 'none';
                                    document.getElementById('composeFormContainer').style.display = 'block';
                                })
                                .catch(err => console.error('Error fetching itinerary:', err));
                        } else {
                            document.getElementById('loadingSpinner').style.display = 'none';
                            document.getElementById('composeFormContainer').style.display = 'block';
                        }
                    }
                })
                .catch(err => console.error('Failed to load email content:', err));
        }

        // Close the compose form
        function closeComposeForm(reload = 0) {
            document.getElementById('composeFormContainer').style.display = 'none';
            if (reload) {
                location.reload();  // Optional: reload the page after closing the compose form
            }
        }

        function autoAddAttachment(fileName, fileUrl) {
            const container = document.getElementById('attachments-container');

            const attachmentRow = document.createElement('div');
            attachmentRow.className = 'attachment-row';
            attachmentRow.style.marginBottom = '10px';

            // Hidden input so the file gets sent with the form (for backend processing)
            const hiddenInput = document.createElement('input');
            hiddenInput.type = 'hidden';
            hiddenInput.name = 'existing_attachments[]';
            hiddenInput.value = fileUrl;

            // Make file name a clickable download link
            const fileLink = document.createElement('a');
            fileLink.href = fileUrl;          // URL to the file
            fileLink.target = '_blank';       // Open in new tab
            fileLink.textContent = fileName;
            fileLink.style.marginLeft = '10px';
            fileLink.style.fontSize = '0.9em';
            fileLink.style.textDecoration = 'underline';
            fileLink.style.color = 'blue';

            // Remove button
            const removeButton = document.createElement('button');
            removeButton.type = 'button';
            removeButton.style.marginLeft = '10px';
            removeButton.style.border = 'none';
            removeButton.style.background = 'none';
            removeButton.style.color = 'red';
            removeButton.style.cursor = 'pointer';
            removeButton.style.fontSize = '1.2em';
            removeButton.innerHTML = `<i class="fa-regular fa-circle-xmark"></i>`;
            removeButton.onclick = function () {
                attachmentRow.remove();
            };

            // Add elements to row
            attachmentRow.appendChild(hiddenInput);
            attachmentRow.appendChild(fileLink);
            attachmentRow.appendChild(removeButton);

            // Add to container
            container.appendChild(attachmentRow);
        }
    </script>

    <!-- Modal for adding email -->
    <div id="emailModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.5); z-index: 1000; justify-content: center; align-items: center;">
        <div style="background: white; padding: 20px; border-radius: 8px; width: 600px; text-align: center;">
            <h4>Search Email</h4>
            <input type="text" id="emailModalInput" placeholder="Enter email address" style="width: 100%; margin-bottom: 15px; height: 30px;" onkeyup="searchEmail(this.value)">
            <ul id="emailSuggestions" style="list-style: none; padding: 0; margin: 0;"></ul>
            <div style="margin-top: 10px; display: flex; gap: 10px; justify-content: center;">
                <button onclick="confirmAddEmail()" style="padding: 5px 10px;">Add</button>
                <button onclick="closeEmailModal()" style="padding: 5px 10px;">Cancel</button>
            </div>
        </div>
    </div>
    <script>
        function searchEmail(query) {
            const suggestions = document.getElementById('emailSuggestions');
            suggestions.innerHTML = ''; // Clear previous suggestions

            if (query.trim().length === 0) {
                return;
            }
            
            const mailboxFilterId = document.getElementById('from').value;
            const xhr = new XMLHttpRequest();
            xhr.open('POST', 'ajax_outlook_contacts.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    const results = JSON.parse(xhr.responseText);
                    results.forEach(emailData => {
                        const li = document.createElement('li');
                        li.textContent = `${emailData.sender_name} (${emailData.email})`;
                        li.style.cursor = 'pointer';
                        li.style.padding = '5px 10px';
                        li.style.borderBottom = '1px solid #ddd';
                        li.onclick = function () {
                            document.getElementById('emailModalInput').value = emailData.email;
                            suggestions.innerHTML = ''; // Clear suggestions
                        };
                        suggestions.appendChild(li);
                    });
                }
            };
            xhr.send(`query=${encodeURIComponent(query)}&mailboxFilter=${mailboxFilterId}`);
        }
    </script>
    <script>
        let currentFieldId = null;

        function openAddEmailModal(fieldId) {
            currentFieldId = fieldId; // Store the current field ID
            document.getElementById('emailModalInput').value = ''; // Clear the input field
            document.getElementById('emailModal').style.display = 'flex'; // Show the modal
        }

        function closeEmailModal() {
            document.getElementById('emailModal').style.display = 'none'; // Hide the modal
            currentFieldId = null; // Reset the current field ID
        }

        function confirmAddEmail() {
            const emailInput = document.getElementById('emailModalInput').value.trim();
            if (emailInput && currentFieldId) {
                const field = document.getElementById(currentFieldId);
                const currentValue = field.value.trim();
                field.value = currentValue ? `${currentValue}, ${emailInput}` : emailInput;
            }
            closeEmailModal(); // Close the modal after adding
        }
    </script>
    <!-- Compose Mail End -->

    <!-- Loading Spinner -->
    <div id="loadingSpinner" class="spinner-container" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 25%; background-color: white; padding: 20px; border: 1px solid #ccc; z-index: 1000; box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);">
        <div class="spinner"></div>
        <div style="text-align: center;">Loading email content, please wait...</div>
    </div>
    <style>
        .spinner {
            margin: 0 auto 10px;
            width: 50px;
            height: 50px;
            border: 6px solid #ccc;
            border-top-color: #007bff;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
    </style>
    
    <div class="pagination" style="margin-top: 0;">
        <div>
            <?php if ($page > 1): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
            <?php endif; ?>

            <?php
            $max_pages = min($totalPages, $page + 2);
            for ($i = $page; $i <= $max_pages; $i++): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" <?php if ($i == $page) echo 'style="background-color: #334155; color: white;"'; ?>>
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($page < $totalPages): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
            <?php endif; ?>
        </div>
        
        <form method="GET" action="" style="display:inline;">
            <?php
            foreach ($_GET as $key => $value) {
                if ($key != 'page') {
                    echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                }
            }
            ?>
            <input type="number" name="page" min="1" max="<?php echo $totalPages; ?>" value="<?php echo $page; ?>" style="width:75px;"> / <?php echo $totalPages; ?>
            <button type="submit">Jump</button>
        </form>
    </div>

    <style>
        .pagination {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 20px 0;
        }
        
        .pagination div {
            display: flex;
            align-items: center;
        }
        
        .pagination a {
            text-decoration: none;
            padding: 8px 12px;
            margin: 0 5px;
            border: 1px solid #334155;
            color: #334155;
            border-radius: 4px;
            transition: background-color 0.3s, color 0.3s;
        }
        
        .pagination a:hover {
            background-color: #334155;
            color: white;
        }
        
        .pagination input[type="number"] {
            width: 50px;
            padding: 10px;
            margin-left: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        
        .pagination button {
            padding: 10px 10px;
            margin-left: 5px;
            border: none;
            border-radius: 4px;
            background-color: #334155;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .pagination button:hover {
            background-color: #334155;
        }
        
        tr:nth-child(odd) {
            background-color: #f9f9f9;
        }

        input[type="text"], .styled-table td input[type="text"], .styled-table td select {
            width: 100%;
            height: 30px;
            margin: 0;
        }
    </style>
    <?php
}
else if (($title == 'admin' || $title == 'group' || $title == 'fit') && isset($_GET['opt']) && $_GET['opt'] == 'booking-hotels-list') {
    include "header.php";

    // Filters
    $quoteNoFilter = isset($_GET['quote_no']) ? $_GET['quote_no'] : '';
    $hotelNameFilter = isset($_GET['hotelname']) ? $_GET['hotelname'] : '';
    $countryFilter = isset($_GET['country']) ? $_GET['country'] : '';

    // Base query
    $sql = "SELECT vq.quoteid, vi.sequence_no, vq.quote_no, vq.country, vqcf.cf_1162, vp.productname AS hotelname, vi.checkin, vi.checkout
            FROM (SELECT * FROM vtiger_quotes WHERE quoteid = (
                      SELECT MIN(quoteid) AS quoteid FROM vtiger_quotes AS sub WHERE sub.quote_no = vtiger_quotes.quote_no)
                  ORDER BY quote_no DESC) vq
            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid=vqcf.quoteid
            LEFT JOIN vtiger_inventoryproductrel vi ON vq.quoteid=vi.id
            LEFT JOIN (
                SELECT productid, productname, unit_price, 'true' AS customised, vendor_id, '' AS description FROM vtiger_products_custom
                UNION ALL
                SELECT productid, productName AS productname, unitPrice AS unit_price, '' AS customised, vendorid AS vendor_id, description FROM tdu_products
            ) vp ON vi.productid=vp.productid
            WHERE vi.cf_928 = 'Hotel' AND vqcf.cf_1162 > CURDATE() AND vq.quotestage IN (
                'Accepted', 'PRE QA - pending', 'PRE QA - completed', 'Payment Received - Release Vouchers',
                'Final QA', 'Delivered', 'On Ground', 'Accounts - Reconciliation', 'Completed (Accounts)'
            )";

    // Apply filters
    if ($quoteNoFilter) {
        $sql .= " AND vq.quote_no LIKE '%" . $conn->real_escape_string(trim($quoteNoFilter)) . "%'";
    }
    if ($hotelNameFilter) {
        $sql .= " AND vp.productname LIKE '%" . $conn->real_escape_string($hotelNameFilter) . "%'";
    }
    if ($countryFilter) {
        $sql .= " AND vq.country LIKE '%" . $conn->real_escape_string($countryFilter) . "%'";
    }
    if (isset($_GET['checkin_date']) && !empty($_GET['checkin_date'])) {
        $date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['checkin_date']));
        $start_date = $date_range[0];
        $end_date = isset($date_range[1]) ? $date_range[1] : $date_range[0]; // in case only one date is selected
        $sql .= " AND vi.checkin BETWEEN '$start_date' AND '$end_date'";
    }
    if (isset($_GET['checkout_date']) && !empty($_GET['checkout_date'])) {
        $date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['checkout_date']));
        $start_date = $date_range[0];
        $end_date = isset($date_range[1]) ? $date_range[1] : $date_range[0]; // in case only one date is selected
        $sql .= " AND vi.checkout BETWEEN '$start_date' AND '$end_date'";
    }
    if (isset($_GET['date_range']) && !empty($_GET['date_range'])) {
        $date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['date_range']));
        $start_date = $date_range[0];
        $end_date = isset($date_range[1]) ? $date_range[1] : $date_range[0]; // in case only one date is selected
        $sql .= " AND DATE_ADD(vqcf.cf_1162, INTERVAL vi.day - 1 DAY) BETWEEN '$start_date' AND '$end_date'";
    }

    // Pagination
    $limit = 20;
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $page = max($page, 1);
    $offset = ($page - 1) * $limit;

    $sql_total = $sql;
    $total_result = mysqli_query($conn, $sql_total);
    $totalRecords = mysqli_num_rows($total_result);
    $totalPages = ceil($totalRecords / $limit);

    $sql .= " ORDER BY vqcf.cf_1162 ASC LIMIT $limit OFFSET $offset";

    // Execute query
    $result = $conn->query($sql);
    ?>

    <h1 style="text-align: center; margin-top: 20px;">Hotel Rates Report</h1>
    <table class="styled-table" style="width: 80%; margin: 20px auto;">
        <tr>
            <th></th>
            <th>Travel Date</th>
            <th>Quote Number</th>
            <th style="text-align: left;">Hotel Name</th>
            <th>Double Room Per Night</th>
            <th>Check-in Date</th>
            <th>Check-out Date</th>
            <th>Country</th>
        </tr>
        <tr>
            <form method="GET">
                <input type="hidden" name="opt" value="booking-hotels-list">
                <td><button type="submit">Search</button></td>
                <td><input type="text" id="date_range" name="date_range" value="<?php echo isset($_GET['date_range']) ? htmlspecialchars($_GET['date_range']) : ''; ?>"></td>
                <td><input type="text" name="quote_no" value="<?= htmlspecialchars($quoteNoFilter); ?>"></td>
                <td><input type="text" name="hotelname" value="<?= htmlspecialchars($hotelNameFilter); ?>"></td>
                <td></td>
                <td><input type="text" id="checkin_date" name="checkin_date" value="<?php echo isset($_GET['checkin_date']) ? htmlspecialchars($_GET['checkin_date']) : ''; ?>"></td>
                <td><input type="text" id="checkout_date" name="checkout_date" value="<?php echo isset($_GET['checkout_date']) ? htmlspecialchars($_GET['checkout_date']) : ''; ?>"></td>
                <td>
                    <select name="country">
                        <option value="" <?php echo $countryFilter == '' ? 'selected' : ''; ?>>All</option>
                        <option value="Australia" <?php echo $countryFilter == 'Australia' ? 'selected' : ''; ?>>Australia</option>
                        <option value="New Zealand" <?php echo $countryFilter == 'New Zealand' ? 'selected' : ''; ?>>New Zealand</option>
                    </select>
                </td>
            </form>
        </tr>
        <?php if ($result->num_rows > 0): ?>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td></td>
                    <td>
                        <?php 
                        if (isset($row['cf_1162']) && $row['cf_1162'] != '0000-00-00') {
                            $date = new DateTime($row['cf_1162']);
                            echo $date->format('d-M-Y');
                        }
                        ?>
                    </td>
                    <td>
                        <a href="quote.php?opt=summary&quoteNumber=<?= urlencode($row['quote_no']); ?>">
                            <?= htmlspecialchars($row['quote_no']); ?>
                        </a>
                    </td>
                    <td style="text-align: left;"><?= htmlspecialchars($row['hotelname']); ?></td>
                    <td>
                        <?php
                        $quoteid = $row['quoteid'];
                        $sequence_no = $row['sequence_no'];
                        $sql_price = "SELECT sale_price_single, sale_price_double, sale_price_triple, sale_price_child_no_bed 
                                    FROM vtiger_products_saleprice 
                                    WHERE quoteid='$quoteid' AND sequence_no='$sequence_no' AND subquoteid=1
                                    LIMIT 1";
                        $result_price = $conn->query($sql_price);
                        if ($result_price->num_rows > 0) {
                            $price = $result_price->fetch_assoc();                            
                            echo '$ ' . ceil($price['sale_price_double']);
                        }
                        ?>
                    </td>
                    <td><?= htmlspecialchars($row['checkin']); ?></td>
                    <td><?= htmlspecialchars($row['checkout']); ?></td>
                    <td><?= htmlspecialchars($row['country']); ?></td>
                </tr>
            <?php endwhile; ?>
        <?php endif; ?>
        <tr><td></td><td colspan="7" style="text-align: left;">Number of results: <?= $totalRecords ?></td></tr>
    </table>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        flatpickr("#date_range", {
            mode: "range",
            dateFormat: "Y-m-d",
            defaultDate: "<?php echo isset($_GET['date_range']) ? htmlspecialchars($_GET['date_range']) : ''; ?>"
        });
        flatpickr("#checkin_date", {
            mode: "range",
            dateFormat: "Y-m-d",
            defaultDate: "<?php echo isset($_GET['checkin_date']) ? htmlspecialchars($_GET['checkin_date']) : ''; ?>"
        });
        flatpickr("#checkout_date", {
            mode: "range",
            dateFormat: "Y-m-d",
            defaultDate: "<?php echo isset($_GET['checkout_date']) ? htmlspecialchars($_GET['checkout_date']) : ''; ?>"
        });
    </script>
    
    <div class="pagination" style="margin-top: 0;">
        <div>
            <?php if ($page > 1): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
            <?php endif; ?>

            <?php
            $max_pages = min($totalPages, $page + 2);
            for ($i = $page; $i <= $max_pages; $i++): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" <?php if ($i == $page) echo 'style="background-color: #334155; color: white;"'; ?>>
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($page < $totalPages): ?>
                <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
            <?php endif; ?>
        </div>
        
        <form method="GET" action="" style="display:inline;">
            <?php
            foreach ($_GET as $key => $value) {
                if ($key != 'page') {
                    echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                }
            }
            ?>
            <input type="number" name="page" min="1" max="<?php echo $totalPages; ?>" value="<?php echo $page; ?>" style="width:75px;"> / <?php echo $totalPages; ?>
            <button type="submit">Jump</button>
        </form>
    </div>

    <style>
        .pagination {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 20px 0;
        }
        
        .pagination div {
            display: flex;
            align-items: center;
        }
        
        .pagination a {
            text-decoration: none;
            padding: 8px 12px;
            margin: 0 5px;
            border: 1px solid #334155;
            color: #334155;
            border-radius: 4px;
            transition: background-color 0.3s, color 0.3s;
        }
        
        .pagination a:hover {
            background-color: #334155;
            color: white;
        }
        
        .pagination input[type="number"] {
            width: 50px;
            padding: 10px;
            margin-left: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        
        .pagination button {
            padding: 10px 10px;
            margin-left: 5px;
            border: none;
            border-radius: 4px;
            background-color: #334155;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .pagination button:hover {
            background-color: #334155;
        }
        
        tr:nth-child(odd) {
            background-color: #f9f9f9;
        }

        .styled-table td input[type="text"], .styled-table td select {
            width: 100%;
            height: 30px;
            margin: 0;
        }
    </style>
    <?php
}

// Sales Report
else if (($title == 'admin') && isset($_GET['opt']) && $_GET['opt'] == 'email-tags-monthly') {
    include "header.php";

    $tagFilter = isset($_GET['filter_tag']) ? $conn->real_escape_string($_GET['filter_tag']) : '';
    ?>
    <div id="loader">
        <p>Loading...</p><br>
    </div>
    <style>
        #loader {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 50vh;
            font-size: 2em;
        }
        .filter-form input, .filter-form button {
            height: 30px;
        }
    </style>
    <div id="content-all" style="display: none; width: 50%; margin: auto;">
        <h1 style="text-align: center; margin: 20px 0;">Tagging Report</h1>
        <?php
        $sql = "SELECT vf.tag, COUNT(*) 
                FROM vtiger_freetagged_objects vfo
                LEFT JOIN vtiger_freetags vf ON vfo.tag_id = vf.id
                WHERE vf.raw_tag = 'type'
                GROUP BY vf.tag";

        $result = mysqli_query($conn, $sql);

        // Check if there are any rows returned
        if (mysqli_num_rows($result) > 0) {
            echo "<h3>Tagging Summary</h3>";
            echo "<table class='styled-table'>";
            
            // Header Row for Tags
            echo "<thead><tr>";
            while ($row = mysqli_fetch_assoc($result)) {
                echo "<th>" . htmlspecialchars($row['tag']) . "</th>";
            }
            echo "</tr></thead>";

            // Reset the result pointer to start over
            mysqli_data_seek($result, 0);

            // Row for Counts
            echo "<tbody><tr>";
            while ($row = mysqli_fetch_assoc($result)) {
                echo "<td>" . htmlspecialchars($row['COUNT(*)']) . "</td>";
            }
            echo "</tr></tbody></table>";
        } else {
            echo "No results found.";
        }
        ?>
        <form class="filter-form" method="GET">
            <input type="hidden" name="opt" value="email-tags-monthly">
            <label for="filter_tag">Filter by Tag:</label>
            <input type="text" id="filter_tag" name="filter_tag" value="<?php echo htmlspecialchars($tagFilter); ?>">
            <button type="submit">Search</button>
        </form>
        <?php
        for ($i = 0; $i <= 11; $i++) {
            $startDate = date("Y-m-01", strtotime("first day of -$i month"));
            $endDate = date("Y-m-t", strtotime("first day of -$i month"));
            
            $sql = "SELECT vf.tag, vf.raw_tag, MIN(vfo.tagged_on) AS tagged_on, COUNT(*) AS count 
                    FROM vtiger_freetagged_objects vfo 
                    LEFT JOIN (SELECT DISTINCT mailbox, conversation_id FROM tdu_emails) te 
                    ON vfo.object_id = te.conversation_id 
                    LEFT JOIN vtiger_freetags vf 
                    ON vfo.tag_id = vf.id 
                    WHERE vfo.tagged_on BETWEEN '$startDate' AND '$endDate'";
            if (!empty($tagFilter)) {
                $sql .= " AND vf.tag LIKE '%$tagFilter%'";
            }

            $sql .= " GROUP BY vf.tag, vf.raw_tag
                      ORDER BY vf.raw_tag, vf.tag";
            $result = $conn->query($sql);
        
            if ($result->num_rows > 0) {
                echo "<h3>" . date("F Y", strtotime("-$i month")) . "</h3>";
                echo "<table class='styled-table'>
                        <tr>
                            <th>Category</th>
                            <th>Tag</th>
                            <th>Count</th>
                        </tr>";
        
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>
                            <td>" . ucfirst($row['raw_tag']) . "</td>
                            <td>" . $row['tag'] . "</td>
                            <td>" . $row['count'] . "</td>
                        </tr>";
                }
        
                echo "</table>";
            }
        }
        ?>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('loader').style.display = 'none'; // Hide loader
            document.getElementById('content-all').style.display = 'block'; // Show content
        });
    </script>
    <?php
}
else if (($title == 'admin') && isset($_GET['opt']) && $_GET['opt'] == 'sales-home-admin') {
    include "header.php";

    $tagFilter = isset($_GET['filter_tag']) ? $conn->real_escape_string($_GET['filter_tag']) : '';
    $notRejectStages = fetchNotRejectQuoteStages($conn);
    $notRejectStages = implode(',', $notRejectStages);
    ?>
    <div id="loader">
        <p>Loading...</p><br>
    </div>
    <style>
        #loader {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 50vh;
            font-size: 2em;
        }
        .filter-form input, .filter-form button {
            height: 30px;
        }
    </style>
    <div id="content-all" style="display: none;" style="width: 100%;">
        <?php
        $sql = "SELECT 
                    COALESCE(NULLIF(vqinfo.assigned_to_sales_agent, ''), 'unassigned') AS agent_name,
                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(CURDATE()) 
                            AND MONTH(vq.cf_1162) = MONTH(CURDATE()) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_0,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(CURDATE()) 
                            AND MONTH(vq.cf_1162) = MONTH(CURDATE()) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_0,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_1,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_1,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_2,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_2,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_3,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_3,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_4,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_4,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_5,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_5,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_6,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_6,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_7,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_7,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_8,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_8,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_9,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_9,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_10,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_10,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_11,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_11
                FROM (
                    SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162, 'group' AS source
                    FROM vtiger_quotes vq
                    LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                    WHERE vq.quoteid IN (
                        SELECT MIN(sub.quoteid)
                        FROM vtiger_quotes AS sub
                        GROUP BY sub.quote_no
                    )
                    UNION
                    SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162, 'crm' AS source
                    FROM vtiger_quotes_crm vq
                    LEFT JOIN vtiger_quotescf_crm vqcf ON vq.quoteid = vqcf.quoteid
                    WHERE vqcf.cf_1162 >= '2024-10-01'
                ) vq
                LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
                WHERE vq.quotestage NOT LIKE '%reject%' AND vq.cf_1162 >= '2024-10-01'
                GROUP BY agent_name
                HAVING agent_name LIKE '%$tagFilter%'
                ORDER BY (agent_name = 'unassigned') DESC, agent_name;";
        $result = $conn->query($sql);

        if ($result->num_rows > 0): ?>
            <h1 style="text-align:center; margin-top: 20px;">Internal Sales Quote Report</h1>
            <form class="filter-form" method="GET" style="text-align:center; margin-top: 20px;">
                <input type="hidden" name="opt" value="sales-home-admin">
                <label for="filter_tag">Filter by Tag:</label>
                <input type="text" id="filter_tag" name="filter_tag" value="<?php echo htmlspecialchars($tagFilter); ?>">
                <button type="submit">Search</button>
            </form>
            <div class="table-container" style="width: 80%; margin: auto;">
                <div class="table-wrapper">
                    <h2 style="margin-bottom: 10px;">Internal Agents</h2>
                    <table border="1" cellpadding="10" cellspacing="0" style="width: 100%; text-align: center;">
                        <thead>
                            <tr>
                                <th>Agent Name</th>
                                <?php for ($i = 0; $i <= 11; $i++): ?>
                                    <th><?= date('M-y', strtotime("+$i months")) ?></th>
                                <?php endfor; ?>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = $result->fetch_assoc()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['agent_name']) ?></td>
                                    <?php 
                                        $total_count = 0; // Initialize total for the agent
                                        for ($i = 0; $i <= 11; $i++):
                                            $group_count = $row["group_count_next_month_$i"];
                                            $crm_count = $row["crm_count_next_month_$i"];
                                            $monthly_total = $group_count + $crm_count;
                                            $total_count += $monthly_total;
        
                                            if ($monthly_total == 0) {
                                                echo '<td></td>';
                                                continue;
                                            }
                                            $first_day = date('Y-m-01', strtotime("+$i months"));
                                            $last_day = date('Y-m-t', strtotime("+$i months"));
                                            $date_range = "$first_day to $last_day";
                                    ?>
                                        <td>
                                            <a href="quote.php?opt=sales-search&quote_type=fit&date_range=<?= $date_range ?>&assigned_to_sales_agent=<?= urlencode($row['agent_name']) ?>">
                                                <?= $monthly_total ?>
                                            </a>
                                        </td>
                                    <?php endfor; ?>
                                    <td><?= $total_count ?></td> <!-- Display total for the agent -->
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>

        <?php
        $sql = "SELECT 
                    COALESCE(NULLIF(vqinfo.assigned_to_external_sales_agent, ''), 'unassigned') AS agent_name,
                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(CURDATE()) 
                            AND MONTH(vq.cf_1162) = MONTH(CURDATE()) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_0,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(CURDATE()) 
                            AND MONTH(vq.cf_1162) = MONTH(CURDATE()) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_0,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_1,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_1,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_2,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_2,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_3,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_3,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_4,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_4,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_5,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_5,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_6,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_6,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_7,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_7,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_8,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_8,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_9,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_9,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_10,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_10,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) 
                            AND vq.source = 'group' 
                            THEN vq.quoteid END) AS group_count_next_month_11,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) 
                            AND vq.source = 'crm' 
                            THEN vq.quoteid END) AS crm_count_next_month_11
                FROM (
                    SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162, 'group' AS source
                    FROM vtiger_quotes vq
                    LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                    WHERE vq.quoteid IN (
                        SELECT MIN(sub.quoteid)
                        FROM vtiger_quotes AS sub
                        GROUP BY sub.quote_no
                    )
                    UNION
                    SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162, 'crm' AS source
                    FROM vtiger_quotes_crm vq
                    LEFT JOIN vtiger_quotescf_crm vqcf ON vq.quoteid = vqcf.quoteid
                    WHERE vqcf.cf_1162 >= '2024-10-01'
                ) vq
                LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
                WHERE vq.quotestage NOT LIKE '%reject%' AND vq.cf_1162 >= '2024-10-01'
                GROUP BY agent_name
                HAVING agent_name LIKE '%$tagFilter%'
                ORDER BY (agent_name = 'unassigned') DESC, agent_name;";
        $result = $conn->query($sql);

        if ($result->num_rows > 0): ?>
            <div class="table-container" style="width: 80%; margin: auto;">
                <div class="table-wrapper">
                    <h2 style="margin-bottom: 10px;">External Agents</h2>
                    <table border="1" cellpadding="10" cellspacing="0" style="width: 100%; text-align: center;">
                        <thead>
                            <tr>
                                <th>Agent Name</th>
                                <?php for ($i = 0; $i <= 11; $i++): ?>
                                    <th><?= date('M-y', strtotime("+$i months")) ?></th>
                                <?php endfor; ?>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = $result->fetch_assoc()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['agent_name']) ?></td>
                                    <?php 
                                        $total_count = 0; // Initialize total for the agent
                                        for ($i = 0; $i <= 11; $i++):
                                            $group_count = $row["group_count_next_month_$i"];
                                            $crm_count = $row["crm_count_next_month_$i"];
                                            $monthly_total = $group_count + $crm_count;
                                            $total_count += $monthly_total;
        
                                            if ($monthly_total == 0) {
                                                echo '<td></td>';
                                                continue;
                                            }
                                            $first_day = date('Y-m-01', strtotime("+$i months"));
                                            $last_day = date('Y-m-t', strtotime("+$i months"));
                                            $date_range = "$first_day to $last_day";
                                    ?>
                                        <td>
                                            <a href="quote.php?opt=sales-search&quote_type=fit&date_range=<?= $date_range ?>&assigned_to_external_sales_agent=<?= urlencode($row['agent_name']) ?>">
                                                <?= $monthly_total ?>
                                            </a>
                                        </td>
                                    <?php endfor; ?>
                                    <td><?= $total_count ?></td> <!-- Display total for the agent -->
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>

        <?php
        $sql = "SELECT
                    vq.quotestage,
                    COUNT(CASE WHEN MONTH(vq.cf_1162) = MONTH(CURDATE()) AND YEAR(vq.cf_1162) = YEAR(CURDATE()) THEN vq.quoteid END) AS count_current_month,
                    COUNT(CASE WHEN MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) AND YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 1 MONTH)) THEN vq.quoteid END) AS count_next_month_1,
                    COUNT(CASE WHEN MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) AND YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 2 MONTH)) THEN vq.quoteid END) AS count_next_month_2,
                    COUNT(CASE WHEN MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) AND YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 3 MONTH)) THEN vq.quoteid END) AS count_next_month_3,
                    COUNT(CASE WHEN MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) AND YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 4 MONTH)) THEN vq.quoteid END) AS count_next_month_4,
                    COUNT(CASE WHEN MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) AND YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 5 MONTH)) THEN vq.quoteid END) AS count_next_month_5,
                    COUNT(CASE WHEN MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) AND YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 6 MONTH)) THEN vq.quoteid END) AS count_next_month_6,
                    COUNT(CASE WHEN MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) AND YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 7 MONTH)) THEN vq.quoteid END) AS count_next_month_7,
                    COUNT(CASE WHEN MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) AND YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 8 MONTH)) THEN vq.quoteid END) AS count_next_month_8,
                    COUNT(CASE WHEN MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) AND YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 9 MONTH)) THEN vq.quoteid END) AS count_next_month_9,
                    COUNT(CASE WHEN MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) AND YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 10 MONTH)) THEN vq.quoteid END) AS count_next_month_10,
                    COUNT(CASE WHEN MONTH(vq.cf_1162) = MONTH(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) AND YEAR(vq.cf_1162) = YEAR(DATE_ADD(CURDATE(), INTERVAL 11 MONTH)) THEN vq.quoteid END) AS count_next_month_11
                FROM (
                    SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162
                    FROM vtiger_quotes vq
                    LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                    WHERE vq.quoteid IN (
                        SELECT MIN(sub.quoteid)
                        FROM vtiger_quotes AS sub
                        GROUP BY sub.quote_no
                    )
                    UNION 
                    SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162
                    FROM vtiger_quotes_crm vq
                    LEFT JOIN vtiger_quotescf_crm vqcf ON vq.quoteid = vqcf.quoteid
                    WHERE vqcf.cf_1162 >= '2024-10-01'
                ) vq
                LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
                WHERE vq.cf_1162 >= '2024-10-01' ";
        if(isset($tagFilter) && !empty($tagFilter)) {
            $sql .= " AND (vqinfo.assigned_to_sales_agent LIKE '%$tagFilter%' OR vqinfo.assigned_to_external_sales_agent LIKE '%$tagFilter%')";
        }
        $sql .= " GROUP BY vq.quotestage;";
        $result = $conn->query($sql);

        $sql_category = "SELECT category FROM `tdu_agents` WHERE name LIKE '%%';";
        $result_category = $conn->query($sql_category);
        $row_category = $result_category->fetch_assoc();
        if($row_category['category'] == 'internal') {
            $cate = 'assigned_to_sales_agent';
        } else {
            $cate = 'assigned_to_external_sales_agent';
        }

        if ($result->num_rows > 0): ?>
            <div class="table-container" style="width: 80%; margin: auto;">
                <div class="table-wrapper">
                    <h2 style="margin-bottom: 10px;">Monthly Summary</h2>
                    <table border="1" cellpadding="10" cellspacing="0" style="width: 100%; text-align: center;">
                        <thead>
                            <tr>
                                <th style="width: 15%;">Quote Stage</th>
                                <?php for ($i = 0; $i < 12; $i++): ?>
                                    <th><?= date('M-y', strtotime("+$i months")) ?></th>
                                <?php endfor; ?>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = $result->fetch_assoc()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['quotestage']) ?></td>
                                    <?php 
                                        $total_count = 0; // Initialize total count for the row
                                        for ($i = 0; $i < 12; $i++): 
                                            // Determine the column name dynamically
                                            $count_column = $i == 0 ? 'count_current_month' : 'count_next_month_' . $i;
        
                                            // Calculate total
                                            $monthly_count = $row[$count_column];
                                            $total_count += $monthly_count;
        
                                            // Only display the count if it's greater than 0
                                            if ($monthly_count > 0): 
                                                $date_range = getMonthRange($i);
                                    ?>
                                                <td>
                                                    <a href="quote.php?opt=sales-search&quote_type=fit&date_range=<?= $date_range ?>&quote_stage=<?= urlencode($row['quotestage']) ?>&<?= $cate ?>=<?= $tagFilter ?>">
                                                        <?= $monthly_count ?>
                                                    </a>
                                                </td>
                                            <?php else: ?>
                                                <td></td>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                        <td><?= $total_count ?></td> <!-- Display total for the row -->
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>
        
        <style>
            .table-wrapper table tr th {
                width: 7%;
            }
            .table-wrapper table tr:nth-child(even) {
                background-color: #f2f2f2;
            }
        </style>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('loader').style.display = 'none'; // Hide loader
        document.getElementById('content-all').style.display = 'block'; // Show content
        });
    </script>
    <?php
}
else if (($title == 'admin') && isset($_GET['opt']) && $_GET['opt'] == 'sales-home-external') {
    include "header.php";
    ?>
    <h1 style="text-align:center; margin-top: 20px;">External Sales</h1>
    <div class="table-container">
        <div class="table-wrapper">
            <table>
                <tr>
                    <th>TDU Team Member</th>
                    <th>Mode of Meeting</th>
                    <th>Name of the Agency</th>
                    <th>Country</th>
                    <th>City</th>
                    <th>Area</th>
                    <th style="width: 10%;">Contact Person</th>
                    <th>Designation</th>
                    <th style="width: 10%;">Contact No</th>
                    <th style="width: 10%;">Email ID</th>
                    <th>Current ITO (DMC)</th>
                    <th>Meeting Notes</th>
                    <th>Action</th>
                    <th style="width: 10%;">Next Follow-up Date</th>
                    <th>Create Time</th>
                </tr>
                <?php
                $sql = "SELECT *
                        FROM tdu_external_sales AS tes
                        WHERE tes.create_date = (
                            SELECT MAX(create_date)
                            FROM tdu_external_sales
                            WHERE email_id = tes.email_id
                        );";
                $result = mysqli_query($conn, $sql);

                if (mysqli_num_rows($result) > 0) {
                    while ($row = mysqli_fetch_assoc($result)) {
                        echo "<tr>";
                        echo "<td>" . htmlspecialchars($row['tdu_team_member']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['mode_of_meeting']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['agency_name']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['country']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['city']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['area']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['contact_person']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['designation']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['contact_no']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['email_id']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['current_ito_dmc']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['meeting_notes']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['action']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['next_follow_up_date']) . "</td>";
                        echo "<td>" . date("d-M-Y H:i:s", strtotime($row['create_date'])) . "</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='14'>No records found</td></tr>";
                }
                $conn->close();
                ?>
            </table>
        </div>
    </div>

    <?php
}
else if (($title == 'admin') && isset($_GET['opt']) && $_GET['opt'] == 'report-sales') {
    include "header.php";
    $sql = "SELECT 
                'internal' AS agent_type,
                COALESCE(NULLIF(vqinfo.assigned_to_sales_agent, ''), 'unassigned') AS agent_name,
                COUNT(*) AS count,
                CASE 
                    WHEN vq.quotestage LIKE '%reject%' THEN 'Yes' 
                    ELSE 'No' 
                END AS is_rejected
            FROM (
                SELECT quoteid, quotestage
                FROM vtiger_quotes
                WHERE quoteid IN (
                    SELECT MIN(sub.quoteid)
                    FROM vtiger_quotes AS sub
                    GROUP BY sub.quote_no
                )
                UNION 
                SELECT vtiger_quotes_crm.quoteid, vtiger_quotes_crm.quotestage
                FROM vtiger_quotes_crm
                LEFT JOIN vtiger_quotescf_crm ON vtiger_quotes_crm.quoteid = vtiger_quotescf_crm.quoteid
                WHERE vtiger_quotescf_crm.cf_1162 >= '2024-10-01'
            ) vq 
            LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
            GROUP BY agent_name, is_rejected

            UNION ALL

            SELECT 
                'external' AS agent_type,
                COALESCE(NULLIF(vqinfo.assigned_to_external_sales_agent, ''), 'unassigned') AS agent_name,
                COUNT(*) AS count,
                CASE 
                    WHEN vq.quotestage LIKE '%reject%' THEN 'Yes' 
                    ELSE 'No' 
                END AS is_rejected
            FROM (
                SELECT quoteid, quotestage
                FROM vtiger_quotes
                WHERE quoteid IN (
                    SELECT MIN(sub.quoteid)
                    FROM vtiger_quotes AS sub
                    GROUP BY sub.quote_no
                )
                UNION 
                SELECT vtiger_quotes_crm.quoteid, vtiger_quotes_crm.quotestage
                FROM vtiger_quotes_crm
                LEFT JOIN vtiger_quotescf_crm ON vtiger_quotes_crm.quoteid = vtiger_quotescf_crm.quoteid
                WHERE vtiger_quotescf_crm.cf_1162 >= '2024-10-01'
            ) vq 
            LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
            GROUP BY agent_name, is_rejected;";
    $result = $conn->query($sql);

    $internalAgents = [];
    $externalAgents = [];
    while ($row = $result->fetch_assoc()) {
        if ($row['agent_type'] == 'internal') {
            if($row['agent_name'] == 'unassigned' || $row['is_rejected'] == 'No') {
                $internalAgents[] = $row;
            }
        } else {
            if($row['agent_name'] == 'unassigned' || $row['is_rejected'] == 'No') {
                $externalAgents[] = $row;
            }
        }
    }

    foreach ($internalAgents as $key => $agent) {
        if ($agent['agent_name'] == 'unassigned') {
            unset($internalAgents[$key]);
            $internalAgents[] = $agent;
        }
    }
    
    foreach ($externalAgents as $key => $agent) {
        if ($agent['agent_name'] == 'unassigned') {
            unset($externalAgents[$key]);
            $externalAgents[] = $agent;
        }
    }
    ?>
    <h1 style="text-align:center; margin-top: 20px;">Internal Sales</h1>
    
    <div class="table-container" style="width: 80%; margin: auto;">
        <div class="table-wrapper">
            <table>
                <tr>
                    <th>Internal Agents</th>
                    <th>Quotes Assigned</th>
                </tr>
                <?php foreach ($internalAgents as $agent): ?>
                    <tr>
                        <td>
                            <?php 
                            if($agent['is_rejected'] == 'Yes' && $agent['agent_name'] =='unassigned') {
                                echo "<a href='?opt=sales-search&quote_stage=reject&assigned_to_sales_agent=" . urlencode($agent['agent_name']) . "'>rejected</a>"; 
                            } else {
                                echo "<a href='?opt=sales-search&assigned_to_sales_agent=" . urlencode($agent['agent_name']) . "'>" . $agent['agent_name'] . "</a>"; 
                            }
                            ?>
                        </td>
                        <td><?php echo htmlspecialchars($agent['count']); ?></td>
                    </tr>
                <?php endforeach; ?>
            </table>
        </div>
        <div class="table-wrapper">
            <table>
                <tr>
                    <th>External Agents</th>
                    <th>Quotes Assigned</th>
                </tr>
                <?php foreach ($externalAgents as $agent): ?>
                    <tr>
                        <td>
                            <?php 
                            if($agent['is_rejected'] == 'Yes' && $agent['agent_name'] =='unassigned') {
                                echo "<a href='?opt=sales-search&quote_stage=reject&assigned_to_external_sales_agent=" . urlencode($agent['agent_name']) . "'>rejected</a>"; 
                            } else {
                                echo "<a href='?opt=sales-search&assigned_to_external_sales_agent=" . urlencode($agent['agent_name']) . "'>" . $agent['agent_name'] . "</a>"; 
                            }
                            ?>
                        </td>
                        <td><?php echo htmlspecialchars($agent['count']); ?></td>
                    </tr>
                <?php endforeach; ?>
            </table>
        </div>
    </div>

    <?php

    $notRejectStages = fetchNotRejectQuoteStages($conn);
    $notRejectStages = implode(',', $notRejectStages);
    ?>
    <div id="loader">
        <p>Loading...</p><br>
    </div>
    <style>
        #loader {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 50vh;
            font-size: 2em;
        }
    </style>
    <div id="content-all" style="display: none;" style="width: 100%;">
        <?php
        $sql = "SELECT 
                COALESCE(NULLIF(vqinfo.assigned_to_sales_agent, ''), 'unassigned') AS agent_name,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) 
                        AND vq.source = 'group' 
                        THEN vq.quoteid END) AS group_count_last_month_1,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) 
                        AND vq.source = 'crm' 
                        THEN vq.quoteid END) AS crm_count_last_month_1,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) 
                        AND vq.source = 'group' 
                        THEN vq.quoteid END) AS group_count_last_month_2,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) 
                        AND vq.source = 'crm' 
                        THEN vq.quoteid END) AS crm_count_last_month_2,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) 
                        AND vq.source = 'group' 
                        THEN vq.quoteid END) AS group_count_last_month_3,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) 
                        AND vq.source = 'crm' 
                        THEN vq.quoteid END) AS crm_count_last_month_3,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) 
                        AND vq.source = 'group' 
                        THEN vq.quoteid END) AS group_count_last_month_4,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) 
                        AND vq.source = 'crm' 
                        THEN vq.quoteid END) AS crm_count_last_month_4,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) 
                        AND vq.source = 'group' 
                        THEN vq.quoteid END) AS group_count_last_month_5,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) 
                        AND vq.source = 'crm' 
                        THEN vq.quoteid END) AS crm_count_last_month_5,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) 
                        AND vq.source = 'group' 
                        THEN vq.quoteid END) AS group_count_last_month_6,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) 
                        AND vq.source = 'crm' 
                        THEN vq.quoteid END) AS crm_count_last_month_6

            FROM (
                SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162, 'group' AS source
                FROM vtiger_quotes vq
                LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                WHERE vq.quoteid IN (
                    SELECT MIN(sub.quoteid)
                    FROM vtiger_quotes AS sub
                    GROUP BY sub.quote_no
                )
                UNION
                SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162, 'crm' AS source
                FROM vtiger_quotes_crm vq
                LEFT JOIN vtiger_quotescf_crm vqcf ON vq.quoteid = vqcf.quoteid
                WHERE vqcf.cf_1162 >= DATE_SUB(CURDATE(), INTERVAL 6 MONTH)
            ) vq
            LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
            WHERE vq.quotestage NOT LIKE '%reject%' AND vq.cf_1162 >= DATE_SUB(CURDATE(), INTERVAL 6 MONTH)
            GROUP BY agent_name;";
        $result = $conn->query($sql);

        if ($result->num_rows > 0): ?>
            <div class="table-container" style="width: 80%; margin: auto;">
                <div class="table-wrapper">
                    <h2 style="margin-bottom: 10px;">Internal Agents</h2>
                    <table border="1" cellpadding="10" cellspacing="0" style="width: 100%; text-align: center;">
                        <thead>
                            <tr>
                                <th>Agent Name</th>
                                <?php for ($i = 1; $i <= 6; $i++): ?>
                                    <th><?= date('M-y', strtotime("-$i months")) ?></th>
                                <?php endfor; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = $result->fetch_assoc()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['agent_name']) ?></td>
                                    <?php for ($i = 1; $i <= 6; $i++):
                                        $group_count = $row["group_count_last_month_$i"];
                                        $crm_count = $row["crm_count_last_month_$i"];
                                        $total_count = $group_count + $crm_count;

                                        if ($total_count == 0) {
                                            echo '<td></td>';
                                            continue;
                                        }
                                        $first_day = date('Y-m-01', strtotime("-$i months"));
                                        $last_day = date('Y-m-t', strtotime("-$i months"));
                                        $date_range = "$first_day to $last_day";
                                    ?>
                                        <td><a href="quote.php?opt=sales-search&date_range=<?= $date_range ?>&assigned_to_sales_agent=<?= urlencode($row['agent_name']) ?>"><?= $group_count+$crm_count ?></a></td>
                                    <?php endfor; ?>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>

        <?php
        $sql = "SELECT 
                COALESCE(NULLIF(vqinfo.assigned_to_external_sales_agent, ''), 'unassigned') AS agent_name,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) 
                        AND vq.source = 'group' 
                        THEN vq.quoteid END) AS group_count_last_month_1,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) 
                        AND vq.source = 'crm' 
                        THEN vq.quoteid END) AS crm_count_last_month_1,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) 
                        AND vq.source = 'group' 
                        THEN vq.quoteid END) AS group_count_last_month_2,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) 
                        AND vq.source = 'crm' 
                        THEN vq.quoteid END) AS crm_count_last_month_2,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) 
                        AND vq.source = 'group' 
                        THEN vq.quoteid END) AS group_count_last_month_3,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) 
                        AND vq.source = 'crm' 
                        THEN vq.quoteid END) AS crm_count_last_month_3,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) 
                        AND vq.source = 'group' 
                        THEN vq.quoteid END) AS group_count_last_month_4,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) 
                        AND vq.source = 'crm' 
                        THEN vq.quoteid END) AS crm_count_last_month_4,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) 
                        AND vq.source = 'group' 
                        THEN vq.quoteid END) AS group_count_last_month_5,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) 
                        AND vq.source = 'crm' 
                        THEN vq.quoteid END) AS crm_count_last_month_5,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) 
                        AND vq.source = 'group' 
                        THEN vq.quoteid END) AS group_count_last_month_6,

                COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) 
                        AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) 
                        AND vq.source = 'crm' 
                        THEN vq.quoteid END) AS crm_count_last_month_6

            FROM (
                SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162, 'group' AS source
                FROM vtiger_quotes vq
                LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                WHERE vq.quoteid IN (
                    SELECT MIN(sub.quoteid)
                    FROM vtiger_quotes AS sub
                    GROUP BY sub.quote_no
                )
                UNION
                SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162, 'crm' AS source
                FROM vtiger_quotes_crm vq
                LEFT JOIN vtiger_quotescf_crm vqcf ON vq.quoteid = vqcf.quoteid
                WHERE vqcf.cf_1162 >= DATE_SUB(CURDATE(), INTERVAL 6 MONTH)
            ) vq
            LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
            WHERE vq.quotestage NOT LIKE '%reject%' AND vq.cf_1162 >= DATE_SUB(CURDATE(), INTERVAL 6 MONTH)
            GROUP BY agent_name;";
        $result = $conn->query($sql);

        if ($result->num_rows > 0): ?>
            <div class="table-container" style="width: 80%; margin: auto;">
                <div class="table-wrapper">
                    <h2 style="margin-bottom: 10px;">External Agents</h2>
                    <table border="1" cellpadding="10" cellspacing="0" style="width: 100%; text-align: center;">
                        <thead>
                            <tr>
                                <th>Agent Name</th>
                                <?php for ($i = 1; $i <= 6; $i++): ?>
                                    <th><?= date('M-y', strtotime("-$i months")) ?></th>
                                <?php endfor; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = $result->fetch_assoc()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['agent_name']) ?></td>
                                    <?php for ($i = 1; $i <= 6; $i++):
                                        $group_count = $row["group_count_last_month_$i"];
                                        $crm_count = $row["crm_count_last_month_$i"];
                                        $total_count = $group_count + $crm_count;

                                        if ($total_count == 0) {
                                            echo '<td></td>';
                                            continue;
                                        }
                                        $first_day = date('Y-m-01', strtotime("-$i months"));
                                        $last_day = date('Y-m-t', strtotime("-$i months"));
                                        $date_range = "$first_day to $last_day";
                                    ?>
                                        <td><a href="quote.php?opt=sales-search&date_range=<?= $date_range ?>&assigned_to_external_sales_agent=<?= urlencode($row['agent_name']) ?>"><?= $group_count+$crm_count ?></a></td>
                                    <?php endfor; ?>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>

        <?php
        $sql = "SELECT 
                    vq.quotestage,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) 
                            THEN vq.quoteid END) AS count_last_month_1,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 2 MONTH)) 
                            THEN vq.quoteid END) AS count_last_month_2,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 3 MONTH)) 
                            THEN vq.quoteid END) AS count_last_month_3,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 4 MONTH)) 
                            THEN vq.quoteid END) AS count_last_month_4,

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 5 MONTH)) 
                            THEN vq.quoteid END) AS count_last_month_5, 

                    COUNT(CASE WHEN YEAR(vq.cf_1162) = YEAR(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) 
                            AND MONTH(vq.cf_1162) = MONTH(DATE_SUB(CURDATE(), INTERVAL 6 MONTH)) 
                            THEN vq.quoteid END) AS count_last_month_6

                FROM (
                    SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162
                    FROM vtiger_quotes vq
                    LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                    WHERE vq.quoteid IN (
                        SELECT MIN(sub.quoteid)
                        FROM vtiger_quotes AS sub
                        GROUP BY sub.quote_no
                    )
                    UNION 
                    SELECT vq.quoteid, vq.quotestage, vqcf.cf_1162
                    FROM vtiger_quotes_crm vq
                    LEFT JOIN vtiger_quotescf_crm vqcf ON vq.quoteid = vqcf.quoteid
                ) vq
                LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
                WHERE (vq.quotestage = 'Create Project'
                        OR vq.quotestage LIKE '%Requote%'
                        OR vq.quotestage LIKE '%On Ground%')
                GROUP BY vq.quotestage;";

        $result = $conn->query($sql);

        if ($result->num_rows > 0): ?>
            <div class="table-container" style="width: 80%; margin: auto;">
                <div class="table-wrapper">
                    <h2 style="margin-bottom: 10px;">Monthly Summary</h2>
                    <table border="1" cellpadding="10" cellspacing="0" style="width: 100%; text-align: center;">
                        <thead>
                            <tr>
                                <th style="width: 15%;">Quote Stage</th>
                                <?php for ($i = 1; $i <= 6; $i++): ?>
                                    <th><?= date('M-y', strtotime("-$i months")) ?></th>
                                <?php endfor; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = $result->fetch_assoc()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['quotestage']) ?></td>
                                    <?php 
                                    for ($i = 1; $i <= 6; $i++): 
                                        // Determine the column name dynamically
                                        $count_column = 'count_last_month_' . $i;
                                        
                                        // Only display the count if it's greater than 0
                                        if ($row[$count_column] > 0): 
                                            $date_range = getMonthRangeMinus($i);
                                    ?>
                                            <td>
                                                <a href="quote.php?opt=sales-search&quote_type=fit&date_range=<?= $date_range ?>&quote_stage=<?= urlencode($row['quotestage']) ?>">
                                                    <?= $row[$count_column] ?>
                                                </a>
                                            </td>
                                    <?php else: ?>
                                            <td></td>
                                    <?php endif; endfor; ?>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>
        
        <style>
            .table-wrapper table tr th {
                width: 7%;
            }
            .table-wrapper table tr:nth-child(even) {
                background-color: #f2f2f2;
            }
        </style>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
        document.getElementById('loader').style.display = 'none'; // Hide loader
        document.getElementById('content-all').style.display = 'block'; // Show content
        });
    </script>
    <?php
}
else if (($title == 'admin') && isset($_GET['opt']) && $_GET['opt'] == 'report-sales-region') {
    include "header.php";
    $sql = "SELECT 
                assigned_to_region, 
                COUNT(*) AS record_count
            FROM 
                vtiger_quotes_info
            WHERE assigned_to_region != ''
            GROUP BY 
                assigned_to_region";

    $result = $conn->query($sql);
    ?>

    <h1 style="text-align:center; margin-top: 20px;">Region-wise Quote Assignment Overview</h1>
    <div class="table-container" style="width: 50%; margin: auto;">
        <div class="table-wrapper">
            <table>
                <tr>
                    <th>Assigned Region</th>
                    <th>Record Count</th>
                </tr>
                <?php
                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        ?>
                        <tr>
                            <td>
                                <?php 
                                echo "<a href='quote.php?opt=sales-search&assigned_to_region=" . urlencode($row['assigned_to_region']) . "'>" . htmlspecialchars($row['assigned_to_region']) . "</a>";
                                ?>
                            </td>
                            <td><?php echo $row['record_count']; ?></td>
                        </tr>
                        <?php
                    }
                } else {
                    ?>
                    <tr>
                        <td colspan="2">No results found</td>
                    </tr>
                    <?php
                }
                ?>
            </table>
        </div>
    </div>
    <?php
}
else if (($title == 'admin') && isset($_GET['opt']) && $_GET['opt'] == 'payment-due-approve-list') {
    include "header.php";
    ?>

    <h1 style="text-align: center; margin-top: 20px;">Payment Due change pending approval</h1>
    <table class="styled-table" style="width: 20%; margin: 20px auto;">
        <?php
        $sql = "SELECT vq.quoteid, vq.quote_no 
                FROM vtiger_quotes vq
                LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
                WHERE vqcf.cf_1182_pending IS NOT NULL";

        $result = $conn->query($sql);

        if ($result && $result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $quoteid = htmlspecialchars($row['quoteid']);
                $quote_no = htmlspecialchars($row['quote_no']);
                $quotetype = (str_ends_with($quote_no, 'G')) ? 'group' : 'fit-dashboard';

                echo "<tr>
                        <td>
                            <a href='quote.php?opt=summary&sales=true&quotetype=$quotetype&quoteid=$quoteid'>
                                $quote_no
                            </a>
                        </td>
                        </tr>";
            }
        } else {
            echo "<tr><td colspan='1'>No quotes found.</td></tr>";
        }
        ?>
    </table>

    <?php
}


// Redirect
else {
    header('Location: login.php');
    exit();
}
?>
