<?php
// New Sales Report
if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'sales-home-v2') {
    include "header.php";
    $blocked_users = getBlockedUsers($conn);

    if (!isset($_GET['date_range'])) {
        $_GET['date_range'] = date('Y-m-d', strtotime('-7 day')) . ' to ' . date('Y-m-d', strtotime('+6 day'));
    }

    // Date range filter
    $date_range = isset($_GET['date_range']) ? $_GET['date_range'] : '';
    $date_sql = '';
    if (!empty($date_range)) {
        $date_range = explode(' to ', mysqli_real_escape_string($conn, $date_range));
        $start_date = $date_range[0];
        $end_date = isset($date_range[1]) ? $date_range[1] : $date_range[0];
        $date_sql = " AND DATE(vqcf.cf_1162) BETWEEN '$start_date' AND '$end_date'";
    }

    // Quote type filter
    $quote_type = isset($_GET['quote_type']) ? $_GET['quote_type'] : '';
    $quote_type_sql = '';
    if ($quote_type == 'group') {
        $quote_type_sql = " AND vq.quote_no LIKE '%G'";
    } elseif ($quote_type == 'fit-dashboard') {
        $quote_type_sql = " AND vq.quote_no NOT LIKE '%G'";
    }

    // Sales agent selection
    if($title == 'external') {
        $_GET['agent_type'] = 'external';
    } 
    $agent_column = isset($_GET['agent_type']) && $_GET['agent_type'] == 'external' ? 'assigned_to_external_sales_agent' : 'assigned_to_sales_agent';

    // SQL query
    $sql = "SELECT vqcf.cf_1162 AS travel_date, vqinfo.$agent_column, vqinfo.priority
            FROM vtiger_quotes vq
            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
            LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid AND vqinfo.quotetype = 'group'
            WHERE 1=1 $date_sql $quote_type_sql";

    $result = mysqli_query($conn, $sql);

    // Process results into a grouped array
    $data = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $agent = !empty($row[$agent_column]) ? $row[$agent_column] : 'Unassigned';
        $priority = !empty($row['priority']) ? strtolower($row['priority']) : 'none';

        if ($agent == 'Unassigned') {
            continue; // Skip unassigned agents
        }

        if (in_array($agent, $blocked_users)) {
            continue; // Skip blocked users
        }

        if ($title == 'sales' || $title == 'external') {
            if($agent != $username_ajax) {
                continue; // Skip agents not matching the logged-in user
            }
        }

        if (!isset($data[$agent][$priority])) {
            $data[$agent][$priority] = 0;
        }

        $data[$agent][$priority]++;
    }

    ?>
    <h1 style="text-align:center; margin: 20px 0;">Sales Reports</h1>

    <form method="GET" style="text-align: center; margin: 20px auto;">
        <input type="hidden" name="opt" value="sales-home-v2">
        <input type="hidden" name="date_range" value="<?php echo htmlspecialchars($_GET['date_range'] ?? ''); ?>">
        <input type="hidden" name="date_field" value="<?php echo htmlspecialchars($_GET['date_field']); ?>">
        <table style="margin: 0 auto; width: 80%;">
            <tr>
                <td>
                    <select name="quote_type" id="quote_type" style="margin: 0; height: 30px; width: 100%;">
                        <option value="">All</option>
                        <option value="group" <?php echo (isset($_GET['quote_type']) && $_GET['quote_type'] == 'group') ? 'selected' : ''; ?>>Group</option>
                        <option value="fit-dashboard" <?php echo (isset($_GET['quote_type']) && $_GET['quote_type'] == 'fit-dashboard') ? 'selected' : ''; ?>>FIT</option>
                    </select>
                </td>
                <td><input type="text" id="date_range" name="date_range" value="<?php echo isset($_GET['date_range']) ? htmlspecialchars($_GET['date_range']) : ''; ?>" style="margin: 0; height: 30px; width: 100%;" placeholder="Date Filter"></td>
                <td>
                    <select name="agent_type" id="agent_type" style="margin: 0; height: 30px; width: 100%;">
                        <option value="internal" <?php echo (!isset($_GET['agent_type']) || $_GET['agent_type'] == 'internal') ? 'selected' : ''; ?>>Internal</option>
                        <option value="external" <?php echo (isset($_GET['agent_type']) && $_GET['agent_type'] == 'external') ? 'selected' : ''; ?>>External</option>
                    </select>
                </td>
                <td><button type="submit" style="height: 30px; width: 100%;"><i class="fa-solid fa-magnifying-glass"></i></button></td>
            </tr>
        </table>
    </form>

    <table class="styled-table" style="width: 80%; margin: auto;">
        <tr>
            <th style="text-align: left;">Agent/Priority</th>
            <th>High</th>
            <th>Low</th>
            <th>Not Connected</th>
            <th>None</th>
        </tr>
        <?php foreach ($data as $agent => $priorities): ?>
            <tr>
                <td style="text-align: left;"><?= htmlspecialchars($agent) ?></td>
                <?php foreach (['high', 'low', 'not connected', 'none'] as $priority): 
                    $count = $priorities[$priority] ?? 0;
                    $url = "quote.php?query=&opt=sales-search&priority=";
                    $url .= urlencode($priority);
                    $url .= "&" . $agent_column . "=" . urlencode($agent);
                    $url .= "&date_range=" . urlencode($_GET['date_range']);
                    $url .= "&quote_type=" . urlencode($_GET['quote_type']);
                ?>
                    <td>
                        <a href="<?= htmlspecialchars($url) ?>"><?= $count ?></a>
                    </td>
                <?php endforeach; ?>
            </tr>
        <?php endforeach; ?>
    </table>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        flatpickr("#date_range", {
            mode: "range",
            dateFormat: "Y-m-d",
            defaultDate: "<?php echo isset($_GET['date_range']) ? htmlspecialchars($_GET['date_range']) : ''; ?>"
        });
    </script>

    <?php

    // Filters
    $date_range = isset($_GET['date_range']) ? $_GET['date_range'] : '';
    $quote_type = isset($_GET['quote_type']) ? $_GET['quote_type'] : '';
    $agent_column = (isset($_GET['agent_type']) && $_GET['agent_type'] == 'external') ? 'assigned_to_external_sales_agent' : 'assigned_to_sales_agent';
    if($title == 'external') {
        $_GET['agent_type'] = 'external';
    } 

    $date_field = $_GET['date_field'] ?? 'next_follow_up_date';
    $date_column_sql = ($date_field == 'calltime') ? 'vqf.calltime' : 'vqf.next_follow_up_date';

    // SQL Conditions
    $follow_up_sql = '';
    if (!empty($date_range)) {
        $date_range = explode(' to ', mysqli_real_escape_string($conn, $date_range));
        $start_date = $date_range[0];
        $end_date = isset($date_range[1]) ? $date_range[1] : $date_range[0];
        $follow_up_sql = " AND DATE($date_column_sql) BETWEEN '$start_date' AND '$end_date'";
    } else {
        $follow_up_sql = " AND $date_column_sql IS NULL AND (vq.quotestage = 'Created' OR vq.quotestage = 'Accepted')";
    }

    $quote_type_sql = '';
    if ($quote_type == 'group') {
        $quote_type_sql = " AND vq.quote_no LIKE '%G'";
    } elseif ($quote_type == 'fit-dashboard') {
        $quote_type_sql = " AND vq.quote_no NOT LIKE '%G'";
    }

    // Main Query
    $sql = "SELECT vqinfo.$agent_column AS agent, DATE($date_column_sql) AS follow_up_date
            FROM vtiger_quotes vq
            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
            LEFT JOIN vtiger_quotes_followup vqf ON vq.quoteid = vqf.quoteid AND vqf.quotetype = 'group'
            LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
            WHERE 1=1 $follow_up_sql $quote_type_sql";

    $result = mysqli_query($conn, $sql);

    $data = [];
    $all_dates = [];

    while ($row = mysqli_fetch_assoc($result)) {
        $agent = !empty($row['agent']) ? $row['agent'] : 'Unassigned';
        if ($agent == 'Unassigned') {
            continue; // Skip unassigned agents
        }

        if ($title == 'sales' || $title == 'external') {
            if($agent != $username_ajax) {
                continue; // Skip agents not matching the logged-in user
            }
        }

        $date = $row['follow_up_date'] ?: 'No Date';

        $all_dates[$date] = true;

        if (!isset($data[$agent][$date])) {
            $data[$agent][$date] = 0;
        }
        $data[$agent][$date]++;
    }

    ksort($all_dates);
    ksort($data);

    $heading_label = ($date_field == 'calltime') ? 'Call Time Report' : 'Follow-Up Report';
    ?>

    <form id="dateForm" method="GET" style="text-align: center; margin: 20px auto;">
        <input type="hidden" name="opt" value="sales-home-v2">
        <table style="margin: 0 auto; width: 80%;">
            <tr>
                <input type="hidden" name="quote_type" value="<?php echo htmlspecialchars($quote_type); ?>">
                <input type="hidden" name="date_range" value="<?php echo htmlspecialchars($_GET['date_range'] ?? ''); ?>">
                <input type="hidden" name="agent_type" value="<?php echo htmlspecialchars($_GET['agent_type'] ?? ''); ?>">
                <td>
                    <select name="date_field" style="height: 30px; width: 100%; margin: 0;" onchange="document.getElementById('dateForm').submit();">
                        <option value="next_follow_up_date" <?php echo ($date_field == 'next_follow_up_date') ? 'selected' : ''; ?>>Follow-Up Date Report</option>
                        <option value="calltime" <?php echo ($date_field == 'calltime') ? 'selected' : ''; ?>>Call Time Report</option>
                    </select>
                </td>
            </tr>
        </table>
    </form>

    <table class="styled-table" style="width: 80%; margin: auto; margin-bottom: 20px;">
        <thead>
            <tr>
                <th style="text-align: left;">Agent/<?php echo $heading_label; ?></th>
                <?php foreach (array_keys($all_dates) as $date): ?>
                    <th style="text-align: left;"><?php echo htmlspecialchars($date); ?></th>
                <?php endforeach; ?>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($data as $agent => $dates): ?>
                <tr>
                    <td style="text-align: left;"><?php echo htmlspecialchars($agent); ?></td>
                    <?php foreach (array_keys($all_dates) as $date): ?>
                        <td style="text-align: left;">
                            <?php
                                $count = $dates[$date] ?? 0;
                                $link = "quote.php?opt=sales-search";
                                $link .= "&quote_type=" . urlencode($_GET['quote_type'] ?? '');
                                $link .= "&" . $agent_column . "=" . urlencode($agent);

                                $date_param = ($date_field == 'calltime') ? 'call_time_date_range' : 'followup_date_range';
                                if ($date !== 'No Date') {
                                    $link .= "&$date_param=" . urlencode("$date to $date");
                                    echo "<a href=\"" . htmlspecialchars($link) . "\">$count</a>";
                                } else {
                                    echo $count;
                                }

                            ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        flatpickr("#date_range", {
            mode: "range",
            dateFormat: "Y-m-d",
            defaultDate: "<?php echo htmlspecialchars($_GET['date_range'] ?? ''); ?>"
        });
    </script>
    <?php 
}

else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'sales-confirmation-report') {
    include "header.php";
    $blocked_users = getBlockedUsers($conn);

    // Default date range
    if (!isset($_GET['date_range'])) {
        $_GET['date_range'] = date('Y-m', strtotime('-5 month')) . ' to ' . date('Y-m');
    }

    // Parse date range
    $date_range = explode(' to ', mysqli_real_escape_string($conn, $_GET['date_range']));
    $start_date = date('Y-m-01', strtotime($date_range[0]));
    $end_date = date('Y-m-t', strtotime(isset($date_range[1]) ? $date_range[1] : $date_range[0]));

    // Agent column
    if ($title == 'external') {
        $_GET['agent_type'] = 'external';
    }
    $agent_column = (isset($_GET['agent_type']) && $_GET['agent_type'] == 'external') ? 'assigned_to_external_sales_agent' : 'assigned_to_sales_agent';

    // Quote type filter
    $quote_type_sql = '';
    if (isset($_GET['quote_type'])) {
        if ($_GET['quote_type'] == 'group') {
            $quote_type_sql = " AND vq.quote_no LIKE '%G'";
        } elseif ($_GET['quote_type'] == 'fit-dashboard') {
            $quote_type_sql = " AND vq.quote_no NOT LIKE '%G'";
        }
    }

    // SQL to fetch raw data
    $sql = "SELECT vq.quoteid, vqcf.cf_1162 AS travel_date, vqinfo.$agent_column AS agent, vqinfo.priority, vq.quote_no
            FROM vtiger_quotes vq
            LEFT JOIN vtiger_quotescf vqcf ON vq.quoteid = vqcf.quoteid
            LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
            WHERE vq.quotestage IN (
                    'Accepted', 'PRE QA - pending', 'PRE QA - completed', 'Payment Received - Release Vouchers',
                    'Final QA', 'Delivered', 'On Ground', 'Accounts - Reconciliation', 'Completed (Accounts)'
                )
                AND vqcf.cf_1162 BETWEEN '$start_date' AND '$end_date'
                $quote_type_sql";

    $result = mysqli_query($conn, $sql);

    $data = [];
    $months = [];

    while ($row = mysqli_fetch_assoc($result)) {
        $agent = $row['agent'] ?: 'Unassigned';
        $travel_date = $row['travel_date'];

        if (empty($travel_date)) continue;

        $month = date('Y-m', strtotime($travel_date));
        $months[$month] = true;

        if ($agent == 'Unassigned') {
            continue;
        }

        if (in_array($agent, $blocked_users)) {
            continue; // Skip blocked users
        }

        // Only show self for sales/external
        if (($title == 'sales' || $title == 'external') && $agent != $username_ajax) {
            continue;
        }

        if (!isset($data[$agent][$month])) {
            $data[$agent][$month] = 0;
        }

        $data[$agent][$month]++;
    }

    ksort($months);
    ?>

    <h1 style="text-align:center; margin: 20px 0;">Confirmation Report</h1>

    <form method="GET" style="text-align: center; margin: 20px auto;">
        <input type="hidden" name="opt" value="sales-confirmation-report">
        <table style="margin: 0 auto; width: 90%;">
            <tr>
                <td>
                    <select name="quote_type" id="quote_type" style="margin: 0; height: 30px; width: 100%;">
                        <option value="">All</option>
                        <option value="group" <?= (isset($_GET['quote_type']) && $_GET['quote_type'] == 'group') ? 'selected' : '' ?>>Group</option>
                        <option value="fit-dashboard" <?= (isset($_GET['quote_type']) && $_GET['quote_type'] == 'fit-dashboard') ? 'selected' : '' ?>>FIT</option>
                    </select>
                </td>
                <td><input type="text" id="date_range" name="date_range" value="<?= htmlspecialchars($_GET['date_range']) ?>" style="margin: 0; height: 30px; width: 100%;" placeholder="Date Filter"></td>
                <td>
                    <select name="agent_type" id="agent_type" style="margin: 0; height: 30px; width: 100%;">
                        <option value="internal" <?= (!isset($_GET['agent_type']) || $_GET['agent_type'] == 'internal') ? 'selected' : '' ?>>Internal</option>
                        <option value="external" <?= (isset($_GET['agent_type']) && $_GET['agent_type'] == 'external') ? 'selected' : '' ?>>External</option>
                    </select>
                </td>
                <td><button type="submit" style="height: 30px; width: 100%;"><i class="fa-solid fa-magnifying-glass"></i></button></td>
            </tr>
        </table>
    </form>

    <table class="styled-table" style="width: 90%; margin: auto;">
        <thead>
            <tr>
                <th style="text-align: left;">Agent</th>
                <?php foreach (array_keys($months) as $month): ?>
                    <th><?= htmlspecialchars(date('M-y', strtotime($month))) ?></th>
                <?php endforeach; ?>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($data as $agent => $monthCounts): ?>
                <tr>
                    <td style="text-align: left;"><?= htmlspecialchars($agent) ?></td>
                    <?php foreach (array_keys($months) as $month): ?>
                        <?php
                        $count = $monthCounts[$month] ?? 0;
                        if ($count > 0) {
                            $date_from = date('Y-m-01', strtotime($month));
                            $date_to = date('Y-m-t', strtotime($month));
                            $agent_param = ($agent_column === 'assigned_to_external_sales_agent') ? 'assigned_to_external_sales_agent' : 'assigned_to_sales_agent';
                            $quote_stage = urlencode("Accepted,PRE QA - pending,PRE QA - completed,Payment Received - Release Vouchers,Final QA,Delivered,On Ground,Accounts - Reconciliation,Completed (Accounts)");
                            $quote_type = isset($_GET['quote_type']) ? urlencode($_GET['quote_type']) : '';
                            $link = "quote.php?query=&opt=sales-search&date_range={$date_from}+to+{$date_to}&quote_stage={$quote_stage}&{$agent_param}=" . urlencode($agent);
                            if ($quote_type !== '') {
                                $link .= "&quote_type={$quote_type}";
                            }
                            echo "<td><a href=\"$link\">$count</a></td>";
                        } else {
                            echo "<td>0</td>";
                        }
                        ?>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/plugins/monthSelect/style.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/plugins/monthSelect/index.js"></script>
    <script>
        flatpickr("#date_range", {
            mode: "range",
            dateFormat: "Y-m", // Format as YYYY-MM
            plugins: [
                new monthSelectPlugin({
                    shorthand: true,
                    dateFormat: "Y-m",
                    altFormat: "F Y"
                })
            ]
        });
    </script>

    <?php
}

// Redirect
else {
    header('Location: login.php');
    exit();
}
?>
