<?php
// Template
if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'templates') {
    include "header.php";

    // Filters
    $templateNameFilter = isset($_GET['templatename']) ? $_GET['templatename'] : '';
    $cityFilter = isset($_GET['cities']) ? $_GET['cities'] : [];
    $categoryFilter = isset($_GET['category']) ? $_GET['category'] : '';
    $nightsFilter = isset($_GET['nights']) ? $_GET['nights'] : '';
    $templateidFilter = isset($_GET['templateid']) ? $_GET['templateid'] : '';
    $countryFilter = isset($_GET['country']) ? $_GET['country'] : '';
    $seatersFilter = isset($_GET['seaters']) ? $_GET['seaters'] : '';
    $typeFilter = isset($_GET['type']) ? $_GET['type'] : '';
    $active = isset($_GET['active']) ? $_GET['active'] : 1;
    if($title != 'admin') {
        $active = 1;
    }
	
	// Get search query from the keyword search textarea
	$searchQuery = isset($_GET['query']) ? trim($_GET['query']) : '';
	//$searchWords = $searchQuery ? array_unique(preg_split('/\s+/', strtolower($searchQuery))) : [];   //search words separated by whitespace
	$searchWords = array_filter(array_map('trim', explode(',', strtolower($searchQuery))));             //search words separated by comma(,)
	$keywordMatches = array();

    // Base query
    $sql = "SELECT templateid, templatename, city, category, nights, seaters, type, preferred, used FROM tdu_templates WHERE active = $active ";

    // Apply filters
    if ($templateNameFilter) {
        $sql .= " AND templatename LIKE '%" . $conn->real_escape_string($templateNameFilter) . "%'";
    }
    if (!empty($cityFilter) && is_array($cityFilter)) {
        $cityConditions = [];
        foreach ($cityFilter as $city) {
            $cityConditions[] = "city LIKE '%" . $conn->real_escape_string(trim($city)) . "%'";
        }
        if (!empty($cityConditions)) {
            $sql .= " AND (" . implode(" OR ", $cityConditions) . ")";
        }
    }
    if ($categoryFilter) {
        $sql .= " AND category = '" . $conn->real_escape_string($categoryFilter) . "'";
    }
    if ($nightsFilter != '') {
        $sql .= " AND nights = " . (int)$nightsFilter;
    }
    if ($seatersFilter) {
        $sql .= " AND seaters = " . (int)$seatersFilter;
    }
    if ($templateidFilter) {
        $sql .= " AND templateid NOT IN (" . $templateidFilter . ")";
    }
    if ($countryFilter) {
        $sql .= " AND country = '" . $conn->real_escape_string($countryFilter) . "'";
    } else {
        $sql.= " AND country = 'Australia'";
    }

    $sql .= " ORDER BY preferred DESC, used DESC, num_cities ASC, templatename ASC";
    // if ($typeFilter) {
    //     $sql .= " AND type = '" . $conn->real_escape_string($typeFilter) . "'";
    // } else {
    //     $sql.= " AND type = 'Group'";
    // }
    
	//allRows will house the filtered rows
	$allRows = [];
	//if keyword search ain't empty, filter out whatever isn't relevant to the keywords
	if (!empty($searchWords)) 
	{		
		
		$keywordResult = $conn->query($sql);
             
        // Calculate relevance
        while ($row = mysqli_fetch_assoc($keywordResult)) 
		{
            $relevance = 0;
            $content = "";
            $content2 = "";
            $row['Matches'] = array();
            $base_sql2 = 
            "
				SELECT tp.auto_id, tp.day, p.productName, v.vendorName 
                FROM tdu_template_products tp
                LEFT JOIN tdu_products p ON tp.productid=p.productid
                LEFT JOIN tdu_vendors v ON p.vendorid = v.vendorid
                WHERE tp.templateid='$row[templateid]'
                ORDER BY tp.sequence_no ASC
            ";
                                    
            if (!empty($searchWords)) 
			{
                        
                // Remove LIMIT for full results
                $sql2 = preg_replace('/LIMIT \d+,\s*\d+/i', '', $base_sql2);
                $result2 = mysqli_query($conn, $sql2);
                //$allRows = [];
        
                // Calculate relevance
                while ($row2 = mysqli_fetch_assoc($result2)) 
				{
                    $content2 = implode(' ', array_map('strtolower', [
                        $row2['productName'],
                        $row2['vendorName']
                    ]));
							
                    $safe = false;
                    foreach ($searchWords as $word) 
					{
                        $relevance += substr_count($content2, $word);
                        if(substr_count($content2, $word)>0)
                        {
                            if(array_key_exists($word, $row['Matches'])){$row['Matches'][$word]++;}
                            else
							{
                                $row['Matches'][$word] = 1;
                                if($relevance>0){
                                if(array_key_exists($word, $keywordMatches)){$keywordMatches[$word]++;}
                                else{$keywordMatches[$word] = 1;}}     
                            }
                            $safe = true;
                        } 
                    }
                }
						
				//trim the rows with no matches or mismatch for keywords
				if(empty($row['Matches']) || !empty(array_diff($searchWords, array_keys($row['Matches']))))
				{
					if($relevance>0)
					{//var_dump($row['Matches']);
						$relevance-=10000;//foreach ($cityMatches as $cityMatch => &$cityCount) {$cityCount--;}
					}
				}
			}
                
			if ($relevance > 0) 
			{
				$row['relevance'] = $relevance;
				$allRows[] = $row;
			}
        }
    }else
	{
		$allRows = mysqli_fetch_all($conn->query($sql), MYSQLI_ASSOC);
	}

    $limit = 20;
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $page = max($page, 1);
    $offset = ($page - 1) * $limit;

    $sql_total = $sql;
    $total_result = mysqli_query($conn, $sql_total);
    $totalRecords = mysqli_num_rows($total_result);
    $totalPages = ceil($totalRecords / $limit);

    $sql .= " LIMIT $limit OFFSET $offset";

    $result = $conn->query($sql);
	/*
	// Pagination setup
    $results_per_page = 30; // Adjust as needed
    $current_page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $offset = ($current_page - 1) * $results_per_page;
            
    // Total count for pagination
    $total_result_query = mysqli_query($conn, $sql);
    $total_quotes = mysqli_num_rows($total_result_query);
    $total_pages = ceil($total_quotes / $results_per_page);
            
    $sql .= " LIMIT $offset, $results_per_page";
    $result = mysqli_query($conn, $sql);	
    */	
	//Manual Pagination
	$total_quotes = count($allRows);
    $totalPages = ceil($total_quotes / $limit);
    $offset = ($page - 1) * $limit;
    $paginatedRows = array_slice($allRows, $offset, $limit);    	
    
	?>

    <div style="display: flex; gap: 50px; justify-content: center; margin: 20px 10%;">
        <!-- Filters Section -->
        <div style="flex: 1; max-width: 25%; margin-top: 70px;">
            <form id="filterForm" method="GET" style="display: flex; flex-direction: column; gap: 10px;">
                <input type="hidden" name="opt" value="templates">
                <input type="hidden" name="templateid" value="<?= $_GET['templateid'] ?>">
                <input type="hidden" name="organisationid" value="<?= $_GET['organisationid'] ?>">
                <input type="hidden" name="contactid" value="<?= $_GET['contactid'] ?>">
                <input type="hidden" name="quoteid" value="<?= $_GET['quoteid'] ?>">

                <select name="country" id="country" style="width: 100%; height: 50px; font-size: 18px;">
                    <option value="Australia" <?= ($countryFilter === 'Australia') ? 'selected' : ''; ?>>Australia</option>
                    <option value="New Zealand" <?= ($countryFilter === 'New Zealand') ? 'selected' : ''; ?>>New Zealand</option>
                </select>

                <select name="category" id="category" style="width: 100%; height: 50px; font-size: 18px;">
                    <option value="" <?= ($categoryFilter == '') ? 'selected' : ''; ?>>Select Category</option>
                    <option value="SIC" <?= ($categoryFilter == 'SIC') ? 'selected' : ''; ?>>SIC</option>
                    <option value="Private" <?= ($categoryFilter == 'Private') ? 'selected' : ''; ?>>Private</option>
                    <option value="SIC+Private" <?= ($categoryFilter == 'SIC+Private') ? 'selected' : ''; ?>>SIC+Private</option>
                    <option value="Group" <?= ($categoryFilter == 'Group') ? 'selected' : ''; ?>>Group</option> <!-- New Group Option -->
                </select>

                <div id="cityFieldsContainer">
                    <?php foreach ($cityFilter as $city): ?>
                        <?php if (!empty($city)): ?>
                            <input type="text" name="cities[]" value="<?= htmlspecialchars($city); ?>" style="width: 100%; height: 30px; margin-top: 10px;">
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
                <button type="button" onclick="addCityField()" style="background-color: #334155; color: white; padding: 10px; border: none; border-radius: 4px; cursor: pointer;">City Filter</button>

                <label for="templatename">Template Name:</label>
                <input type="text" name="templatename" id="templatename" value="<?= htmlspecialchars($templateNameFilter); ?>" style="width: 100%; height: 30px;">

                <label for="nights">Number of Nights:</label>
                <select name="nights" id="nights" style="width: 100%; height: 30px;">
                    <option value=""></option>
                    <?php
                    $sql1 = "SELECT DISTINCT nights FROM tdu_templates ORDER BY nights ASC";
                    $result1 = $conn->query($sql1);

                    if ($result1 && $result1->num_rows > 0) {
                        while ($row1 = $result1->fetch_assoc()) {
                            $selected = ($row1['nights'] == $nightsFilter) ? 'selected' : '';
                            echo '<option value="' . htmlspecialchars($row1['nights']) . '" ' . $selected . '>' . htmlspecialchars($row1['nights']) . '</option>';
                        }
                    }
                    ?>
                </select>

                <label for="seaters">Number of Seaters:</label>
                <select name="seaters" id="seaters" style="width: 100%; height: 30px;">
                    <option value=""></option>
                    <?php
                    $sqlSeaters = "SELECT DISTINCT seaters FROM tdu_templates ORDER BY seaters ASC";
                    $resultSeaters = $conn->query($sqlSeaters);

                    if ($resultSeaters && $resultSeaters->num_rows > 0) {
                        while ($rowSeaters = $resultSeaters->fetch_assoc()) {
                            $selected = ($rowSeaters['seaters'] == $seatersFilter) ? 'selected' : '';
                            echo '<option value="' . htmlspecialchars($rowSeaters['seaters']) . '" ' . $selected . '>' . htmlspecialchars($rowSeaters['seaters']) . '</option>';
                        }
                    }
                    ?>
                </select>
				
				<label for="keywords">Product Keyword(s):</label>
				<input type="text" id="query" name="query" style="width: 100%; height: 30px" value="<?= htmlspecialchars($searchQuery) ?>"></input>

                <button type="submit" style="background-color: #334155; color: white; padding: 10px; border: none; border-radius: 4px; cursor: pointer;">Search</button>
            </form>
        </div>

        <!-- Results Table Section -->
        <div style="flex: 3;">
            <h1><?= $categoryFilter ?> Templates</h1>

            <!-- Added Templates Table -->
            <?php
            if (isset($_GET['templateid']) && $_GET['templateid'] != '') {
                ?>
                <table class="styled-table" style="width: 100%; border-collapse: collapse;">
                    <tr>
                        <th></th>
                        <th style="text-align: left;">Template Name</th>
                        <th style="text-align: left;">City</th>
                        <th style="text-align: center;">Nights</th>
                        <th style="text-align: center;">Category</th>
                        <th style="text-align: center;">Seaters</th>
                        <th></th>
                    </tr>
                    <?php
                    $selectedTemplateIds = explode(',', $_GET['templateid']);
                    $selectedTemplates = [];

                    // Fetch all selected templates from the database
                    foreach ($selectedTemplateIds as $templateId) {
                        $templateId = trim($templateId);
                        $sql2 = "SELECT * FROM tdu_templates WHERE templateid = '$templateId'";
                        $result2 = $conn->query($sql2);

                        if ($result2 && $result2->num_rows > 0) {
                            $selectedTemplates[] = $result2->fetch_assoc();
                        }
                    }

                    foreach ($selectedTemplates as $template) {
                        $cityData = explode(',', $template['city']);
                        $formattedCities = [];
                        foreach ($cityData as $city) {
                            list($name, $nights) = explode(':', $city);
                            $formattedCities[] = htmlspecialchars($name);
                        }
                        ?>
                        <tr style="background-color: lightgreen;">
                            <td>selected</td>
                            <td style="text-align: left; width: 35%;">
                                <i class="fa-solid fa-circle-info" onclick="openInfoModal('<?= urlencode($template['templateid']); ?>')"></i> 
                                <?= htmlspecialchars($template['templatename']); ?>
                            </td>
                            <td style="text-align: left;"><?= implode(', ', $formattedCities); ?></td>
                            <td style="text-align: center;"><?= htmlspecialchars($template['nights']); ?></td>
                            <td style="text-align: center;"><?= htmlspecialchars($template['category']); ?></td>
                            <td style="text-align: center;"><?= htmlspecialchars($template['seaters']); ?></td>
                            <td>
                                <button type='button' onclick="removeTemplate('<?= urlencode($template['templateid']); ?>')" style="background-color: red; color: white;"><i class="fa-solid fa-trash-can"></i></button>
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </table>
                <?php
                if (isset($_GET['organisationid']) && $_GET['organisationid'] != '') {
                    ?>
                    <button type='button' style="float: right; margin-bottom: 20px;" onclick="window.location.href='?opt=create-fit&organisationid=<?= urlencode($_GET['organisationid']); ?>&contactid=<?= urlencode($_GET['contactid']); ?>&templateid=<?= urlencode($_GET['templateid']); ?>&country=<?= urlencode($_GET['country'] ?? 'Australia'); ?>&type=<?= urlencode($typeFilter != '' ? $typeFilter : 'Group'); ?>'">Create Quote</button>
                    <?php
                }
                else if (isset($_GET['quoteid']) && $_GET['quoteid'] != '') {
                    $new_quoteid = $_GET['quoteid'];
                    $templateid = $_GET['templateid'];
                    $sql_followup = "SELECT quote_no FROM vtiger_quotes WHERE quoteid='$new_quoteid';";
                    $result_followup = mysqli_query($conn, $sql_followup);
                    $new_quote_no = mysqli_fetch_assoc($result_followup)['quote_no'];
                    ?>
                    <button type="button" style="float: right; margin-bottom: 20px;" id="sendRequestsButton">Add Template to <?= $new_quote_no ?></button>
                    <script>
                        document.getElementById('sendRequestsButton').addEventListener('click', function() {
                            var templateIds = '<?php echo $templateid; ?>'.split(',').map(id => id.trim()); // Split and trim template IDs
                            var currentIndex = 0;

                            function sendAjaxRequest() {
                                if (currentIndex >= templateIds.length) {
                                    // Redirect after all requests are complete
                                    window.location.href = '?opt=summary&quoteNumber=<?php echo $new_quote_no; ?>';
                                    return;
                                }

                                var templateId = templateIds[currentIndex];
                                var xhr = new XMLHttpRequest();
                                xhr.open('POST', 'ajax_quote_template.php', true);
                                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                                xhr.onreadystatechange = function() {
                                    if (xhr.readyState == 4 && xhr.status == 200) {
                                        console.log('AJAX response for templateId ' + templateId + ':', xhr.responseText);
                                        currentIndex++; // Move to the next template ID
                                        sendAjaxRequest(); // Call the function again for the next ID
                                    }
                                };
                                xhr.send('quoteid=<?php echo $new_quoteid; ?>&templateid=' + encodeURIComponent(templateId));
                            }

                            sendAjaxRequest(); // Start the first AJAX call
                        });
                    </script>
                    <?php
                }
            }
            ?>

            <!-- Templates Table Section -->
            <table class="styled-table" style="width: 100%; border-collapse: collapse;">
                <thead>
                    <tr>
                        <th></th>
                        <th style="text-align: left;">Template Name</th>
                        <th style="text-align: left;">City</th>
                        <th style="text-align: center;">Nights</th>
                        <th style="text-align: center;">Category</th>
                        <th style="text-align: center;">Seaters</th>
                        <th>
                            <?php if ($title == 'admin' && !(isset($_GET['quoteid']) && $_GET['quoteid'] != '') && !(isset($_GET['organisationid']) && $_GET['organisationid'] != '')): ?>
                                <?php
                                $queryParams = $_GET; 
                                $queryParams['active'] = ($active == 1) ? 0 : 1; 
                                $queryString = http_build_query($queryParams);
                                ?>
                                <button type="button" onclick="window.location.href='?<?php echo $queryString; ?>'" 
                                    style="background-color: <?php echo ($active == 1) ? 'red' : 'green'; ?>;">
                                    <?php echo ($active == 1) ? 'Inactive' : 'Active'; ?>
                                </button>
                            <?php endif; ?>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result->num_rows > 0): ?>
                        <?php foreach ($paginatedRows as $row){ ?>
                            <tr id="row-<?= $row['templateid']; ?>">
                                <td>
                                    <?php if ((isset($_GET['quoteid']) && $_GET['quoteid'] != '') || (isset($_GET['organisationid']) && $_GET['organisationid'] != '')): ?>
                                        <button type="button" onclick="selectTemplate('<?= urlencode($row['templateid']); ?>')">Select</button>
                                    <?php endif; ?>
                                    <?php if ($title == 'admin' && !(isset($_GET['quoteid']) && $_GET['quoteid'] != '') && !(isset($_GET['organisationid']) && $_GET['organisationid'] != '')): ?>
                                        <input type="checkbox" class="templateCheckbox" data-id="<?= urlencode($row['templateid']); ?>">
                                    <?php endif; ?>
                                </td>
                                <td style="text-align: left; width: 35%;">
                                    <i class="fa-solid fa-circle-info" onclick="openInfoModal('<?= urlencode($row['templateid']); ?>')"></i> 
                                    <?= $row['preferred'] == 1 ? '<i class="fa-solid fa-heart" style="color: red;"></i>' : '' ?> 
                                    <?= ($row['preferred'] == 0 && $row['used'] > 5) ? '<i class="fa-solid fa-fire" style="color: red;"></i>' : '' ?>
                                    <?php if ((isset($_GET['quoteid']) && $_GET['quoteid'] != '') || (isset($_GET['organisationid']) && $_GET['organisationid'] != '')): ?>
                                        <?= htmlspecialchars($row['templatename']); ?>
                                    <?php else: ?>
                                        <a href="quote.php?opt=template-details&id=<?= urlencode($row['templateid']); ?>">
                                            <?= htmlspecialchars($row['templatename']); ?>
                                        </a>
                                    <?php endif;?>
                                </td>
                                <td style="text-align: left;">
                                    <?php
                                        $cityData = explode(',', $row['city']);
                                        $formattedCities = [];
                                        foreach ($cityData as $city) {
                                            list($name, $nights) = explode(':', $city);
                                            $formattedCities[] = htmlspecialchars($name);
                                        }
                                        echo implode(', ', $formattedCities);
                                    ?>
                                </td>
                                <td style="text-align: center;"><?= htmlspecialchars($row['nights']); ?></td>
                                <td style="text-align: center;" class="category"><?= htmlspecialchars($row['category']); ?></td>
                                <td style="text-align: center;"><?= htmlspecialchars($row['seaters']); ?></td>
                                <td>
                                    <?php if ($title == 'admin' && !(isset($_GET['quoteid']) && $_GET['quoteid'] != '') && !(isset($_GET['organisationid']) && $_GET['organisationid'] != '')): ?>
                                        <button class="duplicate-btn" data-id="<?= $row['templateid']; ?>" style="background-color: orange; color: white;">
                                            <i class="fa-solid fa-copy"></i>
                                        </button>
                                        <button class="delete-btn" data-id="<?= $row['templateid']; ?>" style="background-color: <?= $active == 0 ? 'green' : 'red' ?>; color: white;">
                                            <?php
                                            if ($active == 0) {
                                                echo '<i class="fa-solid fa-rotate-left"></i>';
                                            } else {
                                                echo '<i class="fa-solid fa-trash-can"></i>';
                                            }
                                            ?>
                                        </button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php } ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="8" style="text-align: left;">No results found</td>
                        </tr>
                    <?php endif; ?>
                    <?php if ($title == 'admin' && !(isset($_GET['quoteid']) && $_GET['quoteid'] != '') && !(isset($_GET['organisationid']) && $_GET['organisationid'] != '')): ?>
                        <tr>
                            <td><input type="checkbox" id="selectAll"></td>
                            <td colspan="7" style="text-align: left;">
                                <button type="button" id="editCategoryBtn">Edit Selected Category</button>
                                <button type="button" id="editTypeBtn" style="display: none;">Edit Selected Type</button>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <script>
                document.addEventListener("DOMContentLoaded", function() {
                    document.querySelectorAll(".delete-btn").forEach(button => {
                        button.addEventListener("click", function() {
                            let templateId = this.getAttribute("data-id");
                            if (confirm("Are you sure you want to <?= $active == 1 ? 'delete' : 'recover' ?> this template?")) {
                                fetch("ajax_del_template.php", {
                                    method: "POST",
                                    headers: { "Content-Type": "application/json" },
                                    body: JSON.stringify({ template_id: templateId })
                                })
                                .then(response => response.json())
                                .then(data => {
                                    if (data.success) {
                                        document.getElementById("row-" + templateId).remove();
                                    } else {
                                        alert("Error: " + data.message);
                                    }
                                })
                                .catch(error => console.error("Error:", error));
                            }
                        });
                    });
                });
                document.addEventListener("DOMContentLoaded", function() {
                    document.querySelectorAll(".duplicate-btn").forEach(button => {
                        button.addEventListener("click", function() {
                            let templateId = this.getAttribute("data-id");
                            if (confirm("Are you sure you want to duplicate this template?")) {
                                fetch("ajax_duplicate_template.php", {
                                    method: "POST",
                                    headers: { "Content-Type": "application/json" },
                                    body: JSON.stringify({ template_id: templateId })
                                })
                                .then(response => response.json())
                                .then(data => {
                                    if (data.success) {
                                        alert("Template duplicated successfully!");
                                        location.reload(); // Reload page to reflect changes
                                    } else {
                                        alert("Error: " + data.message);
                                    }
                                })
                                .catch(error => console.error("Error:", error));
                            }
                        });
                    });
                });
            </script>

            <!-- Modal for displaying template product details -->
            <div id="infoModal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 75%; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto;">
                <h3>Template Details <button type="button" id="closeInfoModalBtn" style="float: right;"><i class="fa-solid fa-xmark"></i></button></h3>
                <div id="infoContent"></div>
            </div>
            <script>
                // Open the modal and load data via AJAX
                function openInfoModal(templateId) {
                    // Create an AJAX request to fetch the product and vendor details
                    const xhr = new XMLHttpRequest();
                    xhr.open('GET', 'ajax_get_template_info.php?templateid=' + encodeURIComponent(templateId), true);
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState === 4 && xhr.status === 200) {
                            // Populate the modal with the response data
                            document.getElementById('infoContent').innerHTML = xhr.responseText;
                            // Display the modal
                            document.getElementById('infoModal').style.display = 'block';
                        }
                    };
                    xhr.send();
                }

                // Close the modal
                document.getElementById('closeInfoModalBtn').addEventListener('click', function () {
                    document.getElementById('infoModal').style.display = 'none';
                });
            </script>

            <!-- Modal -->
            <div id="editCategoryModal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 50%; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto;">
                <label for="newCategory">New Category:</label>
                <select id="newCategory">
                    <option value="SIC">SIC</option>
                    <option value="Private">Private</option>
                    <option value="SIC+Private">SIC+Private</option>
                    <option value="Group">Group</option>
                </select>
                <button type="button" id="saveCategoryBtn">Save</button>
                <button type="button" id="closeModalBtn">Close</button>
            </div>
            <script>
                // Select All Checkbox functionality
                document.getElementById('selectAll').addEventListener('change', function () {
                    const checkboxes = document.querySelectorAll('.templateCheckbox');
                    checkboxes.forEach(checkbox => checkbox.checked = this.checked);
                });

                // Show the modal for editing category
                document.getElementById('editCategoryBtn').addEventListener('click', function () {
                    const selectedTemplates = [];
                    document.querySelectorAll('.templateCheckbox:checked').forEach(checkbox => {
                        selectedTemplates.push(checkbox.getAttribute('data-id'));
                    });

                    if (selectedTemplates.length === 0) {
                        alert('Please select at least one template.');
                        return;
                    }

                    // Open the modal
                    document.getElementById('editCategoryModal').style.display = 'block';
                    window.selectedTemplates = selectedTemplates;
                });

                // Save the new category via AJAX
                document.getElementById('saveCategoryBtn').addEventListener('click', function () {
                    const newCategory = document.getElementById('newCategory').value;

                    if (!newCategory) {
                        alert('Please enter a category.');
                        return;
                    }

                    // Send AJAX request
                    const xhr = new XMLHttpRequest();
                    xhr.open('POST', 'ajax_update_template_category.php', true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState === 4 && xhr.status === 200) {
                            alert('Category updated successfully.');
                            // Update the category in the table
                            selectedTemplates.forEach(templateId => {
                                const row = document.querySelector(`.templateCheckbox[data-id="${templateId}"]`).closest('tr');
                                row.querySelector('.category').innerText = newCategory;
                            });
                            // Close the modal
                            document.getElementById('editCategoryModal').style.display = 'none';
                        }
                    };
                    xhr.send('templateIds=' + encodeURIComponent(selectedTemplates.join(',')) + '&newCategory=' + encodeURIComponent(newCategory));
                });

                // Close the modal
                document.getElementById('closeModalBtn').addEventListener('click', function () {
                    document.getElementById('editCategoryModal').style.display = 'none';
                });
            </script>

            <div id="editTypeModal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 50%; background: white; border: 1px solid #ccc; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); padding: 20px; z-index: 1000; max-height: 90vh; overflow-y: auto;">
                <label for="newType">New Type:</label>
                <select id="newType">
                    <option value="Group">Group</option>
                    <option value="FIT">FIT</option>
                </select>
                <button type="button" id="saveTypeBtn">Save</button>
                <button type="button" id="closeTypeModalBtn">Close</button>
            </div>
            <script>
                // Show the modal for editing type
                document.getElementById('editTypeBtn').addEventListener('click', function () {
                    const selectedTemplates = [];
                    document.querySelectorAll('.templateCheckbox:checked').forEach(checkbox => {
                        selectedTemplates.push(checkbox.getAttribute('data-id'));
                    });

                    if (selectedTemplates.length === 0) {
                        alert('Please select at least one template.');
                        return;
                    }

                    // Open the modal
                    document.getElementById('editTypeModal').style.display = 'block';
                    window.selectedTemplates = selectedTemplates;
                });

                // Save the new type via AJAX
                document.getElementById('saveTypeBtn').addEventListener('click', function () {
                    const newType = document.getElementById('newType').value;

                    if (!newType) {
                        alert('Please select a type.');
                        return;
                    }

                    // Send AJAX request
                    const xhr = new XMLHttpRequest();
                    xhr.open('POST', 'ajax_update_template_type.php', true);
                    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState === 4 && xhr.status === 200) {
                            alert('Type updated successfully.');
                            window.location.reload();
                        }
                    };
                    xhr.send('templateIds=' + encodeURIComponent(selectedTemplates.join(',')) + '&newType=' + encodeURIComponent(newType));
                });

                // Close the modal
                document.getElementById('closeTypeModalBtn').addEventListener('click', function () {
                    document.getElementById('editTypeModal').style.display = 'none';
                });
            </script>

            <div class="pagination" style="margin-top: 0;">
                <div>
                    <?php if ($page > 1): ?>
                        <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
                    <?php endif; ?>

                    <?php
                    $max_pages = min($totalPages, $page + 2);
                    for ($i = $page; $i <= $max_pages; $i++): ?>
                        <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" <?php if ($i == $page) echo 'style="background-color: #334155; color: white;"'; ?>>
                            <?php echo $i; ?>
                        </a>
                    <?php endfor; ?>

                    <?php if ($page < $totalPages): ?>
                        <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
                    <?php endif; ?>
                </div>

                <form method="GET" action="" style="display:inline;">
                    <?php
                    foreach ($_GET as $key => $value) {
                        if (is_array($value)) {
                            foreach ($value as $subValue) {
                                echo '<input type="hidden" name="' . htmlspecialchars($key) . '[]" value="' . htmlspecialchars($subValue) . '">';
                            }
                        } else {
                            echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                        }
                    }
                    ?>
                    <input type="number" name="page" min="1" max="<?php echo $totalPages; ?>" value="<?php echo $page; ?>" style="width:75px;"> / <?php echo $totalPages; ?>
                    <button type="submit">Jump</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        function selectTemplate(templateId) {
            let urlParams = new URLSearchParams(window.location.search);
            let templateIds = urlParams.get('templateid') ? urlParams.get('templateid').split(',') : [];

            // If templateId is not already in the list, add it
            if (!templateIds.includes(templateId)) {
                templateIds.push(templateId);
            }

            // Update the URL with the new templateid list
            urlParams.set('templateid', templateIds.join(','));
            window.location.search = urlParams.toString();
        }

        function removeTemplate(templateId) {
            let urlParams = new URLSearchParams(window.location.search);
            let templateIds = urlParams.get('templateid') ? urlParams.get('templateid').split(',') : [];

            // Remove the templateId from the list
            templateIds = templateIds.filter(id => id !== templateId);

            // Update the URL with the new templateid list
            if (templateIds.length > 0) {
                urlParams.set('templateid', templateIds.join(','));
            } else {
                urlParams.delete('templateid');
            }

            window.location.search = urlParams.toString();
        }
    </script>

    <script>
        // Function to add a new city input field
        function addCityField() {
            var newCityField = document.createElement("input");
            newCityField.type = "text";
            newCityField.name = "cities[]";
            newCityField.style.width = "100%";
            newCityField.style.height = "30px";
            newCityField.style.marginTop = "10px";

            // Append the new city input field
            document.getElementById("cityFieldsContainer").appendChild(newCityField);
        }

        document.addEventListener("DOMContentLoaded", function () {
            const form = document.getElementById("filterForm");

            if (form) {
                form.querySelectorAll("input, select, textarea").forEach(field => {
                    field.addEventListener("change", function () {
                        form.submit();
                    });
                });
            }
        });
    </script>

    <style>
        .pagination {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 20px 0;
        }
        
        .pagination div {
            display: flex;
            align-items: center;
        }
        
        .pagination a {
            text-decoration: none;
            padding: 8px 12px;
            margin: 0 5px;
            border: 1px solid #334155;
            color: #334155;
            border-radius: 4px;
            transition: background-color 0.3s, color 0.3s;
        }
        
        .pagination a:hover {
            background-color: #334155;
            color: white;
        }
        
        .pagination input[type="number"] {
            width: 50px;
            padding: 10px;
            margin-left: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        
        .pagination button {
            padding: 10px 10px;
            margin-left: 5px;
            border: none;
            border-radius: 4px;
            background-color: #334155;
            color: white;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        
        .pagination button:hover {
            background-color: #334155;
        }
        
        tr:nth-child(odd) {
            background-color: #f9f9f9;
        }

        .styled-table td input[type="text"] {
            width: 100%;
            height: 30px;
            margin: 0;
        }

        .styled-table td {
            width: 12%;
        }
    </style>
    <?php
}
else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'template-details') {
    include "header.php";

    $template_id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
    if ($template_id > 0) {
        $sql = "SELECT templatename, category, country, type, seaters, preferred, nights, 
                        start_month, end_month, replace_templateid 
                FROM tdu_templates WHERE templateid = $template_id";
        $result = $conn->query($sql);

        if ($result->num_rows > 0) {
            $template = $result->fetch_assoc();
        } else {
            echo "Template not found.";
            exit;
        }
    }
    ?>

    <div style="padding: 20px; background-color: #c5c5c5;">
        <div style="display: flex; justify-content: space-between; margin: 0;">
            <div style="flex: 2; padding-right: 20px;">
                <h1 style="text-align: left;">
                    <a style="margin: 0 15px;" href="javascript:history.back()"><i class="fas fa-arrow-left"></i></a>
                    <span id="name-display"><?php echo htmlspecialchars($template['templatename']); ?></span>
                    <input id="name-edit" style="display:none;" type="text" value="<?php echo htmlspecialchars($template['templatename']); ?>">
                    <button type="button" id="editBtn" onclick="toggleEditMode()"><i class="fa-solid fa-pen-to-square"></i></button>
                </h1>
                <div style="margin-top: 20px; text-align: right;">
                    <button id="saveBtn" style="display:none;" onclick="saveChanges()">Save</button>
                    <button id="cancelBtn" style="display:none;" onclick="cancelEdit()">Cancel</button>
                </div>
            </div>
            <div style="flex: 2; padding-right: 20px;">
                <h3>Template Information</h3>
                <p>Category:
                    <span id="category-display"><?php echo htmlspecialchars($template['category']); ?></span>
                    <select id="category-edit" style="display:none; width: 100%;">
                        <option value="SIC" <?php echo ($template['category'] == 'SIC') ? 'selected' : ''; ?>>SIC</option>
                        <option value="Private" <?php echo ($template['category'] == 'Private') ? 'selected' : ''; ?>>Private</option>
                        <option value="SIC+Private" <?php echo ($template['category'] == 'SIC+Private') ? 'selected' : ''; ?>>SIC+Private</option>
                        <option value="Group" <?php echo ($template['category'] == 'Group') ? 'selected' : ''; ?>>Group</option>
                    </select>
                </p>
                <p>Country:
                    <span id="country-display"><?php echo htmlspecialchars($template['country']); ?></span>
                    <select id="country-edit" style="display:none; width: 100%;">
                        <option value="Australia" <?php echo ($template['country'] == 'Australia') ? 'selected' : ''; ?>>Australia</option>
                        <option value="New Zealand" <?php echo ($template['country'] == 'New Zealand') ? 'selected' : ''; ?>>New Zealand</option>
                    </select>
                </p>
                <p>Seaters:
                    <span id="seaters-display"><?php echo htmlspecialchars($template['seaters']); ?></span>
                    <input id="seaters-edit" type="number" style="display:none; width: 100%;" value="<?php echo htmlspecialchars($template['seaters']); ?>" min="1">
                </p>
                <p>Nights:
                    <span id="nights-display"><?php echo htmlspecialchars($template['nights']); ?></span>
                    <input id="nights-edit" type="number" style="display:none; width: 100%;" value="<?php echo htmlspecialchars($template['nights']); ?>" min="1">
                </p>
                <p>Preferred:
                    <span id="preferred-display">
                        <?php echo ($template['preferred'] == 1) ? 'Yes' : 'No'; ?>
                    </span>
                    <select id="preferred-edit" style="display:none; width: 100%;">
                        <option value="1" <?php echo ($template['preferred'] == 1) ? 'selected' : ''; ?>>Yes</option>
                        <option value="0" <?php echo ($template['preferred'] == 0) ? 'selected' : ''; ?>>No</option>
                    </select>
                </p>
            </div>
            <div style="flex: 2; padding-right: 20px;">
                <h3>Availability</h3>
                <p>
                    <span id="duration-display">
                        <?php echo ($template['start_month'] == 0 && $template['end_month'] == 0) ? 'Whole year' : 'Limited'; ?>
                    </span>
                    <select id="duration-type" style="display: none; width: 100%;" onchange="toggleMonthFields()">
                        <option value="whole" <?php echo ($template['start_month'] == 0 && $template['end_month'] == 0) ? 'selected' : ''; ?>>Whole year</option>
                        <option value="limited" <?php echo ($template['start_month'] > 0 || $template['end_month'] > 0) ? 'selected' : ''; ?>>Limited</option>
                    </select>
                </p>

                <div id="limited-fields" style="display: <?php echo ($template['start_month'] > 0 || $template['end_month'] > 0) ? 'block' : 'none'; ?>;">
                    <?php 
                        $months = [
                            1 => "January", 2 => "February", 3 => "March", 4 => "April",
                            5 => "May", 6 => "June", 7 => "July", 8 => "August",
                            9 => "September", 10 => "October", 11 => "November", 12 => "December"
                        ];
                    ?>
                    <p>
                        <span id="start-month-display"><?php echo $months[$template['start_month']] ?? '-'; ?></span>
                        <select id="start-month-edit" style="display:none; width: 100%;">
                            <?php 
                            foreach ($months as $num => $name) {
                                $selected = ($template['start_month'] == $num) ? 'selected' : '';
                                echo "<option value=\"$num\" $selected>$name</option>";
                            }
                            ?>
                        </select>
                        to 
                        <span id="end-month-display"><?php echo $months[$template['end_month']] ?? '-'; ?></span>
                        <select id="end-month-edit" style="display:none; width: 100%;">
                            <?php 
                            foreach ($months as $num => $name) {
                                $selected = ($template['end_month'] == $num) ? 'selected' : '';
                                echo "<option value=\"$num\" $selected>$name</option>";
                            }
                            ?>
                        </select>
                    </p>
                    <p>Replace Template ID:
                        <span id="replace-templateid-display"><?php echo (int) $template['replace_templateid']; ?></span>
                        <input id="replace-templateid-edit" type="number" min="0" style="display:none; width: 100%;" value="<?php echo (int) $template['replace_templateid']; ?>">
                    </p>
                </div>
            </div>
            <div style="flex: 2; padding-right: 20px;"></div>
        </div>
    </div>

    <script>
        function cancelEdit() {
            document.querySelectorAll('span[id$="-display"]').forEach(el => el.style.display = 'inline');
            document.querySelectorAll('input[id$="-edit"], select[id$="-edit"], #duration-type').forEach(el => el.style.display = 'none');

            document.getElementById('editBtn').style.display = 'inline';
            document.getElementById('saveBtn').style.display = 'none';
            document.getElementById('cancelBtn').style.display = 'none';
        }

        function toggleEditMode() {
            document.querySelectorAll('span[id$="-display"]').forEach(el => el.style.display = 'none');
            document.querySelectorAll('input[id$="-edit"], select[id$="-edit"], #duration-type').forEach(el => el.style.display = 'inline');

            document.getElementById('editBtn').style.display = 'none';
            document.getElementById('saveBtn').style.display = 'inline';
            document.getElementById('cancelBtn').style.display = 'inline';
        }

        function toggleMonthFields() {
            const durationType = document.getElementById('duration-type').value;
            document.getElementById('limited-fields').style.display = durationType === 'limited' ? 'block' : 'none';
        }

        function saveChanges() {
            const durationType = document.getElementById('duration-type').value;
            const startMonth = (durationType === 'limited') ? parseInt(document.getElementById('start-month-edit').value) || 0 : 0;
            const endMonth = (durationType === 'limited') ? parseInt(document.getElementById('end-month-edit').value) || 0 : 0;
            const replaceTemplateId = (durationType === 'limited') ? parseInt(document.getElementById('replace-templateid-edit').value) || 0 : 0;

            const data = {
                templatename: document.getElementById('name-edit').value,
                category: document.getElementById('category-edit').value,
                country: document.getElementById('country-edit').value,
                seaters: document.getElementById('seaters-edit').value,
                preferred: document.getElementById('preferred-edit').value,
                nights: document.getElementById('nights-edit').value,
                start_month: startMonth,
                end_month: endMonth,
                replace_templateid: replaceTemplateId,
                template_id: <?php echo $template_id; ?>
            };

            fetch('ajax_update_template.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data),
            })
            .then(response => response.json())
            .then(result => {
                if (result.success) {
                    window.location.reload();
                } else {
                    alert(result.message);
                }
            })
            .catch(error => console.error('Error:', error));
        }
    </script>

    <div>
        <button type="button" style="padding: 10px 20px;" onclick="showModal()">Add New Product</button>
        <button type="button" style="padding: 10px 20px;" onclick="showEventModal()">Add New Event</button>
        <button type="button" style="padding: 10px 20px;" onclick="showCopyEventModal()">Import Events</button>

        <p>Template ID: <?= $template_id ?></p>

        <table class="styled-table" style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr>
                    <th style="text-align: center;">Show</th>
                    <th style="text-align: center;">Day</th>
                    <th style="text-align: left; width: 200px;">Time</th>
                    <th style="text-align: left;">Product Name</th>
                    <th style="text-align: left;">Vendor Name</th>
                    <th style="text-align: left;">Actions</th>
                </tr>
            </thead>
            <tbody id="sortable">
                <?php
                $sql = "SELECT tp.auto_id, tp.day, tp.productid, tp.event_time, p.productName, v.vendorName, tp.event_name, tp.show_status 
                        FROM tdu_template_products tp
                        LEFT JOIN tdu_products p ON tp.productid=p.productid
                        LEFT JOIN tdu_vendors v ON p.vendorid = v.vendorid
                        WHERE tp.templateid='$template_id'
                        ORDER BY tp.sequence_no ASC";
                $result = $conn->query($sql);

                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        $eventBackground = "";
                        if($row['event_name'] != '') {
                            $eventBackground = "background: lightgrey;";
                        }
                        echo "<tr id='product_row_" . $row['auto_id'] . "' data-id='" . $row['auto_id'] . "' draggable='true' style='$eventBackground'>";

                        $checked = ($row['show_status'] == 1) ? 'checked' : '';
                        if ($row['productid'] != 0) {
                            echo "<td style='text-align: center;'>
                                    <input type='checkbox' class='show-checkbox' data-id='" . $row['auto_id'] . "' $checked>
                                </td>";
                        } else {
                            echo "<td></td>";
                        }

                        echo "<td style='text-align: center;' contenteditable='true' 
                                class='editable-day' data-id='" . $row['auto_id'] . "'>" . 
                                htmlspecialchars($row['day']) . "</td>";
                        echo "<td style='text-align: left;'>
                                <input type='text' style='border: none; $eventBackground' class='event-time' data-id='" . $row['auto_id'] . "' 
                                value='" . htmlspecialchars($row['event_time']) . "'>
                            </td>";
                        if($row['event_name'] != '') {
                            echo "<td style='text-align: left;'><i class='fa-brands fa-creative-commons-nc'></i> " . htmlspecialchars($row['event_name']) . "</td>";
                        } else {
                            echo "<td style='text-align: left;'>" . htmlspecialchars($row['productName']) . "</td>";
                        }
                        echo "<td style='text-align: left;'>" . htmlspecialchars($row['vendorName']) . "</td>";
                        echo "<td style='text-align: left;'>
                                <button onclick='deleteRow(" . $row['auto_id'] . ")' 
                                        style='color: white; border: none; background-color: red;'>
                                    <i class='fa-solid fa-trash-can'></i>
                                </button>
                            </td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='6' style='text-align: left;'>No records found</td></tr>";
                }
                ?>
            </tbody>
        </table>

        <!-- Save button -->
        <button id="saveChanges" style="margin: 0 20px; padding: 8px 12px;">Save Changes</button>

        <script>
            let draggedRow;

            function handleDragStart(event) {
                draggedRow = event.target;
                event.dataTransfer.effectAllowed = 'move';
                event.target.style.opacity = '0.5'; // Visual feedback
            }

            function handleDragOver(event) {
                event.preventDefault();
                event.dataTransfer.dropEffect = 'move';

                // Auto-scroll
                const scrollThreshold = 50;
                const scrollSpeed = 20;
                if (event.clientY < scrollThreshold) {
                    window.scrollBy(0, -scrollSpeed);
                } else if (window.innerHeight - event.clientY < scrollThreshold) {
                    window.scrollBy(0, scrollSpeed);
                }
            }

            function handleDrop(event) {
                event.preventDefault();
                if (draggedRow && draggedRow !== event.target.closest('tr')) {
                    const targetRow = event.target.closest('tr');
                    const tbody = targetRow.parentNode;

                    // Positioning logic
                    const rect = targetRow.getBoundingClientRect();
                    const offsetY = event.clientY - rect.top;
                    if (offsetY < rect.height / 2) {
                        tbody.insertBefore(draggedRow, targetRow);
                    } else {
                        tbody.insertBefore(draggedRow, targetRow.nextSibling);
                    }

                    draggedRow.style.opacity = '1';
                }
            }

            document.addEventListener('DOMContentLoaded', function () {
                document.querySelectorAll('tr[draggable="true"]').forEach(row => {
                    row.addEventListener('dragstart', handleDragStart);
                    row.addEventListener('dragover', handleDragOver);
                    row.addEventListener('drop', handleDrop);
                });

                // Save button event
                $("#saveChanges").click(function () {
                    let updatedData = [];

                    $("#sortable tr").each(function (index) {
                        let auto_id = $(this).attr("data-id");
                        let dayValue = $(this).find(".editable-day").text().trim();
                        let eventTimeValue = $(this).find(".event-time").val().trim();
                        let isChecked = $(this).find(".show-checkbox").is(":checked") ? 1 : 0;

                        updatedData.push({ 
                            auto_id: auto_id, 
                            day: dayValue, 
                            event_time: eventTimeValue, 
                            show_status: isChecked, 
                            sequence: index 
                        });
                    });

                    $.ajax({
                        url: 'ajax_save_template_changes.php',
                        type: 'POST',
                        contentType: 'application/json',
                        data: JSON.stringify({ updates: updatedData }),
                        success: function (response) {
                            if (response.trim() === "Success") {
                                alert("Changes saved successfully!");
                            } else {
                                alert("Error saving changes: " + response);
                            }
                        }
                    });
                });
            });
        </script>
    </div>

    <!-- Include jQuery and Flatpickr -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        $(document).ready(function () {
            // Ensure Flatpickr is initialized on all event-time inputs
            $(".event-time").each(function () {
                flatpickr(this, {
                    enableTime: true,
                    noCalendar: true,
                    time_24hr: true
                });
            });
        });
    </script>

    <!-- Event Modal -->
    <div id="eventModal" class="modal" style="display: none; position: fixed; z-index: 1; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.4);">
        <div class="modal-content" style="background-color: #fff; margin: 10% auto; padding: 20px; border: 1px solid #888; width: 300px;">
            <span class="close" onclick="closeEventModal()" style="float: right; cursor: pointer;">&times;</span>
            <h3>Add New Event</h3>
            <input type="text" id="eventName" placeholder="Enter event name" style="width: 100%; padding: 8px;">
            <br><br>
            <button onclick="saveEvent()" style="padding: 8px 12px;">Save Event</button>
        </div>
    </div>
    <script>
        function showEventModal() {
            document.getElementById("eventModal").style.display = "block";
        }

        function closeEventModal() {
            document.getElementById("eventModal").style.display = "none";
        }

        function saveEvent() {
            let eventName = document.getElementById("eventName").value.trim();
            var templateId = '<?php echo $_GET['id']; ?>'; // Get template ID from URL

            if (eventName === "") {
                alert("Please enter an event name.");
                return;
            }

            $.ajax({
                url: 'ajax_template_save_event.php',
                type: 'POST',
                data: { templateid: templateId, event_name: eventName },
                success: function(response) {
                    alert(response);
                    location.reload();
                }
            });
        }
    </script>

    <!-- Event Loading Modal -->
    <div id="copyEventModal" class="modal" style="display: none; position: fixed; z-index: 1; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.4);">
        <div class="modal-content" style="background-color: #fff; margin: 10% auto; padding: 20px; border: 1px solid #888; width: 300px;">
            <span class="close" onclick="closeCopyEventModal()" style="float: right; cursor: pointer;">&times;</span>
            <h3>Import Events</h3>
            <input type="text" id="copyTemplateId" placeholder="Enter template ID ..." style="width: 100%; padding: 8px;">
            <br><br>
            <input type="number" id="templateDay" placeholder="Enter day you want to copy from" style="width: 100%; padding: 8px;">
            <br><br>
            <input type="number" id="targetDay" placeholder="Enter day you want to copy to" style="width: 100%; padding: 8px;">
            <br><br>
            <button onclick="copyEvent()" style="padding: 8px 12px;">Import</button>
        </div>
    </div>
    <script>
        function showCopyEventModal() {
            document.getElementById("copyEventModal").style.display = "block";
        }

        function closeCopyEventModal() {
            document.getElementById("copyEventModal").style.display = "none";
        }

        function copyEvent() {
            let copyTemplateId = document.getElementById("copyTemplateId").value.trim();
            let templateDay = document.getElementById("templateDay").value.trim();
            let targetDay = document.getElementById("targetDay").value.trim();
            var templateId = '<?php echo $_GET['id']; ?>'; // Get template ID from URL

            if (copyTemplateId === "") {
                alert("Please enter a template ID to copy.");
                return;
            }

            if (templateDay === "") {
                alert("Please enter the template day.");
                return;
            }

            if (targetDay === "") {
                alert("Please enter the target day.");
                return;
            }

            $.ajax({
                url: 'ajax_template_copy_event.php',
                type: 'POST',
                data: { 
                    templateid: templateId,
                    copy_templateid: copyTemplateId,
                    template_day: templateDay,
                    target_day: targetDay
                },
                success: function(response) {
                    alert(response);
                    location.reload();
                }
            });
        }
    </script>

    <!-- Modal for adding a new product -->
    <div id="productModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.5);">
        <div style="background-color: white; margin: 100px auto; padding: 20px; width: 80%; max-height: 80vh; overflow-y: auto;">
            <h2>Select Product to Add <button onclick="closeModal()" style="float: right;"><i class="fa-solid fa-xmark"></i></button></h2>
            <table class="styled-table" style="width: 100%; border-collapse: collapse;">
                <thead>
                    <tr>
                        <th style="text-align: left;">
                            <input type="text" id="filterProductName" placeholder="Product Name Filter" style="width: 100%; margin: 0;">
                        </th>
                        <th style="text-align: left;">
                            <input type="text" id="filterVendorName" placeholder="Vendor Name Filter" style="width: 100%; margin: 0;">
                        </th>
                        <th style="text-align: left;">
                            <select id="filterCategory" style="width: 100%; margin: 0;">
                                <option value="">All</option>
                                <option value="Attraction">Attraction</option>
                                <option value="Hotel">Hotel</option>
                                <option value="Restaurant">Restaurant</option>
                                <option value="Tour">Tour</option>
                                <option value="Transfers">Transfers</option>
                                <option value="SIC">SIC</option>
                                <option value="Guide">Guide</option>
                            </select>
                        </th>
                        <th style="text-align: left;">
                            <select id="filterCity" style="width: 100%; margin: 0;">
                                <option value="">All</option>
                                <?php
                                $sql = "SELECT DISTINCT TRIM(city) AS city FROM tdu_products WHERE city IS NOT NULL AND city != '' AND country = '$country' GROUP BY city ORDER BY COUNT(city) DESC";
                                $result = $conn->query($sql);
                                while ($row = $result->fetch_assoc()) {
                                    echo '<option value="' . htmlspecialchars($row['city']) . '">' . htmlspecialchars($row['city']) . '</option>';
                                }
                                ?>
                            </select> 
                        </th>
                        <th style="text-align: left;">Seats</th>
                        <th><button onclick="filterTable()"><i class="fa-solid fa-magnifying-glass"></i></button></th>
                    </tr>
                </thead>
                <tbody id="productTableBody">
                    <?php
                    $sql = "SELECT p.productid, p.productName, v.vendorName, p.category, p.city, p.seats
                            FROM tdu_products p
                            LEFT JOIN tdu_vendors v ON p.vendorid = v.vendorid
                            WHERE p.productActive = 'Yes' AND v.vendorActive = 'Yes'
                            ORDER BY p.productName ASC";

                    $productResult = $conn->query($sql);

                    if ($productResult->num_rows > 0) {
                        while ($productRow = $productResult->fetch_assoc()) {
                            echo "<tr>";
                            echo "<td style='text-align: left;'>" . htmlspecialchars($productRow['productName']) . "</td>";
                            echo "<td style='text-align: left;'>" . htmlspecialchars($productRow['vendorName']) . "</td>";
                            echo "<td>" . htmlspecialchars($productRow['category']) . "</td>";
                            echo "<td>" . htmlspecialchars($productRow['city']) . "</td>"; // City column
                            
                            // Only show the seats column if the category is 'Transfers'
                            if ($productRow['category'] == 'Transfers') {
                                echo "<td>" . htmlspecialchars($productRow['seats']) . "</td>";
                            } else {
                                echo "<td></td>";
                            }
                            
                            echo "<td><button onclick='addProductToTemplate(" . $productRow['productid'] . ")'>Add</button></td>";
                            echo "</tr>";
                        }
                    } else {
                        echo "<tr><td colspan='6'>No products found</td></tr>"; // Adjusted colspan for added column
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <script>
        // Function to add product to the template using AJAX
        function addProductToTemplate(productId) {
            var templateId = '<?php echo $_GET['id']; ?>'; // Get template ID from URL
            var xhr = new XMLHttpRequest();
            xhr.open('POST', 'ajax_add_to_template.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    alert(xhr.responseText); // Alert success or error message
                    location.reload(); // Reload the page
                }
            };

            // Send the AJAX request with necessary parameters
            xhr.send('templateid=' + templateId + '&productid=' + productId);
        }
    </script>


    <script>
        function showModal() {
            document.getElementById('productModal').style.display = 'block';
        }

        function closeModal() {
            document.getElementById('productModal').style.display = 'none';
        }

        function filterTable() {
            var productNameFilter = document.getElementById("filterProductName").value.toUpperCase();
            var vendorNameFilter = document.getElementById("filterVendorName").value.toUpperCase();
            var categoryFilter = document.getElementById("filterCategory").value.toUpperCase();
            var cityFilter = document.getElementById("filterCity").value.toUpperCase(); // Added city filter
            
            var table = document.getElementById("productTableBody");
            var rows = table.getElementsByTagName("tr");

            for (var i = 0; i < rows.length; i++) {
                var cells = rows[i].getElementsByTagName("td");
                var productName = cells[0] ? cells[0].textContent || cells[0].innerText : "";
                var vendorName = cells[1] ? cells[1].textContent || cells[1].innerText : "";
                var category = cells[2] ? cells[2].textContent || cells[2].innerText : "";
                var city = cells[3] ? cells[3].textContent || cells[3].innerText : ""; // Get city value

                var showRow = true;

                if (productName.toUpperCase().indexOf(productNameFilter) === -1) {
                    showRow = false;
                }
                if (vendorName.toUpperCase().indexOf(vendorNameFilter) === -1) {
                    showRow = false;
                }
                if (categoryFilter && category.toUpperCase().indexOf(categoryFilter) === -1) {
                    showRow = false;
                }
                if (cityFilter && city.toUpperCase().indexOf(cityFilter) === -1) { // Check city filter
                    showRow = false;
                }

                rows[i].style.display = showRow ? "" : "none";
            }
        }
    </script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        function deleteRow(auto_id) {
            if (confirm("Are you sure you want to delete this record?")) {
                $.ajax({
                    url: "ajax_delete_product_in_template.php",
                    type: "POST",
                    data: { auto_id: auto_id },
                    success: function(response) {
                        console.log("Server Response:", response); // Debugging

                        if (response.trim() === "success") {
                            location.reload(); // Reload the page on success
                        } else {
                            alert("Error: " + response);
                        }
                    },
                    error: function() {
                        alert("An error occurred while processing your request.");
                    }
                });
            }
        }
    </script>

    <style>
        select, input, textarea {
            width: 100%;
            height: 30px;
            margin: 0;
        }
    </style>
    <?php
}

// Redirect
else {
    header('Location: login.php');
    exit();
}
?>
