<?php
include "dbconn.php";

if (!isset($_GET['quoteid'])) {
    echo json_encode(['success' => false, 'error' => 'Invalid request']);
    exit;
}

$quoteid = $_GET['quoteid'];
$action = $_GET['action'] ?? 'status';

$sql = "SELECT * FROM vtiger_payment_history WHERE quoteid='$quoteid' ORDER BY added_on ASC;";
$result = $conn->query($sql);

$initial_amount = 0;
$total_amount = 0;
$trams_received_amount = 0;

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        if (isset($row['total_amount']) && !empty($row['total_amount'])) {
            if ($row['source'] == 'initial') {
                $initial_amount = (float)$row['total_amount'];
            }
            if ($row['source'] == 'final') {
                $total_amount = (float)$row['total_amount'];
            }
        }
        if (!empty($row['trams_received_amount'])) {
            $trams_received_amount += (float)$row['trams_received_amount'];
        }
    }
}

if ($initial_amount > 0) {
    $initial_amount -= 30;
}

if ($total_amount == 0) {
    $total_amount = $initial_amount;
}

$adjustment = $total_amount - $initial_amount;
$final_balance = $total_amount - $trams_received_amount;

$colorClass = 'grey';
if ($total_amount == 0) {
    $colorClass = 'grey';
} elseif ($trams_received_amount <= 0) {
    $colorClass = 'red';
} elseif ($trams_received_amount >= $total_amount) {
    $colorClass = 'green';
} else {
    $colorClass = 'orange';
}

if ($action === 'popup') {
    echo "
        <div>
            <div style='display: flex; justify-content: space-between; margin: 5px 0;'>
                <span>Initial Invoice: </span>
                <span>$ " . number_format($initial_amount, 2) . "</span>
            </div>
            <div style='display: flex; justify-content: space-between; margin: 5px 0;'>
                <span>Received: </span>
                <span>$ " . number_format($trams_received_amount, 2) . "</span>
            </div>
            <div style='display: flex; justify-content: space-between; margin: 5px 0;'>
                <span>Adjustment: </span>
                <span>$ " . number_format($adjustment, 2) . "</span>
            </div>
            <div style='display: flex; justify-content: space-between; margin: 5px 0;'>
                <span>Final Balance: </span>
                <span>$ " . number_format($final_balance, 2) . "</span>
            </div>
        </div>
    ";
    exit;
}

echo json_encode([
    'success' => true,
    'colorClass' => $colorClass
]);
?>
