<?php
function getMarkupValues($conn, $membershipid, $quote_type_mup, $pax_no) {
    $sql_fixed_mup = "SELECT markup_type, pax_min, pax_max, markup1, markup2 
                      FROM tdu_membership_organization 
                      WHERE membershipid='$membershipid' 
                      AND quote_type='$quote_type_mup' 
                      ORDER BY pax_min ASC";
    
    $result_fixed_mup = mysqli_query($conn, $sql_fixed_mup);
    
    $markup_type = '';
    $markup1 = 0;
    $markup2 = 0;

    if (mysqli_num_rows($result_fixed_mup) > 0) {
        $first_row = mysqli_fetch_assoc($result_fixed_mup);
        $markup_type = $first_row['markup_type'];
        $markup1 = $first_row['markup1'];
        $markup2 = $first_row['markup2'];
        mysqli_data_seek($result_fixed_mup, 0);

        while ($tmp_row = mysqli_fetch_assoc($result_fixed_mup)) {
            if ($pax_no >= $tmp_row['pax_min'] && $pax_no <= $tmp_row['pax_max']) {
                $markup_type = $tmp_row['markup_type'];
                $markup1 = $tmp_row['markup1'];
                $markup2 = $tmp_row['markup2'];
                $last_row = $tmp_row;

                break;
            }
            $last_row = $tmp_row;
        }

        if ($pax_no > $last_row['pax_max']) {
            $markup_type = $last_row['markup_type'];
            $markup1 = $last_row['markup1'];
            $markup2 = $last_row['markup2'];
        }
    }

    return [
        'markup_type' => $markup_type,
        'markup1' => $markup1,
        'markup2' => $markup2
    ];
}

function getPricingDetails($conn, $quoteid) {
    $sql_fixed_sum = "SELECT 
                        vps.cf_928, 
                        SUM(CAST(vps.sale_price_single AS DECIMAL(10,2)) * vps.nights) AS total_sale_price_single,
                        SUM(CAST(vps.sale_price_double AS DECIMAL(10,2)) * vps.nights) AS total_sale_price_double,
                        SUM(CEIL(CAST(vps.sale_price_triple AS DECIMAL(10,2)) / 3) * vps.nights) AS total_sale_price_triple,
                        SUM(CAST(vps.sale_price_child_with_bed AS DECIMAL(10,2)) * vps.nights) AS total_sale_price_child_with_bed,
                        SUM(CAST(vps.sale_price_child_no_bed AS DECIMAL(10,2)) * vps.nights) AS total_sale_price_child_no_bed,
                        SUM(CAST(vps.sale_price AS DECIMAL(10,2))) AS total_sale_price,
                        SUM(CAST(vps.sale_price_child AS DECIMAL(10,2))) AS total_sale_price_child,
                        SUM(CAST(vps.sale_price_infant AS DECIMAL(10,2))) AS total_sale_price_infant
                    FROM vtiger_products_saleprice vps
                    WHERE vps.quoteid = '$quoteid' AND vps.subquoteid = 1
                    GROUP BY vps.cf_928";
    
    $result_fixed_sum = mysqli_query($conn, $sql_fixed_sum);
    $pricing = [
        'Attraction' => ['adult' => 0, 'child' => 0, 'infant' => 0],
        'SIC' => ['adult' => 0, 'child' => 0, 'infant' => 0],
        'Hotel' => ['single' => 0, 'double' => 0, 'triple' => 0, 'child_with_bed' => 0, 'child_no_bed' => 0],
        'Restaurant' => ['adult' => 0, 'child' => 0, 'infant' => 0],
        'Transfers' => ['adult' => 0],
        'Guide' => ['adult' => 0],
        'Tour' => ['adult' => 0, 'child' => 0, 'infant' => 0]
    ];
    
    while ($row = mysqli_fetch_assoc($result_fixed_sum)) {
        $category = $row['cf_928'];
        switch ($category) {
            case 'Attraction':
            case 'SIC':
            case 'Restaurant':
            case 'Tour':
                $pricing[$category]['adult'] = ceil((float) $row['total_sale_price'] ?? 0);
                $pricing[$category]['child'] = ceil((float) $row['total_sale_price_child'] ?? 0);
                $pricing[$category]['infant'] = ceil((float) $row['total_sale_price_infant'] ?? 0);
                break;
            case 'Hotel':
                $pricing['Hotel']['single'] = ceil((float) $row['total_sale_price_single'] ?? 0);
                $pricing['Hotel']['double'] = ceil(((float) $row['total_sale_price_double'] ?? 0) / 2);
                $pricing['Hotel']['triple'] = (int) $row['total_sale_price_triple'] ?? 0;
                $pricing['Hotel']['child_with_bed'] = ceil((float) $row['total_sale_price_child_with_bed'] ?? 0);
                $pricing['Hotel']['child_no_bed'] = ceil((float) $row['total_sale_price_child_no_bed'] ?? 0);
                break;
            case 'Transfers':
                $pricing['Transfers']['adult'] = ceil((float) $row['total_sale_price'] ?? 0);
                break;
            case 'Guide':
                $pricing['Guide']['adult'] = ceil((float) $row['total_sale_price'] ?? 0);
                break;
        }
    }
    
    return $pricing;
}

function getQuotePricing($conn, $quoteid, $quote_pax) {
    $sql_quote = "SELECT q.*, a.membershipid
                  FROM vtiger_quotes q
                  LEFT JOIN tdu_organisation a ON q.accountid = a.organizationid 
                  WHERE q.quoteid='$quoteid'";
    $result_quote = mysqli_query($conn, $sql_quote);
    if(mysqli_num_rows($result_quote) > 0) {
        $row = mysqli_fetch_assoc($result_quote);

        $quote_number = $row['quote_no'];
        $mode = 'group';
        if(isset($row['mode']) && $row['mode'] == 'standard') {
            $mode = $row['mode'];
        }
        $adults_no = $row['adults'] ?? 0;
        $children_no = $row['children']?? 0;
        $infants_no = $row['infants']?? 0;
        $pax_no = $adults_no + $children_no;
        $country = $row['country'];
        $membershipid = $row['membershipid'] ?? 0;
        $extra_mup = (float) $row['extra_mup'] ?? 0;
    } else {
        return [];
    }

    // total price for each category
    $pricing_data = getPricingDetails($conn, $quoteid);
    if($pricing_data) {
        $pricing_attraction = $pricing_data['Attraction']['adult'];
        $pricing_attraction_child = $pricing_data['Attraction']['child'];
        $pricing_attraction_infant = $pricing_data['Attraction']['infant'];

        $pricing_sic = $pricing_data['SIC']['adult'];
        $pricing_sic_child = $pricing_data['SIC']['child'];
        $pricing_sic_infant = $pricing_data['SIC']['infant'];

        $pricing_single = $pricing_data['Hotel']['single'];
        $pricing_double = $pricing_data['Hotel']['double'];
        $pricing_triple = $pricing_data['Hotel']['triple'];
        $pricing_child_with_bed = $pricing_data['Hotel']['child_with_bed'];
        $pricing_child_no_bed = $pricing_data['Hotel']['child_no_bed'];

        $pricing_restaurant = $pricing_data['Restaurant']['adult'];
        $pricing_restaurant_child = $pricing_data['Restaurant']['child'];
        $pricing_restaurant_infant = $pricing_data['Restaurant']['infant'];

        $pricing_transfers = $pricing_data['Transfers']['adult'];
        $pricing_guide = $pricing_data['Guide']['adult'];

        $pricing_tour = $pricing_data['Tour']['adult'];
        $pricing_tour_child = $pricing_data['Tour']['child'];
        $pricing_tour_infant = $pricing_data['Tour']['infant'];
    }

    if(substr($quote_number, -1) === 'G') {
        $quote_type_mup = 'Group';
    } else {
        $quote_type_mup = 'FIT';
    }

    $mode_sql = '=0';
    if($mode == 'group') {
        $mode_sql = '>1';
    }
    $sql_group_sum = "SELECT vps.subquoteid, SUM(vps.sale_price) AS total_sale_price, MIN(vps.pax_min) AS pax_min, MAX(vps.pax_max) AS pax_max
                    FROM vtiger_products_saleprice vps
                    WHERE vps.quoteid='$quoteid' AND vps.subquoteid $mode_sql AND vps.cf_928='Transfers'
                    GROUP BY vps.subquoteid
                    ORDER BY pax_min ASC;";
    $result_group_sum = mysqli_query($conn, $sql_group_sum);

    if (mysqli_num_rows($result_group_sum) > 0) {
        $pax_no_pax_range = $pax_no;
        while ($row_group_sum = mysqli_fetch_assoc($result_group_sum)) {
            if($mode == 'group') {
                $highlight_pax_range = '';
                if ($row_group_sum['pax_min'] <= $pax_no_pax_range && $pax_no_pax_range <= $row_group_sum['pax_max']) {
                    $highlight_pax_range = 'style="background-color: lightyellow;"';
                    $subquoteid_supplier = $row_group_sum['subquoteid'];
                    $pricing_transfers_total = ceil((float) $row_group_sum['total_sale_price'] / $row_group_sum['pax_min']) * $pax_no_pax_range;
                }
                $pax_no = $row_group_sum['pax_min'];
                $markups = getMarkupValues($conn, $membershipid, $quote_type_mup, $row_group_sum['pax_max']);
            }
            else {
                $markups = getMarkupValues($conn, $membershipid, $quote_type_mup, $pax_no);
            }

            if(!isset($pax_no) || $pax_no == 0) {
                $pax_no = 1;
            }
            $pricing_transfers = $row_group_sum['total_sale_price'];

            if($quote_type_mup == 'FIT') {
                if($country == 'Australia') {
                    $markup_percent = (float) $markups['markup1'] / 100 + 1;
                } else {
                    $markup_percent = (float) $markups['markup2'] / 100 + 1;
                }

                // Calculating total_double_cost for different room types
                $single_room = ceil(($pricing_single + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_percent);
                $double_room = ceil(($pricing_double + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_percent);
                $triple_room = ceil(($pricing_triple + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_percent);
                $child_with_bed = ceil(($pricing_child_with_bed + $pricing_attraction_child + $pricing_restaurant_child + $pricing_tour_child + $pricing_sic_child + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_percent);
                $child_no_bed = ceil(($pricing_child_no_bed + $pricing_attraction_child + $pricing_restaurant_child + $pricing_tour_child + $pricing_sic_child + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_percent);
                $infant = ceil($pricing_attraction_infant + $pricing_restaurant_infant + $pricing_tour_infant + $pricing_sic_infant);
            } else {
                if($markups['markup_type'] == 'ratio') {
                    $markup_amt_adult = $markups['markup1'] / 100 + 1;
                    $markup_amt_child = $markups['markup2'] / 100 + 1;

                     // Calculating total_double_cost for different room types
                    $single_room = ceil(($pricing_single + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_amt_adult);
                    $double_room = ceil(($pricing_double + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_amt_adult);
                    $triple_room = ceil(($pricing_triple + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_amt_adult);
                    $child_with_bed = ceil(($pricing_child_with_bed + $pricing_attraction_child + $pricing_restaurant_child + $pricing_tour_child + $pricing_sic_child + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_amt_child);
                    $child_no_bed = ceil(($pricing_child_no_bed + $pricing_attraction_child + $pricing_restaurant_child + $pricing_tour_child + $pricing_sic_child + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_amt_child);
                    $infant = ceil($pricing_attraction_infant + $pricing_restaurant_infant + $pricing_tour_infant + $pricing_sic_infant);
                } else {
                    $markup_amt_adult = $markups['markup1'];
                    $markup_amt_child = $markups['markup2'];

                     // Calculating total_double_cost for different room types
                    $single_room = ceil(($pricing_single + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) + $markup_amt_adult);
                    $double_room = ceil(($pricing_double + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) + $markup_amt_adult);
                    $triple_room = ceil(($pricing_triple + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) + $markup_amt_adult);
                    $child_with_bed = ceil(($pricing_child_with_bed + $pricing_attraction_child + $pricing_restaurant_child + $pricing_tour_child + $pricing_sic_child + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) + $markup_amt_child);
                    $child_no_bed = ceil(($pricing_child_no_bed + $pricing_attraction_child + $pricing_restaurant_child + $pricing_tour_child + $pricing_sic_child + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) + $markup_amt_child);
                    $infant = ceil($pricing_attraction_infant + $pricing_restaurant_infant + $pricing_tour_infant + $pricing_sic_infant);
                }
            }
            if($mode == 'group' && $quote_pax == $pax_no) {
                break;
            }
        }
    } else {
        $markups = getMarkupValues($conn, $membershipid, $quote_type_mup, $pax_no);
        if($quote_type_mup == 'FIT') {
            if($country == 'Australia') {
                $markup_percent = (float) $markups['markup1'] / 100 + 1;
            } else {
                $markup_percent = (float) $markups['markup2'] / 100 + 1;
            }

            // Calculating total_double_cost for different room types
            $single_room = ceil(($pricing_single + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_percent);
            $double_room = ceil(($pricing_double + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_percent);
            $triple_room = ceil(($pricing_triple + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_percent);
            $child_with_bed = ceil(($pricing_child_with_bed + $pricing_attraction_child + $pricing_restaurant_child + $pricing_tour_child + $pricing_sic_child + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_percent);
            $child_no_bed = ceil(($pricing_child_no_bed + $pricing_attraction_child + $pricing_restaurant_child + $pricing_tour_child + $pricing_sic_child + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_percent);
            $infant = ceil($pricing_attraction_infant + $pricing_restaurant_infant + $pricing_tour_infant + $pricing_sic_infant);
        } else {
            if($markups['markup_type'] == 'ratio') {
                $markup_amt_adult = $markups['markup1'] / 100 + 1;
                $markup_amt_child = $markups['markup2'] / 100 + 1;

                    // Calculating total_double_cost for different room types
                $single_room = ceil(($pricing_single + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_amt_adult);
                $double_room = ceil(($pricing_double + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_amt_adult);
                $triple_room = ceil(($pricing_triple + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_amt_adult);
                $child_with_bed = ceil(($pricing_child_with_bed + $pricing_attraction_child + $pricing_restaurant_child + $pricing_tour_child + $pricing_sic_child + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_amt_child);
                $child_no_bed = ceil(($pricing_child_no_bed + $pricing_attraction_child + $pricing_restaurant_child + $pricing_tour_child + $pricing_sic_child + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) * $markup_amt_child);
                $infant = ceil($pricing_attraction_infant + $pricing_restaurant_infant + $pricing_tour_infant + $pricing_sic_infant);
            } else {
                $markup_amt_adult = $markups['markup1'];
                $markup_amt_child = $markups['markup2'];

                    // Calculating total_double_cost for different room types
                $single_room = ceil(($pricing_single + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) + $markup_amt_adult);
                $double_room = ceil(($pricing_double + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) + $markup_amt_adult);
                $triple_room = ceil(($pricing_triple + $pricing_attraction + $pricing_restaurant + $pricing_tour + $pricing_sic + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) + $markup_amt_adult);
                $child_with_bed = ceil(($pricing_child_with_bed + $pricing_attraction_child + $pricing_restaurant_child + $pricing_tour_child + $pricing_sic_child + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) + $markup_amt_child);
                $child_no_bed = ceil(($pricing_child_no_bed + $pricing_attraction_child + $pricing_restaurant_child + $pricing_tour_child + $pricing_sic_child + ceil($pricing_transfers / $pax_no) + ceil($pricing_guide / $pax_no)) + $markup_amt_child);
                $infant = ceil($pricing_attraction_infant + $pricing_restaurant_infant + $pricing_tour_infant + $pricing_sic_infant);
            }
        }
    }
    
    $childAgeAdjust = 0;
    if ($children_no > 0) {
        $childAgeAdjust = getChildAdjustAmount($conn, $quoteid);
        $child_with_bed += ceil($childAgeAdjust / $children_no);
        $child_no_bed += ceil($childAgeAdjust / $children_no);
    }

    return [
        'single_room' => $single_room + $extra_mup,
        'double_room' => $double_room + $extra_mup,
        'triple_room' => $triple_room + $extra_mup,
        'child_with_bed' => $child_with_bed + $extra_mup,
        'child_no_bed' => $child_no_bed + $extra_mup,
        'infant' => $infant + $extra_mup
    ];
}

function getChildAdjustAmount($conn, $quoteid) {
    $total_adjust = 0;

    $sql_quote = "SELECT children, infants, child_ages FROM vtiger_quotes WHERE quoteid='$quoteid'";
    $result_quote = mysqli_query($conn, $sql_quote);
    if(mysqli_num_rows($result_quote) > 0) {
        $row = mysqli_fetch_assoc($result_quote);
        $children_no = $row['children'] ?? 0;
        $child_ages = $row['child_ages'] ?? '';
        $child_ages_array = explode(',', $child_ages);

        if($children_no == 0 || $child_ages == '') {
            return 0;
        }

        $sql = "SELECT * FROM vtiger_inventoryproductrel vi
                LEFT JOIN tdu_products vp ON vi.productid = vp.productid
                WHERE vi.id='$quoteid' AND vi.cf_928 NOT IN ('Hotel', 'Transfers', 'Guide');";
        $result = mysqli_query($conn, $sql);
        if(mysqli_num_rows($result) > 0) {
            while($row = mysqli_fetch_assoc($result)) {
                if(isset($row['childAge']) && $row['childAge'] != '' && $children_no > 0) {
                    $child_age_range = explode('-', $row['childAge']); 
                    $min_age = (int) $child_age_range[0];
                    $max_age = (int) $child_age_range[1];

                    foreach($child_ages_array as $child_age) {
                        $child_age = (int) $child_age;
                        if($child_age > $max_age) {
                            $total_adjust += (float) $row['unitPrice'] - (float) $row['childPrice'];
                        } else if ($child_age < $min_age) {
                            $total_adjust += (float) $row['infantPrice'] - (float) $row['childPrice'];
                        }
                    }
                } 
            }
        }
        return ceil($total_adjust);
    }
    return 0;
}
?>
