<?php
include "dbconn.php";

if (isset($_GET['quoteid'])) {
    $quoteid = $_GET['quoteid'];

    $status_classes = ['Attraction' => 'grey', 'Hotel' => 'grey', 'Restaurant' => 'grey', 'Transfers' => 'grey', 'Tour' => 'grey', 'SIC' => 'grey', 'Guide' => 'grey'];

    $sql = "SELECT cf_928, COUNT(*) AS row_count FROM vtiger_inventoryproductrel WHERE id='$quoteid' GROUP BY cf_928;";
    $result = mysqli_query($conn, $sql);

    $counts = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $counts[$row['cf_928']] = $row['row_count'];
    }

    $sql = "SELECT vip.cf_928, COUNT(*) AS row_count FROM vtiger_itinerary vi 
            LEFT JOIN vtiger_inventoryproductrel vip ON vi.quoteid=vip.id AND vi.sequence_no=vip.sequence_no 
            WHERE vi.quoteid='$quoteid' GROUP BY vip.cf_928;";
    $result = mysqli_query($conn, $sql);

    $total_counts = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $total_counts[$row['cf_928']] = $row['row_count'];
    }

    $sql = "SELECT vip.cf_928, COUNT(*) AS row_count FROM vtiger_itinerary vi
            LEFT JOIN vtiger_inventoryproductrel vip 
            ON vi.quoteid = vip.id AND vi.sequence_no = vip.sequence_no
            WHERE vi.quoteid = '$quoteid' AND vi.meta_key = 'booking_status' 
            AND vi.meta_value = 'Confirmation received' 
            AND vi.created_at = (SELECT MAX(sub_vi.created_at) FROM vtiger_itinerary sub_vi WHERE sub_vi.quoteid = vi.quoteid AND sub_vi.sequence_no = vi.sequence_no AND sub_vi.meta_key = 'booking_status')
            GROUP BY vip.cf_928;";
    $result = mysqli_query($conn, $sql);

    $confirmed_counts = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $confirmed_counts[$row['cf_928']] = $row['row_count'];
    }

    // Determine the status based on conditions
    foreach ($status_classes as $type => &$status) {
        if (isset($total_counts[$type]) && $total_counts[$type] > 0) {
            $status = 'orange';
            if (isset($confirmed_counts[$type]) && isset($counts[$type]) && $confirmed_counts[$type] >= $counts[$type]) {
                $status = 'green';
            }
        }
    }

    echo json_encode([
        'success' => true,
        'attraction' => $status_classes['Attraction'],
        'hotel' => $status_classes['Hotel'],
        'restaurant' => $status_classes['Restaurant'],
        'transfers' => $status_classes['Transfers'],
        'tour' => $status_classes['Tour'],
        'sic' => $status_classes['SIC'],
        'guide' => $status_classes['Guide']
    ]);

    mysqli_close($conn);
} else {
    echo json_encode(['success' => false, 'error' => 'Invalid request']);
}
?>
