<?php
if (($title == 'admin') && isset($_GET['opt']) && $_GET['opt'] == 'rezdy-search') {
    include "header.php";
    ?>
    <h1 style="text-align: center; margin: 20px 0;">Rezdy Orders</h1>

    <table class="styled-table" style="width: 95%; margin: 20px auto;" id="rezdy-table">
        <thead>
            <tr>
                <th></th>
                <th>Status</th>
                <th>TDU Reference</th>
                <th>Order number</th>
                <th>Product</th>
                <th>Customer</th>
                <th>Amount</th>
                <th>Created</th>
                <th>Source</th>
            </tr>
            <tr>
                <th><button id="filterBtn" style="padding: 5px 10px; width: 100%;"><i class="fa-solid fa-magnifying-glass"></i></button></th>
                <th style="width: auto;">
                    <select id="orderStatus" style="padding: 5px; margin: 0; width: 100%;">
                        <option value="PROCESSING">PROCESSING</option>
                        <option value="NEW">NEW</option>
                        <option value="ON_HOLD">ON_HOLD</option>
                        <option value="PENDING_SUPPLIER">PENDING_SUPPLIER</option>
                        <option value="PENDING_CUSTOMER">PENDING_CUSTOMER</option>
                        <option value="CONFIRMED" selected>CONFIRMED</option>
                        <option value="CANCELLED">CANCELLED</option>
                        <option value="ABANDONED_CART">ABANDONED_CART</option>
                    </select>
                </th>
                <th>
                    <input type="text" id="resellerReference" style="padding: 5px; width: 100%;">
                </th>
                <th colspan="4" style="text-align: center;">
                    <input type="text" id="search" placeholder="Search in Order number, Customer name, Agent code and payment transaction codes" style="padding: 5px; width: 100%;">
                </th>
                <th colspan="2">
                    <input type="date" id="minDate" style="padding: 5px;"> - 
                    <input type="date" id="maxDate" style="padding: 5px;">
                </th>
            </tr>
        </thead>
        <tbody id="rezdy-tbody">
            <!-- Loaded via AJAX -->
        </tbody>
    </table>

    <div style="text-align: center; margin: 20px;">
        <button id="load-more" data-offset="0">Load More</button>
    </div>

    <style>
        .styled-table tr th, .styled-table tr td {
            text-align: left;
        }
        #load-more {
            padding: 10px 20px;
            font-size: 16px;
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const tbody = document.getElementById('rezdy-tbody');
            const loadBtn = document.getElementById('load-more');
            const limit = 20;

            function getFilters() {
                return {
                    search: document.getElementById('search').value,
                    resellerReference: document.getElementById('resellerReference').value,
                    orderStatus: document.getElementById('orderStatus').value,
                    minDateCreated: document.getElementById('minDate').value,
                    maxDateCreated: document.getElementById('maxDate').value
                };
            }

            function buildQuery(params) {
                return Object.entries(params)
                    .filter(([_, v]) => v !== '')
                    .map(([k, v]) => `${encodeURIComponent(k)}=${encodeURIComponent(v)}`)
                    .join('&');
            }

            function loadBookings(offset, append = true) {
                const filters = getFilters();
                filters.offset = offset;
                filters.limit = limit;

                loadBtn.disabled = true;
                loadBtn.textContent = 'Loading...';

                fetch(`ajax_rezdy_fetch_orders.php?${buildQuery(filters)}`)
                    .then(res => res.json())
                    .then(data => {
                        if (!append) {
                            tbody.innerHTML = '';
                        }
                        if (data.length === 0) {
                            loadBtn.style.display = 'none';
                        } else {
                            data.forEach(booking => {
                                const row = document.createElement('tr');
                                if (booking.status === 'CANCELLED') {
                                    row.style.color = 'grey';
                                } else if (booking.status === 'NEW') {
                                    row.style.color = 'blue';
                                } else if (booking.status === 'ON_HOLD') {
                                    row.style.color = 'purple';
                                } else if (booking.status === 'PENDING_SUPPLIER') {
                                    row.style.color = 'red';
                                } else if (booking.status === 'PENDING_CUSTOMER') {
                                    row.style.color = 'orange';
                                } else if (booking.status === 'CONFIRMED') {
                                    row.style.color = 'green';
                                }
                                const cancelBtn = (booking.status !== 'CANCELLED') 
                                    ? `<button class="cancel-btn" data-order="${booking.orderNumber}" style="padding: 5px 10px; background-color: red; color: white; border: none; border-radius: 4px; width: 100%;">Cancel</button>`
                                    : '';

                                row.innerHTML = `
                                    <td>${cancelBtn}</td>
                                    <td>${booking.status}</td>
                                    <td>${booking.resellerReference}</td>
                                    <td>${booking.orderNumber}</td>
                                    <td>${booking.product}</td>
                                    <td>${booking.customer}</td>
                                    <td>${booking.amount}</td>
                                    <td>${booking.created}</td>
                                    <td>${booking.source}</td>
                                `;
                                tbody.appendChild(row);
                            });
                            loadBtn.dataset.offset = offset + limit;
                            loadBtn.disabled = false;
                            loadBtn.textContent = 'Load More';
                        }
                    })
                    .catch(err => {
                        console.error(err);
                        loadBtn.textContent = 'Error';
                    });
            }

            // Initial load
            loadBookings(0);

            // Load more click
            loadBtn.addEventListener('click', function () {
                const offset = parseInt(loadBtn.dataset.offset);
                loadBookings(offset);
            });

            // Filter button
            document.getElementById('filterBtn').addEventListener('click', function () {
                loadBtn.dataset.offset = 0;
                // loadBtn.style.display = 'block';
                loadBookings(0, false); // Reset
            });

            // Cancel button click
            document.getElementById('rezdy-tbody').addEventListener('click', function (e) {
                if (e.target.classList.contains('cancel-btn')) {
                    const orderNumber = e.target.dataset.order;
                    if (!confirm(`Are you sure you want to cancel order ${orderNumber}?`)) return;

                    fetch(`ajax_rezdy_cancel_order.php?orderNumber=${orderNumber}`, {
                        method: 'DELETE'
                    })
                    .then(res => res.json())
                    .then(data => {
                        if (data.success) {
                            if (data.warningMessage) {
                                alert(data.warningMessage);
                            } else {
                                alert(`Order ${orderNumber} canceled successfully.`);
                            }
                            window.location.reload();
                        } else {
                            alert(`Failed to cancel order: ${data.message || 'Unknown error'}`);
                        }
                    })
                    .catch(err => {
                        console.error(err);
                        alert('Error canceling order.');
                    });
                }
            });
        });
    </script>
    <?php 
} 

// Redirect
else {
    header('Location: login.php');
    exit();
}
?>
