<?php
// --- START: HEADER PHP LOGIC ---
session_start();
include "header.php";
$is_logged_in = isset($_SESSION['user_name']) && $_SESSION['user_name'] != '';
$title = $_SESSION['title'] ?? '';
$department = $_SESSION['department'] ?? '';

// Include database connection. Ensure this file exists and correctly establishes $conn.
// If dbconn.php also starts a session, ensure session_start() is called only once.
include "dbconn.php";

$username_ajax = ''; // Initialize
if ($is_logged_in) {
    if ($conn) { // Check if $conn is valid before querying
        $username = mysqli_real_escape_string($conn, $_SESSION['user_name']);
        $sql_ajax = "SELECT id, user_name, CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users WHERE user_name = '" . $username . "';";
        $result_ajax = mysqli_query($conn, $sql_ajax);
        if ($result_ajax && mysqli_num_rows($result_ajax) > 0) {
            $row_ajax = $result_ajax->fetch_assoc();
            $username_ajax = $row_ajax['name'];
        } else {
             // Use username from session as fallback if DB query fails or no user found
             $username_ajax = $_SESSION['user_name'] ?? '';
        }
    } else {
        // Use username from session as fallback if no DB connection
        $username_ajax = $_SESSION['user_name'] ?? '';
        // error_log("Database connection not established in header section.");
    }
} else {
    // If not logged in, username_ajax remains empty string
}


$base_path = ''; // Define the base path for links
// --- END: HEADER PHP LOGIC ---

// --- START: SALES REPORT PHP LOGIC ---
$create_date_range_str = isset($_POST['create_date_range']) ? $_POST['create_date_range'] : '';
$start_date = '';
$end_date = '';

// If date range is not set in POST, calculate the default 10 months including current
if (empty($create_date_range_str)) {
    $start_date = date('Y-m-01', strtotime('-5 months')); // Start 9 months ago on the 1st
    $end_date = date('Y-m-t'); // End on the last day of the current month
    $create_date_range_str = $start_date . ' to ' . $end_date;
} else {
     $dates = explode(" to ", $create_date_range_str);
     if (count($dates) === 2) {
         $start_date = trim($dates[0]);
         $end_date = trim($dates[1]);
     } elseif (count($dates) === 1 && !empty($dates[0])) {
         // Handle single date as a range for that day
         $start_date = trim($dates[0]);
         $end_date = trim($dates[0]);
     } else {
         // Fallback to default 10 months if input is invalid
         $start_date = date('Y-m-01', strtotime('-5 months'));
         $end_date = date('Y-m-t');
         $create_date_range_str = $start_date . ' to ' . $end_date;
     }
}


$quote_type_filter = isset($_POST['quote_type']) ? $_POST['quote_type'] : '';

// Overall report variables
$total_quotes = 0; $total_au_quotes = 0; $total_nz_quotes = 0; // Removed other/unknown
$confirmed_quotes = 0; $confirmed_au_quotes = 0; $confirmed_nz_quotes = 0; // Removed other/unknown
$conversion_rate = 0; $conversion_rate_au = 0; $conversion_rate_nz = 0; // Removed other/unknown

$confirmed_stages = [
    'Accepted', 'PRE QA - pending', 'PRE QA - completed',
    'Payment Received - Release Vouchers', 'Final QA', 'Delivered',
    'On Ground', 'Accounts - Reconciliation', 'Completed (Accounts)'
];
$confirmed_stages_sql_in = "";
if ($conn) {
    $escaped_stages = array_map([$conn, 'real_escape_string'], $confirmed_stages);
    $confirmed_stages_sql_in = "('" . implode("','", $escaped_stages) . "')";
}

// Subquery to select unique quotes based on quote_no
$unique_quotes_subquery = "
    (SELECT
        inner_vq.quoteid, inner_vq.created_at, inner_vq.deleted, inner_vq.quote_no,
        inner_vq.quotestage, inner_vq.no_pax, inner_vq.country, inner_vq.subject, inner_vq.contactid
     FROM vtiger_quotes inner_vq
     WHERE inner_vq.quoteid = (
         SELECT MIN(sub.quoteid) FROM vtiger_quotes AS sub WHERE sub.quote_no = inner_vq.quote_no AND sub.deleted = 0
     )
    ) vq
";


// Region report variables
$region_data = [];
$region_report_total_queries = 0; $region_report_total_queries_au = 0; $region_report_total_queries_nz = 0; // Removed other
$region_report_total_confirmed = 0; $region_report_total_confirmed_au = 0; $region_report_total_confirmed_nz = 0; // Removed other
$region_report_overall_conversion = 0; $region_report_overall_conversion_au = 0; $region_report_overall_conversion_nz = 0; // Removed other

// Report data arrays
$external_sales_report_data = [];
$rejected_quotes_data = [
    'AU_FIT' => [], 'AU_GROUP' => [], 'NZ_FIT' => [], 'NZ_GROUP' => [], 'OTHER_FIT' => [], 'OTHER_GROUP' => []
];
$query_confirmation_detail_data = [];
$available_regions_for_filter = [];

// --- Consolidated Report Data Arrays ---
$live_queries_data = []; // Consolidated Live
$consolidated_priority_data = []; // Consolidated Priority

// --- Month-Wise Report Data Arrays ---
$month_wise_priority_counts = []; // Nested: region -> month -> country -> priority -> count
$month_wise_period_totals = []; // Nested: region -> country -> total
$key_agents_list = []; // Nested: region -> list of agent names
$report_months = []; // To store the list of months in the selected range

$rejected_stages_list = [
    'Rejected', 'Rejected After Confrmation QA pending', 'Rejected After Confrmation QA completed', 'Auto Rejected'
];
$rejected_stages_sql_in = "";

// Main data fetching block
if (!empty($start_date) && !empty($end_date) && $conn) {

    if ($conn) {
        $escaped_rejected_stages = array_map([$conn, 'real_escape_string'], $rejected_stages_list);
        $rejected_stages_sql_in = "('" . implode("','", $escaped_rejected_stages) . "')";
    }

    $sql_where_for_vq_main_filter_component = "";
    if ($quote_type_filter == 'fit-dashboard') {
        $sql_where_for_vq_main_filter_component = " AND vq.quote_no NOT LIKE '%G'";
    } else if ($quote_type_filter == 'group') {
        $sql_where_for_vq_main_filter_component = " AND vq.quote_no LIKE '%G'";
    }
    $sql_date_filter_component = " AND vq.created_at BETWEEN '" . $conn->real_escape_string($start_date) . " 00:00:00' AND '" . $conn->real_escape_string($end_date) . " 23:59:59'";
    // This variable now includes both date and the main FIT/Group filter
    $sql_where_for_vq = $sql_date_filter_component . $sql_where_for_vq_main_filter_component;

    // --- Overall Total Quotes ---
    // This query now respects the main filter, removed other/unknown
    $sql_total = "SELECT COUNT(vq.quoteid) AS total_count, SUM(CASE WHEN vq.country = 'Australia' THEN 1 ELSE 0 END) AS total_au, SUM(CASE WHEN vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS total_nz FROM " . $unique_quotes_subquery . " WHERE vq.deleted = 0" . $sql_where_for_vq;
    $result_total = $conn->query($sql_total);
    if ($result_total && $result_total->num_rows > 0) {
        $row = $result_total->fetch_assoc();
        $total_quotes = (int)$row['total_count']; $total_au_quotes = (int)$row['total_au']; $total_nz_quotes = (int)$row['total_nz'];
    } // else { error_log("Error fetching total quotes: " . $conn->error . " Query: " . $sql_total); }

    // --- Overall Confirmed Quotes ---
    // This query now respects the main filter, removed other/unknown
    $sql_confirmed_where_for_vq_ext = $sql_where_for_vq . " AND vq.quotestage IN " . $confirmed_stages_sql_in;
    $sql_confirmed = "SELECT COUNT(vq.quoteid) AS confirmed_count, SUM(CASE WHEN vq.country = 'Australia' THEN 1 ELSE 0 END) AS confirmed_au, SUM(CASE WHEN vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS confirmed_nz FROM " . $unique_quotes_subquery . " WHERE vq.deleted = 0" . $sql_confirmed_where_for_vq_ext;
    $result_confirmed = $conn->query($sql_confirmed);
    if ($result_confirmed && $result_confirmed->num_rows > 0) {
        $row = $result_confirmed->fetch_assoc();
        $confirmed_quotes = (int)$row['confirmed_count']; $confirmed_au_quotes = (int)$row['confirmed_au']; $confirmed_nz_quotes = (int)$row['confirmed_nz'];
    } // else { error_log("Error fetching confirmed quotes: " . $conn->error . " Query: " . $sql_confirmed); }

    if ($total_quotes > 0) $conversion_rate = ($confirmed_quotes / $total_quotes) * 100;
    if ($total_au_quotes > 0) $conversion_rate_au = ($confirmed_au_quotes / $total_au_quotes) * 100;
    if ($total_nz_quotes > 0) $conversion_rate_nz = ($confirmed_nz_quotes / $total_nz_quotes) * 100;
    // Removed other conversion rate calculation

    // --- Region-wise Report Data ---
    // This query now respects the main filter, removed other/unknown
     $sql_region_total = "SELECT COALESCE(vqinfo.assigned_to_region, 'Unknown') AS region_name, COUNT(vq.quoteid) AS total_region_quotes, SUM(CASE WHEN vq.country = 'Australia' THEN 1 ELSE 0 END) AS total_au_in_region, SUM(CASE WHEN vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS total_nz_in_region FROM " . $unique_quotes_subquery . " LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid WHERE vq.deleted = 0 " . $sql_where_for_vq . " GROUP BY region_name ORDER BY region_name";
     $result_region_total = $conn->query($sql_region_total);
     if ($result_region_total) {
         while ($row = $result_region_total->fetch_assoc()) {
             $region_name = $row['region_name'];
             $region_data[$region_name] = ['total' => (int)$row['total_region_quotes'], 'total_au' => (int)$row['total_au_in_region'], 'total_nz' => (int)$row['total_nz_in_region'], 'confirmed' => 0, 'confirmed_au' => 0, 'confirmed_nz' => 0, 'conversion' => 0.0, 'conversion_au' => 0.0, 'conversion_nz' => 0.0 ]; // Removed other/unknown
         }
     } // else { error_log("Error fetching regional total quotes: " . $conn->error); }

    $sql_region_confirmed = "SELECT COALESCE(vqinfo.assigned_to_region, 'Unknown') AS region_name, COUNT(vq.quoteid) AS confirmed_region_quotes, SUM(CASE WHEN vq.country = 'Australia' THEN 1 ELSE 0 END) AS confirmed_au_in_region, SUM(CASE WHEN vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS confirmed_nz_in_region FROM " . $unique_quotes_subquery . " LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid WHERE vq.deleted = 0 " . $sql_confirmed_where_for_vq_ext . " GROUP BY region_name ORDER BY region_name";
    $result_region_confirmed = $conn->query($sql_region_confirmed);
    if ($result_region_confirmed) {
        while ($row = $result_region_confirmed->fetch_assoc()) {
            $region_name = $row['region_name'];
            if (!isset($region_data[$region_name])) { $region_data[$region_name] = ['total' => 0, 'total_au' => 0, 'total_nz' => 0, 'confirmed' => 0, 'confirmed_au' => 0, 'confirmed_nz' => 0, 'conversion' => 0.0, 'conversion_au' => 0.0, 'conversion_nz' => 0.0 ]; } // Removed other/unknown
            $region_data[$region_name]['confirmed'] = (int)$row['confirmed_region_quotes']; $region_data[$region_name]['confirmed_au'] = (int)$row['confirmed_au_in_region']; $region_data[$region_name]['confirmed_nz'] = (int)$row['confirmed_nz_in_region']; // Removed other/unknown
        }
    } // else { error_log("Error fetching regional confirmed quotes: " . $conn->error); }

    foreach ($region_data as &$data_item_region) {
        if ($data_item_region['total'] > 0) $data_item_region['conversion'] = ($data_item_region['confirmed'] / $data_item_region['total']) * 100;
        if ($data_item_region['total_au'] > 0) $data_item_region['conversion_au'] = ($data_item_region['confirmed_au'] / $data_item_region['total_au']) * 100;
        if ($data_item_region['total_nz'] > 0) $data_item_region['conversion_nz'] = ($data_item_region['confirmed_nz'] / $data_item_region['total_nz']) * 100;
        // Removed other conversion
        $region_report_total_queries += $data_item_region['total']; $region_report_total_queries_au += $data_item_region['total_au']; $region_report_total_queries_nz += $data_item_region['total_nz']; // Removed other
        $region_report_total_confirmed += $data_item_region['confirmed']; $region_report_total_confirmed_au += $data_item_region['confirmed_au']; $region_report_total_confirmed_nz += $data_item_region['confirmed_nz']; // Removed other
    }
    unset($data_item_region);
    if ($region_report_total_queries > 0) $region_report_overall_conversion = ($region_report_total_confirmed / $region_report_total_queries) * 100;
    if ($region_report_total_queries_au > 0) $region_report_overall_conversion_au = ($region_report_total_confirmed_au / $region_report_total_queries_au) * 100;
    if ($region_report_total_queries_nz > 0) $region_report_overall_conversion_nz = ($region_report_total_confirmed_nz / $region_report_total_queries_nz) * 100;
     // Removed other conversion


    // --- Consolidated Live Queries (Respects Main Filter), Removed Other/Unknown ---
     $sql_live_queries = "SELECT
        COALESCE(vqinfo.assigned_to_region, 'Unknown Region') AS region,
        COUNT(vq.quoteid) AS total_queries,
        SUM(CASE WHEN vq.country = 'Australia' THEN 1 ELSE 0 END) AS au_queries,
        SUM(CASE WHEN vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS nz_queries
    FROM " . $unique_quotes_subquery . "
    LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
    WHERE vq.deleted = 0 " . $sql_where_for_vq . "  -- Applies main filter (All/FIT/Group) and date filter
    AND vq.quotestage IN ('Created', 'Requote')
    GROUP BY region
    ORDER BY region";

    $result_live_queries = $conn->query($sql_live_queries);
    if ($result_live_queries) {
        while ($row = $result_live_queries->fetch_assoc()) {
            // Removed other_queries calculation
            $live_queries_data[] = $row;
        }
    } // else { error_log("Error Live Queries: " . $conn->error); }


    // --- Consolidated Priority (Respects Main Filter), Removed Other/Unknown ---
    $sql_consolidated_priority = "(
        -- Internal Agents (primarily FIT, but includes any quote assigned if main filter is All)
        SELECT
            'Internal' AS agent_type,
            COALESCE(vqinfo.assigned_to_sales_agent, 'Unassigned Internal') AS person,
            COALESCE(vqinfo.assigned_to_region, 'Unknown Region') AS region,
            COUNT(vq.quoteid) AS total_queries_overall,
            SUM(CASE WHEN vq.country = 'Australia' THEN 1 ELSE 0 END) AS total_queries_au,
            SUM(CASE WHEN vqinfo.priority = 'high' AND vq.country = 'Australia' THEN 1 ELSE 0 END) AS high_au,
            SUM(CASE WHEN vqinfo.priority = 'low' AND vq.country = 'Australia' THEN 1 ELSE 0 END) AS low_au,
            SUM(CASE WHEN (vqinfo.priority IS NULL OR vqinfo.priority = '') AND vq.country = 'Australia' THEN 1 ELSE 0 END) AS blank_priority_au,
            SUM(CASE WHEN vqinfo.priority = 'not connected' AND vq.country = 'Australia' THEN 1 ELSE 0 END) AS not_connected_priority_au,

            SUM(CASE WHEN vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS total_queries_nz,
            SUM(CASE WHEN vqinfo.priority = 'high' AND vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS high_nz,
            SUM(CASE WHEN vqinfo.priority = 'low' AND vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS low_nz,
            SUM(CASE WHEN (vqinfo.priority IS NULL OR vqinfo.priority = '') AND vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS blank_priority_nz,
            SUM(CASE WHEN vqinfo.priority = 'not connected' AND vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS not_connected_priority_nz
            -- Removed other country sums

        FROM " . $unique_quotes_subquery . "
        LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
        WHERE vq.deleted = 0 " . $sql_where_for_vq . " -- Applies main filter
        AND (vqinfo.assigned_to_sales_agent IS NOT NULL AND vqinfo.assigned_to_sales_agent != '') -- Assigned Internal Agent
        GROUP BY person, region
    )
    UNION ALL
    (
        -- External Agents (primarily Group, but includes any quote assigned if main filter is All)
         SELECT
            'External' AS agent_type,
            COALESCE(vqinfo.assigned_to_external_sales_agent, 'Unassigned Ext. Agent') AS person,
            COALESCE(vqinfo.assigned_to_region, 'Unknown Region') AS region,
            COUNT(vq.quoteid) AS total_queries_overall,
            SUM(CASE WHEN vq.country = 'Australia' THEN 1 ELSE 0 END) AS total_queries_au,
            SUM(CASE WHEN vqinfo.priority = 'high' AND vq.country = 'Australia' THEN 1 ELSE 0 END) AS high_au,
            SUM(CASE WHEN vqinfo.priority = 'low' AND vq.country = 'Australia' THEN 1 ELSE 0 END) AS low_au,
            SUM(CASE WHEN (vqinfo.priority IS NULL OR vqinfo.priority = '') AND vq.country = 'Australia' THEN 1 ELSE 0 END) AS blank_priority_au,
            SUM(CASE WHEN vqinfo.priority = 'not connected' AND vq.country = 'Australia' THEN 1 ELSE 0 END) AS not_connected_priority_au,

            SUM(CASE WHEN vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS total_queries_nz,
            SUM(CASE WHEN vqinfo.priority = 'high' AND vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS high_nz,
            SUM(CASE WHEN vqinfo.priority = 'low' AND vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS low_nz,
            SUM(CASE WHEN (vqinfo.priority IS NULL OR vqinfo.priority = '') AND vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS blank_priority_nz,
            SUM(CASE WHEN vqinfo.priority = 'not connected' AND vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS not_connected_priority_nz
            -- Removed other country sums

        FROM " . $unique_quotes_subquery . "
        LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
        WHERE vq.deleted = 0 " . $sql_where_for_vq . " -- Applies main filter
        AND (vqinfo.assigned_to_external_sales_agent IS NOT NULL AND vqinfo.assigned_to_external_sales_agent != '') -- Assigned External Agent
        GROUP BY person, region
    )
    ORDER BY agent_type, person, region";


    $result_consolidated_priority = $conn->query($sql_consolidated_priority);
     if ($result_consolidated_priority) {
        while ($row = $result_consolidated_priority->fetch_assoc()) {
             // Removed other_queries calculation
             // Removed high_other, low_other, blank_priority_other, not_connected_priority_other calculations
             $consolidated_priority_data[] = $row;
        }
    } // else { error_log("Error Consolidated Priority: " . $conn->error); }


    // --- External Sales Report Data, Removed Other/Unknown ---
    // This report still ignores the main fit/group filter as it reports across both types for external agents.
    // The $sql_external_sales_base_where is correct as it only includes the date filter.
    $sql_external_sales_base_where = $sql_date_filter_component; // No quote type filter here
    $sql_external_sales = "SELECT COALESCE(vqinfo.assigned_to_external_sales_agent, 'Unassigned Ext. Agent') AS person, COALESCE(vqinfo.assigned_to_region, 'Unknown Region') AS region, SUM(CASE WHEN vq.country = 'Australia' THEN 1 ELSE 0 END) AS no_of_inquiries_au, SUM(CASE WHEN vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS no_of_inquiries_nz, SUM(CASE WHEN vq.quote_no LIKE '%G' AND vq.quotestage IN " . $confirmed_stages_sql_in . " AND vq.country = 'Australia' THEN 1 ELSE 0 END) AS no_of_confirm_groups_au, SUM(CASE WHEN vq.quote_no LIKE '%G' AND vq.quotestage IN " . $confirmed_stages_sql_in . " AND vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS no_of_confirm_groups_nz, SUM(CASE WHEN vq.quote_no NOT LIKE '%G' AND vq.quotestage IN " . $confirmed_stages_sql_in . " AND vq.country = 'Australia' THEN 1 ELSE 0 END) AS no_of_confirm_fit_au, SUM(CASE WHEN vq.quote_no NOT LIKE '%G' AND vq.quotestage IN " . $confirmed_stages_sql_in . " AND vq.country = 'New Zealand' THEN 1 ELSE 0 END) AS no_of_confirm_fit_nz, SUM(CASE WHEN vq.quotestage IN " . $confirmed_stages_sql_in . " AND vq.country = 'Australia' THEN COALESCE(vq.no_pax, 0) ELSE 0 END) AS no_of_pax_au, SUM(CASE WHEN vq.quotestage IN " . $confirmed_stages_sql_in . " AND vq.country = 'New Zealand' THEN COALESCE(vq.no_pax, 0) ELSE 0 END) AS no_of_pax_nz FROM " . $unique_quotes_subquery . " LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid WHERE vq.deleted = 0 " . $sql_external_sales_base_where . " AND (vqinfo.assigned_to_external_sales_agent IS NOT NULL AND vqinfo.assigned_to_external_sales_agent != '') GROUP BY person, region ORDER BY person, region";
    $result_external_sales = $conn->query($sql_external_sales);
    if ($result_external_sales) { while ($row = $result_external_sales->fetch_assoc()) {
        // Removed other/unknown calculations
        $external_sales_report_data[] = $row;
        }
    } // else { error_log("Error External Sales: " . $conn->error); }

    // --- Rejected Quotes Report Data ---
    // This report now respects the main filter, split by AU/NZ/Other for display logic
    if (!empty($rejected_stages_sql_in)) {
        $sql_rejected_quotes = "SELECT vq.quote_no, vq.quotestage, vq.subject AS description, vq.country, vqi.assigned_to_external_sales_agent, vqi.assigned_to_sales_agent FROM " . $unique_quotes_subquery . " LEFT JOIN vtiger_quotes_info vqi ON vq.quoteid = vqi.quoteid WHERE vq.deleted = 0 " . $sql_date_filter_component . $sql_where_for_vq_main_filter_component . " AND vq.quotestage IN " . $rejected_stages_sql_in . " ORDER BY vq.country, vq.quote_no";
        $result_rejected_quotes = $conn->query($sql_rejected_quotes);
        if ($result_rejected_quotes) {
            while ($row = $result_rejected_quotes->fetch_assoc()) {
                $is_group = (substr($row['quote_no'], -1) === 'G');
                $country_category_key = 'OTHER';
                if ($row['country'] == 'Australia') $country_category_key = 'AU'; elseif ($row['country'] == 'New Zealand') $country_category_key = 'NZ';
                $type_category_key = $is_group ? 'GROUP' : 'FIT';
                // Using the unique quoteid for a unique key, just in case quote_no is not strictly unique across all deleted/non-deleted
                 $rejected_quotes_data[$country_category_key . '_' . $type_category_key][] = $row; // Storing the row
            }
        } // else { error_log("Error Rejected Quotes: " . $conn->error); }
    }

    // --- Query & Confirmation Detail Report Data, Removed Other/Unknown ---
    // This report now respects the main filter
    $sql_query_confirmation = "SELECT COALESCE(vqi.assigned_to_region, 'Unknown Region') AS region, CASE WHEN vqi.assigned_to_sales_agent IS NOT NULL AND vqi.assigned_to_sales_agent <> '' THEN 'Internal' WHEN vqi.assigned_to_external_sales_agent IS NOT NULL AND vqi.assigned_to_external_sales_agent <> '' THEN 'External' ELSE 'Unassigned' END AS agent_type, COALESCE(vqi.assigned_to_sales_agent, vqi.assigned_to_external_sales_agent, 'Unassigned') AS agent_name, vq.country, COUNT(vq.quoteid) AS total_queries, SUM(CASE WHEN vq.quotestage IN " . $confirmed_stages_sql_in . " THEN 1 ELSE 0 END) AS total_confirmations FROM " . $unique_quotes_subquery . " LEFT JOIN vtiger_quotes_info vqi ON vq.quoteid = vqi.quoteid WHERE vq.deleted = 0 " . $sql_where_for_vq . " GROUP BY region, agent_type, agent_name, vq.country ORDER BY region, agent_type, agent_name, vq.country";
    $result_query_confirmation = $conn->query($sql_query_confirmation);
    if ($result_query_confirmation) {
        while ($row = $result_query_confirmation->fetch_assoc()) {
            $region = $row['region']; $agent_type = $row['agent_type']; $agent_name = ($row['agent_name'] === '') ? 'Unassigned' : $row['agent_name'];
            // Only process if country is AU or NZ
            if ($row['country'] == 'Australia') $country_key = 'AU'; elseif ($row['country'] == 'New Zealand') $country_key = 'NZ'; else continue; // Skip other/unknown countries
            if (!in_array($region, $available_regions_for_filter, true)) { $available_regions_for_filter[] = $region; }
            if (!isset($query_confirmation_detail_data[$region])) $query_confirmation_detail_data[$region] = [];
            if (!isset($query_confirmation_detail_data[$region][$agent_type])) $query_confirmation_detail_data[$region][$agent_type] = [];
            if (!isset($query_confirmation_detail_data[$region][$agent_type][$agent_name])) { $query_confirmation_detail_data[$region][$agent_type][$agent_name] = [ 'AU' => ['queries' => 0, 'confirmations' => 0], 'NZ' => ['queries' => 0, 'confirmations' => 0] ]; } // Removed other/unknown
            $query_confirmation_detail_data[$region][$agent_type][$agent_name][$country_key]['queries'] += (int)$row['total_queries'];
            $query_confirmation_detail_data[$region][$agent_type][$agent_name][$country_key]['confirmations'] += (int)$row['total_confirmations'];
        }
        if (!empty($available_regions_for_filter)) { sort($available_regions_for_filter); }
    } // else { error_log("Error Query & Confirmation Detail: " . $conn->error); }

     // --- NEW: Month-Wise Report Data with Priority Breakdown (Respects Main Filter), Removed Other/Unknown ---
     $sql_month_wise_priority_counts_query = "SELECT
        COALESCE(vqinfo.assigned_to_region, 'Unknown') AS region,
        DATE_FORMAT(vq.created_at, '%Y-%m') AS quote_month,
        vq.country,
        COALESCE(vqinfo.priority, 'blank') AS priority,
        COUNT(vq.quoteid) AS priority_count
    FROM " . $unique_quotes_subquery . "
    LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
    WHERE vq.deleted = 0 " . $sql_where_for_vq . " -- Applies main filter and date filter
    AND (vq.country = 'Australia' OR vq.country = 'New Zealand') -- Only include AU and NZ
    GROUP BY region, quote_month, vq.country, priority
    ORDER BY region, quote_month, vq.country, priority";

     $result_month_wise_priority_counts = $conn->query($sql_month_wise_priority_counts_query);

    // Initialize data structures for month-wise report
    $month_wise_priority_counts = []; // region -> month -> country -> priority -> count
    $month_wise_period_totals = []; // region -> country -> total
    $report_months = []; // list of months

     if ($result_month_wise_priority_counts) {
         while ($row = $result_month_wise_priority_counts->fetch_assoc()) {
             $region = $row['region'];
             $month = $row['quote_month'];
             $country = $row['country'];
             $priority = $row['priority'];
             $count = (int)$row['priority_count'];

             // Build the nested priority counts structure
             if (!isset($month_wise_priority_counts[$region])) $month_wise_priority_counts[$region] = [];
             if (!isset($month_wise_priority_counts[$region][$month])) $month_wise_priority_counts[$region][$month] = [];
             if (!isset($month_wise_priority_counts[$region][$month][$country])) $month_wise_priority_counts[$region][$month][$country] = ['high' => 0, 'low' => 0, 'blank' => 0, 'not connected' => 0, 'total' => 0];

             $month_wise_priority_counts[$region][$month][$country][$priority] += $count;
             $month_wise_priority_counts[$region][$month][$country]['total'] += $count;

             // Accumulate period totals
             if (!isset($month_wise_period_totals[$region])) $month_wise_period_totals[$region] = ['Australia' => 0, 'New Zealand' => 0];
             $month_wise_period_totals[$region][$country] += $count;

             // Collect unique months for the header
             if (!in_array($month, $report_months)) {
                 $report_months[] = $month;
             }
         }
         sort($report_months); // Ensure months are in chronological order
     } // else { error_log("Error Month-Wise Priority Counts: " . $conn->error); }


     // --- NEW: Key Agents for Month-Wise Report (Respects Main Filter), Removed Other/Unknown ---
     $sql_key_agents = "SELECT
        COALESCE(vqinfo.assigned_to_region, 'Unknown') AS region,
        o.organization_name AS key_agent_name
    FROM " . $unique_quotes_subquery . "
    LEFT JOIN vtiger_quotes_info vqinfo ON vq.quoteid = vqinfo.quoteid
    LEFT JOIN tdu_contacts c ON c.auto_id = vq.contactid
    LEFT JOIN tdu_organisation o ON o.organizationid = c.organizationid
    WHERE
        vq.deleted = 0
        " . $sql_where_for_vq . " -- Applies main filter and date filter
        AND o.preferred = 1
        AND (vq.country = 'Australia' OR vq.country = 'New Zealand') -- Only include AU and NZ for key agents
        AND o.organization_name IS NOT NULL AND o.organization_name != '' -- Ensure organization name exists
    GROUP BY region, key_agent_name -- Group to get unique agent names per region
    ORDER BY region, key_agent_name";

     $result_key_agents = $conn->query($sql_key_agents);
     if ($result_key_agents) {
         while ($row = $result_key_agents->fetch_assoc()) {
             $region = $row['region'];
             if (!isset($key_agents_list[$region])) {
                 $key_agents_list[$region] = [];
             }
             $key_agents_list[$region][] = $row['key_agent_name'];
         }
     } // else { error_log("Error Key Agents: " . $conn->error); }

     // Collect all regions from both month counts and key agents for display
    $all_regions = array_unique(array_merge(array_keys($month_wise_priority_counts), array_keys($key_agents_list), array_keys($month_wise_period_totals)));
    sort($all_regions);


}
// --- END: SALES REPORT PHP LOGIC ---
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <title>TDU Dashboard</title>
    <style>


        /* --- Sales Report Specific Styles (prefixed with sr-) --- */
        .sr-page-wrapper { padding: 20px; background-color: #f4f7f6; /* Main container for report content below header */ }
        .sr-filter-container { padding: 15px; border: 1px solid #ddd; border-radius: 5px; margin-bottom: 20px; background-color: #fff; box-shadow: 0 2px 4px rgba(0,0,0,0.05); display: flex; flex-wrap: wrap; gap: 15px; align-items: flex-end; }
        .sr-filter-container h2 { color: #007bff; margin-bottom: 0px; margin-right: 15px; font-size: 1.5em; align-self: center;}
        .sr-internal-tab-filters { padding: 15px; border: 1px solid #ddd; border-radius: 5px; margin-bottom: 20px; background-color: #f9f9f9; box-shadow: 0 1px 3px rgba(0,0,0,0.05); display: flex; flex-wrap: wrap; gap: 15px; align-items: flex-end; }
        .sr-form-group { margin-bottom: 0; }
        .sr-form-group label { display: block; margin-bottom: 5px; font-weight: bold; font-size: 0.9em; }
        .sr-form-group input[type="text"], .sr-form-group select { width: 200px; padding: 8px; border: 1px solid #ccc; border-radius: 4px; box-sizing: border-box; font-size:0.9em; }
        .sr-form-group input[type="submit"], .sr-internal-tab-filters button { padding: 8px 15px; background-color: #007bff; color: white; border: none; border-radius: 4 intimensionspx; cursor: pointer; font-size: 0.9em; height: 35px; line-height: normal; }
        .sr-form-group input[type="submit"]:hover, .sr-internal-tab-filters button:hover { background-color: #0056b3; }
        .sr-report-table { width: 100%; margin-top: 10px; border-collapse: collapse; background-color: #fff; box-shadow: 0 2px 4px rgba(0,0,0,0.05); }
        .sr-report-table th, .sr-report-table td { border: 1px solid #ddd; padding: 8px 10px; text-align: left; font-size:0.85em; vertical-align: top; }
        .sr-report-table th { background-color: #e9ecef; color: #495057; font-weight: bold; }
        .sr-report-table tfoot td { font-weight: bold; background-color: #f8f9fa; }
        .sr-report-table tbody tr:nth-child(even) { background-color: #fdfdfd; }
        .sr-report-table .sr-sub-metric td { padding-left: 25px !important; font-style: italic; font-size: 0.9em; }
        .sr-report-container h3 { color: #343a40; margin-top: 0; margin-bottom: 15px; border-bottom: 2px solid #007bff; padding-bottom: 5px;}
        h4.sr-report-subsection-heading { margin-top: 20px; margin-bottom: 5px; color: #0056b3; font-size: 1.1em; padding: 5px; background-color: #f0f0f0; border-left: 3px solid #0056b3;}
        h5.sr-report-agent-type-heading { margin-top: 15px; margin-bottom: 3px; color: #17a2b8; font-size: 1.05em; padding-left:10px; }
        h6.sr-report-agent-heading { margin-top: 10px; margin-bottom: 3px; color: #28a745; font-size: 1em; padding-left:20px; }
        .sr-report-container { padding: 20px; border: 1px solid #ddd; border-radius: 5px; margin-bottom: 20px; background-color: #fff; box-shadow: 0 2px 4px rgba(0,0,0,0.1); overflow-x: auto; }
        .sr-tab-container { width: 100%; margin-top: 20px; }
        .sr-tab-buttons { overflow: hidden; border: 1px solid #dee2e6; background-color: #f8f9fa; border-radius: 5px 5px 0 0; }
        .sr-tab-buttons button { background-color: inherit; float: left; border: none; outline: none; cursor: pointer; padding: 9px 12px; transition: 0.3s; font-size: 12.5px; color: #007bff; border-right: 1px solid #dee2e6; }
        .sr-tab-buttons button:last-child { border-right: none; }
        .sr-tab-buttons button:hover { background-color: #e9ecef; }
        .sr-tab-buttons button.sr-tab-active { background-color: #007bff; color: white; border-bottom: 2px solid #0056b3; }
        .sr-tab-content { display: none; padding: 0; border: 1px solid #dee2e6; border-top: none; background-color: #fff; border-radius: 0 0 5px 5px;}
        .sr-tab-content .sr-report-container { border: none; box-shadow: none; margin-bottom: 0; border-radius: 0; }
        .sr-note { font-size: 0.9em; color: #666; margin-bottom:10px; }
        .sr-empty-subsection, .sr-no-data-message { margin-top:10px; font-style: italic; color: #777; padding: 10px;}
        .sr-agent-country-table { margin-left: 25px; margin-bottom: 15px; width: calc(100% - 25px); }
        .sr-agent-country-table th, .sr-agent-country-table td { font-size: 0.95em; }
        .sr-total-row td {font-weight: bold; background-color: #f8f9fa;}
        .sr-region-block, .sr-agent-type-block, .sr-agent-block { margin-bottom: 10px; }

        /* Styles for clickable headings */
        .sr-clickable-heading {
            cursor: pointer;
            user-select: none; /* Prevent text selection on click */
            position: relative; /* Needed for pseudo-element positioning */
            padding-right: 20px; /* Make space for caret */
        }
        .sr-clickable-heading::after {
            content: '\25BC'; /* Down caret */
            position: absolute;
            right: 5px;
            top: 50%;
            transform: translateY(-50%);
            transition: transform 0.2s ease;
        }
        .sr-clickable-heading.collapsed::after {
            content: '\25B6'; /* Right caret */
             transform: translateY(-50%); /* No rotation needed for right caret */
        }
         .sr-rejected-section .sr-report-table {
             /* Optionally add top margin if needed after heading */
             margin-top: 10px;
         }
          /* Month-Wise specific styles */
         .sr-month-wise-table th {
            vertical-align: middle;
            text-align: center;
         }
          .sr-month-wise-table th.sr-monthly-header {
             min-width: 80px; /* Give month headers some space */
          }
         .sr-month-wise-table th[rowspan="2"] {
             vertical-align: bottom;
         }
         .sr-month-wise-table td {
             text-align: right;
         }
         .sr-month-wise-table td:first-child {
             text-align: left;
         }
         .sr-month-wise-table td:last-child {
             text-align: left;
             font-size: 0.8em;
         }
         .sr-month-wise-table .sr-monthly-priority-header th {
             font-weight: normal; /* Sub-headers less bold */
             font-size: 0.8em;
             padding: 5px 3px;
         }
         .sr-month-wise-table .sr-monthly-priority-data td {
              font-size: 0.8em;
              padding: 5px 3px;
         }

    </style>
</head>
<body>


<div class="sr-page-wrapper">
    <div class="sr-filter-container">
        <h2>Sales Quote Report Filter</h2>
        <form method="POST" action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>">
            <div class="sr-form-group">
                <label for="sr-create_date_range">Quote Creation Date Range:</label>
                <input type="text" id="sr-create_date_range" name="create_date_range" value="<?php echo htmlspecialchars($create_date_range_str); ?>" required placeholder="Select date range">
            </div>
            <div class="sr-form-group">
                <label for="sr-quote_type">Quote Type (Overall Filter):</label>
                <select id="sr-quote_type" name="quote_type">
                    <option value="" <?php if ($quote_type_filter == '') echo 'selected'; ?>>All (FIT & Group)</option>
                    <option value="fit-dashboard" <?php if ($quote_type_filter == 'fit-dashboard') echo 'selected'; ?>>FIT Dashboard Only</option>
                    <option value="group" <?php if ($quote_type_filter == 'group') echo 'selected'; ?>>Group Only</option>
                </select>
            </div>
            <div class="sr-form-group">
                <input type="submit" value="Generate Report">
            </div>
        </form>
    </div>

    <?php if (!empty($start_date) && !empty($end_date)): // Ensure dates are valid after processing ?>
        <div class="sr-tab-container">
            <div class="sr-tab-buttons">
                <button class="sr-tab-link sr-tab-active" onclick="openReport(event, 'sr-OverallReport')">Overall Conv.</button>
                <button class="sr-tab-link" onclick="openReport(event, 'sr-RegionReport')">Region-wise</button>
                 <!-- NEW MONTH-WISE TAB -->
                 <button class="sr-tab-link" onclick="openReport(event, 'sr-MonthWiseReport')">Month-Wise</button>
                <button class="sr-tab-link" onclick="openReport(event, 'sr-QueryConfirmationDetailReport')">Query & Conf. Detail</button>
                 <!-- CONSOLIDATED LIVE TAB -->
                <button class="sr-tab-link" onclick="openReport(event, 'sr-LiveQueries')">Live Queries</button>
                 <!-- CONSOLIDATED PRIORITY TAB -->
                <button class="sr-tab-link" onclick="openReport(event, 'sr-ConsolidatedPriority')">Priority Report</button>

                <button class="sr-tab-link" onclick="openReport(event, 'sr-ExternalSalesReport')">External Sales</button>
                <button class="sr-tab-link" onclick="openReport(event, 'sr-RejectedQuotesReport')">Rejected Quotes</button>
            </div>

            <div id="sr-OverallReport" class="sr-tab-content" style="display: block;">
                <div class="sr-report-container">
                    <h3>Overall Conversion Report (<?php echo htmlspecialchars($start_date); ?> to <?php echo htmlspecialchars($end_date); ?>)</h3>
                    <p class="sr-note"><strong>Quote Type Filter Applied:</strong> <?php echo ($quote_type_filter == 'fit-dashboard') ? 'FIT Only' : (($quote_type_filter == 'group') ? 'Group Only' : 'All'); ?></p>
                    <table class="sr-report-table">
                        <thead><tr><th>Metric</th><th>Value</th></tr></thead>
                        <tbody>
                            <tr><td>Total Quotes</td><td><?php echo $total_quotes; ?></td></tr>
                            <tr class="sr-sub-metric"><td>  - AU Quotes</td><td><?php echo $total_au_quotes; ?></td></tr>
                            <tr class="sr-sub-metric"><td>  - NZ Quotes</td><td><?php echo $total_nz_quotes; ?></td></tr>
                            <tr><td>Confirmed Quotes</td><td><?php echo $confirmed_quotes; ?></td></tr>
                            <tr class="sr-sub-metric"><td>  - Confirmed AU Quotes</td><td><?php echo $confirmed_au_quotes; ?></td></tr>
                            <tr class="sr-sub-metric"><td>  - Confirmed NZ Quotes</td><td><?php echo $confirmed_nz_quotes; ?></td></tr>
                            <tr><td>Overall Conversion Rate</td><td><?php echo number_format($conversion_rate, 2); ?>%</td></tr>
                            <tr class="sr-sub-metric"><td>  - Conversion Rate AU</td><td><?php echo number_format($conversion_rate_au, 2); ?>%</td></tr>
                            <tr class="sr-sub-metric"><td>  - Conversion Rate NZ</td><td><?php echo number_format($conversion_rate_nz, 2); ?>%</td></tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div id="sr-RegionReport" class="sr-tab-content">
                 <div class="sr-report-container">
                    <?php if (!empty($region_data)): ?>
                        <h3>Region-wise Conversion Report (<?php echo htmlspecialchars($start_date); ?> to <?php echo htmlspecialchars($end_date); ?>)</h3>
                        <p class="sr-note"><strong>Quote Type Filter Applied:</strong> <?php echo ($quote_type_filter == 'fit-dashboard') ? 'FIT Only' : (($quote_type_filter == 'group') ? 'Group Only' : 'All'); ?>. Region from quote info.</p>
                        <table class="sr-report-table">
                            <thead>
                                <tr><th rowspan="2">Region</th><th colspan="3">Overall</th><th colspan="3">Australia</th><th colspan="3">New Zealand</th></tr>
                                <tr><th>Total Q.</th><th>Conf. Q.</th><th>Conv. %</th><th>Total Q.</th><th>Conf. Q.</th><th>Conv. %</th><th>Total Q.</th><th>Conf. Q.</th><th>Conv. %</th></tr>
                            </thead>
                            <tbody>
                                <?php foreach ($region_data as $region => $data_item_region): ?>
                                <tr><td><?php echo htmlspecialchars($region); ?></td><td><?php echo $data_item_region['total']; ?></td><td><?php echo $data_item_region['confirmed']; ?></td><td><?php echo number_format($data_item_region['conversion'], 2); ?>%</td><td><?php echo $data_item_region['total_au']; ?></td><td><?php echo $data_item_region['confirmed_au']; ?></td><td><?php echo number_format($data_item_region['conversion_au'], 2); ?>%</td><td><?php echo $data_item_region['total_nz']; ?></td><td><?php echo $data_item_region['confirmed_nz']; ?></td><td><?php echo number_format($data_item_region['conversion_nz'], 2); ?>%</td></tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot>
                                <tr class="sr-total-row"><td>Total</td><td><?php echo $region_report_total_queries; ?></td><td><?php echo $region_report_total_confirmed; ?></td><td><?php echo number_format($region_report_overall_conversion, 2); ?>%</td><td><?php echo $region_report_total_queries_au; ?></td><td><?php echo $region_report_total_confirmed_au; ?></td><td><?php echo number_format($region_report_overall_conversion_au, 2); ?>%</td><td><?php echo $region_report_total_queries_nz; ?></td><td><?php echo $region_report_total_confirmed_nz; ?></td><td><?php echo number_format($region_report_overall_conversion_nz, 2); ?>%</td></tr>
                            </tfoot>
                        </table>
                    <?php else: ?><h3>Region-wise Conversion Report</h3><p class="sr-no-data-message">No regional data found for the selected criteria.</p><?php endif; ?>
                </div>
            </div>

            <!-- NEW MONTH-WISE REPORT CONTENT -->
            <div id="sr-MonthWiseReport" class="sr-tab-content">
                 <div class="sr-report-container">
                     <h3>Month-Wise Query Report (<?php echo htmlspecialchars($start_date); ?> to <?php echo htmlspecialchars($end_date); ?>)</h3>
                     <p class="sr-note"><strong>Quote Type Filter Applied:</strong> <?php echo ($quote_type_filter == 'fit-dashboard') ? 'FIT Only' : (($quote_type_filter == 'group') ? 'Group Only' : 'All'); ?>. Shows AU and NZ quotes by month, region, and priority. Key Agents are from 'preferred' organizations matching the filters.</p>
                     <?php if (!empty($all_regions) && !empty($report_months)): // Ensure there are regions and months to display ?>
                     <table class="sr-report-table sr-month-wise-table">
                         <thead>
                             <tr>
                                 <th rowspan="2">Region</th>
                                 <th colspan="2">Total for Period</th>
                                 <?php foreach ($report_months as $month_year): ?>
                                     <th colspan="5" class="sr-monthly-header"><?php echo htmlspecialchars(date('M Y', strtotime($month_year . '-01'))); ?></th>
                                 <?php endforeach; ?>
                                 <th rowspan="2">Key Agents</th>
                             </tr>
                             <tr class="sr-monthly-priority-header">
                                 <th>AU</th>
                                 <th>NZ</th>
                                 <?php foreach ($report_months as $month_year): ?>
                                      <th>Total</th><th>High</th><th>Low</th><th>Blank</th><th>Not Conn.</th>
                                 <?php endforeach; ?>
                             </tr>
                         </thead>
                         <tbody>
                              <?php
                              $grand_total_au_period = 0;
                              $grand_total_nz_period = 0;
                              $monthly_grand_totals = array_fill_keys($report_months, ['total' => 0, 'high' => 0, 'low' => 0, 'blank' => 0, 'not connected' => 0]); // Initialize monthly grand totals per priority

                              foreach ($all_regions as $region):
                                   $region_period_totals = $month_wise_period_totals[$region] ?? ['Australia' => 0, 'New Zealand' => 0];
                                   $region_key_agents = $key_agents_list[$region] ?? [];
                                   $key_agents_str = implode(', ', $region_key_agents);

                                   $grand_total_au_period += $region_period_totals['Australia'];
                                   $grand_total_nz_period += $region_period_totals['New Zealand'];
                             ?>
                             <tr>
                                 <td><?php echo htmlspecialchars($region); ?></td>
                                 <td><?php echo $region_period_totals['Australia']; ?></td>
                                 <td><?php echo $region_period_totals['New Zealand']; ?></td>
                                 <?php foreach ($report_months as $month_year):
                                     // Sum priority counts for this region and month across AU and NZ
                                     $monthly_region_total = 0;
                                     $monthly_region_priority = ['high' => 0, 'low' => 0, 'blank' => 0, 'not connected' => 0];

                                     foreach(['Australia', 'New Zealand'] as $country) {
                                         $monthly_region_total += $month_wise_priority_counts[$region][$month_year][$country]['total'] ?? 0;
                                         $monthly_region_priority['high'] += $month_wise_priority_counts[$region][$month_year][$country]['high'] ?? 0;
                                         $monthly_region_priority['low'] += $month_wise_priority_counts[$region][$month_year][$country]['low'] ?? 0;
                                         $monthly_region_priority['blank'] += $month_wise_priority_counts[$region][$month_year][$country]['blank'] ?? 0;
                                         $monthly_region_priority['not connected'] += $month_wise_priority_counts[$region][$month_year][$country]['not connected'] ?? 0;
                                     }

                                     // Add to monthly grand totals
                                     $monthly_grand_totals[$month_year]['total'] += $monthly_region_total;
                                     $monthly_grand_totals[$month_year]['high'] += $monthly_region_priority['high'];
                                     $monthly_grand_totals[$month_year]['low'] += $monthly_region_priority['low'];
                                     $monthly_grand_totals[$month_year]['blank'] += $monthly_region_priority['blank'];
                                     $monthly_grand_totals[$month_year]['not connected'] += $monthly_region_priority['not connected'];

                                 ?>
                                      <td class="sr-monthly-priority-data"><?php echo $monthly_region_total; ?></td>
                                      <td class="sr-monthly-priority-data"><?php echo $monthly_region_priority['high']; ?></td>
                                      <td class="sr-monthly-priority-data"><?php echo $monthly_region_priority['low']; ?></td>
                                      <td class="sr-monthly-priority-data"><?php echo $monthly_region_priority['blank']; ?></td>
                                      <td class="sr-monthly-priority-data"><?php echo $monthly_region_priority['not connected']; ?></td>
                                 <?php endforeach; ?>
                                 <td><?php echo htmlspecialchars($key_agents_str); ?></td>
                             </tr>
                             <?php endforeach; ?>
                         </tbody>
                         <tfoot>
                             <tr class="sr-total-row">
                                 <td><strong>Total</strong></td>
                                 <td><strong><?php echo $grand_total_au_period; ?></strong></td>
                                 <td><strong><?php echo $grand_total_nz_period; ?></strong></td>
                                 <?php foreach ($report_months as $month_year): ?>
                                      <td><strong><?php echo $monthly_grand_totals[$month_year]['total']; ?></strong></td>
                                      <td><strong><?php echo $monthly_grand_totals[$month_year]['high']; ?></strong></td>
                                      <td><strong><?php echo $monthly_grand_totals[$month_year]['low']; ?></strong></td>
                                      <td><strong><?php echo $monthly_grand_totals[$month_year]['blank']; ?></strong></td>
                                      <td><strong><?php echo $monthly_grand_totals[$month_year]['not connected']; ?></strong></td>
                                 <?php endforeach; ?>
                                  <td></td> <!-- Empty cell for Key Agents total -->
                             </tr>
                         </tfoot>
                     </table>
                     <?php else: ?>
                          <p class="sr-no-data-message">No month-wise query data found for the selected date range and criteria.</p>
                     <?php endif; ?>
                 </div>
            </div>


            <div id="sr-QueryConfirmationDetailReport" class="sr-tab-content">
                <div class="sr-report-container">
                    <h3>Query & Confirmation Detail (<?php echo htmlspecialchars($start_date); ?> to <?php echo htmlspecialchars($end_date); ?>)</h3>
                    <p class="sr-note"><strong>Main Quote Type Filter Applied:</strong> <?php echo ($quote_type_filter == 'fit-dashboard') ? 'FIT Only' : (($quote_type_filter == 'group') ? 'Group Only' : 'All'); ?></p>
                    <div class="sr-internal-tab-filters">
                        <div class="sr-form-group"><label for="sr-qcdFilterRegion">Filter by Region:</label><select id="sr-qcdFilterRegion" onchange="applyQueryConfirmationFilters()"><option value="">All Regions</option><?php foreach ($available_regions_for_filter as $region_filter_option): ?><option value="<?php echo htmlspecialchars($region_filter_option); ?>"><?php echo htmlspecialchars($region_filter_option); ?></option><?php endforeach; ?></select></div>
                        <div class="sr-form-group"><label for="sr-qcdFilterAgentType">Filter by Agent Type:</label><select id="sr-qcdFilterAgentType" onchange="applyQueryConfirmationFilters()"><option value="">All Types</option><option value="Internal">Internal</option><option value="External">External</option><option value="Unassigned">Unassigned</option></select></div>
                        <div class="sr-form-group"><label for="sr-qcdFilterAgentName">Filter by Agent Name:</label><input type="text" id="sr-qcdFilterAgentName" onkeyup="applyQueryConfirmationFilters()" placeholder="Enter agent name..."></div>
                    </div>
                    <div id="sr-qcdReportData">
                    <?php if (!empty($query_confirmation_detail_data)): ?>
                        <?php foreach ($query_confirmation_detail_data as $region_name => $agent_types): ?>
                            <div class="sr-region-block" data-region="<?php echo htmlspecialchars($region_name); ?>">
                                <h4 class="sr-report-subsection-heading"><?php echo htmlspecialchars($region_name); ?></h4>
                                <?php foreach ($agent_types as $agent_type_name => $agents): ?>
                                    <div class="sr-agent-type-block" data-agent-type="<?php echo htmlspecialchars($agent_type_name); ?>">
                                        <h5 class="sr-report-agent-type-heading"><?php echo htmlspecialchars($agent_type_name); ?> Agents</h5>
                                        <?php if (empty($agents)): ?><p class="sr-empty-subsection">No data for <?php echo htmlspecialchars($agent_type_name); ?> agents in this region.</p>
                                        <?php else: ?>
                                            <?php foreach ($agents as $agent_name_val => $countries): ?>
                                                <div class="sr-agent-block" data-agent-name="<?php echo htmlspecialchars(strtolower($agent_name_val)); ?>">
                                                    <h6 class="sr-report-agent-heading"><?php echo htmlspecialchars($agent_name_val); ?></h6>
                                                    <table class="sr-report-table sr-agent-country-table">
                                                        <thead><tr><th>Country</th><th>Queries</th><th>Confirmations</th><th>Conversion %</th></tr></thead>
                                                        <tbody>
                                                            <?php $agent_total_queries = 0; $agent_total_confirmations = 0; $country_display_map = ['AU' => 'Australia', 'NZ' => 'New Zealand']; // Removed other/unknown
                                                            foreach (['AU', 'NZ'] as $country_code) { // Loop only AU and NZ
                                                                $data = $countries[$country_code];
                                                                // Only show row if there are queries or confirmations
                                                                if ($data['queries'] > 0 || $data['confirmations'] > 0) {
                                                                    $conversion = ($data['queries'] > 0) ? ($data['confirmations'] / $data['queries']) * 100 : 0;
                                                                    echo "<tr><td>" . htmlspecialchars($country_display_map[$country_code]) . "</td><td>" . $data['queries'] . "</td><td>" . $data['confirmations'] . "</td><td>" . number_format($conversion, 2) . "%</td></tr>";
                                                                    $agent_total_queries += $data['queries']; $agent_total_confirmations += $data['confirmations'];
                                                                }
                                                            } $agent_total_conversion = ($agent_total_queries > 0) ? ($agent_total_confirmations / $agent_total_queries) * 100 : 0; ?>
                                                        </tbody>
                                                        <tfoot>
                                                            <?php if ($agent_total_queries > 0 || $agent_total_confirmations > 0): // Only show agent total if there's data ?>
                                                            <tr class="sr-total-row"><td>Agent Total</td><td><?php echo $agent_total_queries; ?></td><td><?php echo $agent_total_confirmations; ?></td><td><?php echo number_format($agent_total_conversion, 2); ?>%</td></tr>
                                                            <?php endif; ?>
                                                        </tfoot>
                                                    </table>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?><p class="sr-no-data-message">No detailed query and confirmation data found for the selected criteria and main filter.</p><?php endif; ?>
                    </div>
                    <p class="sr-no-data-message" id="sr-qcdNoFilterMatchMessage" style="display:none;">No data matches the current filter criteria.</p>
                </div>
            </div>

            <!-- CONSOLIDATED LIVE QUERIES TAB CONTENT -->
             <div id="sr-LiveQueries" class="sr-tab-content">
                <div class="sr-report-container">
                    <?php if (!empty($live_queries_data)): ?>
                        <h3>Live Queries (<?php echo htmlspecialchars($start_date); ?> to <?php echo htmlspecialchars($end_date); ?>)</h3>
                        <p class="sr-note"><strong>Quote Type Filter Applied:</strong> <?php echo ($quote_type_filter == 'fit-dashboard') ? 'FIT Only' : (($quote_type_filter == 'group') ? 'Group Only' : 'All'); ?>. Shows AU and NZ quotes in 'Created' or 'Requote' stage.</p>
                        <table class="sr-report-table">
                            <thead><tr><th>Region</th><th>Total Queries</th><th>AU Queries</th><th>NZ Queries</th></tr></thead>
                            <tbody>
                                <?php $gt_live_queries = 0; $gt_live_au = 0; $gt_live_nz = 0;
                                foreach ($live_queries_data as $data_item):
                                    $gt_live_queries += (int)$data_item['total_queries'];
                                    $gt_live_au += (int)$data_item['au_queries'];
                                    $gt_live_nz += (int)$data_item['nz_queries']; ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($data_item['region']); ?></td>
                                    <td><?php echo (int)$data_item['total_queries']; ?></td>
                                    <td><?php echo (int)$data_item['au_queries']; ?></td>
                                    <td><?php echo (int)$data_item['nz_queries']; ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot><tr class="sr-total-row"><td><strong>Total</strong></td><td><strong><?php echo $gt_live_queries; ?></strong></td><td><strong><?php echo $gt_live_au; ?></strong></td><td><strong><?php echo $gt_live_nz; ?></strong></td></tr></tfoot>
                        </table>
                    <?php else: ?><h3>Live Queries</h3><p class="sr-no-data-message">No live query data found for the selected criteria.</p><?php endif; ?>
                </div>
            </div>

            <!-- CONSOLIDATED PRIORITY TAB CONTENT -->
            <div id="sr-ConsolidatedPriority" class="sr-tab-content">
                 <div class="sr-report-container">
                     <?php if (!empty($consolidated_priority_data)): ?>
                        <h3>Consolidated Priority Report (Internal & External Agents) (<?php echo htmlspecialchars($start_date); ?> to <?php echo htmlspecialchars($end_date); ?>)</h3>
                        <p class="sr-note"><strong>Quote Type Filter Applied:</strong> <?php echo ($quote_type_filter == 'fit-dashboard') ? 'FIT Only' : (($quote_type_filter == 'group') ? 'Group Only' : 'All'); ?>. Shows AU and NZ quotes assigned to either Internal or External agents.</p>
                         <table class="sr-report-table">
                            <thead>
                                <tr><th rowspan="2">Agent Type</th><th rowspan="2">Person</th><th rowspan="2">Region</th><th rowspan="2">Total Queries</th><th colspan="4">Australia Queries</th> <th colspan="4">New Zealand Queries</th></tr>
                                <tr><th>Total</th><th>High</th><th>Low</th><th>Blank/Not Conn.</th><th>Total</th><th>High</th><th>Low</th><th>Blank/Not Conn.</th></tr>
                            </thead>
                            <tbody>
                                <?php $gt_cp_queries = 0; $gt_cp_au = 0; $gt_cp_h_au = 0; $gt_cp_l_au = 0; $gt_cp_bnc_au = 0; $gt_cp_nz = 0; $gt_cp_h_nz = 0; $gt_cp_l_nz = 0; $gt_cp_bnc_nz = 0;
                                foreach ($consolidated_priority_data as $di):
                                    $total_bnc_au = (int)$di['blank_priority_au'] + (int)$di['not_connected_priority_au'];
                                    $total_bnc_nz = (int)$di['blank_priority_nz'] + (int)$di['not_connected_priority_nz'];

                                    $gt_cp_queries += (int)$di['total_queries_overall'];
                                    $gt_cp_au += (int)$di['total_queries_au']; $gt_cp_h_au += (int)$di['high_au']; $gt_cp_l_au += (int)$di['low_au']; $gt_cp_bnc_au += $total_bnc_au;
                                    $gt_cp_nz += (int)$di['total_queries_nz']; $gt_cp_h_nz += (int)$di['high_nz']; $gt_cp_l_nz += (int)$di['low_nz']; $gt_cp_bnc_nz += $total_bnc_nz;

                                ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($di['agent_type']); ?></td>
                                    <td><?php echo htmlspecialchars($di['person']); ?></td>
                                    <td><?php echo htmlspecialchars($di['region']); ?></td>
                                    <td><?php echo (int)$di['total_queries_overall']; ?></td>
                                    <td><?php echo (int)$di['total_queries_au']; ?></td><td><?php echo (int)$di['high_au']; ?></td><td><?php echo (int)$di['low_au']; ?></td><td><?php echo $total_bnc_au; ?></td>
                                    <td><?php echo (int)$di['total_queries_nz']; ?></td><td><?php echo (int)$di['high_nz']; ?></td><td><?php echo (int)$di['low_nz']; ?></td><td><?php echo $total_bnc_nz; ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                             <tfoot>
                                <tr class="sr-total-row">
                                    <td colspan="3"><strong>Total</strong></td>
                                    <td><strong><?php echo $gt_cp_queries; ?></strong></td>
                                    <td><strong><?php echo $gt_cp_au; ?></strong></td><td><strong><?php echo $gt_cp_h_au; ?></strong></td><td><strong><?php echo $gt_cp_l_au; ?></strong></td><td><strong><?php echo $gt_cp_bnc_au; ?></strong></td>
                                    <td><strong><?php echo $gt_cp_nz; ?></strong></td><td><strong><?php echo $gt_cp_h_nz; ?></strong></td><td><strong><?php echo $gt_cp_l_nz; ?></strong></td><td><strong><?php echo $gt_cp_bnc_nz; ?></strong></td>
                                </tr>
                            </tfoot>
                        </table>
                    <?php else: ?><h3>Consolidated Priority Report (Internal & External Agents)</h3><p class="sr-no-data-message">No consolidated priority data found for the selected criteria.</p><?php endif; ?>
                </div>
            </div>

            <div id="sr-ExternalSalesReport" class="sr-tab-content">
                <div class="sr-report-container">
                    <?php if (!empty($external_sales_report_data)): ?>
                        <h3>External Sales Report (<?php echo htmlspecialchars($start_date); ?> to <?php echo htmlspecialchars($end_date); ?>)</h3>
                        <p class="sr-note">Shows activity for assigned External Sales Agents. Ignores main FIT/Group filter.</p>
                        <table class="sr-report-table">
                            <thead>
                                <tr><th rowspan="2">External Sales Person</th><th rowspan="2">Region</th><th colspan="2">No of Inquiries</th> <th colspan="2">No of Confirm Groups</th><th colspan="2">No of Confirm FIT</th> <th colspan="2">No of Pax (Confirmed)</th></tr>
                                <tr><th>AU</th><th>NZ</th> <th>AU</th><th>NZ</th><th>AU</th><th>NZ</th> <th>AU</th><th>NZ</th></tr>
                            </thead>
                            <tbody>
                                <?php $tot_ext_inq_au = 0; $tot_ext_inq_nz = 0; $tot_ext_cg_au = 0; $tot_ext_cg_nz = 0; $tot_ext_cf_au = 0; $tot_ext_cf_nz = 0; $tot_ext_pax_au = 0; $tot_ext_pax_nz = 0;
                                foreach ($external_sales_report_data as $di):
                                    $tot_ext_inq_au += (int)$di['no_of_inquiries_au']; $tot_ext_inq_nz += (int)$di['no_of_inquiries_nz'];
                                    $tot_ext_cg_au += (int)$di['no_of_confirm_groups_au']; $tot_ext_cg_nz += (int)$di['no_of_confirm_groups_nz'];
                                    $tot_ext_cf_au += (int)$di['no_of_confirm_fit_au']; $tot_ext_cf_nz += (int)$di['no_of_confirm_fit_nz'];
                                    $tot_ext_pax_au += (int)$di['no_of_pax_au']; $tot_ext_pax_nz += (int)$di['no_of_pax_nz'];
                                ?>
                                <tr><td><?php echo htmlspecialchars($di['person']); ?></td><td><?php echo htmlspecialchars($di['region']); ?></td><td><?php echo (int)$di['no_of_inquiries_au']; ?></td><td><?php echo (int)$di['no_of_inquiries_nz']; ?></td><td><?php echo (int)$di['no_of_confirm_groups_au']; ?></td><td><?php echo (int)$di['no_of_confirm_groups_nz']; ?></td><td><?php echo (int)$di['no_of_confirm_fit_au']; ?></td><td><?php echo (int)$di['no_of_confirm_fit_nz']; ?></td><td><?php echo (int)$di['no_of_pax_au']; ?></td><td><?php echo (int)$di['no_of_pax_nz']; ?></td></tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot>
                                <tr class="sr-total-row"><td colspan="2"><strong>Total</strong></td><td><strong><?php echo $tot_ext_inq_au; ?></strong></td><td><strong><?php echo $tot_ext_inq_nz; ?></strong></td><td><strong><?php echo $tot_ext_cg_au; ?></strong></td><td><strong><?php echo $tot_ext_cg_nz; ?></strong></td><td><strong><?php echo $tot_ext_cf_au; ?></strong></td><td><strong><?php echo $tot_ext_cf_nz; ?></strong></td><td><strong><?php echo $tot_ext_pax_au; ?></strong></td><td><strong><?php echo $tot_ext_pax_nz; ?></strong></td></tr>
                            </tfoot>
                        </table>
                    <?php else: ?><h3>External Sales Report</h3><p class="sr-no-data-message">No external sales data found for the selected criteria.</p><?php endif; ?>
                </div>
            </div>

            <div id="sr-RejectedQuotesReport" class="sr-tab-content">
                <div class="sr-report-container">
                    <h3>Rejected Quotes (<?php echo htmlspecialchars($start_date); ?> to <?php echo htmlspecialchars($end_date); ?>)</h3>
                    <p class="sr-note"><strong>Quote Type Filter Applied:</strong> <?php echo ($quote_type_filter == 'fit-dashboard') ? 'FIT Only' : (($quote_type_filter == 'group') ? 'Group Only' : 'All'); ?>. Click on a title to expand/collapse the table.</p>
                    <?php $country_map_rej = ['AU' => 'Australia', 'NZ' => 'New Zealand']; // Removed 'OTHER'
                     $type_map_rej = ['FIT' => 'FIT Quotes', 'GROUP' => 'Group Quotes']; $has_any_rejected_data = false;
                    foreach ($country_map_rej as $ck => $cn) {
                        foreach ($type_map_rej as $tk => $tn) {
                            // Access the correct key, including 'OTHER' for backward compatibility with data structure if needed, but only display AU/NZ sections
                            $data_key = $ck . '_' . $tk;
                            $data_subset = $rejected_quotes_data[$data_key] ?? [];

                            // Generate a unique ID for the section
                            $section_id = 'rejected-' . strtolower($ck) . '-' . strtolower($tk);

                            // Only show section if it's AU or NZ country category
                            if (($ck == 'AU' || $ck == 'NZ') && !empty($data_subset)) {
                                $has_any_rejected_data = true;
                                // Wrap heading and table in a div for easy toggling
                                echo "<div class='sr-rejected-section' id='sr-{$section_id}'>";
                                echo "<h4 class='sr-report-subsection-heading sr-clickable-heading'>" . htmlspecialchars($cn . " - " . $tn) . " (" . count($data_subset) . ")</h4>";
                                echo "<table class='sr-report-table'><thead><tr><th>Quote No</th><th>Stage</th><th>Description</th><th>External Agent</th><th>Internal Agent</th></tr></thead><tbody>";
                                foreach ($data_subset as $item) { echo "<tr><td>" . htmlspecialchars($item['quote_no']) . "</td><td>" . htmlspecialchars($item['quotestage']) . "</td><td>" . htmlspecialchars($item['description']) . "</td><td>" . htmlspecialchars($item['assigned_to_external_sales_agent'] ?: 'N/A') . "</td><td>" . htmlspecialchars($item['assigned_to_sales_agent'] ?: 'N/A') . "</td></tr>"; }
                                echo "</tbody></table>";
                                echo "</div>"; // Close sr-rejected-section div
                            }
                             // Note: 'OTHER' rejected data is still fetched into $rejected_quotes_data but not displayed here.
                        }
                    }
                     // Check if any AU or NZ rejected data was found and displayed
                    if (!$has_any_rejected_data) { echo "<p class='sr-no-data-message'>No rejected quotes found for the selected criteria and main filter (showing only AU and NZ).</p>"; } ?>
                </div>
            </div>

        </div>

    <?php elseif ($_SERVER["REQUEST_METHOD"] == "POST"): ?>
        <div class="sr-filter-container"><p style="color: red; text-align: center;">Please select a valid date range to generate reports.</p></div>
    <?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
    // Initialize flatpickr with the calculated default date range
    flatpickr("#sr-create_date_range", { mode: "range", dateFormat: "Y-m-d", defaultDate: "<?php echo !empty($create_date_range_str) ? htmlspecialchars($create_date_range_str) : ''; ?>", });

    function openReport(evt, reportName) {
        var i, tabcontent, tablinks;
        tabcontent = document.getElementsByClassName("sr-tab-content");
        for (i = 0; i < tabcontent.length; i++) { tabcontent[i].style.display = "none"; }
        tablinks = document.getElementsByClassName("sr-tab-link");
        for (i = 0; i < tablinks.length; i++) { tablinks[i].classList.remove("sr-tab-active"); }
        var targetTab = document.getElementById(reportName);
        if (targetTab) { targetTab.style.display = "block"; }
        if (evt && evt.currentTarget) { evt.currentTarget.classList.add("sr-tab-active"); }

        // If the rejected quotes tab is opened, initialize toggle
        if (reportName === 'sr-RejectedQuotesReport') {
             initRejectedQuotesToggle();
        }
    }

    function applyQueryConfirmationFilters() {
        const selectedRegion = document.getElementById('sr-qcdFilterRegion').value;
        const selectedAgentType = document.getElementById('sr-qcdFilterAgentType').value;
        const agentNameFilter = document.getElementById('sr-qcdFilterAgentName').value.toLowerCase().trim();
        const dataContainer = document.getElementById('sr-qcdReportData');
        const noFilterMatchMsgElement = document.getElementById('sr-qcdNoFilterMatchMessage');
        let hasVisibleData = false;

        if (!dataContainer || !noFilterMatchMsgElement) return;

        dataContainer.querySelectorAll('.sr-region-block').forEach(regionBlock => {
            const regionName = regionBlock.dataset.region;
            let regionMatches = (selectedRegion === "" || selectedRegion === regionName);
            let regionHasVisibleChildren = false;
            if (regionMatches) {
                regionBlock.querySelectorAll('.sr-agent-type-block').forEach(agentTypeBlock => {
                    const agentTypeName = agentTypeBlock.dataset.agentType;
                    let agentTypeMatches = (selectedAgentType === "" || selectedAgentType === agentTypeName);
                    let agentTypeHasVisibleChildren = false;
                    if (agentTypeMatches) {
                        agentTypeBlock.querySelectorAll('.sr-agent-block').forEach(agentBlock => {
                            const agentName = agentBlock.dataset.agentName;
                            let agentNameMatches = (agentNameFilter === "" || agentName.includes(agentNameFilter));
                            if (agentNameMatches) { agentBlock.style.display = ""; agentTypeHasVisibleChildren = true; regionHasVisibleChildren = true; hasVisibleData = true; }
                            else { agentBlock.style.display = "none"; }
                        });
                        // Show agent type block only if it contains at least one visible agent block
                        agentTypeBlock.style.display = agentTypeHasVisibleChildren ? "" : "none";
                    } else { agentTypeBlock.style.display = "none"; }
                });
                 // Show region block only if it contains at least one visible agent type block (which in turn has visible agent blocks)
                regionBlock.style.display = regionHasVisibleChildren ? "" : "none";
            } else { regionBlock.style.display = "none"; }
        });

        const initialNoDataMsgElement = document.querySelector('#sr-QueryConfirmationDetailReport .sr-report-container > .sr-no-data-message');
        const totalReportBlocks = document.querySelectorAll('#sr-qcdReportData .sr-region-block').length;
        // Filter out hidden blocks to check if *any* block is visible
        const visibleReportBlocks = Array.from(document.querySelectorAll('#sr-qcdReportData .sr-region-block')).filter(block => block.style.display !== 'none').length;


        if (visibleReportBlocks > 0) {
             noFilterMatchMsgElement.style.display = 'none';
             if(initialNoDataMsgElement) initialNoDataMsgElement.style.display = 'none';
        } else {
            // If there were report blocks initially, but filters hide them all
            if (totalReportBlocks > 0) {
                 noFilterMatchMsgElement.style.display = 'block';
                 if(initialNoDataMsgElement) initialNoDataMsgElement.style.display = 'none';
            } else {
                 // If there were no report blocks initially (PHP returned no data)
                 noFilterMatchMsgElement.style.display = 'none'; // Filter message shouldn't show if no data was loaded at all
                 if(initialNoDataMsgElement) initialNoDataMsgElement.style.display = 'block'; // Show original "No data" message
            }
        }
    }

    // Function to initialize rejected quotes hide/show toggle
    function initRejectedQuotesToggle() {
        document.querySelectorAll('.sr-rejected-section h4.sr-clickable-heading').forEach(heading => {
            // Prevent multiple listeners
            if (heading.dataset.listenerAttached) {
                 return;
            }
            heading.dataset.listenerAttached = 'true'; // Mark as having listener

            const sectionDiv = heading.parentElement; // The parent div wrapper
            const table = sectionDiv.querySelector('.sr-report-table'); // The table inside the wrapper
            if (!table) return;

            // Use the div's ID for localStorage key
            const sectionId = sectionDiv.id;

            // Check localStorage for saved state
            const savedState = localStorage.getItem(sectionId + '_collapsed');
            if (savedState === 'true') {
                table.style.display = 'none';
                heading.classList.add('collapsed');
            } else {
                table.style.display = ''; // Reset to default (likely 'table')
                heading.classList.remove('collapsed');
            }

            // Attach click listener
            heading.onclick = function() {
                const isCollapsed = heading.classList.toggle('collapsed');
                table.style.display = isCollapsed ? 'none' : ''; // Toggle display

                // Save state to localStorage
                try {
                     localStorage.setItem(sectionId + '_collapsed', isCollapsed);
                } catch (e) {
                     console.error("Could not save collapse state to localStorage:", e);
                }
            };
        });
    }


    <?php if (!empty($start_date) && !empty($end_date)): ?>
    document.addEventListener('DOMContentLoaded', function() {
        // Ensure the default active tab's content is shown on load if JS is enabled.
        const activeTabButton = document.querySelector('.sr-tab-link.sr-tab-active');
        if (activeTabButton) {
             // Simulate click on the active tab button to ensure its content is shown and any init functions are called
             // Extract report name from onclick attribute
             const reportNameMatch = activeTabButton.getAttribute('onclick').match(/'([^']+)'/);
             if (reportNameMatch && reportNameMatch[1]) {
                 openReport({currentTarget: activeTabButton}, reportNameMatch[1]);
             }
        } else {
             // If no tab is active, open the first one
             const firstTabButton = document.querySelector('.sr-tab-link');
             if(firstTabButton){
                 const reportNameMatch = firstTabButton.getAttribute('onclick').match(/'([^']+)'/);
                 if (reportNameMatch && reportNameMatch[1]) {
                     openReport({currentTarget: firstTabButton}, reportNameMatch[1]);
                 }
             }
        }


        // If the Query Confirmation tab was active on load, apply filters
        const qcdReportTab = document.getElementById('sr-QueryConfirmationDetailReport');
        if (qcdReportTab && qcdReportTab.style.display === 'block') {
           applyQueryConfirmationFilters();
        }

         // If the Rejected Quotes tab was active on load, initialize toggle
         const rejectedQuotesTab = document.getElementById('sr-RejectedQuotesReport');
         if (rejectedQuotesTab && rejectedQuotesTab.style.display === 'block') {
            initRejectedQuotesToggle();
         }

    });
    <?php endif; ?>
</script>
</body>
</html>
<?php
// Final check and close DB connection
if (isset($conn) && $conn instanceof mysqli && $conn->thread_id) {
    mysqli_close($conn);
}
?>