<?php
header('Content-Type: application/json');

$carrier = $_GET['carrier'] ?? '';
$flightNo = $_GET['flightNo'] ?? '';
$date = $_GET['date'] ?? '';
$type = $_GET['type'] ?? ''; // departing or arriving

if (!$carrier || !$flightNo || !$date || !in_array($type, ['departing', 'arriving'])) {
    echo json_encode(['error' => 'Invalid request']);
    exit;
}

$year = substr($date, 0, 4);
$month = substr($date, 5, 2);
$day = substr($date, 8, 2);

$appId = '1c21e6d6'; // Your actual App ID
$appKey = '3a6edcd665f5a07cd34e3e2a26469a3c'; // Your actual App Key (insert it here)

// Build URL
$url = "https://api.flightstats.com/flex/schedules/rest/v1/json/flight/$carrier/$flightNo/$type/$year/$month/$day?appId=$appId&appKey=$appKey";

// cURL request
$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo json_encode(['error' => 'cURL error: ' . curl_error($ch)]);
    curl_close($ch);
    exit;
}

curl_close($ch);
echo $response; // Directly pass through the FlightStats response
?>
