<?php
include "dbconn.php";
include "dictionaries.php";

session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name'])) {
    header('Location: login.php');
    exit;
}
$username = $_SESSION['user_name'];
$sql_ajax = "SELECT CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users WHERE user_name = '$username';";
$result_ajax = mysqli_query($conn, $sql_ajax);
if(mysqli_num_rows($result_ajax) > 0) {
    $row_ajax = $result_ajax->fetch_assoc();
    $username_ajax = $row_ajax['name'];
}
$defaultTaskCategories = [
    "account" => "Accounts",
    "fit" => "Operation",
    "group" => "Operation",
    "sales" => "Sales",
    "external" => "Sales",
    "qa" => "QA"
];

$title = $_SESSION['title'] ?? '';
$department = $_SESSION['department'] ?? '';

date_default_timezone_set('Australia/Melbourne');

if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'tasks') {
    include "header.php";

    $sql_check = "SELECT task_id FROM tdu_tasks_management
                WHERE deadline < CURRENT_DATE + INTERVAL 3 DAY AND assigned_to_user = '$username_ajax' AND (status = 'Open' OR status = 'In Progress');";
    $result_check = mysqli_query($conn, $sql_check);

    $flashClass = "";
    if (mysqli_num_rows($result_check) > 0) { 
        $flashClass = "flash";
        ?>
        <div id="editHotelModal" style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); display: flex; align-items: center; justify-content: center; z-index: 1000;">
            <div style="background: white; padding: 20px; border-radius: 8px; width: 50%; text-align: center; box-shadow: 0px 0px 10px rgba(0,0,0,0.3);">
                <h1 style="margin-bottom: 15px;">Notice</h1>
                <h2 style="margin-bottom: 15px; color: red;">You have tasks due soon</h2>
                <button onclick="document.getElementById('editHotelModal').style.display='none';" 
                    style="background: #334155; color: white; border: none; padding: 10px 15px; border-radius: 5px; cursor: pointer;">
                    Close
                </button>
            </div>
        </div>
        <style>
            @keyframes flash {
                0% { background-color: #f8d7da; }
                50% { background-color: #ffffcc; }
                100% { background-color: #f8d7da; }
            }

            .flash {
                animation: flash 2s infinite alternate;
            }
        </style>
        <?php 
    }
    
    $taskidFilter = isset($_GET['task_id']) ? $_GET['task_id'] : '';
    $subjectFilter = isset($_GET['subject']) ? $_GET['subject'] : '';
    $quoteNoFilter = isset($_GET['quote_no']) ? $_GET['quote_no'] : '';
    $quotestageFilter = isset($_GET['quote_stage']) ? $_GET['quote_stage'] : '';
    $regionFilter = isset($_GET['assigned_to_region']) ? $_GET['assigned_to_region'] : '';
    $userFilter = isset($_GET['assigned_to_user']) ? $_GET['assigned_to_user'] : '';
    $categoryFilter = isset($_GET['category']) ? $_GET['category'] : '';
    $statusFilter = isset($_GET['status']) ? $_GET['status'] : '';
    $priorityFilter = isset($_GET['priority']) ? $_GET['priority'] : '';
    $deadlineFilter = isset($_GET['deadline']) ? $_GET['deadline'] : '';
    if (count($_GET) === 1) {
        $userFilter = $username_ajax;
        $statusFilter = "Open/In Progress";
        // if (isset($defaultTaskCategories[$title])) {
        //     $categoryFilter = $defaultTaskCategories[$title];
        // }
    }

    if ($_GET['deadline'] == 'due-soon') {
        $startDate = date('Y-m-d');
        $endDate = date('Y-m-d', strtotime('+3 days'));
        $deadlineFilter = "$startDate to $endDate";
    } elseif ($_GET['deadline'] == 'overdue') {
        $startDate = date('Y-m-d', strtotime('-1 year'));
        $endDate = date('Y-m-d');
        $deadlineFilter = "$startDate to $endDate";
    }
    $created_atFilter = isset($_GET['created_at']) ? $_GET['created_at'] : '';

    // Base query
    $sql = "SELECT ttm.task_id, ttm.subject, ttm.quote_no, ttm.assigned_to_region, ttm.assigned_to_user, ttm.category, ttm.status, ttm.priority, ttm.deadline, ttm.created_at, vq.quotestage
            FROM tdu_tasks_management ttm
            LEFT JOIN vtiger_quotes vq ON ttm.quote_no = vq.quote_no
            WHERE 1=1";

    // Apply filters
    if ($taskidFilter) {
        $sql .= " AND ttm.task_id = '" . $conn->real_escape_string($taskidFilter) . "'";
    }
    if ($subjectFilter) {
        $sql .= " AND ttm.subject LIKE '%" . $conn->real_escape_string($subjectFilter) . "%'";
    }
    if ($quoteNoFilter) {
        $sql .= " AND ttm.quote_no LIKE '%" . $conn->real_escape_string($quoteNoFilter) . "%'";
    }
    if ($quotestageFilter) {
        // Split the comma-separated values into an array
        $stages = array_map('trim', explode(',', $quotestageFilter));
    
        // Escape each value to prevent SQL injection
        $escapedStages = array_map(function($stage) use ($conn) {
            return "'" . $conn->real_escape_string($stage) . "'";
        }, $stages);
    
        // Join the escaped values for the SQL IN clause
        $sql .= " AND vq.quotestage IN (" . implode(',', $escapedStages) . ")";
    }    
    if ($regionFilter) {
        $sql .= " AND ttm.assigned_to_region LIKE '%" . $conn->real_escape_string($regionFilter) . "%'";
    }
    if ($userFilter || $categoryFilter) {
        $sql .= " AND (";
        $conditions = [];

        if ($userFilter) {
            if ($userFilter == 'unassigned') {
                $conditions[] = "ttm.assigned_to_user = ''";
            } else {
                $conditions[] = "ttm.assigned_to_user = '" . $conn->real_escape_string($userFilter) . "'";
            }
        }

        if ($categoryFilter) {
            $conditions[] = "ttm.category = '" . $conn->real_escape_string($categoryFilter) . "'";
        }

        $sql .= implode(" OR ", $conditions) . ")";
    }
    if ($statusFilter) {
        if ($statusFilter == "Open/In Progress") {
            $sql .= " AND (ttm.status = 'Open' OR ttm.status = 'In Progress')";
        } else {
            $sql .= " AND ttm.status = '" . $conn->real_escape_string($statusFilter) . "'";
        }
    }
    if ($priorityFilter) {
        $sql .= " AND ttm.priority = '" . $conn->real_escape_string($priorityFilter) . "'";
    }
    if (!empty($deadlineFilter)) {
        $date_range = explode(' to ', mysqli_real_escape_string($conn, $deadlineFilter));
        $start_date = $date_range[0];
        $end_date = isset($date_range[1]) ? $date_range[1] : $date_range[0]; // in case only one date is selected
        $sql .= " AND ttm.deadline BETWEEN '$start_date' AND '$end_date'";
    }
    if ($created_atFilter) {
        $sql .= " AND DATE(ttm.created_at) = '" . $conn->real_escape_string($created_atFilter) . "'";
    }

    // Pagination
    $limit = 20;
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    $page = max($page, 1);
    $offset = ($page - 1) * $limit;

    // Get total records
    $sql_total = $sql;
    $total_result = mysqli_query($conn, $sql_total);
    $totalRecords = mysqli_num_rows($total_result);
    $totalPages = ceil($totalRecords / $limit);

    // Apply sorting and limits
    $sql .= " ORDER BY 
                CASE WHEN ttm.deadline IS NULL THEN 1 ELSE 0 END ASC, 
                ttm.deadline ASC, 
                ttm.created_at DESC
            LIMIT $limit OFFSET $offset";
    $result = $conn->query($sql);
    ?>

    <div style="display: flex; justify-content: space-between; margin: 0; min-height: 100vh; width: 100%;">
        <div style="flex: 1; padding-right: 20px; background-color: #133e5e;">
            <h2 style="text-align: center; padding: 20px; color: white;">Task</h2>
        </div>
        <div style="flex: 9; padding-left: 20px; margin: 20px auto;">
            <div class="tabs">
                <button type="button" onclick="window.location.href='task.php?opt=tasks&assigned_to_user=<?= urlencode($username_ajax); ?>&category=<?= urlencode($defaultTaskCategories[$title] ?? ''); ?>'" class="tab <?= $flashClass; ?>">Assigned to me</button>
                <button type="button" onclick="window.location.href='task.php?opt=tasks&assigned_to_user='" class="tab">All</button>
                <button type="button" onclick="window.location.href='task.php?opt=tasks&assigned_to_user=unassigned'" class="tab">Unassigned</button>
                <button type="button" onclick="window.location.href='task.php?opt=tasks&deadline=due-soon'" class="tab" style="background-color: #ffffcc">Due Soon</button>
                <button type="button" onclick="window.location.href='task.php?opt=tasks&deadline=overdue'" class="tab" style="background-color: #f8d7da">Overdue</button>
            </div>
            <table class="styled-table" style="width: 100%; margin: 20px auto;">
                <tr>
                    <th style="text-align: center;"><button onclick="window.location.href='task.php?opt=add-new-tasks'"><i class="fa-solid fa-plus"></i></button></th>
                    <th>ID</th>
                    <th>Subject</th>
                    <th>Quote No</th>
                    <th>Deadline</th>
                    <th>Quote Stage</th>
                    <th>Assigned Region</th>
                    <th>Assigned User</th>
                    <th>Category 
                        <?php if ($title == 'admin') : ?>
                            <button onclick="openCategoryModal()" style="padding: 3px 6px;">+</button>
                        <?php endif; ?>
                    </th>
                    <th>Status</th>
                    <th>Priority</th>
                    <th>Created At</th>
                </tr>
                <tr>
                    <form method="GET">
                        <input type="hidden" name="opt" value="tasks">
                        <td><button type="submit"><i class="fa-solid fa-magnifying-glass"></i></button></td>
                        <td><input type="text" style="max-width: 50px;" name="task_id" value="<?= htmlspecialchars($taskidFilter); ?>"></td>
                        <td><input type="text" name="subject" value="<?= htmlspecialchars($subjectFilter); ?>"></td>
                        <td><input type="text" name="quote_no" value="<?= htmlspecialchars($quoteNoFilter); ?>"></td>

                        <td><input type="text" id="deadline" name="deadline" value="<?= isset($_GET['deadline']) ? htmlspecialchars($_GET['deadline']) : ''; ?>"></td>
                        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
                        <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
                        <script>
                            flatpickr("#deadline", {
                                mode: "range",
                                dateFormat: "Y-m-d",
                                defaultDate: "<?= isset($_GET['deadline']) ? htmlspecialchars($_GET['deadline']) : ''; ?>"
                            });
                        </script>

                        <?php $quoteStages = fetchQuoteStages($conn); ?>
                        <td>
                            <div style="width: 100%;">
                                <input type="text" id="quote_stage_input" name="quote_stage" value="<?php echo isset($quotestageFilter) ? htmlspecialchars($quotestageFilter) : ''; ?>" readonly style="width: 100%;">
                                <div id="checkboxes" style="display: none; border: 1px solid #ccc; padding: 10px; position: absolute; background: white; z-index: 1000;">
                                    <?php foreach ($quoteStages as $stage): ?>
                                        <label>
                                            <input type="checkbox" value="<?php echo htmlspecialchars($stage); ?>" 
                                                <?php 
                                                if(isset($quotestageFilter) && $quotestageFilter != '') {
                                                    $checked_stage = explode(',', $quotestageFilter);
                                                    echo in_array($stage, $checked_stage) ? 'checked' : '';
                                                }
                                                ?>
                                            >
                                            <?php echo htmlspecialchars($stage); ?>
                                        </label><br>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </td>
                        <script>
                            const input = document.getElementById('quote_stage_input');
                            const checkboxes = document.getElementById('checkboxes');

                            // Toggle the display of the checkboxes on input click
                            input.addEventListener('click', function() {
                                checkboxes.style.display = checkboxes.style.display === 'block' ? 'none' : 'block';
                            });

                            // Update the input field with selected checkbox values
                            document.querySelectorAll('#checkboxes input[type="checkbox"]').forEach(checkbox => {
                                checkbox.addEventListener('change', function() {
                                    const selectedValues = Array.from(document.querySelectorAll('#checkboxes input[type="checkbox"]:checked')).map(cb => cb.value);
                                    input.value = selectedValues.join(','); // Join selected values with a comma
                                });
                            });

                            // Close the checkbox dropdown when clicking outside
                            document.addEventListener('click', function(event) {
                                if (!input.contains(event.target) && !checkboxes.contains(event.target)) {
                                    checkboxes.style.display = 'none';
                                }
                            });
                        </script>

                        <!-- Assigned to Region - Dropdown -->
                        <td>
                            <select name="assigned_to_region">
                                <option value="">All</option>
                                <?php
                                $sqlr = "SELECT groupname FROM vtiger_groups";
                                $resultr = $conn->query($sqlr);
                                if ($resultr->num_rows > 0) {
                                    while ($rowr = $resultr->fetch_assoc()) {
                                        $selected = ($regionFilter == $rowr['groupname']) ? 'selected' : '';
                                        echo "<option value=\"" . htmlspecialchars($rowr['groupname']) . "\" $selected>" . htmlspecialchars($rowr['groupname']) . "</option>";
                                    }
                                }
                                ?>
                            </select>
                        </td>

                        <!-- Assigned to User - Dropdown -->
                        <td>
                            <select name="assigned_to_user">
                                <option value="">All</option>
                                <?php
                                $sqlr = "SELECT title, CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users 
                                        WHERE title != 'block'
                                        ORDER BY title ASC, first_name ASC;";
                                $resultr = $conn->query($sqlr);
                                $current_title = '';
                                $rolesHumanReadable = [
                                    "admin" => "Admin",
                                    "account" => "Account",
                                    "fit" => "FIT Ops",
                                    "group" => "Group Ops",
                                    "sales" => "Internal Sales",
                                    "external" => "External Sales",
                                    "qa" => "QA",
                                    "block" => "No Access"
                                ];
                                if ($resultr->num_rows > 0) {
                                    while ($rowr = $resultr->fetch_assoc()) {
                                        if ($rowr['title'] !== $current_title) {
                                            // Output section header for user roles
                                            $current_title = $rowr['title'];
                                            echo "<option value='' disabled>--- " . $rolesHumanReadable[$current_title] . " ---</option>";
                                        }
                                        $selected = ($userFilter == $rowr['name']) ? 'selected' : '';
                                        echo "<option value=\"" . htmlspecialchars($rowr['name']) . "\" $selected>" . htmlspecialchars($rowr['name']) . "</option>";
                                    }
                                }
                                ?>
                            </select>
                        </td>

                        <td>
                            <select name="category">
                                <option value="">All</option>
                                <?php
                                $taskCategories = getTaskCategories($conn);
                                foreach ($taskCategories as $category) {
                                    $selected = ($categoryFilter === $category) ? "selected" : "";
                                    echo "<option value=\"$category\" $selected>$category</option>";
                                }
                                ?>
                            </select>
                        </td>
                        <td>
                            <select name="status">
                                <option value="">All</option>
                                <option value="Open/In Progress" <?= ($statusFilter === "Open/In Progress") ? "selected" : "" ?>>Open / In Progress</option>
                                <option value="Open" <?= ($statusFilter === "Open") ? "selected" : "" ?>>Open</option>
                                <option value="In Progress" <?= ($statusFilter === "In Progress") ? "selected" : "" ?>>In Progress</option>
                                <option value="Completed" <?= ($statusFilter === "Completed") ? "selected" : "" ?>>Completed</option>
                                <option value="Deferred" <?= ($statusFilter === "Deferred") ? "selected" : "" ?>>Deferred</option>
                                <option value="Canceled" <?= ($statusFilter === "Canceled") ? "selected" : "" ?>>Canceled</option>
                            </select>
                        </td>
                        <td>
                            <select name="priority">
                                <option value="">All</option>
                                <option value="Low" <?= ($priorityFilter === "Low") ? "selected" : "" ?>>Low</option>
                                <option value="Normal" <?= ($priorityFilter === "Normal") ? "selected" : "" ?>>Normal</option>
                                <option value="High" <?= ($priorityFilter === "High") ? "selected" : "" ?>>High</option>
                            </select>
                        </td>
                        <td><input type="date" style="height: 30px;" name="created_at" value="<?= htmlspecialchars($created_atFilter); ?>"></td>
                    </form>
                </tr>

                <?php if ($result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <?php
                        $iconColor = ''; 
                        if (isset($row['deadline']) && ($row['status'] == 'Open' || $row['status'] == 'In Progress')) {
                            $deadline_r = strtotime($row['deadline']);
                            $today = strtotime(date('Y-m-d'));
                            $threeDaysLater = strtotime('+3 days', $today);

                            if ($deadline_r <= $today) {
                                $iconColor = 'red'; // Past deadline
                            } elseif ($deadline_r <= $threeDaysLater) {
                                $iconColor = 'orange'; // Within 3 days
                            }
                        }
                        ?>
                        <tr>
                            <td><input type="checkbox" class="taskCheckbox" value="<?= htmlspecialchars($row['task_id']); ?>"></td>
                            <td><?= htmlspecialchars($row['task_id']); ?></td>
                            <td>
                                <?php if ($iconColor): ?>
                                    <i class="fa-solid fa-circle-exclamation" style="color: <?= $iconColor; ?>"></i>
                                <?php endif; ?>
                                <a href="task.php?opt=task-details&id=<?php echo urlencode($row['task_id']); ?>"><?php echo htmlspecialchars($row['subject']); ?></a>
                            </td>
                            <td>
                                <a href="quote.php?opt=summary&quoteNumber=<?php echo urlencode($row['quote_no']); ?>"><?php echo htmlspecialchars($row['quote_no']); ?></a>
                                <a href="quote.php?opt=quote-product-faq&quoteNumber=<?php echo urlencode($row['quote_no']); ?>" target="_blank"><i class="fa-solid fa-circle-question"></i></a>
                            </td>
                            <td><?= $row['deadline'] ? date('d-M-Y', strtotime($row['deadline'])) : ''; ?></td>
                            <td><?= htmlspecialchars($row['quotestage']); ?></td>
                            <td><?= htmlspecialchars($row['assigned_to_region']); ?></td>
                            <td><?= htmlspecialchars($row['assigned_to_user']); ?></td>
                            <td><?= htmlspecialchars($row['category']); ?></td>
                            <td><?= htmlspecialchars($row['status']); ?></td>
                            <td><?= htmlspecialchars($row['priority']); ?></td>
                            <td><?= date('d-M-Y', strtotime($row['created_at'])); ?></td>
                        </tr>
                    <?php endwhile; ?>
                <?php endif; ?>
                <tr>
                    <td></td><td colspan="11" style="text-align: left;">Number of results: <?= $totalRecords ?></td>
                </tr>
                <tr>
                    <td><input type="checkbox" id="selectAll" onclick="toggleSelectAll(this)"></td>
                    <td colspan="11" style="text-align: left;">
                        <button onclick="openBulkCategoryModal()">Bulk Edit Category</button>
                        <button onclick="openBulkStatusModal()">Bulk Edit Status</button>
                    </td>
                </tr>
            </table>
            <!-- Hidden Category Modal -->
            <div id="categoryModal" class="modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); padding: 20px 50px; background: white; border: 1px solid #ccc; z-index: 1000;">
                <div class="modal-content">
                    <h3>Add New Category<br><br></h3>
                    <form id="categoryForm">
                        <input type="text" id="categoryInput" placeholder="Enter category name" style="width: 100%; padding: 8px;">
                        <br><br>
                        <button type="button" onclick="saveCategory()">Save</button>
                        <button type="button" onclick="closeCategoryModal()">Cancel</button>
                    </form>
                </div>
            </div>
            <script>
                function openCategoryModal() {
                    document.getElementById('categoryInput').value = ''; // Clear input
                    document.getElementById('categoryModal').style.display = 'block';
                }

                function closeCategoryModal() {
                    document.getElementById('categoryModal').style.display = 'none';
                }

                function saveCategory() {
                    var categoryName = document.getElementById('categoryInput').value.trim();
                    
                    if (categoryName === '') {
                        alert("Category name cannot be empty!");
                        return;
                    }

                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", "ajax_task_add_category.php", true);
                    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                    
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState === 4 && xhr.status === 200) {
                            if (xhr.responseText === "success") {
                                alert("Category added successfully!");
                                closeCategoryModal();
                                location.reload(); // Reload or dynamically add the category
                            } else {
                                alert("Error adding category.");
                            }
                        }
                    };

                    xhr.send("category_name=" + encodeURIComponent(categoryName));
                }
            </script>

            <div class="pagination" style="margin-top: 0;">
                <div>
                    <?php if ($page > 1): ?>
                        <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page - 1])); ?>">&#8592;</a> <!-- Left arrow -->
                    <?php endif; ?>

                    <?php
                    $max_pages = min($totalPages, $page + 2);
                    for ($i = $page; $i <= $max_pages; $i++): ?>
                        <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $i])); ?>" <?php if ($i == $page) echo 'style="background-color: #334155; color: white;"'; ?>>
                            <?php echo $i; ?>
                        </a>
                    <?php endfor; ?>

                    <?php if ($page < $totalPages): ?>
                        <a href="?<?php echo http_build_query(array_merge($_GET, ['page' => $page + 1])); ?>">&#8594;</a> <!-- Right arrow -->
                    <?php endif; ?>
                </div>
                
                <form method="GET" action="" style="display:inline;">
                    <?php
                    foreach ($_GET as $key => $value) {
                        if ($key != 'page') {
                            echo '<input type="hidden" name="' . htmlspecialchars($key) . '" value="' . htmlspecialchars($value) . '">';
                        }
                    }
                    ?>
                    <input type="number" name="page" min="1" max="<?php echo $totalPages; ?>" value="<?php echo $page; ?>" style="width:75px;"> / <?php echo $totalPages; ?>
                    <button type="submit">Jump</button>
                </form>
            </div>
            <style>
                .pagination {
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    margin: 20px 0;
                }
                
                .pagination div {
                    display: flex;
                    align-items: center;
                }
                
                .pagination a {
                    text-decoration: none;
                    padding: 8px 12px;
                    margin: 0 5px;
                    border: 1px solid #334155;
                    color: #334155;
                    border-radius: 4px;
                    transition: background-color 0.3s, color 0.3s;
                }
                
                .pagination a:hover {
                    background-color: #334155;
                    color: white;
                }
                
                .pagination input[type="number"] {
                    width: 50px;
                    padding: 10px;
                    margin-left: 10px;
                    border: 1px solid #ccc;
                    border-radius: 4px;
                }
                
                .pagination button {
                    padding: 10px 10px;
                    margin-left: 5px;
                    border: none;
                    border-radius: 4px;
                    background-color: #334155;
                    color: white;
                    cursor: pointer;
                    transition: background-color 0.3s;
                }
                
                .pagination button:hover {
                    background-color: #334155;
                }
                
                tr:nth-child(odd) {
                    background-color: #f9f9f9;
                }

                .styled-table td input[type="text"], .styled-table td select, .styled-table td input[type="date"] {
                    width: 100%;
                    height: 30px;
                    margin: 0;
                }
            </style>
        </div>
    </div>

    <script>
        function toggleSelectAll(source) {
            let checkboxes = document.querySelectorAll('.taskCheckbox');
            checkboxes.forEach(cb => cb.checked = source.checked);
        }
    </script>
    <!-- Bulk Edit Category Modal start -->
    <div id="bulkCategoryModal" class="modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); padding: 20px 50px; background: white; border: 1px solid #ccc; z-index: 1000;">
        <div class="modal-content">
            <h3>Bulk Edit Category<br><br></h3>
            <form id="bulkCategoryForm">
                <select id="bulkCategorySelect" style="width: 100%; padding: 8px;">
                    <option value="">Select Category</option>
                    <?php
                    $taskCategories = getTaskCategories($conn);
                    foreach ($taskCategories as $category) {
                        echo "<option value='$category'>$category</option>";
                    }
                    ?>
                </select>
                <br><br>
                <button type="button" onclick="saveBulkCategory()">Save</button>
                <button type="button" onclick="closeBulkCategoryModal()">Cancel</button>
            </form>
        </div>
    </div>
    <script>
        function openBulkCategoryModal() {
            let selectedTasks = getSelectedTasks();
            if (selectedTasks.length === 0) {
                alert("Please select at least one task.");
                return;
            }
            document.getElementById('bulkCategoryModal').style.display = 'block';
        }

        function closeBulkCategoryModal() {
            document.getElementById('bulkCategoryModal').style.display = 'none';
        }

        function getSelectedTasks() {
            let checkboxes = document.querySelectorAll('.taskCheckbox:checked');
            return Array.from(checkboxes).map(cb => cb.value);
        }

        function saveBulkCategory() {
            let selectedTasks = getSelectedTasks();
            let newCategory = document.getElementById('bulkCategorySelect').value;
            
            if (!newCategory) {
                alert("Please select a category.");
                return;
            }

            let xhr = new XMLHttpRequest();
            xhr.open("POST", "ajax_task_bulk_edit_category.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    if (xhr.responseText === "success") {
                        alert("Categories updated successfully!");
                        closeBulkCategoryModal();
                        location.reload();
                    } else {
                        alert("Error updating categories.");
                    }
                }
            };
            
            xhr.send("task_ids=" + encodeURIComponent(selectedTasks.join(',')) + "&category=" + encodeURIComponent(newCategory));
        }
    </script>
    <!-- Bulk Edit Category Modal end -->

    <!-- Bulk Edit Status Modal start -->
    <div id="bulkStatusModal" class="modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); padding: 20px 50px; background: white; border: 1px solid #ccc; z-index: 1000;">
        <div class="modal-content">
            <h3>Bulk Edit Status<br><br></h3>
            <form id="bulkStatusForm">
                <select id="bulkStatusSelect" style="width: 100%; padding: 8px;">
                    <option value="">Select Status</option>
                    <option value="Open">Open</option>
                    <option value="In Progress">In Progress</option>
                    <option value="Completed">Completed</option>
                    <option value="Deferred">Deferred</option>
                    <option value="Canceled">Canceled</option>
                </select>
                <br><br>
                <button type="button" onclick="saveBulkStatus()">Save</button>
                <button type="button" onclick="closeBulkStatusModal()">Cancel</button>
            </form>
        </div>
    </div>
    <script>
        function openBulkStatusModal() {
            let selectedTasks = getSelectedTasks();
            if (selectedTasks.length === 0) {
                alert("Please select at least one task.");
                return;
            }
            document.getElementById('bulkStatusModal').style.display = 'block';
        }

        function closeBulkStatusModal() {
            document.getElementById('bulkStatusModal').style.display = 'none';
        }

        function saveBulkStatus() {
            let selectedTasks = getSelectedTasks();
            let newStatus = document.getElementById('bulkStatusSelect').value;

            if (!newStatus) {
                alert("Please select a status.");
                return;
            }

            let xhr = new XMLHttpRequest();
            xhr.open("POST", "ajax_task_bulk_edit_status.php", true);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    if (xhr.responseText === "success") {
                        alert("Statuses updated successfully!");
                        closeBulkStatusModal();
                        location.reload();
                    } else {
                        alert("Error updating statuses.");
                    }
                }
            };

            xhr.send("task_ids=" + encodeURIComponent(selectedTasks.join(',')) + "&status=" + encodeURIComponent(newStatus));
        }
    </script>
    <!-- Bulk Edit Status Modal end -->
    <?php
}
else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'add-new-tasks') {
    $quote_no_default = $_GET['quoteNumber'] ?? '';
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $subject = $conn->real_escape_string($_POST['subject']);
        $quote_no = $conn->real_escape_string($_POST['quote_no']);
        $assigned_to_region = $conn->real_escape_string($_POST['assigned_to_region']);
        $assigned_to_user = $conn->real_escape_string($_POST['assigned_to_user']);
        $category = $conn->real_escape_string($_POST['category']);
        $status = $conn->real_escape_string($_POST['status']);
        $priority = $conn->real_escape_string($_POST['priority']);
        
        // Check if deadline is empty and set appropriately
        if (empty($_POST['deadline'])) {
            $deadline = "NULL";
        } else {
            $deadline = "'" . $conn->real_escape_string($_POST['deadline']) . "'";
        }
    
        // Insert query
        $sql = "INSERT INTO tdu_tasks_management (
                    subject, quote_no, assigned_to_region, assigned_to_user, 
                    category, status, priority, deadline, created_at, created_by
                ) VALUES (
                    '$subject', '$quote_no', '$assigned_to_region', '$assigned_to_user', 
                    '$category', '$status', '$priority', $deadline, NOW(), '$username_ajax'
                )";
    
        // Execute query
        if ($conn->query($sql) === TRUE) {
            $lastInsertedId = $conn->insert_id;
        
            // Build multiline log for history
            $details = "";
            $details .= "Subject: $subject\n";
            $details .= "Quote No: $quote_no\n";
            $details .= "Assigned to Region: $assigned_to_region\n";
            $details .= "Assigned to User: $assigned_to_user\n";
            $details .= "Category: $category\n";
            $details .= "Status: $status\n";
            $details .= "Priority: $priority\n";
            $details .= "Deadline: " . ($_POST['deadline'] ?: "N/A") . "\n";
        
            $details = $conn->real_escape_string($details);
        
            // Insert into history table
            $historySql = "INSERT INTO tdu_tasks_management_history (task_id, details, created_at, created_by) 
                            VALUES ('$lastInsertedId', '$details', NOW(), '$username_ajax')";
            $conn->query($historySql); // Optional: check result
        
            header("Location: task.php?opt=task-details&id=$lastInsertedId");
            exit();
        } else {
            echo "Error: " . $sql . "<br>" . $conn->error;
        }
    }

    include "header.php";
    ?>
    <div style="display: flex; justify-content: space-between; margin: 0; min-height: 100vh; width: 100%;">
        <div style="flex: 1; padding-right: 20px; background-color: #133e5e;">
            <h2 style="text-align: center; padding: 20px; color: white; border-bottom: unset; margin: unset;">Task</h2>
        </div>
        <div style="flex: 7;">
            <form method="POST" action="" style="margin-top: 20px;">
                <h2>New Task</h2>
                <div class="form-row">
                    <label for="subject">Subject:</label>
                    <input type="text" id="subject" name="subject" required>
                </div>
                <?php
                // Fetch distinct quote_no values
                $quoteNumbers = [];
                $sqlr = "SELECT DISTINCT quote_no FROM vtiger_quotes";
                $resultr = $conn->query($sqlr);
                while ($rowr = $resultr->fetch_assoc()) {
                    $quoteNumbers[] = $rowr['quote_no'];
                }
                ?>

                <div class="form-row">
                    <label for="quote_no">Quote No:</label>
                    <input list="quote_no_list" id="quote_no" name="quote_no" value="<?= $quote_no_default ?>" required>
                    <datalist id="quote_no_list">
                        <?php foreach ($quoteNumbers as $quote): ?>
                            <option value="<?= htmlspecialchars($quote); ?>"></option>
                        <?php endforeach; ?>
                    </datalist>
                </div>
                <div class="form-row">
                    <label for="assigned_to_region">Assigned to Region:</label>
                    <select name="assigned_to_region">
                        <option value=""></option>
                        <?php
                        // Query to get group names from the vtiger_groups table
                        $sqlr = "SELECT groupname FROM vtiger_groups";
                        $resultr = $conn->query($sqlr);

                        // Populate the select dropdown with group names
                        if ($resultr->num_rows > 0) {
                            while ($rowr = $resultr->fetch_assoc()) {
                                echo "<option value=\"" . htmlspecialchars($rowr['groupname']) . "\">" . htmlspecialchars($rowr['groupname']) . "</option>";
                            }
                        }
                        ?>
                    </select>
                </div>
                <div class="form-row">
                    <label for="assigned_to_user">Assigned to User:</label>
                    <select name="assigned_to_user">
                        <option value=""></option>
                        <?php
                        $sqlr = "SELECT title, CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users 
                                WHERE title != 'block'
                                ORDER BY title ASC, first_name ASC;";

                        $resultr = $conn->query($sqlr);
                        $current_title = '';
                        $rolesHumanReadable = [
                            "admin" => "Admin",
                            "account" => "Account",
                            "fit" => "FIT Ops",
                            "group" => "Group Ops",
                            "sales" => "Internal Sales",
                            "external" => "External Sales",
                            "qa" => "QA",
                            "block" => "No Access"
                        ];

                        if ($resultr->num_rows > 0) {
                            while ($rowr = $resultr->fetch_assoc()) {
                                if ($rowr['title'] !== $current_title) {
                                    $current_title = $rowr['title'];
                                    echo "<option value='' disabled>--- " . $rolesHumanReadable[$current_title] . " ---</option>";
                                }

                                $selected = (isset($assigned_to_ops) && $assigned_to_ops == $rowr['name']) ? 'selected' : '';
                                echo "<option value=\"" . htmlspecialchars($rowr['name']) . "\" $selected>" . htmlspecialchars($rowr['name']) . "</option>";
                            }
                        }
                        ?>
                    </select>
                </div>
                <div class="form-row">
                    <label for="category">Category:</label>
                    <select id="category" name="category" required>
                        <?php
                        $taskCategories = getTaskCategories($conn);
                        foreach ($taskCategories as $category) {
                            echo "<option value=\"$category\">$category</option>";
                        }
                        ?>
                    </select>
                </div>
                <div class="form-row">
                    <label for="status">Status:</label>
                    <select id="status" name="status" required>
                        <option value="Open">Open</option>
                        <option value="In Progress">In Progress</option>
                        <option value="Completed">Completed</option>
                        <option value="Deferred">Deferred</option>
                        <option value="Canceled">Canceled</option>
                    </select>
                </div>
                <div class="form-row">
                    <label for="priority">Priority:</label>
                    <select id="priority" name="priority" required>
                        <option value="Low">Low</option>
                        <option value="Normal" selected>Normal</option>
                        <option value="High">High</option>
                    </select>
                </div>
                <div class="form-row">
                    <label for="deadline">Deadline:</label>
                    <input type="date" id="deadline" name="deadline">
                </div>
                <button type="submit">Create Task</button>
                <button type="button" onclick="window.location.href='task.php?opt=tasks'">Cancel</button>
            </form>
        </div>
        <div style="flex: 2;"></div>
    </div>
    <style>
        h2 {
            text-align: left;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
            margin: 20px 0;
        }
        form {
            width: 600px;
            margin: 0 auto;
        }
        .form-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        .form-row label {
            width: 45%;
            margin-right: 10px;
        }
        .form-row input, .form-row select {
            width: 45%;
            padding: 5px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
    </style>
    <?php
}
else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'task-details') {
    include "header.php";

    $task_id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
    ?>

    <div style="display: flex; justify-content: space-between; margin: 0; min-height: 100vh; width: 100%;">
        <div style="flex: 1; padding-right: 20px; background-color: #133e5e;">
            <h2 style="text-align: center; padding: 20px; color: white;">Task</h2>
        </div>
        <div style="flex: 7;">
            <div>
                <?php
                if ($task_id > 0) {
                    $sql = "SELECT * FROM tdu_tasks_management WHERE task_id = $task_id";
                    $result = $conn->query($sql);

                    if ($result->num_rows > 0) {
                        $task = $result->fetch_assoc();
                    } else {
                        echo "Task not found.";
                        exit;
                    }
                }
                ?>
                <h1 style="text-align: center; margin: 20px 0;"><?php echo htmlspecialchars($task['subject']); ?></h1>
            </div>
            <div style="margin: 0 13%;">
                <button type="button" onclick="openNewMessageModal()" style="padding: 10px 20px;">New Message</button>
            </div>
            <?php
            $sql = "SELECT msg_id, created_at, created_by, message FROM tdu_tasks_management_msg WHERE task_id = $task_id ORDER BY created_at DESC";
            $result = $conn->query($sql);
            
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    $msg_id = $row['msg_id'];
                    ?>
                    <div style="width: 75%; margin: auto; padding: 20px; border-bottom: 1px solid #ccc;">
                        <div style="font-weight: bold; margin-bottom: 10px;">
                            <span>Time: <?php echo $row['created_at']; ?></span><br>
                            <span>Author: <?php echo $row['created_by']; ?></span>
                        </div>
                        <div style="padding: 10px; border: 1px solid #ddd; background-color: #f9f9f9;">
                            <p><?php echo nl2br(htmlspecialchars($row['message'])); ?></p>
                        </div>
            
                        <!-- Fetch and display attachments -->
                        <?php
                        $attachmentSql = "SELECT attachment_path FROM tdu_tasks_management_attached WHERE msg_id = $msg_id";
                        $attachmentResult = $conn->query($attachmentSql);
                        if ($attachmentResult->num_rows > 0) {
                            echo "<div style='margin-top: 10px;'><strong>Attachments:</strong><br>";
                            while ($attachmentRow = $attachmentResult->fetch_assoc()) {
                                $filePath = htmlspecialchars($attachmentRow['attachment_path']);
                                $fullFileName = basename($filePath);
                                $fileName = preg_replace('/^\d+_/', '', $fullFileName);
                                echo "<a href='$filePath' target='_blank' style='display: block; margin-top: 5px;'><i class='fa-solid fa-paperclip'></i> $fileName</a>";
                            }
                            echo "</div>";
                        }
                        ?>
                    </div>
                    <?php
                }
            }
            ?>
        </div>
        <div style="flex: 2; padding-left: 20px; margin: 20px auto;">
            <?php
            if ($task_id > 0) {
                $sql = "SELECT * FROM tdu_tasks_management WHERE task_id = $task_id";
                $result = $conn->query($sql);

                if ($result->num_rows > 0) {
                    $task = $result->fetch_assoc();
                } else {
                    echo "Task not found.";
                    exit;
                }
            }
            ?>
            <div class="task-summary-container">
                <div style="border: 1px solid #ddd; padding-right: 20px; margin: 20px;">
                    <p>Quote No:
                        <span id="quote_no-display"><?php echo htmlspecialchars($task['quote_no']); ?></span>
                        <input id="quote_no-edit" style="display:none;" type="text" value="<?php echo htmlspecialchars($task['quote_no']); ?>" list="quote_no_list">
                        <datalist id="quote_no_list">
                            <?php
                            // Fetch distinct quote_no values
                            $quoteNumbers = [];
                            $sqlr = "SELECT DISTINCT quote_no FROM vtiger_quotes";
                            $resultr = $conn->query($sqlr);
                            while ($rowr = $resultr->fetch_assoc()) {
                                $quoteNumbers[] = $rowr['quote_no'];
                            }
                            ?>

                            <?php foreach ($quoteNumbers as $quote): ?>
                                <option value="<?= htmlspecialchars($quote); ?>"></option>
                            <?php endforeach; ?>
                        </datalist>
                    </p>
                    <p>Assigned User:
                        <span id="assigned_to_user-display"><?php echo htmlspecialchars($task['assigned_to_user']); ?></span>
                        <select id="assigned_to_user-edit" style="display:none;" name="assigned_to_user" required>
                            <option value=""></option>
                            <?php
                            $sqlr = "SELECT title, CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users 
                                    WHERE title != 'block'
                                    ORDER BY title ASC, first_name ASC;";
                            $resultr = $conn->query($sqlr);
                            $current_title = '';
                            $rolesHumanReadable = [
                                "admin" => "Admin",
                                "account" => "Account",
                                "fit" => "FIT Ops",
                                "group" => "Group Ops",
                                "sales" => "Internal Sales",
                                "external" => "External Sales",
                                "qa" => "QA",
                                "block" => "No Access"
                            ];
                            if ($resultr->num_rows > 0) {
                                while ($rowr = $resultr->fetch_assoc()) {
                                    if ($rowr['title'] !== $current_title) {
                                        $current_title = $rowr['title'];
                                        echo "<option value='' disabled>--- " . $rolesHumanReadable[$current_title] . " ---</option>";
                                    }
                                    $selected = ($task['assigned_to_user'] == $rowr['name']) ? 'selected' : '';
                                    echo "<option value=\"" . htmlspecialchars($rowr['name']) . "\" $selected>" . htmlspecialchars($rowr['name']) . "</option>";
                                }
                            }
                            ?>
                        </select>
                    </p>
                    <p>Assigned Region:
                        <span id="assigned_to_region-display"><?php echo htmlspecialchars($task['assigned_to_region']); ?></span>
                        <select id="assigned_to_region-edit" style="display:none;">
                            <option value=""></option>
                            <?php
                            $sqlr = "SELECT groupname FROM vtiger_groups";
                            $resultr = $conn->query($sqlr);
                            if ($resultr->num_rows > 0) {
                                while ($rowr = $resultr->fetch_assoc()) {
                                    $selected = ($task['assigned_to_region'] == $rowr['groupname']) ? 'selected' : '';
                                    echo "<option value=\"" . htmlspecialchars($rowr['groupname']) . "\" $selected>" . htmlspecialchars($rowr['groupname']) . "</option>";
                                }
                            }
                            ?>
                        </select>
                    </p>
                </div>
                <div style="border: 1px solid #ddd; padding-right: 20px; margin: 20px;">
                    <p>Category:
                        <span id="category-display"><?php echo htmlspecialchars($task['category']); ?></span>
                        <select id="category-edit" style="display:none;" name="category">
                            <?php
                            $taskCategories = getTaskCategories($conn);
                            foreach ($taskCategories as $category) {
                                $selected = ($task['category'] === $category) ? "selected" : "";
                                echo "<option value=\"$category\" $selected>$category</option>";
                            }
                            ?>
                        </select>
                    </p>
                    <p>Priority:
                        <span id="priority-display"><?php echo htmlspecialchars($task['priority']); ?></span>
                        <select id="priority-edit" style="display:none;">
                            <option value="Low" <?php echo $task['priority'] == 'Low' ? 'selected' : ''; ?>>Low</option>
                            <option value="Normal" <?php echo $task['priority'] == 'Normal' ? 'selected' : ''; ?>>Normal</option>
                            <option value="High" <?php echo $task['priority'] == 'High' ? 'selected' : ''; ?>>High</option>
                        </select>
                    </p>
                    <p>Status:
                        <span id="status-display"><?php echo htmlspecialchars($task['status']); ?></span>
                        <select id="status-edit" style="display:none;">
                            <option value="Open" <?= ($task['status'] === "Open") ? "selected" : "" ?>>Open</option>
                            <option value="In Progress" <?= ($task['status'] === "In Progress") ? "selected" : "" ?>>In Progress</option>
                            <option value="Completed" <?= ($task['status'] === "Completed") ? "selected" : "" ?>>Completed</option>
                            <option value="Deferred" <?= ($task['status'] === "Deferred") ? "selected" : "" ?>>Deferred</option>
                            <option value="Canceled" <?= ($task['status'] === "Canceled") ? "selected" : "" ?>>Canceled</option>
                        </select>
                    </p>
                    <p>Deadline:
                        <span id="deadline-display"><?php echo htmlspecialchars($task['deadline']); ?></span>
                        <input id="deadline-edit" style="display:none;" type="date" value="<?php echo htmlspecialchars($task['deadline']); ?>">
                    </p>
                    <button id="editBtn" onclick="toggleEditMode()" style="text-align: left; margin-left: 10px;"><i class="fa-solid fa-pen-to-square"></i></button>
                    <p>
                        <div style="text-align: left; margin: 10px;">
                            <button id="saveBtn" style="display:none;" onclick="saveChanges()">Save</button>
                            <button id="cancelBtn" style="display:none;" onclick="cancelEdit()">Cancel</button>
                        </div>
                    </p>
                </div>
                <div style="border: 1px solid #ddd; margin: 20px;">
                    <?php
                    $historySql = "SELECT details, created_at, created_by 
                                    FROM tdu_tasks_management_history 
                                    WHERE task_id = '$task_id' 
                                    ORDER BY created_at DESC";
                    $historyResult = $conn->query($historySql);
                    ?>
                    <p style="margin: 10px; text-align: center;">Task History</p>
                    <?php if ($historyResult && $historyResult->num_rows > 0): ?>
                        <?php while ($row = $historyResult->fetch_assoc()): ?>
                            <div style="border-top: 1px solid #ccc; padding: 10px; margin-bottom: 10px;">
                                <div><strong>Date:</strong> <?= htmlspecialchars($row['created_at']) ?></div>
                                <div><strong>By:</strong> <?= htmlspecialchars($row['created_by']) ?></div>
                                <pre style="white-space: pre-wrap; margin-top: 5px;"><?= htmlspecialchars($row['details']) ?></pre>
                            </div>
                        <?php endwhile; ?>
                    <?php endif; ?>
                </div>
            </div>
            <script>
                function toggleEditMode() {
                    document.querySelectorAll('span[id$="-display"]').forEach(el => el.style.display = 'none');
                    document.querySelectorAll('input[id$="-edit"], select[id$="-edit"]').forEach(el => el.style.display = 'inline');
                    document.getElementById('editBtn').style.display = 'none';
                    document.getElementById('saveBtn').style.display = 'inline';
                    document.getElementById('cancelBtn').style.display = 'inline';
                }

                function cancelEdit() {
                    document.querySelectorAll('span[id$="-display"]').forEach(el => el.style.display = 'inline');
                    document.querySelectorAll('input[id$="-edit"], select[id$="-edit"]').forEach(el => el.style.display = 'none');
                    document.getElementById('editBtn').style.display = 'inline';
                    document.getElementById('saveBtn').style.display = 'none';
                    document.getElementById('cancelBtn').style.display = 'none';
                }

                function saveChanges() {
                    const data = {
                        task_id: <?php echo $task_id; ?>,
                        quote_no: document.getElementById('quote_no-edit').value,
                        assigned_to_user: document.getElementById('assigned_to_user-edit').value,
                        assigned_to_region: document.getElementById('assigned_to_region-edit').value,
                        category: document.getElementById('category-edit').value,
                        priority: document.getElementById('priority-edit').value,
                        status: document.getElementById('status-edit').value,
                        deadline: document.getElementById('deadline-edit').value
                    };

                    fetch('ajax_update_task_details.php', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify(data),
                    })
                    .then(response => response.json())
                    .then(result => {
                        if (result.success) {
                            window.location.reload();
                        } else {
                            alert('Failed to update task information.');
                        }
                    })
                    .catch(error => console.error('Error:', error));
                }
            </script>
        </div>
    </div>

    <!-- New Message Modal -->
    <div id="newMsgModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0, 0, 0, 0.5); align-items: center; justify-content: center;">
        <div class="modal-content" style="background-color: white; padding: 20px; border-radius: 5px; width: 75%; position: relative;">
            <h2>Add New Message</h2><br>
            <form id="newMessageForm" enctype="multipart/form-data">
                <input type="hidden" name="task_id" value="<?php echo $task_id; ?>">
                <input type="hidden" name="created_by" value="<?php echo $username_ajax; ?>">
                <input type="hidden" id="msg_status" name="msg_status" value="">
                <textarea id="message" name="message" style="width: 100%; height: 50vh;" required></textarea><br>
                <div id="attachments-container" style="margin-bottom: 10px;">
                    <label>Attachments:</label>
                    <div class="attachment-row" style="margin-bottom: 10px;">
                        <input type="file" name="attachments[]" onchange="handleAttachmentChange('attachments-container', this)">
                    </div>
                </div>

                <!-- Save button with dropdown -->
                <div style="position: relative; display: inline-block;">
                    <button type="button" id="saveBtnMsg">Submit As</button>
                    <div id="statusDropdown" style="display: none; position: absolute; bottom: 100%; left: 0; border-radius: 5px; width: 100%; z-index: 10;">
                        <button type="button" style="width: 100%; height: 50px;" onclick="setStatusAndSubmit('Open')">Open</button>
                        <button type="button" style="width: 100%; height: 50px;" onclick="setStatusAndSubmit('In Progress')">In Progress</button>
                        <button type="button" style="width: 100%; height: 50px;" onclick="setStatusAndSubmit('Completed')">Completed</button>
                        <button type="button" style="width: 100%; height: 50px;" onclick="setStatusAndSubmit('Deferred')">Deferred</button>
                        <button type="button" style="width: 100%; height: 50px;" onclick="setStatusAndSubmit('Canceled')">Canceled</button>
                    </div>
                </div>

                <button type="button" onclick="closeNewMessageModal()">Cancel</button>
            </form>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        function openNewMessageModal() {
            document.getElementById('newMsgModal').style.display = 'flex';
        }

        function closeNewMessageModal() {
            document.getElementById('newMsgModal').style.display = 'none';
        }

        function setStatusAndSubmit(status) {
            document.getElementById('msg_status').value = status; // Update hidden input
            $('#newMessageForm').submit(); // Submit the form
        }

        $(document).ready(function() {
            // Show dropdown on hover
            $('#saveBtnMsg').hover(function() {
                $('#statusDropdown').show();
            });

            // Hide dropdown when mouse leaves
            $('#statusDropdown').mouseleave(function() {
                $(this).hide();
            });

            // Handle form submission
            $('#newMessageForm').submit(function(e) {
                e.preventDefault(); // Prevent the default form submission
                var formData = new FormData(this); // Use FormData to handle file uploads

                // AJAX request
                $.ajax({
                    url: 'ajax_add_task_message.php', // PHP file to handle the form submission
                    type: 'POST',
                    data: formData,
                    processData: false, // Prevent jQuery from converting data into a string
                    contentType: false, // Let the browser set the correct content type
                    success: function(response) {
                        alert(response);
                        location.reload(); // Reload the page
                    },
                    error: function(xhr, status, error) {
                        alert('Error: ' + error); // Alert with the error message
                    }
                });
            });
        });

        function handleAttachmentChange(containerId, input) {
            const container = document.getElementById(containerId);

            // If the input has a file, display the file name
            if (input.files.length > 0) {
                // Hide the input field
                input.style.display = "none";

                // Create a span to display the file name
                const fileName = document.createElement("span");
                fileName.textContent = input.files[0].name;
                fileName.style.marginLeft = "10px";
                fileName.style.fontSize = "0.9em";

                // Add a remove icon
                const removeButton = document.createElement("button");
                removeButton.type = "button";
                removeButton.style.marginLeft = "10px";
                removeButton.style.border = "none";
                removeButton.style.background = "none";
                removeButton.style.color = "red";
                removeButton.style.cursor = "pointer";
                removeButton.style.fontSize = "1.2em";
                removeButton.innerHTML = `<i class="fa-regular fa-circle-xmark"></i>`;
                removeButton.onclick = function () {
                    // Remove the parent row
                    input.parentElement.remove();
                };

                // Append the file name and remove button to the current row
                input.parentElement.appendChild(fileName);
                input.parentElement.appendChild(removeButton);

                // Add a new file input for future attachments
                const newField = document.createElement("div");
                newField.className = "attachment-row";
                newField.style.marginBottom = "10px";
                newField.innerHTML = `
                    <input type="file" name="attachments[]" onchange="handleAttachmentChange('${containerId}', this)">
                `;

                container.appendChild(newField);
            }
        }
    </script>

    <style>
        input[type="text"], select, input[type="date"] {
            width: 100%;
            height: 30px;
            margin: 0;
        }
    </style>
    <?php 
}
else if (($title == 'admin' || $title == 'fit' || $title == 'sales' || $title == 'group' || $title == 'account' || $title == 'qa' || $title == 'external') && isset($_GET['opt']) && $_GET['opt'] == 'define-auto-task') {
    include "header.php";
    $sql = "SELECT auto_id, quotestage, assigned_to_region, assigned_to_user, message, active, category 
            FROM tdu_tasks_management_define_rule
            ORDER BY category DESC;";
    $resultTasks = mysqli_query($conn, $sql);

    $quotestage_array = fetchQuoteStages($conn);
    $assigned_to_region_array = fetchGroupNames($conn);
    $assigned_to_user_array = fetchUserTitlesAndNames($conn);
    $grouped_users = [];
    foreach ($assigned_to_user_array as $user) {
        $grouped_users[$user['title']][] = $user['name'];
    }
    ?>

    <div style="display: flex; justify-content: space-between; margin: 0; min-height: 100vh; width: 100%;">
        <div style="flex: 1; padding-right: 20px; background-color: #133e5e;">
            <h2 style="text-align: center; padding: 20px; color: white;">Task</h2>
        </div>
        <div style="flex: 9; padding-left: 20px; margin: 20px auto;">
            <?php if (mysqli_num_rows($resultTasks) > 0) : ?>
                <h1>Auto Create Task Console</h1>
                <table class="styled-table" id="tasks-table">
                    <?php $lastCategory = null; ?>
                    <?php while ($row = mysqli_fetch_assoc($resultTasks)) : ?>
                        <?php
                        if ($lastCategory !== $row['category']) {
                            if ($row['category'] == 'quotestage') {
                                ?>
                                <tr>
                                    <th style="text-align: center; width: 100px;"><button id="add-task-btn">+</button></th>
                                    <th style="text-align: left;">Quote Stage</th>
                                    <th style="text-align: left;">Category</th>
                                    <th style="text-align: left;">Assigned User</th>
                                    <th style="text-align: left; width: 40%;">Task Subject</th>
                                    <th></th>
                                </tr>
                                <?php 
                            } else if ($row['category'] == 'custom') {
                                ?>
                                <tr>
                                    <th style="text-align: center; width: 100px;"></th>
                                    <th style="text-align: left;">Condition</th>
                                    <th style="text-align: left;">Category</th>
                                    <th style="text-align: left;">Assigned User</th>
                                    <th style="text-align: left; width: 40%;">Description</th>
                                    <th></th>
                                </tr>
                                <?php 
                            }
                            $lastCategory = $row['category'];
                        }
                        ?>
                        <tr>
                            <?= ($row['active'] == 1) ? '<td style="text-align: center; background-color: lightgreen;">Active</td>' : '<td style="text-align: center; background-color: orange;">Paused</td>' ?>
                            <td style="text-align: left;"><span class="task-quotestage"><?php echo htmlspecialchars($row['quotestage']); ?></span></td>
                            <td style="text-align: left;" class="task-category" data-category="<?= htmlspecialchars($row['category']); ?>">
                                <span class="task-region"><?= htmlspecialchars($row['assigned_to_region']); ?></span>
                            </td>
                            <td style="text-align: left;">
                                <span class="task-user">
                                    <?php
                                        if ($row['assigned_to_user'] == '') {
                                            if ($row['assigned_to_region'] == 'Sales') {
                                                echo 'Quote Sales';
                                            } elseif ($row['assigned_to_region'] == 'Operation') {
                                                echo 'Quote Ops';
                                            } elseif ($row['assigned_to_region'] == 'QA') {
                                                echo 'Quote QA';
                                            }
                                        } else {
                                            echo htmlspecialchars($row['assigned_to_user']);
                                        }
                                    ?>
                                </span>
                            </td>
                            <td style="text-align: left;"><span class="task-message"><?php echo htmlspecialchars($row['message']); ?></span></td>
                            <td style="width: 200px; text-align: center;">
                                <button type="button" class="edit-task-btn" style="background-color: #2c70a2; color: white;" data-id="<?php echo htmlspecialchars($row['auto_id']); ?>">
                                    <i class="fa-solid fa-pencil"></i>
                                </button>
                                <?php if ($row['active'] == 1): ?>
                                    <button type="button" class="pause-task-btn" style="background-color: orange; color: white;" data-id="<?php echo htmlspecialchars($row['auto_id']); ?>">
                                        <i class="fa-solid fa-pause"></i>
                                    </button>
                                <?php else: ?>
                                    <button type="button" class="resume-task-btn" style="background-color: green; color: white;" data-id="<?php echo htmlspecialchars($row['auto_id']); ?>">
                                        <i class="fa-solid fa-play"></i>
                                    </button>
                                <?php endif; ?>
                                <button type="button" class="delete-task-btn" style="background-color: red; color: white;" data-id="<?php echo htmlspecialchars($row['auto_id']); ?>" <?= $row['category'] == 'quotestage' ? '' : 'disabled' ?>>
                                    <i class="fa-solid fa-trash-can"></i>
                                </button>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </table>
            <?php else : ?>
                <p style="margin: 20px; text-align: center;"><button id="add-task-btn">Add Task</button></p>
            <?php endif; ?>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        const quotestageOptions = <?php echo json_encode($quotestage_array); ?>;
        const regionOptions = <?php echo json_encode($assigned_to_region_array); ?>;
        const userOptionsGrouped = <?php echo json_encode($grouped_users); ?>;

        function buildSelect(name, selectedVal, options) {
            let select = '<select class="task-' + name + '">';
            select += '<option value="">-- Select --</option>';
            for (const option of options) {
                const selected = (option === selectedVal) ? ' selected' : '';
                select += '<option value="' + option + '"' + selected + '>' + option + '</option>';
            }
            select += '</select>';
            return select;
        }
        
        $(document).ready(function () {
            // Edit task inline
            $(document).on('click', '.edit-task-btn', function () {
                var taskId = $(this).data('id');
                var row = $(this).closest('tr');

                const currentQuotestage = row.find('.task-quotestage').text().trim();
                const currentRegion = row.find('.task-region').text().trim();
                const currentUser = row.find('.task-user').text().trim();
                const currentMessage = row.find('.task-message').text().trim();
                const category = row.find('.task-category').data('category');

                if (category === 'custom') {
                    // Only editable: region + user
                    row.find('.task-region').replaceWith(buildSelect('region', currentRegion, regionOptions));

                    let userSelect = '<select class="task-user">';
                    userSelect += '<option value="">None</option>';
                    for (const title in userOptionsGrouped) {
                        userSelect += '<option disabled>--- ' + title.toUpperCase() + ' ---</option>';
                        for (const name of userOptionsGrouped[title]) {
                            const selected = (name === currentUser) ? ' selected' : '';
                            userSelect += '<option value="' + name + '"' + selected + '>' + name + '</option>';
                        }
                    }
                    userSelect += '</select>';
                    row.find('.task-user').replaceWith(userSelect);

                } else {
                    // Fully editable
                    row.find('.task-quotestage').replaceWith(buildSelect('quotestage', currentQuotestage, quotestageOptions));
                    row.find('.task-region').replaceWith(buildSelect('region', currentRegion, regionOptions));
                    row.find('.task-message').replaceWith('<input class="task-message" type="text" value="' + currentMessage + '" style="width: 100%; height: 30px;" />');

                    let userSelect = '<select class="task-user">';
                    userSelect += '<option value="">None</option>';
                    for (const title in userOptionsGrouped) {
                        userSelect += '<option disabled>--- ' + title.toUpperCase() + ' ---</option>';
                        for (const name of userOptionsGrouped[title]) {
                            const selected = (name === currentUser) ? ' selected' : '';
                            userSelect += '<option value="' + name + '"' + selected + '>' + name + '</option>';
                        }
                    }
                    userSelect += '</select>';
                    row.find('.task-user').replaceWith(userSelect);
                }

                row.find('.edit-task-btn').html('<i class="fa-solid fa-check"></i>').removeClass('edit-task-btn').addClass('save-task-btn');
            });

            // Save task via AJAX
            $(document).on('click', '.save-task-btn', function () {
                var taskId = $(this).data('id');
                var row = $(this).closest('tr');

                var quotestage = row.find('.task-quotestage').val();
                var region = row.find('.task-region').val();
                var user = row.find('.task-user').val();
                var message = row.find('.task-message').val();

                $.ajax({
                    url: 'ajax_task_console.php',
                    type: 'POST',
                    data: {
                        action: 'update',
                        id: taskId,
                        quotestage: quotestage,
                        region: region,
                        user: user,
                        message: message
                    },
                    success: function (response) {
                        const result = JSON.parse(response);
                        if (result.success) {
                            location.reload();
                        } else {
                            alert('Update failed: ' + result.message);
                        }
                    }
                });
            });

            // Delete task
            $(document).on('click', '.delete-task-btn', function () {
                var taskId = $(this).data('id');
                if (confirm('Are you sure you want to delete this task?')) {
                    $.ajax({
                        url: 'ajax_task_console.php',
                        type: 'POST',
                        data: {
                            action: 'delete',
                            id: taskId
                        },
                        success: function (response) {
                            const result = JSON.parse(response);
                            if (result.success) {
                                alert('Task deleted successfully');
                                location.reload();
                            } else {
                                alert('Delete failed: ' + result.message);
                            }
                        }
                    });
                }
            });

            // Pause Task
            $(document).on('click', '.pause-task-btn', function () {
                const taskId = $(this).data('id');
                $.post('ajax_task_console.php', {
                    action: 'toggle_active',
                    id: taskId,
                    active: 0
                }, function (result) {
                    if (result.success) {
                        alert('Task paused.');
                        location.reload();
                    } else {
                        alert('Pause failed: ' + result.message);
                    }
                }, 'json');
            });

            // Resume Task
            $(document).on('click', '.resume-task-btn', function () {
                const taskId = $(this).data('id');
                $.post('ajax_task_console.php', {
                    action: 'toggle_active',
                    id: taskId,
                    active: 1
                }, function (result) {
                    if (result.success) {
                        alert('Task resumed.');
                        location.reload();
                    } else {
                        alert('Resume failed: ' + result.message);
                    }
                }, 'json');
            });

            // Add new task
            $('#add-task-btn').click(function () {
                $('#task-modal').show();
            });

            $('.close').click(function () {
                $('#task-modal').hide();
            });

            $('#add-task-form').submit(function (e) {
                e.preventDefault();
                const formData = $(this).serialize();

                $.ajax({
                    url: 'ajax_task_console.php',
                    type: 'POST',
                    data: formData + '&action=add',
                    success: function (response) {
                        const result = JSON.parse(response);
                        if (result.success) {
                            alert('Task added!');
                            location.reload();
                        } else {
                            alert('Add failed: ' + result.message);
                        }
                    }
                });
            });
        });
    </script>
    
    <div id="task-modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); width: 25%; background-color: white; padding: 20px; border: 1px solid rgb(204, 204, 204); z-index: 1000; box-shadow: rgba(0, 0, 0, 0.1) 0px 4px 6px;">
        <form id="add-task-form">
            <h2>New Rule</h2><br>
            <label>*Quote Stage:
                <select name="quotestage" required>
                    <option value="">-- Select --</option>
                    <?php foreach ($quotestage_array as $stage): ?>
                        <option value="<?php echo htmlspecialchars($stage); ?>"><?php echo htmlspecialchars($stage); ?></option>
                    <?php endforeach; ?>
                </select>
            </label><br><br>

            <label>*Category:
                <select name="assigned_to_region" required>
                    <option value="">-- Select --</option>
                    <?php foreach ($assigned_to_region_array as $region): ?>
                        <option value="<?php echo htmlspecialchars($region); ?>"><?php echo htmlspecialchars($region); ?></option>
                    <?php endforeach; ?>
                </select>
            </label><br><br>

            <label>Assigned User:
                <select name="assigned_to_user">
                    <option value="">None</option>
                    <?php
                    $grouped_users = [];
                    foreach ($assigned_to_user_array as $user) {
                        $grouped_users[$user['title']][] = $user['name'];
                    }
                    foreach ($grouped_users as $title => $names) {
                        echo '<option disabled>--- ' . strtoupper($title) . ' ---</option>';
                        foreach ($names as $name) {
                            echo '<option value="' . htmlspecialchars($name) . '">' . htmlspecialchars($name) . '</option>';
                        }
                    }
                    ?>
                </select>
            </label><br><br>

            <button type="submit">Add Task</button>
            <button type="button" class="close">Cancel</button>
        </form>
    </div>

    <style>
        select { width: 100%; height: 30px; }
    </style>
    <?php
}
else {
    header('Location: login.php');
    exit();
}
?>

<style>
    .styled-table {
        border-collapse: collapse;
        width: 100%;
        margin: 20px 0;
        font-size: 16px;
        text-align: left;
    }
    .styled-table th, .styled-table td {
        padding: 12px 15px;
        border-bottom: 1px solid #ddd;
    }
    .styled-table th {
        background-color: #2c70a2;
        color: white;
    }
    .styled-table tr:nth-of-type(odd) {
        background-color: #d5ebf7;
    }
    .styled-table tr:nth-of-type(even) {
        background-color: #f9f9f9;
    }
    .styled-table tr:hover {
        background-color: lightyellow;
    }

    button {
        color: black;
        background-color: #d5ebf7;
        padding: 6px 12px;
        cursor: pointer;
    }
    button:disabled {
        cursor: not-allowed;
        opacity: 0.6;
    }

    .task-summary-container p {
        margin: 10px;
    }
</style>
