<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>AJAX Debug Test</title>
    <style>
        body { font-family: sans-serif; padding: 20px; }
        table { border-collapse: collapse; width: 600px; margin-top: 20px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
        th, td { border: 1px solid #ddd; padding: 10px; text-align: left; }
        th { background-color: #f2f2f2; }
        .summary-row { cursor: pointer; }
        .summary-row:hover { background-color: #eaf6ff; }
        .detail-row { display: none; }
        .detail-row-cell { padding: 0 !important; }
        .detail-table { width: 100%; }
        .detail-table td { background-color: #fafafe; border: 0; }
    </style>
</head>
<body>

    <h1>AJAX Interaction Test</h1>
    <p>Click the row below. This will test the new, ultra-simple API.</p>

    <table>
        <thead>
            <tr>
                <th>Test Item</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <tr class="summary-row" onclick="toggleDetails(this)">
                <td>Click This Row to Start Test</td>
                <td class="status-cell">Pending</td>
            </tr>
            <tr class="detail-row">
                <td colspan="2" class="detail-row-cell">
                    <!-- Content from API will be injected here -->
                </td>
            </tr>
        </tbody>
    </table>

    <script>
    async function toggleDetails(summaryRow) {
        console.log("toggleDetails function started.");

        const detailRow = summaryRow.nextElementSibling;
        const detailCell = detailRow.querySelector('.detail-row-cell');
        const statusCell = summaryRow.querySelector('.status-cell');

        if (summaryRow.classList.contains('open')) {
            console.log("Row is open. Closing it now.");
            summaryRow.classList.remove('open');
            detailRow.style.display = 'none';
            statusCell.textContent = 'Pending';
            return;
        }

        // --- Start the process ---
        summaryRow.classList.add('open');
        detailRow.style.display = 'table-row';
        statusCell.textContent = 'Testing...';
        detailCell.innerHTML = `<div style="padding:15px; text-align:center;">Loading from API...</div>`;
        console.log("Set to loading state. Attempting to fetch from API...");

        try {
            // --- THIS IS THE ONLY CHANGE: Pointing to the new test_header_api.php ---
            const response = await fetch('test_header_api.php');
            console.log("Fetch response received:", response);

            if (!response.ok) {
                throw new Error(`API returned an error! Status: ${response.status}`);
            }

            const html = await response.text();
            console.log("API returned text:", html);

            // Inject the successful response from the API.
            detailCell.innerHTML = `<div style="padding:15px;">${html}</div>`;
            statusCell.textContent = 'Success!';
            statusCell.style.color = 'green';

        } catch (error) {
            console.error("An error occurred during the fetch operation:", error);
            detailCell.innerHTML = `<div style="padding:15px; text-align:center; color:red;"><b>Fetch Failed.</b> Check console for error details.</div>`;
            statusCell.textContent = 'Failed!';
            statusCell.style.color = 'red';
        }
    }
    </script>
</body>
</html>