<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

echo "Current PHP version: " . phpversion() . "\n";
echo "Current working directory: " . getcwd() . "\n";
$autoloaderPath = __DIR__ . '/vendor/autoload.php';
echo "Attempting to load autoloader from: " . $autoloaderPath . "\n";

if (file_exists($autoloaderPath)) {
    if (is_readable($autoloaderPath)) {
        echo "Autoloader file found and is readable.\n";
        require_once $autoloaderPath;
        echo "Autoloader included.\n";
    } else {
        echo "ERROR: Autoloader file found BUT IS NOT READABLE.\n";
        exit;
    }
} else {
    echo "ERROR: Autoloader file NOT FOUND at " . $autoloaderPath . "\n";
    exit;
}

$className = 'QuickBooksOnline\API\Core\OAuth2\OAuth2LoginHelper';
echo "Checking if class exists: " . $className . "\n";

if (class_exists($className)) {
    echo "SUCCESS: Class '" . $className . "' found by PHP.\n";
} else {
    echo "ERROR: Class '" . $className . "' NOT FOUND by PHP after including autoloader.\n";
    echo "\nIncluded files:\n";
    print_r(get_included_files());
}
?>