<?php
include "dbconn.php";
include "header.php";
include "dictionaries.php";

session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name']) || $_SESSION['title'] != 'admin') {
    header('Location: login.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $created_by = $_SESSION['user_name'];

    // Get full name of the logged-in user
    $sql_user = "SELECT CONCAT(first_name, ' ', last_name) AS user_fullname 
                 FROM vtiger_users WHERE user_name = '$created_by';";
    $result_user = mysqli_query($conn, $sql_user);
    if ($result_user && mysqli_num_rows($result_user) > 0) {
        $row_user = mysqli_fetch_assoc($result_user);
        $created_by = $row_user['user_fullname'];
    }

    // Handle CSV Import
    if (isset($_FILES['import_file'])) {
        $file = $_FILES['import_file']['tmp_name'];
        $handle = fopen($file, 'r');

        // Skip the header row of the CSV
        fgetcsv($handle);

        // Loop through each row in the CSV file
        while (($row = fgetcsv($handle)) !== false) {
            $key = $row[0];
            $value = $row[1];
            
            // Determine the type based on the key
            $type = ($key == 'organisation') ? 'accountname' : (($key == 'quote_no') ? 'quote_no' : null);

            if ($type == 'accountname') {
                $sql = "INSERT INTO vtiger_initial_invoice_percentage 
                        (type, accountname, created_by)
                        VALUES ('$type', '$value', '$created_by')";
                mysqli_query($conn, $sql) or die(mysqli_error($conn));
            } else if ($type == 'quote_no') {
                $sql = "INSERT INTO vtiger_initial_invoice_percentage 
                        (type, quote_no, created_by)
                        VALUES ('$type', '$value', '$created_by')";
                mysqli_query($conn, $sql) or die(mysqli_error($conn));
            }
        }

        fclose($handle);
        echo "<script>
                alert('CSV file imported successfully!');
                window.location.href = '?filter=';
              </script>";
        exit;
    }

    // Handle Adding Single Accountname
    if (isset($_POST['accountname'])) {
        $accountname = mysqli_real_escape_string($conn, $_POST['accountname']);
        $sql = "INSERT INTO vtiger_initial_invoice_percentage 
                (type, accountname, created_by)
                VALUES ('accountname', '$accountname', '$created_by')";
        mysqli_query($conn, $sql) or die(mysqli_error($conn));
        echo "<script>
                alert('Accountname added successfully!');
                window.location.href = '?filter=org';
              </script>";
        exit;
    }

    // Handle Adding Single Quote No
    if (isset($_POST['quote_no'])) {
        $quote_no = mysqli_real_escape_string($conn, $_POST['quote_no']);
        $sql = "INSERT INTO vtiger_initial_invoice_percentage 
                (type, quote_no, created_by)
                VALUES ('quote_no', '$quote_no', '$created_by')";
        mysqli_query($conn, $sql) or die(mysqli_error($conn));
        echo "<script>
                alert('Quote No added successfully!');
                window.location.href = '?filter=quote';
              </script>";
        exit;
    }
}

$filter = isset($_GET['filter']) ? $_GET['filter'] : '';
$column = '';
$title = '';
if ($filter === 'quote') {
    $sql = "
        SELECT iip.quote_no, iip.auto_id, 
               q.quoteid, q.accountid, q.country,
               qcf.cf_1162,
               org.organization_name
        FROM vtiger_initial_invoice_percentage iip
        LEFT JOIN vtiger_quotes q ON iip.quote_no = q.quote_no
        LEFT JOIN vtiger_quotescf qcf ON q.quoteid = qcf.quoteid
        LEFT JOIN tdu_organisation org ON q.accountid = org.organizationid 
        WHERE iip.type = 'quote_no'
    ";
    $column = 'quote_no';
    $title = 'Quote Number';
} elseif ($filter === 'org') {
    $sql = "SELECT accountname, auto_id FROM vtiger_initial_invoice_percentage WHERE type = 'accountname'";
    $column = 'accountname';
    $title = 'Organization';
} else {
    $sql = "";
}


?>
<h1 style="text-align: center; margin-top: 20px;">Initial Invoice Discount</h1>
<div style="text-align: center; margin: 20px;">
    <button onclick="window.location.href='?filter=quote'" style="padding: 10px 20px; margin-right: 10px;">Quote Number</button>
    <button onclick="window.location.href='?filter=org'" style="padding: 10px 20px;">Organization</button>
</div>
<?php

if (!empty($sql)) {
    $result = mysqli_query($conn, $sql);

    if ($result && mysqli_num_rows($result) > 0) {
        echo '<table class="styled-table" style="width: 80%; margin: 20px auto;">';

        // Title row
        echo '<thead><tr><th colspan="' . ($filter === 'quote' ? '4' : '2') . '">' . htmlspecialchars($title) . '</th></tr>';

        // Search bar
        echo '<tr><th colspan="' . ($filter === 'quote' ? '4' : '2') . '" style="background-color: transparent;">';
        echo '<input type="text" id="searchInput" onkeyup="filterTable()" placeholder="Search..." style="width: 100%;">';
        echo '</th></tr>';

        // Table headers
        if ($filter === 'quote') {
            echo '<tr><th>' . htmlspecialchars($title) . '</th><th>Travel Date</th><th>Organization</th><th>Country</th><th></th></tr>';
        } else {
            echo '<tr><th>' . htmlspecialchars($title) . '</th><th></th></tr>';
        }

        echo '</thead>';
        echo '<tbody id="tableBody">';

        while ($row = mysqli_fetch_assoc($result)) {
            echo '<tr id="row-' . $row['auto_id'] . '">';
            echo '<td>' . htmlspecialchars($row[$column]) . '</td>';
        
            if ($filter === 'quote') {
                echo '<td>' . htmlspecialchars($row['cf_1162'] ?? '-') . '</td>';
                echo '<td>' . htmlspecialchars($row['organization_name'] ?? '-') . '</td>';
                echo '<td>' . htmlspecialchars($row['country'] ?? '-') . '</td>';
            }
        
            echo '<td><button class="delete-button" onclick="deleteRow(' . $row['auto_id'] . ')" style="background-color: red;"><i class="fa-solid fa-trash-can"></i></button></td>';
            echo '</tr>';
        }        

        echo '</tbody>';
        echo '</table>';
    } else {
        echo '<p style="text-align: center;">No results found.</p>';
    }
}
?>
<div style="text-align: center; margin-bottom: 20px;">
    <button class="submit-button" onclick="openModal('orgModal')">+ Organisation</button>
    <button class="submit-button" onclick="openModal('quoteModal')">+ Quote</button>
    <button class="submit-button" onclick="openModal('csvModal')">Import CSV</button>
</div>

<script>
    function filterTable() {
        var input = document.getElementById("searchInput");
        var filter = input.value.toUpperCase();
        var table = document.querySelector(".styled-table");
        var tr = table.getElementsByTagName("tr");

        for (let i = 3; i < tr.length; i++) {
            let tds = tr[i].getElementsByTagName("td");
            let quoteCell = tds[0];
            let orgCell = tds[2];
            let match = false;

            // Reset original text first (strip any previous highlighting)
            if (quoteCell) quoteCell.innerHTML = quoteCell.textContent;
            if (orgCell) orgCell.innerHTML = orgCell.textContent;

            // Check quote number
            if (quoteCell) {
                let text = quoteCell.textContent;
                let index = text.toUpperCase().indexOf(filter);
                if (index > -1) {
                    match = true;
                    quoteCell.innerHTML = highlightMatch(text, index, filter.length);
                }
            }

            // Check organization name
            if (orgCell) {
                let text = orgCell.textContent;
                let index = text.toUpperCase().indexOf(filter);
                if (index > -1) {
                    match = true;
                    orgCell.innerHTML = highlightMatch(text, index, filter.length);
                }
            }

            tr[i].style.display = match ? "" : "none";
        }
    }

    function highlightMatch(text, startIndex, length) {
        return text.substring(0, startIndex) +
               '<span style="background-color: #ffff99;">' +
               text.substring(startIndex, startIndex + length) +
               '</span>' +
               text.substring(startIndex + length);
    }

    function deleteRow(auto_id) {
        if (confirm('Are you sure you want to delete this record?')) {
            var xhr = new XMLHttpRequest();
            xhr.open('POST', 'ajax_delete_80_initial_payment.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onreadystatechange = function() {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    if (xhr.responseText == 'success') {
                        // Remove the row from the table
                        var row = document.getElementById('row-' + auto_id);
                        row.parentNode.removeChild(row);
                    } else {
                        alert('Failed to delete the record.');
                    }
                }
            };
            xhr.send('auto_id=' + auto_id);
        }
    }
</script>

<?php $accountnames = fetchOrganizationNames80($conn); ?>
<?php $quote_nos = fetchTDUNames80($conn); ?>

<!-- Add Organisation Modal -->
<div id="orgModal" class="modal">
    <div class="modal-content">
        <span class="close" onclick="closeModal('orgModal')">&times;</span>
        <h2 class="form-title">Add Organisation</h2><br>
        <form method="POST">
            <input type="text" id="accountname" name="accountname" class="text-input" list="accountname-list" required>
            <datalist id="accountname-list">
                <?php foreach ($accountnames as $name): ?>
                    <option value="<?= htmlspecialchars($name) ?>"></option>
                <?php endforeach; ?>
            </datalist>
            <button type="submit" class="submit-button">Add</button>
        </form>
    </div>
</div>

<!-- Add Quote No Modal -->
<div id="quoteModal" class="modal">
    <div class="modal-content">
        <span class="close" onclick="closeModal('quoteModal')">&times;</span>
        <h2 class="form-title">Add Quote No</h2><br>
        <form method="POST">
            <input type="text" id="quote_no" name="quote_no" class="text-input" list="quote_no-list" required>
            <datalist id="quote_no-list">
                <?php foreach ($quote_nos as $quote): ?>
                    <option value="<?= htmlspecialchars($quote) ?>"></option>
                <?php endforeach; ?>
            </datalist>
            <button type="submit" class="submit-button">Add</button>
        </form>
    </div>
</div>

<!-- Import CSV Modal -->
<div id="csvModal" class="modal">
    <div class="modal-content">
        <span class="close" onclick="closeModal('csvModal')">&times;</span>
        <h2 class="form-title">Import CSV</h2><br>
        <form method="POST" enctype="multipart/form-data">
            <label for="import_file" class="file-input-label">Upload CSV: <a href="vendor_uploads/initial-invoice-discount-template.csv" download>Download Template</a></label>
            <br><br><input type="file" id="import_file" name="import_file" accept=".csv" class="file-input">
            <br><button type="submit" class="submit-button">Import</button>
        </form>
    </div>
</div>

<!-- JavaScript to toggle modals -->
<script>
    function openModal(id) {
        document.getElementById(id).style.display = 'block';
    }

    function closeModal(id) {
        document.getElementById(id).style.display = 'none';
    }

    // Close when clicking outside the modal content
    window.onclick = function(event) {
        document.querySelectorAll('.modal').forEach(modal => {
            if (event.target === modal) {
                modal.style.display = "none";
            }
        });
    }
</script>
<!-- JavaScript to validate input -->
<script>
    function validateOnBlur(inputId, datalistId) {
        const input = document.getElementById(inputId);
        const datalist = document.getElementById(datalistId);
        const options = Array.from(datalist.options).map(option => option.value);

        input.addEventListener('blur', () => {
            if (input.dataset.validated) {
                input.dataset.validated = ''; // Clear flag after validation
                return; // Avoid further validation on refocus
            }
            if (!options.includes(input.value) && input.value !== '') {
                alert(`${input.value} is not available. Please check.`);
                input.value = ''; // Clear the input field
                input.dataset.validated = 'true'; // Set validation flag
                input.focus(); // Refocus on the input field
            }
        });
    }

    // Attach blur event listeners
    validateOnBlur('accountname', 'accountname-list');
    validateOnBlur('quote_no', 'quote_no-list');
</script>

<!-- basic style -->
<style>
    .styled-table {
        border-collapse: collapse;
        width: 100%;
        margin: 20px 0;
        font-size: 16px;
        text-align: center;
    }
    .styled-table th, .styled-table td {
        padding: 12px 15px;
        border-bottom: 1px solid #ddd;
    }
    .styled-table th {
        background-color: #f9f9f9;
        color: #333;
    }
    .styled-table tr:nth-of-type(even) {
        /*background-color: #f9f9f9;*/
    }
    .styled-table tr:hover {
        /*background-color: #f1f1f1;*/
    }
    .styled-table th input[type="number"] {
        width: 40px;
        padding: 5px;
        margin: 0 5px;
        box-sizing: border-box;
    }
    .styled-table td input[type="number"] {
        width: 80px;
        padding: 5px;
        margin: 0 5px;
        box-sizing: border-box;
    }
    .styled-table select, .styled-table input[type="text"] {
        width: 150px;
    }
    .styled-table input[type="submit"] {
        margin: 20px 0;
        padding: 10px 20px;
        background-color: #ffbb00;
        border: none;
        color: #fff;
        font-size: 16px;
        cursor: pointer;
    }
    .styled-table input[type="submit"]:hover {
        background-color: #e0a800;
    }

    button {
        color: white;
        background-color: #334155;
        padding: 3px 6px;
        cursor: pointer;
    }
    button:disabled {
        cursor: not-allowed;
        opacity: 0.6;
    }
</style>
<!-- modal style -->
<style>
    .modal {
        display: none;
        position: fixed;
        z-index: 1000;
        left: 0; top: 0;
        width: 100%; height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
    }
    .modal-content {
        background-color: white;
        margin: 15% auto;
        padding: 20px;
        border-radius: 8px;
        width: 400px;
        position: relative;
    }
    .close {
        position: absolute;
        right: 15px;
        top: 10px;
        font-size: 24px;
        cursor: pointer;
    }
    .submit-button {
        margin-top: 10px;
        background-color: green;
        padding: 10px 20px;
    }

    input[type="text"] {
        width: 100%;
        height: 30px;
    }
</style>