<?php
include "dbconn.php";

session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name'])) {
    header('Location: login.php');
    exit;
}

// Check if form was submitted and a file was uploaded
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $timestamp = date('Y-m-d-H-i-s');

    if(isset($_POST['new'])) {
        $country = mysqli_real_escape_string($conn, $_POST['country']);
        $city = mysqli_real_escape_string($conn, $_POST['city']);
        $location = mysqli_real_escape_string($conn, $_POST['location']);
        $market = mysqli_real_escape_string($conn, $_POST['market']);
        $vendor_name = mysqli_real_escape_string($conn, $_POST['vendor_name']);
        $category = mysqli_real_escape_string($conn, $_POST['category']);

        $sql = "INSERT INTO tdu_vendor (country, city, location, vendor_name, market, category) 
                VALUES ('$country', '$city', '$location', '$vendor_name', '$market', '$category')";
        mysqli_query($conn, $sql) or die(mysqli_error($conn));

        $vendor_id = mysqli_insert_id($conn);
    } else {
        $vendor_id = $_POST['vendor_id'];
    }
    
    if (isset($_FILES['file_input']) && $_FILES['file_input']['error'] == 0 && $category != 'Transfer') {
        $allowed_pdf = array("pdf" => "application/pdf");
        $filename = $_FILES['file_input']['name'];
        $filetype = $_FILES['file_input']['type'];
        $filesize = $_FILES['file_input']['size'];

        // Verify file extension for PDF
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        if (!array_key_exists($ext, $allowed_pdf)) {
            die("Error: Please select a valid PDF file.");
        }

        // Verify file size - 25MB maximum
        if ($filesize > 25 * 1024 * 1024 - 1) {
            die("Error: File size is larger than the allowed limit (10M).");
        }

        // Save the uploaded PDF file to the server
        $pdfFilePath = 'vendor_uploads/' . pathinfo($filename, PATHINFO_FILENAME) . '-' . $timestamp . '.' . $ext;
        move_uploaded_file($_FILES['file_input']['tmp_name'], $pdfFilePath);

        // Update vendor's pdf_path in the database
        $sql = "UPDATE tdu_vendor SET pdf_path='$pdfFilePath' WHERE vendor_id='$vendor_id'";
        mysqli_query($conn, $sql) or die(mysqli_error($conn));

        if($category == 'Transfer-PDF') {
            $category = 'Transfer';
        }
        echo "
            <script>
                alert('Data saved successfully!');
                window.location.href = 'quote.php?opt=vendor&country=au&category=". $category ."';
            </script>";
    } 

    // Check if file was uploaded without errors
    else if (isset($_FILES['file_input']) && $_FILES['file_input']['error'] == 0 && $category == 'Transfer') {
        // Allowed file types
        $allowed = array("csv" => "text/csv", "csv" => "application/vnd.ms-excel");
        $filename = $_FILES['file_input']['name'];
        $filetype = $_FILES['file_input']['type'];
        $filesize = $_FILES['file_input']['size'];

        // Verify file extension
        $ext = pathinfo($filename, PATHINFO_EXTENSION);
        if (!array_key_exists($ext, $allowed)) {
            die("Error: Please select a valid CSV file.");
        }

        // Verify file size - 25MB maximum
        if ($filesize > 25 * 1024 * 1024 - 1) {
            die("Error: File size is larger than the allowed limit (10M).");
        }

        // Save the uploaded file to the server (in the same directory)
        $csvFilePath = 'vendor_uploads/' . pathinfo($filename, PATHINFO_FILENAME) . '-' . $timestamp . '.' . $ext;
        move_uploaded_file($_FILES['file_input']['tmp_name'], $csvFilePath);

        // Process the CSV file
        if (($handle = fopen($csvFilePath, 'r')) !== FALSE) {
            // Read the first row (headers) for dynamic sub-categories
            $headers = fgetcsv($handle);

            // The first column is 'SERVICE', so sub-categories start from the second column
            $sub_categories = array_slice($headers, 1);  // Get all seat categories dynamically

            // Read each row of the CSV
            while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                // Assign values from each column
                $product_name = $conn->real_escape_string($data[0]);  // SERVICE column

                // Insert for each sub_category with price
                for ($i = 1; $i < count($data); $i++) {  // Start from column 1 (second column)
                    $sub_category = $conn->real_escape_string($sub_categories[$i - 1]); // Dynamic sub-category
                    $price = str_replace(array('$', ','), '', $data[$i]);  // Remove $ sign if necessary
                    $price = floatval($price);  // Convert to float for decimal values

                    // Build SQL query
                    $sql = "INSERT INTO tdu_product (vendor_id, product_name, sub_category, price) 
                            VALUES ('$vendor_id', '$product_name', '$sub_category', $price)";
                    mysqli_query($conn, $sql) or die("". mysqli_error($conn));
                }
            }
            fclose($handle);
            echo "
                <script>
                    alert('Data saved successfully!');
                    window.location.href = 'quote.php?opt=vendor&country=au&category=". $category ."';
                </script>";
        } else {
            echo "Could not open the CSV file.";
        }
    } else {
        echo "Error: " . $_FILES['file_input']['error'];
    }
}

// Close the connection
mysqli_close($conn);
?>
