<?php
include "dbconn.php";
include "header.php";

// Fetch user roles
$sql = "SELECT * FROM tdu_user_roles WHERE user_role != 'block'";
$result = mysqli_query($conn, $sql);

// Fetch available quote stages
$quoteStagesQuery = "SELECT auto_id, quotestage FROM vtiger_quotestage WHERE quotestage != 'Auto Rejected'";
$quoteStagesResult = mysqli_query($conn, $quoteStagesQuery);
$availableStages = [];
while ($row = mysqli_fetch_assoc($quoteStagesResult)) {
    $availableStages[$row['auto_id']] = $row['quotestage'];
}

// Fetch available quote tabs
$quoteTabsQuery = "SELECT auto_id, tab FROM vtiger_quotetab";
$quoteTabsResult = mysqli_query($conn, $quoteTabsQuery);
$availableTabs = [];
while ($row = mysqli_fetch_assoc($quoteTabsResult)) {
    $availableTabs[$row['auto_id']] = $row['tab'];
}
?>

<h1 style="margin: 20px; text-align: center;">Role Admin</h1>
<table class="styled-table" style="width: 50%; margin: auto;">
    <thead>
        <tr>
            <th>User Role</th>
            <th></th>
        </tr>
    </thead>
    <tbody>
        <?php while ($row = mysqli_fetch_assoc($result)) : ?>
            <tr>
                <td><?php echo htmlspecialchars($row['user_role_display']); ?></td>
                <td>
                    <button class="manage-stages" data-role-id="<?php echo $row['auto_id']; ?>" data-stages="<?php echo htmlspecialchars($row['quote_stages']); ?>">Manage Stages</button>
                    <button class="manage-tabs" data-role-id="<?php echo $row['auto_id']; ?>" data-tabs="<?php echo htmlspecialchars($row['quote_tabs']); ?>">Manage Tabs</button>
                </td>
            </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<!-- Modal for Quote Stages -->
<div id="quoteStageModal" class="modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 20px; border: 1px solid #ccc; box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);">
    <div class="modal-content">
        <span class="close" style="cursor: pointer; float: right; font-size: 20px;">&times;</span>
        <h2>Manage Quote Stages</h2><br>
        <form id="quoteStageForm">
            <input type="hidden" id="roleId" name="role_id" value="">
            <?php foreach ($availableStages as $id => $stage) : ?>
                <label>
                    <input type="checkbox" class="quote-stage" name="quote_stages[]" value="<?php echo $id; ?>"> <?php echo $stage; ?>
                </label><br>
            <?php endforeach; ?>
            <br><label><input type="checkbox" id="selectAllStages"> Select All</label><br>

            <button type="submit">Save</button>
        </form>
    </div>
</div>

<!-- Modal for Quote Tabs -->
<div id="quoteTabModal" class="modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 20px; border: 1px solid #ccc; box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);">
    <div class="modal-content">
        <span class="close" style="cursor: pointer; float: right; font-size: 20px;">&times;</span>
        <h2>Tabs</h2><br>
        <form id="quoteTabForm">
            <input type="hidden" id="roleTabId" name="role_id" value="">
            <?php foreach ($availableTabs as $id => $tab) : ?>
                <label>
                    <input type="checkbox" class="quote-tab" name="quote_tabs[]" value="<?php echo $id; ?>"> <?php echo $tab; ?>
                </label><br>
            <?php endforeach; ?>
            <br><label><input type="checkbox" id="selectAllTabs"> Select All</label><br>
            
            <button type="submit">Save</button>
        </form>
    </div>
</div>

<script>
    document.getElementById('selectAllStages').addEventListener('change', function() {
        let checkboxes = document.querySelectorAll('.quote-stage');
        checkboxes.forEach(checkbox => checkbox.checked = this.checked);
    });
    
    document.getElementById('selectAllTabs').addEventListener('change', function() {
        let checkboxes = document.querySelectorAll('.quote-tab');
        checkboxes.forEach(checkbox => checkbox.checked = this.checked);
    });

    document.querySelectorAll('.manage-stages').forEach(button => {
        button.addEventListener('click', function () {
            document.getElementById('quoteTabModal').style.display = 'none';

            let roleId = this.getAttribute('data-role-id');
            let stages = this.getAttribute('data-stages').split(',');
            document.getElementById('roleId').value = roleId;

            document.querySelectorAll('#quoteStageForm input[type=checkbox]').forEach(checkbox => {
                checkbox.checked = stages.includes(checkbox.value);
            });
            
            document.getElementById('quoteStageModal').style.display = 'block';
        });
    });
    
    document.querySelectorAll('.manage-tabs').forEach(button => {
        button.addEventListener('click', function () {
            document.getElementById('quoteStageModal').style.display = 'none';

            let roleId = this.getAttribute('data-role-id');
            let tabs = this.getAttribute('data-tabs').split(',');
            document.getElementById('roleTabId').value = roleId;

            document.querySelectorAll('#quoteTabForm input[type=checkbox]').forEach(checkbox => {
                checkbox.checked = tabs.includes(checkbox.value);
            });
            
            document.getElementById('quoteTabModal').style.display = 'block';
        });
    });

    document.querySelectorAll('.close').forEach(closeBtn => {
        closeBtn.addEventListener('click', function () {
            document.getElementById('quoteStageModal').style.display = 'none';
            document.getElementById('quoteTabModal').style.display = 'none';
        });
    });

    document.getElementById('quoteStageForm').addEventListener('submit', function (e) {
        e.preventDefault();
        let formData = new FormData(this);

        fetch('ajax_admin_quote_stages.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.text())
        .then(data => {
            alert('Quote stages updated successfully!');
            document.getElementById('quoteStageModal').style.display = 'none';
            window.location.reload();
        })
        .catch(error => console.error('Error:', error));
    });

    document.getElementById('quoteTabForm').addEventListener('submit', function (e) {
        e.preventDefault();
        let formData = new FormData(this);

        fetch('ajax_admin_quote_tabs.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.text())
        .then(data => {
            alert('Quote tabs updated successfully!');
            document.getElementById('quoteTabModal').style.display = 'none';
            window.location.reload();
        })
        .catch(error => console.error('Error:', error));
    });
</script>

<!-- Auto CC Emails -->
<h1 style="margin: 20px; text-align: center;">Auto CC Emails by Region</h1>
<table class="styled-table" style="width: 50%; margin: auto;">
    <thead>
        <tr>
            <th>Region</th>
            <th>Emails</th>
            <th>Email Type</th>
            <th></th>
        </tr>
    </thead>
    <tbody>
        <?php
        $email_query = "SELECT auto_id, region, email, email_type FROM tdu_email_auto_cc ORDER BY region";
        $email_result = mysqli_query($conn, $email_query);

        $regions = [];

        while ($row = mysqli_fetch_assoc($email_result)) {
            $regions[$row['region']][] = $row;
        }

        foreach ($regions as $region => $emailEntries):
            foreach ($emailEntries as $index => $entry): ?>
                <tr>
                    <?php if ($index === 0): ?>
                        <td rowspan="<?= count($emailEntries); ?>"><?= htmlspecialchars($region); ?></td>
                    <?php endif; ?>
                    <td><?= htmlspecialchars($entry['email']); ?></td>
                    <td><?= htmlspecialchars($entry['email_type'] ?? ''); ?></td>
                    <td style="width: 10%;">
                        <button class="editEmailBtn"
                                data-id="<?= $entry['auto_id']; ?>"
                                data-region="<?= htmlspecialchars($region); ?>"
                                data-email="<?= htmlspecialchars($entry['email']); ?>"
                                data-type="<?= htmlspecialchars($entry['email_type'] ?? ''); ?>">
                            <i class="fa-solid fa-pen"></i>
                        </button>
                        <button class="deleteEmailBtn" data-id="<?= $entry['auto_id']; ?>" style="background-color: red; color: white;">
                            <i class="fa-solid fa-trash-can"></i>
                        </button>
                    </td>
                </tr>
            <?php endforeach;
        endforeach;
        ?>
        <tr>
            <td colspan="4" style="text-align: center;">
                <button id="openAddRegionEmailModal">+ Auto CC Rule</button>
            </td>
        </tr>
    </tbody>
</table>

<!-- Modal -->
<div id="addRegionEmailModal" class="modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 20px; border: 1px solid #ccc; box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1); z-index: 1000;">
    <div class="modal-content">
        <span class="close" style="cursor: pointer; float: right; font-size: 20px;">&times;</span>
        <h2 id="modalTitle">Add Auto CC Email</h2><br>
        <form id="addRegionEmailForm">
            <input type="hidden" name="auto_id" id="auto_id">
            <label for="cc_region">Region:</label><br>
            <select name="cc_region" id="cc_region" required style="width: 50vw; height: 30px;">
                <option value=""></option>
                <?php
                $sqlr = "SELECT groupname FROM vtiger_groups";
                $resultr = $conn->query($sqlr);
                if ($resultr->num_rows > 0) {
                    while ($rowr = $resultr->fetch_assoc()) {
                        echo "<option value=\"" . htmlspecialchars($rowr['groupname']) . "\">" . htmlspecialchars($rowr['groupname']) . "</option>";
                    }
                }
                ?>
            </select><br><br>

            <label for="cc_email">Email:</label><br>
            <input type="text" name="cc_email" id="cc_email" required style="width: 50vw; height: 30px;"><br><br>

            <label for="cc_type">Email Type:</label><br>
            <select name="cc_type" id="cc_type" required style="width: 50vw; height: 30px;">
                <option value="All">All</option>
                <option value="Group">Group</option>
                <option value="FIT">FIT</option>
            </select><br><br>

            <button type="submit" id="submitBtn">Add</button>
        </form>
    </div>
</div>

<script>
    const modal = document.getElementById('addRegionEmailModal');
    const form = document.getElementById('addRegionEmailForm');
    const autoIdInput = document.getElementById('auto_id');
    const regionInput = document.getElementById('cc_region');
    const emailInput = document.getElementById('cc_email');
    const typeInput = document.getElementById('cc_type');
    const modalTitle = document.getElementById('modalTitle');
    const submitBtn = document.getElementById('submitBtn');

    // Open modal for add
    document.getElementById('openAddRegionEmailModal').addEventListener('click', function () {
        autoIdInput.value = '';
        regionInput.value = '';
        emailInput.value = '';
        typeInput.value = '';
        modalTitle.textContent = 'Add Auto CC Email';
        submitBtn.textContent = 'Add';
        modal.style.display = 'block';
    });

    // Close modal
    document.querySelectorAll('.close').forEach(closeBtn => {
        closeBtn.addEventListener('click', function () {
            modal.style.display = 'none';
        });
    });

    // Open modal for edit
    document.querySelectorAll('.editEmailBtn').forEach(button => {
        button.addEventListener('click', function () {
            autoIdInput.value = this.dataset.id;
            regionInput.value = this.dataset.region;
            emailInput.value = this.dataset.email;
            typeInput.value = this.dataset.type || '';
            modalTitle.textContent = 'Edit Auto CC Email';
            submitBtn.textContent = 'Update';
            modal.style.display = 'block';
        });
    });

    // Submit form
    form.addEventListener('submit', function (e) {
        e.preventDefault();
        let formData = new FormData(form);

        fetch('ajax_add_region_email.php', {
            method: 'POST',
            body: formData
        })
        .then(res => res.text())
        .then(data => {
            alert(data || 'Success!');
            modal.style.display = 'none';
            window.location.reload();
        })
        .catch(err => console.error('Error:', err));
    });

    // Delete email
    document.querySelectorAll('.deleteEmailBtn').forEach(button => {
        button.addEventListener('click', function () {
            if (confirm("Are you sure you want to delete this email?")) {
                let id = this.dataset.id;
                fetch('ajax_delete_region_email.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: 'auto_id=' + encodeURIComponent(id)
                })
                .then(res => res.text())
                .then(data => {
                    alert(data || 'Deleted successfully!');
                    window.location.reload();
                })
                .catch(err => console.error('Error:', err));
            }
        });
    });
</script>


<style>
    .styled-table {
        border-collapse: collapse;
        width: 100%;
        margin: 20px 0;
        font-size: 16px;
        text-align: center;
    }
    .styled-table th, .styled-table td {
        padding: 12px 15px;
        border-bottom: 1px solid #ddd;
        text-align: left;
    }
    .styled-table th {
        background-color: #f9f9f9;
        color: #333;
    }
    .styled-table tr:nth-of-type(even) {
        /*background-color: #f9f9f9;*/
    }
    .styled-table tr:hover {
        /*background-color: #f1f1f1;*/
    }
    .styled-table th input[type="number"] {
        width: 40px;
        padding: 5px;
        margin: 0 5px;
        box-sizing: border-box;
    }
    .styled-table td input[type="number"] {
        width: 80px;
        padding: 5px;
        margin: 0 5px;
        box-sizing: border-box;
    }
    .styled-table select, .styled-table input[type="text"] {
        width: 150px;
    }
    .styled-table input[type="submit"] {
        margin: 20px 0;
        padding: 10px 20px;
        background-color: #ffbb00;
        border: none;
        color: #fff;
        font-size: 16px;
        cursor: pointer;
    }
    .styled-table input[type="submit"]:hover {
        background-color: #e0a800;
    }
    button {
        color: white;
        background-color: #334155;
        padding: 3px 6px;
        cursor: pointer;
    }
    select, #createUserForm input[type="text"]{
        height: 30px;
        margin: 0;
    }
</style>
