<?php
include "dbconn.php";
include "header.php";
include "dictionaries.php";

session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name']) || $_SESSION['title'] != 'admin') {
    header('Location: login.php');
    exit;
}
$username = $_SESSION['user_name'];

if (!isset($_SESSION['tdu_tai_assigned_role_checked'])) {
    if (function_exists('setup_tdu_tai_assigned_role_table')) {
        setup_tdu_tai_assigned_role_table($conn); // Call it once per session
        $_SESSION['tdu_tai_assigned_role_checked'] = true;
    } else {
        error_log("CRITICAL_ADMIN_PAGE_SETUP: setup_tdu_tai_assigned_role_table function is missing!");
        // Display an error to the admin or handle gracefully
    }
}

// SQL query
$sql = "SELECT id, user_name, CONCAT(first_name, ' ', last_name) AS name, title, department, quote_view, file_access, quote_pricing, alias_name, delete_tag, view_followup
        FROM vtiger_users 
        WHERE status = 'Active'";
$result = mysqli_query($conn, $sql);

$rolesHumanReadable = [
    "admin" => "Admin",
    "account" => "Account",
    "group" => "Ops",
    "sales" => "Internal Sales",
    "external" => "External Sales",
    "qa" => "QA",
    "block" => "No Access"
];

//START TAG MODIFICATION
$availableSystemTypes = [
    110 => 'Complaint',
    92  => 'Confirmation',
    108 => 'Following up Vouchers',
    109 => 'Payment on Arrival',
    88  => 'Post Sales',
    101 => 'Post Sales In Progress',
    89  => 'Pre Sales',
    90  => 'Quotes',
    105 => 'Refund',
    91  => 'Requote',
    107 => 'Requote after Confirmation'
];
//END TAG MODIFICATION

$quoteHumanReadable = [
    "both" => "(All Quotes)",
    "group" => "(Group Quotes)",
    "fit" => "(FIT Quotes)",
];
?>

<h1 style="margin: 20px; text-align: center;">User Role Admin</h1>
<table class="styled-table" style="width: 90%; margin: auto;" id="userTable">
    <thead>
        <tr>
            <th>Username</th>
            <th>Name</th>
            <th>Alias Name</th>
            <th>Role</th>
            <th style="text-align: center;">Quote</th>
            <th style="text-align: center;">Pricing</th>
            <th style="text-align: center;">Del Tag</th>
            <th style="text-align: center;">Followup</th>
            <th>Region</th>
            <th>Type</th><!-- TAG MOFICATION-->
            <th style="text-align: center;">
                <button onclick="openCreateUserModal()">Create User</button>
            </th>
        </tr>
        <tr>
          <td></td>
          <td>
            <input type="text" id="filterName" placeholder="Filter by Name" onkeyup="filterTable()" style="padding: 5px; width: 100%;">
          </td>
          <td></td>
          <td>
            <select id="filterRole" onchange="filterTable()" style="padding: 5px; width: 100%;">
                <option value="">All</option>
                <option value="Admin">Admin</option>
                <option value="Account">Account</option>
                <option value="Ops">Ops</option>
                <option value="Internal Sales">Internal Sales</option>
                <option value="External Sales">External Sales</option>
                <option value="QA">QA</option>
                <option value="No Access">No Access</option>
            </select>
          </td>
          <td colspan='7'></td>
        </tr>
    </thead>
    <tbody>
        <?php while ($row = mysqli_fetch_assoc($result)) { 
            $userid = $row['id'];
            $sql_allowed = "SELECT m.emails, m.emails_tag FROM tdu_users_mailbox m JOIN vtiger_users u ON m.id=u.id WHERE u.id = '$userid';";
            $result_allowed = mysqli_query($conn, $sql_allowed);
            if (mysqli_num_rows($result_allowed) > 0) {
                $row_allowed = mysqli_fetch_assoc($result_allowed);
                if($row_allowed['emails'] != '' || $row_allowed['emails_tag'] != '') {
                    $userEmails = explode(',', $row_allowed['emails']);
                    $tagEmails = explode(',', $row_allowed['emails_tag']);
                }
                else {
                    $userEmails = getEmailsByRole($row['title']);
                    $tagEmails = [];
                }
            } else {
                $userEmails = getEmailsByRole($row['title']);
                $tagEmails = [];
            }
            
            //TAG MODIFICATION
            $assigned_tag_ids_for_this_user = []; // Placeholder
            $assigned_type_names_for_this_user = []; // Placeholder
            // Prepare the SQL statement to prevent SQL injection
            $sql_assigned_types = "SELECT tag_id FROM tdu_tai_assigned_role WHERE user_id = ?";
            $stmt_assigned_types = mysqli_prepare($conn, $sql_assigned_types);

            if ($stmt_assigned_types) {
                mysqli_stmt_bind_param($stmt_assigned_types, "i", $userid);
                mysqli_stmt_execute($stmt_assigned_types);
                $result_assigned_types = mysqli_stmt_get_result($stmt_assigned_types);

                if ($result_assigned_types) {
                    while ($type_row = mysqli_fetch_assoc($result_assigned_types)) {
                        $current_tag_id = (int)$type_row['tag_id']; // Cast to integer
                        $assigned_tag_ids_for_this_user[] = $current_tag_id;
                        // Use your $availableSystemTypes array to get the name
                        if (isset($availableSystemTypes[$current_tag_id])) {
                            $assigned_type_names_for_this_user[] = $availableSystemTypes[$current_tag_id];
                        } else {
                            // Optional: Handle cases where a tag_id might exist in the linking table
                            // but not in your $availableSystemTypes array (e.g., stale data)
                            $assigned_type_names_for_this_user[] = "Unknown Type (ID: " . $current_tag_id . ")";
                        }
                    }
                }
                mysqli_stmt_close($stmt_assigned_types);
            } else {
                // Optional: Log an error if the prepare statement failed
                error_log("Failed to prepare statement for fetching assigned types: " . mysqli_error($conn));
            }
            // --- END: FETCH ASSIGNED SYSTEM TYPES FOR THIS USER ---
        ?>
        <tr>
            <td><?php echo htmlspecialchars($row['user_name']); ?></td>
            <td><?php echo htmlspecialchars($row['name']); ?></td>
            <td>
                <?php echo htmlspecialchars($row['alias_name']); ?>
                <button type="button" onclick="openAliasModal(<?php echo $row['id']; ?>, '<?php echo htmlspecialchars($row['alias_name'], ENT_QUOTES); ?>')">
                    <i class="fa-solid fa-pen-to-square"></i>
                </button>
            </td>
            <td id="title-<?php echo $row['id']; ?>">
                <button onclick="openEditModal(<?php echo $row['id']; ?>, '<?php echo htmlspecialchars($row['title']); ?>')"><i class="fa-solid fa-pen-to-square"></i></button> 
                <?php echo $rolesHumanReadable[$row['title']]; ?> <?= ($row['title'] == 'sales' || $row['title'] == 'external') ? $quoteHumanReadable[$row['quote_view']] : '' ?>
            </td>
            <td style="text-align: center;">
                <select onchange="updateFileAccess(<?php echo $row['id']; ?>, this.value)" style="padding: 5px; width: 100%;">
                    <option value="all" <?php echo ($row['file_access'] == 'all') ? 'selected' : ''; ?>>All Files</option>
                    <option value="assigned_created" <?php echo ($row['file_access'] == 'assigned_created') ? 'selected' : ''; ?>>Assigned + Created</option>
                    <option value="assigned_only" <?php echo ($row['file_access'] == 'assigned_only') ? 'selected' : ''; ?>>Assigned Only</option>
                    <option value="created_only" <?php echo ($row['file_access'] == 'created_only') ? 'selected' : ''; ?>>Created Only</option>
                </select>
            </td>
            <td style="text-align: center;">
                <input type="checkbox" onchange="updateQuotePricing(<?php echo $row['id']; ?>, this)" <?php echo $row['quote_pricing'] ? 'checked' : ''; ?>>
                <?php echo $row['quote_pricing'] ? 'Show' : 'Hide'; ?>
            </td>
            <td style="text-align: center;">
                <input type="checkbox" onchange="updateDeleteTag(<?php echo $row['id']; ?>, this)" <?php echo $row['delete_tag'] ? 'checked' : ''; ?>>
                <?php echo $row['delete_tag'] ? 'Allowed' : 'Disabled'; ?>
            </td>
            <td style="text-align: center;">
                <input type="checkbox" onchange="updateFollowupAccess(<?php echo $row['id']; ?>, this)" <?php echo $row['view_followup'] ? 'checked' : ''; ?>>
                <?php echo $row['view_followup'] ? 'All' : 'Block if followup pending'; ?>
            </td>
            <td id="department-<?php echo $row['id']; ?>" style="max-width: 5vw; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                <button onclick="openDepartmentModal(<?php echo $row['id']; ?>, '<?php echo htmlspecialchars(json_encode(explode(',', $row['department']))); ?>')">
                    <i class="fa-solid fa-pen-to-square"></i>
                </button>
                <?php echo htmlspecialchars($row['department']); ?>
            </td>
            <!-- TYPE MOFICATION START -->
            <td id="assigned_types-<?php echo $row['id']; ?>" style="max-width: 5vw; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                
                <button onclick="openUserTypesModal(<?php echo $row['id']; ?>, '<?php echo htmlspecialchars(json_encode($assigned_tag_ids_for_this_user)); ?>')">
                    <i class="fa-solid fa-pen-to-square"></i>
                </button>
                <span class="assigned-type-names"><?php echo htmlspecialchars(implode(', ', $assigned_type_names_for_this_user)); ?></span>
            </td>
            <!-- TYPE MODIFICATION END -->
            <td style="text-align: center;">
                <?php if ($username == $row['user_name']) : ?>
                    <button type="button" onclick="openChangePasswordModal(<?php echo $row['id']; ?>)">Change Password</button>
                <?php endif; ?>
                <button onclick="resetPassword(<?php echo $row['id']; ?>)">Reset Password</button>
                <button onclick="openEmailModal(<?php echo $row['id']; ?>, '<?php echo htmlspecialchars(json_encode($userEmails)); ?>', '<?php echo htmlspecialchars(json_encode($tagEmails)); ?>')">Mailbox Access</button>
                <button type="button" onclick="window.location.href='<?php echo $base_path; ?>quote.php?opt=assign-rules&category=<?= $row['title'] ?>&user=<?= $row['name'] ?>'">Auto Assign Rules</button>
            </td>
        </tr>
        <?php } ?>
    </tbody>
</table>

<script>    
    function updateQuotePricing(userId, checkbox) {
        let newValue = checkbox.checked ? 1 : 0;
        
        fetch('ajax_update_quote_pricing.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: `user_id=${userId}&quote_pricing=${newValue}`
        })
        .then(response => response.json())
        .then(data => {
            if (!data.success) {
                alert('Error updating quote pricing');
                checkbox.checked = !checkbox.checked; // Revert if update fails
            } else {
                alert('Quote pricing updated successfully.');
                
                // redirect
                var filterName = document.getElementById('filterName').value.trim();
                var filterRole = document.getElementById('filterRole').value.trim();
                var newUrl = window.location.href.split('?')[0] + '?filterName=' + encodeURIComponent(filterName) + '&filterRole=' + encodeURIComponent(filterRole);
                window.location.href = newUrl;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error updating quote pricing');
            checkbox.checked = !checkbox.checked;
        });
    }

    function updateDeleteTag(userId, checkbox) {
        let newValue = checkbox.checked ? 1 : 0;

        fetch('ajax_update_delete_tag.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: `user_id=${userId}&delete_tag=${newValue}`
        })
        .then(response => response.json())
        .then(data => {
            if (!data.success) {
                alert('Error updating delete tag permission');
                checkbox.checked = !checkbox.checked; // Revert if update fails
            } else {
                alert('Delete tag permission updated successfully.');
                
                // redirect
                var filterName = document.getElementById('filterName').value.trim();
                var filterRole = document.getElementById('filterRole').value.trim();
                var newUrl = window.location.href.split('?')[0] + '?filterName=' + encodeURIComponent(filterName) + '&filterRole=' + encodeURIComponent(filterRole);
                window.location.href = newUrl;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error updating delete tag permission');
            checkbox.checked = !checkbox.checked;
        });
    }

    function updateFollowupAccess(userId, checkbox) {
        let newValue = checkbox.checked ? 1 : 0;

        fetch('ajax_update_followup_access.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: `user_id=${userId}&view_followup=${newValue}`
        })
        .then(response => response.json())
        .then(data => {
            if (!data.success) {
                alert('Error updating followup access');
                checkbox.checked = !checkbox.checked; // Revert checkbox if failed
            } else {
                alert('Followup access updated successfully.');

                // Optional: refresh with filters retained
                const filterName = document.getElementById('filterName').value.trim();
                const filterRole = document.getElementById('filterRole').value.trim();
                const newUrl = window.location.href.split('?')[0] + '?filterName=' + encodeURIComponent(filterName) + '&filterRole=' + encodeURIComponent(filterRole);
                window.location.href = newUrl;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error updating followup access');
            checkbox.checked = !checkbox.checked;
        });
    }

    function updateFileAccess(userId, accessType) {
        fetch('ajax_update_file_access.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: `user_id=${userId}&file_access=${encodeURIComponent(accessType)}`
        })
        .then(response => response.json())
        .then(data => {
            if (!data.success) {
                alert('Error updating file access');
            } else {
                alert('File access updated successfully.');
                
                // redirect
                var filterName = document.getElementById('filterName').value.trim();
                var filterRole = document.getElementById('filterRole').value.trim();
                var newUrl = window.location.href.split('?')[0] + '?filterName=' + encodeURIComponent(filterName) + '&filterRole=' + encodeURIComponent(filterRole);
                window.location.href = newUrl;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error updating file access');
        });
    }
</script>

<!-- Alias Name Modal -->
<div id="aliasModal" class="modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); padding: 20px 50px; background: white; border: 1px solid #ccc; z-index: 1000;">
    <div class="modal-content">
        <h3>Edit Alias Name<br><br></h3>
        <form id="aliasForm">
            <input type="text" id="aliasInput" placeholder="Enter alias name" style="width: 100%; padding: 8px;">
            <br><br>
            <button type="button" onclick="saveAlias()">Save</button>
            <button type="button" onclick="closeAliasModal()">Cancel</button>
        </form>
    </div>
</div>
<script>
    function openAliasModal(userId, currentAlias) {
        document.getElementById('aliasInput').value = currentAlias || '';  // Pre-fill if alias exists
        document.getElementById('aliasModal').dataset.userId = userId;
        document.getElementById('aliasModal').style.display = 'block';
    }

    function closeAliasModal() {
        document.getElementById('aliasModal').style.display = 'none';
    }

    function saveAlias() {
        const userId = document.getElementById('aliasModal').dataset.userId;
        const alias = document.getElementById('aliasInput').value.trim();

        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'ajax_custom_aliases.php', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    const response = JSON.parse(xhr.responseText);
                    if (response.status === 'success') {
                        alert('Alias updated successfully.');
                        
                        // redirect
                        var filterName = document.getElementById('filterName').value.trim();
                        var filterRole = document.getElementById('filterRole').value.trim();
                        var newUrl = window.location.href.split('?')[0] + '?filterName=' + encodeURIComponent(filterName) + '&filterRole=' + encodeURIComponent(filterRole);
                        window.location.href = newUrl;
                    } else {
                        alert('Error: ' + response.message);
                    }
                } else {
                    alert('Failed to update alias. Server error.');
                }
            }
        };

        const postData = `id=${encodeURIComponent(userId)}&alias=${encodeURIComponent(alias)}`;
        xhr.send(postData);
    }
</script>

<!-- Change Password Modal -->
<div id="passwordModal" class="modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); padding: 20px 50px; background: white; border: 1px solid #ccc; z-index: 1000;">
    <div class="modal-content">
        <h3>Change Password<br><br></h3>
        <form id="passwordForm">
            <label for="newPassword">New Password:</label>
            <input type="password" id="newPassword" placeholder="Enter new password" style="width: 100%; padding: 8px;">
            <br><br>
            <label for="confirmPassword">Confirm Password:</label>
            <input type="password" id="confirmPassword" placeholder="Confirm new password" style="width: 100%; padding: 8px;">
            <br><br>
            <button type="button" onclick="savePassword()">Save</button>
            <button type="button" onclick="closePasswordModal()">Cancel</button>
        </form>
    </div>
</div>
<script>
    function openChangePasswordModal(userId) {
        document.getElementById('passwordModal').dataset.userId = userId;
        document.getElementById('passwordModal').style.display = 'block';
    }

    function closePasswordModal() {
        document.getElementById('passwordModal').style.display = 'none';
    }

    function savePassword() {
        const userId = document.getElementById('passwordModal').dataset.userId;
        const newPassword = document.getElementById('newPassword').value.trim();
        const confirmPassword = document.getElementById('confirmPassword').value.trim();

        if (newPassword !== confirmPassword) {
            alert('Passwords do not match.');
            return;
        }

        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'ajax_change_password.php', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    const response = JSON.parse(xhr.responseText);
                    if (response.status === 'success') {
                        alert('Password updated successfully.');
                        
                        // redirect
                        var filterName = document.getElementById('filterName').value.trim();
                        var filterRole = document.getElementById('filterRole').value.trim();
                        var newUrl = window.location.href.split('?')[0] + '?filterName=' + encodeURIComponent(filterName) + '&filterRole=' + encodeURIComponent(filterRole);
                        window.location.href = newUrl;
                    } else {
                        alert('Error: ' + response.message);
                    }
                } else {
                    alert('Failed to update password. Server error.');
                }
            }
        };

        const postData = `id=${encodeURIComponent(userId)}&newPassword=${encodeURIComponent(newPassword)}`;
        xhr.send(postData);
    }
</script>

<!-- Email Modal -->
<div id="emailModal" class="modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); padding: 20px 50px; background: white; border: 1px solid #ccc; z-index: 1000;">
    <div class="modal-content">
        <h3>Edit Emails<br><br></h3>
        <form id="emailForm">
            <div style="display: grid; grid-template-columns: 100px 100px auto; gap: 20px; text-align: center;">
                <div><strong>All</strong></div>
                <div><strong>Tagged</strong></div>
                <div><strong>Mailbox</strong></div>

                <!-- Row items for each email -->
                <script>
                    document.addEventListener("DOMContentLoaded", () => {
                        const formGrid = document.querySelector("#emailForm > div");

                        const emailAddresses = [
                            "sales@turtledownunder.com.au",
                            "groupsales@turtledownunder.com.au",
                            "operations@turtledownunder.com.au",
                            "groups@turtledownunder.com.au",
                            "accounts@turtledownunder.com.au",
                            "contracts@turtledownunder.com.au",
                            "groups@turtledownunder.co.nz",
                            "operations@turtledownunder.co.nz",
                            "accounts@turtledownunder.co.nz",
                            "contracts@turtledownunder.co.nz",
                            "asia@turtledownunder.com.au"
                        ];

                        emailAddresses.forEach(email => {
                            formGrid.innerHTML += `
                                <div><input type="checkbox" class="read-checkbox" data-email="${email}" value="${email}"></div>
                                <div><input type="checkbox" class="tag-checkbox" data-email="${email}" value="${email}"></div>
                                <div>${email}</div>
                            `;
                        });

                        // Enforce mutually exclusive checkboxes
                        formGrid.addEventListener("change", (e) => {
                            if (e.target.matches('.read-checkbox') || e.target.matches('.tag-checkbox')) {
                                const email = e.target.dataset.email;
                                const checkboxes = document.querySelectorAll(`[data-email="${email}"]`);

                                if (e.target.checked) {
                                    checkboxes.forEach(cb => {
                                        if (cb !== e.target) cb.checked = false;
                                    });
                                }
                            }
                        });
                    });
                </script>
            </div>

            <br><br>
            <button type="button" onclick="saveEmails()">Save</button>
            <button type="button" onclick="closeEmailModal()">Cancel</button>
        </form>
    </div>
</div>
<script>
    function openEmailModal(userId, userEmailsJson, tagEmailsJson) {
        const userEmails = JSON.parse(userEmailsJson);
        const tagEmails = JSON.parse(tagEmailsJson);

        document.querySelectorAll('.read-checkbox').forEach((checkbox) => {
            checkbox.checked = userEmails.includes(checkbox.value);
        });

        document.querySelectorAll('.tag-checkbox').forEach((checkbox) => {
            checkbox.checked = tagEmails.includes(checkbox.value);
        });

        document.getElementById('emailModal').dataset.userId = userId;
        document.getElementById('emailModal').style.display = 'block';
    }

    function closeEmailModal() {
        document.getElementById('emailModal').style.display = 'none';
    }

    function saveEmails() {
        const userId = document.getElementById('emailModal').dataset.userId;
        const selectedRead = Array.from(document.querySelectorAll('.read-checkbox:checked')).map(cb => cb.value);
        const selectedTag = Array.from(document.querySelectorAll('.tag-checkbox:checked')).map(cb => cb.value);

        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'ajax_custom_mailbox.php', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    const response = JSON.parse(xhr.responseText);
                    if (response.status === 'success') {
                        alert('Emails updated successfully.');
                        closeEmailModal();

                        // redirect
                        var filterName = document.getElementById('filterName').value.trim();
                        var filterRole = document.getElementById('filterRole').value.trim();
                        var newUrl = window.location.href.split('?')[0] + '?filterName=' + encodeURIComponent(filterName) + '&filterRole=' + encodeURIComponent(filterRole);
                        window.location.href = newUrl;
                    } else {
                        alert('Error: ' + response.message);
                    }
                } else {
                    alert('Failed to update emails. Server error.');
                }
            }
        };

        const postData = `id=${encodeURIComponent(userId)}&emails=${encodeURIComponent(selectedRead.join(','))}&tags=${encodeURIComponent(selectedTag.join(','))}`;
        xhr.send(postData);
    }
</script>

<!-- Department Modal -->
<div id="departmentModal" class="modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); padding: 20px 100px; background: white; border: 1px solid #ccc; z-index: 1000;">
    <div class="modal-content">
        <h3>Edit Departments<br><br></h3>
        <form id="departmentForm">
            <div id="departmentList">
                <?php
                // Fetch distinct group names
                $sql_groups = "SELECT DISTINCT groupname FROM vtiger_groups";
                $result_groups = mysqli_query($conn, $sql_groups);

                $groupNames = [];
                if ($result_groups && mysqli_num_rows($result_groups) > 0) {
                    while ($row_group = mysqli_fetch_assoc($result_groups)) {
                        $groupNames[] = $row_group['groupname'];
                    }
                }
                ?>
                <?php foreach ($groupNames as $groupName): ?>
                    <label>
                        <input type="checkbox" value="<?php echo htmlspecialchars($groupName); ?>"> 
                        <?php echo htmlspecialchars($groupName); ?>
                    </label><br><br>
                <?php endforeach; ?>
            </div>
            <button type="button" onclick="saveDepartments()">Save</button>
            <button type="button" onclick="closeDepartmentModal()">Cancel</button>
        </form>
    </div>
</div>
<script>
    function openDepartmentModal(userId, userDepartmentsJson) {
        const userDepartments = JSON.parse(userDepartmentsJson);
        const departmentList = document.querySelectorAll('#departmentList input[type=checkbox]');

        departmentList.forEach((checkbox) => {
            checkbox.checked = userDepartments.includes(checkbox.value);
        });

        document.getElementById('departmentModal').dataset.userId = userId;
        document.getElementById('departmentModal').style.display = 'block';
    }

    function closeDepartmentModal() {
        document.getElementById('departmentModal').style.display = 'none';
    }

    function saveDepartments() {
        const userId = document.getElementById('departmentModal').dataset.userId;
        const selectedDepartments = Array.from(
            document.querySelectorAll('#departmentList input[type=checkbox]:checked')
        ).map((checkbox) => checkbox.value);

        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'ajax_update_departments.php', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    const response = JSON.parse(xhr.responseText);
                    if (response.status === 'success') {
                        alert('Departments updated successfully.');
                        document.getElementById(`department-${userId}`).innerHTML = `
                            <button onclick="openDepartmentModal(${userId}, '${JSON.stringify(selectedDepartments)}')">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </button>
                            ${selectedDepartments.join(', ')}
                        `;
                        closeDepartmentModal();
                    } else {
                        alert('Error: ' + response.message);
                    }
                } else {
                    alert('Failed to update departments. Server error.');
                }
            }
        };

        const postData = `id=${encodeURIComponent(userId)}&departments=${encodeURIComponent(selectedDepartments.join(','))}`;
        xhr.send(postData);
    }
</script>

<!-- Modals -->
<!-- Create User Modal -->
<div id="createUserModal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); padding: 20px; background: white; border: 1px solid #ccc; z-index: 1000;">
    <h3 style="margin-bottom: 10px;">Create New User</h3>
    <form id="createUserForm">
        <label for="newUserName">Username:</label>
        <input type="text" id="newUserName" required><br><br>
        <label for="newFirstName">First Name:</label>
        <input type="text" id="newFirstName" required><br><br>
        <label for="newLastName">Last Name:</label>
        <input type="text" id="newLastName" required><br><br>
        <label for="newTitle">Role:</label>
        <select id="newTitle" required>
            <option value="admin">Admin</option>
            <option value="account">Account</option>
            <option value="group">Ops</option>
            <option value="sales">Internal Sales</option>
            <option value="external">External Sales</option>
            <option value="qa">QA</option>
            <option value="block">No Access</option>
        </select><br><br>
        <button type="button" onclick="createUser()">Create</button>
        <button type="button" onclick="closeCreateUserModal()">Cancel</button>
    </form>
</div>

<script>
    function openCreateUserModal() {
        document.getElementById('createUserModal').style.display = 'block';
        document.getElementById('modalOverlay').style.display = 'block';
    }

    function closeCreateUserModal() {
        document.getElementById('createUserModal').style.display = 'none';
        document.getElementById('modalOverlay').style.display = 'none';
    }

    function createUser() {
        const userName = document.getElementById('newUserName').value;
        const firstName = document.getElementById('newFirstName').value;
        const lastName = document.getElementById('newLastName').value;
        const title = document.getElementById('newTitle').value;

        // AJAX request to create user
        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'ajax_create_user.php', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4 && xhr.status === 200) {
                document.getElementById('newPassword').innerText = xhr.responseText;
                document.getElementById('passwordModal').style.display = 'block';
                closeCreateUserModal();
            }
        };
        xhr.send(
            'user_name=' + encodeURIComponent(userName) +
            '&first_name=' + encodeURIComponent(firstName) +
            '&last_name=' + encodeURIComponent(lastName) +
            '&title=' + encodeURIComponent(title)
        );
    }
</script>

<!-- Modals -->
<div id="editModal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); padding: 20px; background: white; border: 1px solid #ccc; z-index: 1000;">
    <h3>Edit Role</h3>
    <input type="hidden" id="editId">
    
    <select id="editTitle" onchange="toggleSalesGroup()">
        <option value="admin">Admin</option>
        <option value="account">Account</option>
        <option value="group">Ops</option>
        <option value="sales">Internal Sales</option>
        <option value="external">External Sales</option>
        <option value="qa">QA</option>
        <option value="block">No Access</option>
    </select><br><br>

    <h3 id="salesGrouph3">Full Quote Access</h3><br>
    <select id="salesGroup" style="display: none;">
        <option value="both">All</option>
        <option value="group">Group</option>
        <option value="fit">FIT</option>
    </select>

    <h3 id="reassignTasksh3">Reassign Tasks</h3><br>
    <select id="reassignTasks" style="display: none;">
        <option value="">None</option>
        <?php
        $sqlr = "SELECT title, CONCAT(first_name, ' ', last_name) AS name FROM vtiger_users 
                WHERE title != 'block'
                ORDER BY title ASC, first_name ASC;";
        $resultr = $conn->query($sqlr);
        $current_title = '';
        if ($resultr->num_rows > 0) {
            while ($rowr = $resultr->fetch_assoc()) {
                if ($rowr['title'] !== $current_title) {
                    $current_title = $rowr['title'];
                    echo "<option value='' disabled>--- " . $rolesHumanReadable[$current_title] . " ---</option>";
                }
                echo "<option value=\"" . htmlspecialchars($rowr['name']) . "\">" . htmlspecialchars($rowr['name']) . "</option>";
            }
        }
        ?>
    </select><br><br>

    <button onclick="saveTitle()">Save</button>
    <button onclick="closeEditModal()">Cancel</button>
</div>
<div id="passwordModalReset" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); padding: 20px; background: white; border: 1px solid #ccc; z-index: 1000;">
    <h1>New Password: </h1>
    <h2 id="newPasswordReset" style="margin: 20px 0;"></h2>
    <button onclick="closePasswordModalReset()">I've copied, EXIT</button>
</div>
<div id="modalOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 999;"></div>

<!-- User Types Modal -->
<div id="userTypesModal" class="modal" style="display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); padding: 20px 100px; background: white; border: 1px solid #ccc; z-index: 1000;">
    <div class="modal-content">
        <h3>Edit User Assigned Types<br><br></h3>
        <form id="userTypesForm">
            <div id="userTypesList" style="max-height: 300px; overflow-y: auto;">
                <?php
                // Ensure $availableSystemTypes is defined and available here
                if (isset($availableSystemTypes) && is_array($availableSystemTypes)) {
                    foreach ($availableSystemTypes as $tag_id => $typeName): ?>
                        <label style="display: block; margin-bottom: 8px;">
                            <input type="checkbox" name="user_type_tag_ids[]" value="<?php echo htmlspecialchars($tag_id); ?>">
                            <?php echo htmlspecialchars($typeName); ?>
                        </label>
                    <?php endforeach;
                } else {
                    echo "<p>No types available or types not configured.</p>";
                }
                ?>
            </div>
            <br>
            <button type="button" onclick="saveUserTypes()">Save Types</button>
            <button type="button" onclick="closeUserTypesModal()">Cancel</button>
        </form>
    </div>
</div>

<script>
    //START TAG MODIFICATION
    const availableSystemTypesJS = <?php echo json_encode($availableSystemTypes); ?>;
    
    function saveUserTypes() {
        const userId = document.getElementById('userTypesModal').dataset.userId;
        const selectedCheckboxes = document.querySelectorAll('#userTypesList input[type=checkbox]:checked');
        const selectedTagIds = Array.from(selectedCheckboxes).map(cb => cb.value);
    
        // console.log("Saving User Types for User ID:", userId);
        // console.log("Selected Tag IDs:", selectedTagIds);
    
        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'ajax_update_user_types.php', true); 
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    
        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4) {
                if (xhr.status === 200) {
                    try {
                        const response = JSON.parse(xhr.responseText);
                        if (response.status === 'success') {
                            alert(response.message || 'User types updated successfully!');
    
                            const typeDisplayCell = document.getElementById(`assigned_types-${userId}`);
                            if (typeDisplayCell) {
                                const namesSpan = typeDisplayCell.querySelector('.assigned-type-names');
                                if (namesSpan) {
                                    // Use the names provided by the server in the response
                                    namesSpan.textContent = response.assigned_names ? response.assigned_names.join(', ') : '';
                                }
                            }
                            closeUserTypesModal();
                        } else {
                            alert('Error updating types: ' + (response.message || 'Unknown server error'));
                        }
                    } catch (e) {
                        alert('Error parsing server response. Please check console.');
                        console.error("Parse error:", e);
                        console.error("Response text:", xhr.responseText);
                    }
                } else {
                    alert('Failed to update user types. Server error: ' + xhr.status + ' ' + xhr.statusText);
                     console.error("XHR Error:", xhr);
                }
            }
        };
    
        xhr.onerror = function () {
            alert('Request failed. Please check your network connection or server status.');
            console.error("XHR onerror triggered");
        };
    
        const postData = `id=${encodeURIComponent(userId)}&tag_ids=${encodeURIComponent(selectedTagIds.join(','))}`;
        xhr.send(postData);
    }


    function openUserTypesModal(userId, assignedTagIdsJson) {
        const assignedTagIds = JSON.parse(assignedTagIdsJson || '[]'); // Ensure it's an array
        const typeCheckboxes = document.querySelectorAll('#userTypesList input[type=checkbox]');
    
        // Uncheck all first
        typeCheckboxes.forEach((checkbox) => {
            checkbox.checked = false;
        });
    
        // Check the ones that are assigned
        assignedTagIds.forEach((tagId) => {
            const checkbox = document.querySelector(`#userTypesList input[type=checkbox][value="${tagId}"]`);
            if (checkbox) {
                checkbox.checked = true;
            }
        });
    
        document.getElementById('userTypesModal').dataset.userId = userId;
        document.getElementById('userTypesModal').style.display = 'block';
        document.getElementById('modalOverlay').style.display = 'block'; // Assuming you use modalOverlay
    }
    
    function closeUserTypesModal() {
        document.getElementById('userTypesModal').style.display = 'none';
        document.getElementById('modalOverlay').style.display = 'none'; // Assuming you use modalOverlay
    }
    //END TAG MODIFICATION
    function openEditModal(id, currentTitle) {
        document.getElementById('editId').value = id;
        document.getElementById('editTitle').value = currentTitle;
        document.getElementById('editModal').style.display = 'block';
        document.getElementById('modalOverlay').style.display = 'block';
        toggleSalesGroup();
    }

    function closeEditModal() {
        document.getElementById('editModal').style.display = 'none';
        document.getElementById('modalOverlay').style.display = 'none';
    }

    function closePasswordModalReset() {
        document.getElementById('passwordModalReset').style.display = 'none';
        document.getElementById('modalOverlay').style.display = 'none';
    }

    function toggleSalesGroup() {
        const title = document.getElementById('editTitle').value;
        const salesGroup = document.getElementById('salesGroup');
        const salesGrouph3 = document.getElementById('salesGrouph3');
        const reassignTasks = document.getElementById('reassignTasks');
        const reassignTasksh3 = document.getElementById('reassignTasksh3');

        if (title === 'sales' || title === 'external') {
            salesGroup.style.display = 'inline-block';
            salesGrouph3.style.display = 'inline-block';
        } else {
            salesGroup.style.display = 'none';
            salesGrouph3.style.display = 'none';
        }

        if (title === 'block') {
            reassignTasks.style.display = 'inline-block';
            reassignTasksh3.style.display = 'inline-block';
        } else {
            reassignTasks.style.display = 'none';
            reassignTasksh3.style.display = 'none';
        }
    }

    function saveTitle() {
        const id = document.getElementById('editId').value;
        const newTitle = document.getElementById('editTitle').value;
        let salesGroup = '';
        let reassignTo = '';

        if (newTitle === 'sales' || newTitle === 'external') {
            salesGroup = document.getElementById('salesGroup').value;
        }

        if (newTitle === 'block') {
            reassignTo = document.getElementById('reassignTasks').value;
        }

        // AJAX request
        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'ajax_update_title.php', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        xhr.onreadystatechange = function () {
            if (xhr.readyState === 4 && xhr.status === 200) {
                document.getElementById('title-' + id).innerText = newTitle + (salesGroup ? ' (' + salesGroup + ')' : '');
                closeEditModal();

                // redirect
                var filterName = document.getElementById('filterName').value.trim();
                var filterRole = document.getElementById('filterRole').value.trim();
                var newUrl = window.location.href.split('?')[0] + '?filterName=' + encodeURIComponent(filterName) + '&filterRole=' + encodeURIComponent(filterRole);
                window.location.href = newUrl;
            }
        };
        xhr.send('id=' + encodeURIComponent(id) + '&title=' + encodeURIComponent(newTitle) + '&salesGroup=' + encodeURIComponent(salesGroup) + '&reassignTo=' + encodeURIComponent(reassignTo));
    }

    function resetPassword(id) {
        // Confirm with the user before proceeding
        const isConfirmed = confirm("Are you sure you want to reset the password?");
        
        if (isConfirmed) {
            // AJAX request to reset password
            const xhr = new XMLHttpRequest();
            xhr.open('POST', 'ajax_reset_password.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    document.getElementById('newPasswordReset').innerText = xhr.responseText;
                    document.getElementById('passwordModalReset').style.display = 'block';
                    document.getElementById('modalOverlay').style.display = 'block';
                }
            };
            xhr.send('id=' + encodeURIComponent(id));
        } else {
            // If the user cancels the action, you can log or handle it if needed
            console.log('Password reset canceled');
        }
    }

    function filterTable() {
        const nameFilter = document.getElementById('filterName').value.trim().toLowerCase();
        const roleFilter = document.getElementById('filterRole').value.trim().toLowerCase();
        const rows = document.querySelectorAll('#userTable tbody tr');

        rows.forEach(row => {
            const name = row.cells[1].textContent.trim().toLowerCase();
            const role = row.cells[3].textContent.trim().toLowerCase();

            if (
                (name.includes(nameFilter) || nameFilter === '') &&
                (role.includes(roleFilter) || roleFilter === '')
            ) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    }
</script>

<script>
    function getQueryParameter(name) {
        const params = new URLSearchParams(window.location.search);
        return params.get(name);
    }

    // Set the values of filterName and filterRole from the query parameters
    window.onload = function() {
        // Set the filterName field
        const filterName = getQueryParameter('filterName');
        if (filterName) {
            document.getElementById('filterName').value = filterName;
        }

        // Set the filterRole field
        const filterRole = getQueryParameter('filterRole');
        if (filterRole) {
            document.getElementById('filterRole').value = filterRole;
        }

        filterTable();
    };
</script>

<style>
    .styled-table {
        border-collapse: collapse;
        width: 100%;
        margin: 20px 0;
        font-size: 16px;
        text-align: center;
    }
    .styled-table th, .styled-table td {
        padding: 12px 15px;
        border-bottom: 1px solid #ddd;
        text-align: left;
    }
    .styled-table th {
        background-color: #f9f9f9;
        color: #333;
    }
    .styled-table tr:nth-of-type(even) {
        /*background-color: #f9f9f9;*/
    }
    .styled-table tr:hover {
        /*background-color: #f1f1f1;*/
    }
    .styled-table th input[type="number"] {
        width: 40px;
        padding: 5px;
        margin: 0 5px;
        box-sizing: border-box;
    }
    .styled-table td input[type="number"] {
        width: 80px;
        padding: 5px;
        margin: 0 5px;
        box-sizing: border-box;
    }
    .styled-table select, .styled-table input[type="text"] {
        width: 150px;
    }
    .styled-table input[type="submit"] {
        margin: 20px 0;
        padding: 10px 20px;
        background-color: #ffbb00;
        border: none;
        color: #fff;
        font-size: 16px;
        cursor: pointer;
    }
    .styled-table input[type="submit"]:hover {
        background-color: #e0a800;
    }
    button {
        color: white;
        background-color: #334155;
        padding: 3px 6px;
        cursor: pointer;
    }
    select, #createUserForm input[type="text"]{
        height: 30px;
        margin: 0;
    }
</style>