<?php
include "dbconn.php";
include "header.php";

session_start();

// Redirect to login page if not logged in
if (!isset($_SESSION['user_name']) || $_SESSION['title'] != 'admin') {
    header('Location: login.php');
    exit;
}

// Handle the CSV file upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv_file'])) {
    // Check if the file is a valid CSV file
    $fileTmpPath = $_FILES['csv_file']['tmp_name'];
    $fileName = $_FILES['csv_file']['name'];
    $fileSize = $_FILES['csv_file']['size'];
    $fileType = $_FILES['csv_file']['type'];

    if ($fileType === 'text/csv' || strpos($fileName, '.csv') !== false) {
        // Open the CSV file for reading
        if (($handle = fopen($fileTmpPath, 'r')) !== false) {
            // Skip the header row (if there is one)
            $header = fgetcsv($handle);
            
            // Read the CSV rows and store data in an associative array
            $csvData = [];
            while (($row = fgetcsv($handle)) !== false) {
                // Assuming CSV columns are: id, title
                $csvData[] = [
                    'id' => $row[0], // ID from CSV
                    'title' => $row[1] // Title from CSV
                ];
            }
            fclose($handle);
            
            // First set all statuses to Inactive
            $updateStatusQuery = "UPDATE vtiger_users SET status = 'Inactive'";
            if (!mysqli_query($conn, $updateStatusQuery)) {
                echo "Error updating status to Inactive: " . mysqli_error($conn);
                exit;
            }

            // Then set statuses to Active where id exists in the CSV
            foreach ($csvData as $data) {
                $id = (int)$data['id']; // ID must be an integer
                $updateStatusQuery = "UPDATE vtiger_users SET status = 'Active' WHERE id = $id";
                if (!mysqli_query($conn, $updateStatusQuery)) {
                    echo "Error updating status for ID $id: " . mysqli_error($conn);
                    exit;
                }
            }

            // Set all titles to empty string
            $updateTitleQuery = "UPDATE vtiger_users SET title = ''";
            if (!mysqli_query($conn, $updateTitleQuery)) {
                echo "Error resetting titles: " . mysqli_error($conn);
                exit;
            }

            // Then set titles based on the CSV file
            foreach ($csvData as $data) {
                $id = (int)$data['id'];  // ID must be an integer
                $title = $conn->real_escape_string($data['title']); // Escape the title to prevent SQL injection
                $updateTitleQuery = "UPDATE vtiger_users SET title = '$title' WHERE id = $id";
                if (!mysqli_query($conn, $updateTitleQuery)) {
                    echo "Error updating title for ID $id: " . mysqli_error($conn);
                    exit;
                }
            }

            echo "Database updates completed successfully!";
        } else {
            echo "Error reading the CSV file.";
        }
    } else {
        echo "Invalid file type. Please upload a valid CSV file.";
    }
} 
?>

<div class="csv-form">
    <div class="form-container">
        <h1 class="form-title">Upload CSV File to Update User Data</h1>
        <form method="POST" enctype="multipart/form-data">
            <label for="csv_file" class="file-input-label">Choose CSV File: <a href="https://docs.google.com/spreadsheets/d/13n4FFO_Z1q28DqruWCJjlU7fUPVcmd3OF6du-4wt0i0/edit?usp=sharing">View User Roles</a></label>
            <input type="file" name="csv_file" id="csv_file" class="file-input" required />
            <button type="submit" class="submit-button">Upload CSV</button>
        </form>
    </div>
</div>

<style>
    .csv-form * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    .csv-form {
        display: flex;
        justify-content: center;
        align-items: center;
        height: 25vh;
    }

    .csv-form .form-title {
        color: #333;
        text-align: center;
        margin-bottom: 20px;
    }

    .csv-form .file-input-label {
        font-size: 16px;
        color: #333;
        margin-bottom: 8px;
        display: inline-block;
    }

    .csv-form .file-input {
        font-size: 16px;
        padding: 10px;
        width: 100%;
        border: 1px solid #ccc;
        border-radius: 4px;
        background-color: #f9f9f9;
        margin-bottom: 20px;
    }

    .csv-form .submit-button {
        background-color: #4CAF50;
        color: white;
        padding: 12px 20px;
        font-size: 16px;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        width: 100%;
        transition: background-color 0.3s;
    }

    .csv-form .submit-button:hover {
        background-color: #45a049;
    }
</style>
